/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import javax.microedition.lcdui.Graphics;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Image;
import sk.inlogic.game.Game;
import sk.inlogic.game.MainObject;
import sk.inlogic.tt.CMenuItem;
import sk.inlogic.tt.Common;
import sk.inlogic.tt.FontDef;
import sk.inlogic.tt.IMenuAnimationListener;
import sk.inlogic.tt.IMenuItemActivator;
import sk.inlogic.tt.IMenuItemRenderer;
import sk.inlogic.tt.IScreen;
import sk.inlogic.tt.MenuAnimation;
import sk.inlogic.tt.MenuSystem;
import sk.inlogic.tt.MyApplication;
import sk.inlogic.tt.Profile;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.ScreenMenu;
import sk.inlogic.tt.ScreenSplash;
import sk.inlogic.tt.Sounds;
import sk.inlogic.tt.Texts;
import sk.inlogic.tt.TextsDescription;

public class ScreenGame
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer,
IMenuAnimationListener {
    public static final int TOTAL_COMP_IDS = 0;
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    public static final int MODE_PLAY = 2;
    final int MODE_PAUSE;
    final int MODE_INSTRUCTION;
    final int MODE_GAME_OVER;
    final int MODE_CONGRATULATION;
    final int MODE_REALY_RESTART;
    final int MODE_MAIN_MENU_QUESTIONS;
    final int MODE_HELP_CLEAN;
    final int MODE_MENU;
    final int MI_RESTART;
    final int MI_INSTRUCTION;
    final int MI_SOUND;
    final int MI_MENU;
    final int MI_GO_RETRY;
    final int MI_GO_MENU;
    static final int NO_FROG_POSITION = 10;
    final int TIME_DELAY;
    private MainObject helpObjectPaint = null;
    public static int iMode;
    private int iNextMode;
    private int iModeDelay;
    private static int iPosXQuestText;
    MyApplication pMyApplication;
    MenuSystem pMenuSystem = null;
    public static Game pGame;
    private String textTitle;
    Key pMyKey;
    public static boolean bRestart;
    public static boolean bGameOver;
    public static boolean bSetSelectedMenuItem;
    public static int iMenuItemValue;
    public static Image pImgPause;
    public static int CLOSE_SCREEN_TIME;
    public static int iSpeedCloseScreen;
    public static int iDistanceCloseScreen;
    public static int iDspYCloseScreen;
    public static String sWinGame;
    public int iPosYHelpText;
    public static int iHelpValue;
    public final int HELP_CONGRAT;
    public static final int HELP_FIRST_GAME = 2;
    public static final int HELP_FIRST_GAME_2 = 3;
    public final int HELP_ERASE_HELP;
    public boolean bNoGuru = false;
    public static int iWInstrTable;
    public static int iHInstrAll;
    public static int iHInstrLine;
    int iStrechMenu = 4;
    boolean bFinishMove = false;
    private long lTimeSpend = 0L;
    public static boolean bCreateFirstStarParticle;
    public static boolean bCreateSecondStarParticle;
    public static boolean bCreateThirdStarParticle;
    public static boolean bSemaphor;
    public static final long SHIVER_TIME = 300L;
    public static long lTimeSh;
    public boolean bFinal = false;
    public static boolean bHelp1;
    public boolean bSecondHelp = false;
    public boolean bEraseHelp = false;
    private int run = 0;
    int iInstructionPage;
    int iInstructionShift;
    private boolean bKeyDown = false;
    private boolean bKeyUp = false;
    private static int cFontH;
    private static int iTableHeight;
    public static int tableMove;
    public static boolean instructionReleased;
    public static int moveTableY;
    public static int moveTableAcc;
    public static int tableAccDec;
    private static int textOffsetY;
    private static int iPosYUp;
    private static int iPosXUp;
    private static int iPosYDown;
    private static int iPosXDown;
    private static int iPosXShiftIcon;
    private static int iPosYShiftIcon;
    public static boolean bContinue;
    public static int iActualyUsetTutorial;
    private boolean bNewGameStart = false;
    public boolean bPauseMode = false;
    public static int iHCongMove;
    public static int iWCongMove;

    public ScreenGame() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_PAUSE = 3;
        this.MODE_INSTRUCTION = 4;
        this.MODE_GAME_OVER = 5;
        this.MODE_CONGRATULATION = 6;
        this.MODE_REALY_RESTART = 7;
        this.MODE_MAIN_MENU_QUESTIONS = 8;
        this.MODE_HELP_CLEAN = 9;
        this.MODE_MENU = 10;
        this.MI_RESTART = 0;
        this.MI_INSTRUCTION = 1;
        this.MI_SOUND = 2;
        this.MI_MENU = 3;
        this.MI_GO_RETRY = 0;
        this.MI_GO_MENU = 1;
        this.TIME_DELAY = 300;
        this.HELP_CONGRAT = 1;
        this.HELP_ERASE_HELP = 4;
        DebugOutput.traceIn(100, "ScreenGame", "ScreenGame()");
        this.pMyApplication = MyApplication.getInstance();
        if (pGame == null) {
            pGame = new Game();
        }
        if (this.pMyKey == null) {
            this.pMyKey = new Key();
        }
        iMode = 1;
        DebugOutput.traceOut(100, "ScreenGame", "ScreenGame()");
        this.updateLoadingRes();
    }

    private void preparePauseMenuItems() {
        DebugOutput.traceIn(100, "ScreenGame", "preparePauseMenuItems()");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        int iHeight = Texts.getFontHeight();
        Resources.iPosYList = Resources.iHBoard + 5;
        int iGap = iHeight >> 2;
        int iPosY = Resources.iPosYList + (3 * Resources.iHTable >> 1) - (iHeight << 1) - iGap - (iGap >> 1);
        int iHeightBoard = iHeight;
        String sTmp = Texts.getString(11);
        int iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosYShiftBoardIcon = Texts.getFontHeight() - Resources.pSprCheck.getHeight() >> 1;
        Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(sTmp) >> 1;
        Resources.iPosXBoardIcon = Resources.iPosXMenuText - Resources.pSprCheck.getWidth() - (Resources.pSprCheck.getWidth() >> 1);
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
        sTmp = Texts.getString(3);
        iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(sTmp) >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY += iHeightBoard + iGap, iWidth, iHeight));
        iPosY += iHeightBoard + iGap;
        if (!Profile.bMusic) {
            sTmp = Texts.getString(28) + Texts.getString(29);
            iWidth = Texts.getTextWidth(sTmp);
            Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(sTmp) >> 1;
            this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
            iPosY += iHeightBoard + iGap;
        } else {
            sTmp = Texts.getString(28) + Texts.getString(30);
            iWidth = Texts.getTextWidth(sTmp);
            Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(sTmp) >> 1;
            this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
            iPosY += iHeightBoard + iGap;
        }
        sTmp = Texts.getString(5);
        iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(sTmp) >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
        iPosY += iHeightBoard + iGap;
        if (bSetSelectedMenuItem) {
            this.pMenuSystem.iSelectedMenuItem = iMenuItemValue;
        }
        int tableHeight = 3 * Resources.pSprTable.getHeight() + 5;
        Resources.iDspYIn = -tableHeight + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, tableHeight);
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "preparePauseMenuItems()");
    }

    private void prepareCloseScreen() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareCloseScreen()");
        iDistanceCloseScreen = Resources.iScreenH;
        iSpeedCloseScreen = (iDistanceCloseScreen <<= 8) / CLOSE_SCREEN_TIME;
        iDspYCloseScreen = Resources.iScreenH;
        DebugOutput.traceOut(100, "ScreenGame", "prepareCloseScreen()");
    }

    private void prepareGameOver() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareGameOver()");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sText = Texts.getString(8);
        this.pMenuSystem.addMenuItem(new CMenuItem(sText, Resources.iScreenW - Texts.getTextWidth(sText) >> 1, (Resources.iHBoard >> 1) + ScreenSplash.iPosYBoardShift, Resources.pImgBoard.getWidth(), Resources.pImgBoard.getHeight()));
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareGameOver()");
    }

    public void prepareHelpClean() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareHelpClean");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sHelpText = "";
        int iHobj = 0;
        boolean bGuruLow = false;
        switch (iHelpValue) {
            case 1: {
                sHelpText = Texts.getString(9);
                Resources.prepareMultiLineTitleText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
                iHInstrLine = Texts.getFontHeight() + FontDef.iCharGapSmall;
                iHobj = iHInstrLine * Resources.vecMultipleLines.size();
                break;
            }
            case 2: {
                sHelpText = TextsDescription.getString(7);
                Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
                iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
                if (Resources.iScreenW <= 176 || Resources.iScreenH <= 176) {
                    iHInstrLine = TextsDescription.getFontHeight() * 2 / 3;
                }
                iHobj = iHInstrLine * Resources.vecMultipleLinesDescription.size();
                break;
            }
            case 3: {
                sHelpText = TextsDescription.getString(8);
                if (Resources.iScreenW <= 128 && Texts.iLanguage == 2) {
                    Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable);
                } else {
                    Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
                }
                iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
                if (Resources.iScreenW <= 176 || Resources.iScreenH <= 176 || Resources.iScreenW <= 240 && Resources.iScreenH <= 400 || Resources.iScreenW <= 320 && Resources.iScreenH <= 240 || Resources.iScreenW <= 240 && Resources.iScreenH <= 432) {
                    iHInstrLine = TextsDescription.getFontHeight() * 2 / 3;
                    bGuruLow = true;
                } else if (Resources.iScreenW <= 128) {
                    bGuruLow = true;
                }
                if (Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
                    iHInstrLine = TextsDescription.getFontHeight() - (TextsDescription.getFontHeight() >> 2);
                }
                if (Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
                    iHInstrLine = TextsDescription.getFontHeight() * 2 / 3;
                }
                iHobj = iHInstrLine * Resources.vecMultipleLinesDescription.size();
                break;
            }
            case 4: {
                sHelpText = TextsDescription.getString(9);
                Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
                iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
                if (Resources.iScreenW <= 176) {
                    iHInstrLine = TextsDescription.getFontHeight() * 2 / 3;
                }
                iHobj = iHInstrLine * Resources.vecMultipleLinesDescription.size();
            }
        }
        DebugOutput.trace(100, "ScreenGame", "iHInstrLine:" + iHInstrLine);
        DebugOutput.trace(100, "ScreenGame", "Resources.vecMultipleLinesDescription.size():" + Resources.vecMultipleLinesDescription.size());
        Resources.setTableGuruPosition();
        Resources.resetGuru();
        this.bNoGuru = false;
        if (iHobj > Resources.iHCountTableGuru * Resources.iHTable) {
            ++Resources.iHCountTableGuru;
            this.bNoGuru = true;
        }
        this.iPosYHelpText = Resources.getTextPosition(iHobj);
        int iTmpPosY = Resources.iPosYTableGuru + (Resources.iHTable >> 1) + (Resources.iHTable >> 2);
        if (this.iPosYHelpText < iTmpPosY && Resources.iScreenW > 128) {
            this.iPosYHelpText = iTmpPosY;
        }
        if (Texts.iLanguage == 3 && Resources.iScreenW <= 240 && iHelpValue == 2) {
            this.iPosYHelpText += 10;
        }
        if (!(Texts.iLanguage != 2 && Texts.iLanguage != 1 || Resources.iScreenW > 128 || iHelpValue != 2 && iHelpValue != 3)) {
            this.iPosYHelpText = 5;
        }
        if ((Texts.iLanguage == 3 || Texts.iLanguage == 1) && Resources.iScreenW <= 240 && iHelpValue == 3) {
            this.iPosYHelpText = Resources.iPosYTableGuru + (Resources.iHTable >> 3) + (Resources.iHTable * Resources.iHCountTableGuru - iHobj >> 1);
        }
        if (bGuruLow) {
            this.iPosYHelpText += Resources.iHTable >> 2;
            Resources.iPosYGuru = this.iPosYHelpText + iHobj + 5;
        } else {
            Resources.iPosYGuru = this.iPosYHelpText + iHobj;
        }
        if (this.iPosYHelpText + iHobj > Resources.iPosYTableGuru + (Resources.iHCountTableGuru - 1) * Resources.iHTable + (Resources.iHTable >> 2)) {
            ++Resources.iHCountTableGuru;
        }
        this.pMenuSystem.addMenuItem(new CMenuItem(" ", Resources.iPosXMenuText, Resources.iScreenH, 10, 10));
        DebugOutput.trace(100, "ScreenGame", "iPosYHelpText:" + this.iPosYHelpText);
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareHelpClean");
    }

    private void prepareCongratulation() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareCongratulation()");
        this.pMenuSystem.reset();
        String sHelpText = "";
        sHelpText = TextsDescription.getString(9);
        Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
        iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
        int iHobj = (TextsDescription.getFontHeight() + FontDef.iCharGapSmall) * Resources.vecMultipleLinesDescription.size();
        Resources.setTableGuruPosition();
        Resources.resetGuru();
        this.iPosYHelpText = Resources.getTextPosition(iHobj);
        DebugOutput.trace(100, "ScreenGame", "iPosYHelpText:" + this.iPosYHelpText);
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareCongratulation()");
    }

    private void prepareMenuQuestionItem() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareMenuQuestionItem()");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        Resources.iPosYList = Resources.iScreenW <= 176 ? Resources.iHBoard : (Resources.iScreenW >= 360 && Resources.iScreenH > 480 ? Resources.iHBoard + (Resources.iRightButtonY - Resources.iHBoard - 3 * Resources.iHTable >> 1) : Resources.iHBoard + 5);
        String sText = "";
        if (iMode == 8) {
            sText = Texts.getString(10);
        } else if (iMode == 7) {
            sText = Texts.getString(11) + "?";
        }
        int iWidth = Texts.getTextWidth(sText);
        int iHeight = Texts.getFontHeight();
        int iY = Resources.iPosYList + Resources.iHTable - (iHeight >> 1);
        int iX = Resources.iScreenW - iWidth >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sText, iX, iY, iWidth, iHeight));
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareMenuQuestionItem()");
    }

    public void onMenuClosed() {
        DebugOutput.traceIn(100, "ScreenGame", "onMenuClosed()");
        iMode = this.iNextMode;
        DebugOutput.trace(100, "ScreenGame", "change mode to:" + iMode);
        switch (iMode) {
            case 4: {
                this.prepareInstruction();
                break;
            }
            case 3: {
                this.preparePauseMenuItems();
                break;
            }
            case 7: {
                this.prepareMenuQuestionItem();
                break;
            }
            case 8: {
                this.prepareMenuQuestionItem();
                break;
            }
            case 2: {
                if (this.bPauseMode) {
                    this.bPauseMode = false;
                    Resources.prepareRightAndLeftButtons();
                } else {
                    pImgPause = null;
                    if (bRestart) {
                        this.restartGame();
                    }
                    bRestart = false;
                }
                if (!this.bNewGameStart) break;
                MyApplication.bLoading = true;
                Application.getSingleton().repaintScreen();
                Game.generateNewGame();
                MyApplication.bLoading = false;
                this.bNewGameStart = false;
                break;
            }
            case 10: {
                this.endGameStartMenu();
            }
        }
        DebugOutput.traceOut(100, "ScreenGame", "onMenuClosed()");
    }

    public void restartGame() {
        Resources.prepareRightAndLeftButtons();
        pGame.preparePositions();
        this.setDefaultVariables();
        Game.restartSudoku();
    }

    public void changeMode() {
        iMode = this.iNextMode;
        switch (iMode) {
            case 5: {
                DebugOutput.trace(100, "Game", "Game over");
                this.prepareGameOver();
                if (!Profile.bMusic) break;
                MyApplication.soundManager.Play(Sounds.SOUND_GAME_OVER, 1);
                break;
            }
            case 6: {
                this.prepareCongratulation();
                break;
            }
            case 2: {
                pImgPause = null;
                if (bRestart) {
                    this.restartGame();
                    bRestart = false;
                    break;
                }
                this.setupGame();
                break;
            }
            case 8: {
                this.prepareMenuQuestionItem();
                break;
            }
            case 9: {
                this.prepareHelpClean();
            }
        }
    }

    public void renderMenuItem(simple.video.Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        if (iMode != 9) {
            if (iMode == 4) {
                Resources.renderUpperImage(g, pMenuItem, 0);
            } else {
                Resources.renderUpperImage(g, pMenuItem, 2);
            }
        }
        int iHCount = 0;
        iHCount = iMode == 7 || iMode == 8 ? 1 : 2;
        if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
            iHCount = 3;
        }
        int iDspY = 0;
        if (iMode != 9) {
            iDspY = Resources.renderBackPlace(g, pMenuItem, iHCount, Resources.iPosYList);
        }
        pMenuItem.iDspY = 0;
        if (Resources.animationRun && MenuAnimation.iState != 0) {
            pMenuItem.iDspY = -pMenuItem.getTop() + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, pMenuItem.getTop());
        }
        int iStretch = 0;
        if (bSelected) {
            iStretch = this.bFinishMove ? this.iStrechMenu - Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu) : Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu);
            if (iStretch == this.iStrechMenu && !this.bFinishMove) {
                this.bFinishMove = true;
                this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
            } else if (iStretch == 0 && this.bFinishMove) {
                this.bFinishMove = false;
                this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
            }
        }
        if (Resources.bTouchActivated) {
            iStretch = 0;
        }
        int iTextH = Texts.getFontHeight();
        int iDspH = pMenuItem.getHeight() - iTextH >> 1;
        if (iMode == 9) {
            Resources.renderGuruTable(g);
            return;
        }
        if (iMode == 8 || iMode == 7) {
            g.setClipRegion(0, Resources.iPosYList, Resources.iScreenW, Resources.iHTable * (iHCount + 1));
            Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop(), pMenuItem.getCaption());
            g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
            return;
        }
        if (iMode == 5) {
            Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop(), pMenuItem.getCaption());
            return;
        }
        if (iMode == 6) {
            Texts.drawTextAtPos(g, iPosXQuestText, pMenuItem.getTop() + iDspH, pMenuItem.getCaption());
            return;
        }
        if (iMode == 4) {
            this.paintInstructionScreen(g, iDspY, iHCount);
            return;
        }
        g.setClipRegion(0, Resources.iPosYList, Resources.iScreenW, Resources.iHTable * (iHCount + 1));
        Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop(), pMenuItem.getCaption());
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        if (bSelected && !Resources.bTouchActivated) {
            Resources.paintSprite(g, Resources.pSprCheck, 0, pMenuItem.getLeft() + (pMenuItem.getWidth() >> 1) - (Resources.pSprCheck.getWidth() >> 1), pMenuItem.getTop() + pMenuItem.getHeight());
        }
    }

    void paintInstructionScreen(simple.video.Graphics g, int iPosYDsp, int iHCount) {
        if (MenuAnimation.iState == 0) {
            iPosYDsp = 0;
        }
        g.setClipRegion(0, Resources.iPosYInstr + iPosYDsp, Resources.iScreenW, Resources.iHTable * iHCount - (Resources.iHTable >> 1));
        int iPosYInstrShift = Resources.bTouchActivated ? Resources.iPosYInstr + tableMove : Resources.iPosYInstr - textOffsetY;
        for (int i = 0; i < Resources.vecMultipleLinesDescription.size(); ++i) {
            String strText = (String)Resources.vecMultipleLinesDescription.elementAt(i);
            int iItemW = TextsDescription.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            if (iPosYInstrShift >= Resources.iPosYInstr && iPosYInstrShift <= Resources.iPosYInstr + Resources.iHTable * iHCount - (Resources.iHTable >> 1)) {
                TextsDescription.drawTextAtPos(g, Resources.iPosXInstr, iPosYInstrShift + iPosYDsp, strText);
            }
            iPosYInstrShift += iHInstrLine;
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        ScreenGame.paintNavigArrow(g, iPosYDsp);
    }

    public static void paintNavigArrow(simple.video.Graphics g, int shiftY) {
        boolean bPointerDragged = true;
        boolean bInstruc = false;
        bPointerDragged = false;
        if (cFontH - iTableHeight < 0) {
            return;
        }
        if (Resources.bTouchActivated) {
            if (!bPointerDragged) {
                if (tableMove != 0) {
                    if (tableMove != -(cFontH - Resources.iHTable)) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    }
                }
                if (tableMove != -(cFontH - Resources.iHTable)) {
                    if (tableMove != 0) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    }
                }
            } else {
                if (tableMove != 0) {
                    if (tableMove != -(cFontH - Resources.iHTable)) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    }
                }
                if (tableMove != -(cFontH - Resources.iHTable)) {
                    if (tableMove != 0) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    }
                }
            }
        } else {
            if (textOffsetY != 0) {
                if (textOffsetY != iHInstrAll - Resources.iHTable) {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                } else {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                }
            }
            if (textOffsetY != iHInstrAll - Resources.iHTable) {
                if (textOffsetY != 0) {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                } else {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                }
            }
        }
    }

    public void onMenuOpened() {
        this.pMyApplication.repaintScreen();
    }

    public void setDefaultVariables() {
        bRestart = false;
        bGameOver = false;
        Resources.lAllTimeCounter = 0L;
    }

    public void setupGame() {
        DebugOutput.traceIn(100, "ScreenGame", "setupGame()");
        this.setDefaultVariables();
        System.gc();
        Profile.save();
        Game.restartSudoku();
        DebugOutput.traceOut(100, "ScreenGame", "setupGame()");
    }

    public void update(long tick) {
        switch (iMode) {
            case 1: {
                this.updateLoadingRes();
                break;
            }
            case 2: {
                this.updateModeGame(tick);
                Resources.update();
                break;
            }
            case 4: {
                Resources.update();
                this.updateModeInstrucion();
                break;
            }
            case 5: {
                this.updateGameOver(tick);
                break;
            }
            case 6: {
                this.updateCongrat(tick);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                Resources.update();
                break;
            }
            case 9: {
                Resources.update();
            }
        }
        if (MenuAnimation.iState != 0 || this.pMenuSystem.isAnimating()) {
            MenuAnimation.update();
            this.pMyApplication.repaintScreen();
        }
    }

    public void updateTutorial(long tick) {
    }

    public void updateCloseScreen(long tick) {
        this.lTimeSpend += tick;
        if (this.lTimeSpend < 99L) {
            return;
        }
        this.lTimeSpend = 0L;
        int iObjShift = iSpeedCloseScreen * (int)tick;
        iDspYCloseScreen = (iDistanceCloseScreen -= iObjShift) >> 8;
    }

    public void updateCongrat(long tick) {
        if (System.currentTimeMillis() - lTimeSh < 300L) {
            if (bSemaphor) {
                iHCongMove += 2;
                iWCongMove -= 2;
                bSemaphor = false;
            } else {
                iHCongMove -= 2;
                iWCongMove += 2;
                bSemaphor = true;
            }
        }
    }

    void updateLoadingRes() {
        DebugOutput.traceIn(100, "ScreenGame", "updateModeLoadingRes()");
        MyApplication.bLoading = true;
        Application.getSingleton().repaintScreen();
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        Resources.loadGameResources();
        Resources.prepareRightAndLeftButtons();
        if (Profile.bMusic) {
            MyApplication.soundManager.Stop();
            MyApplication.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
        this.bPauseMode = false;
        this.bNewGameStart = false;
        this.bSecondHelp = false;
        this.bEraseHelp = false;
        DebugOutput.traceIn(100, "ScreenGame", "new game:" + Resources.bNewGame);
        pGame.preparePositions();
        if (Resources.bNewGame || Profile.bFirstGame) {
            Game.generateNewGame();
            Game.printSudoku();
            Resources.setTime(0L);
        } else {
            Profile.loadGame();
            Resources.convertTime();
            Game.printSudoku();
            Resources.loadBackgroundImage();
        }
        MyApplication.bLoading = false;
        iMode = 2;
        DebugOutput.traceOut(100, "ScreenGame", "updateModeLoadingRes()");
    }

    public void releaseResources() {
        pImgPause = null;
        Resources.releaseGameResources();
        Resources.releaseSplashResources();
        System.gc();
        DebugOutput.traceOut(100, "ScreenGame", "releaseResources() ");
    }

    void updateModeGame(long lTick) {
        if (Profile.bFirstGame) {
            Profile.bFirstGame = false;
            this.bSecondHelp = true;
            this.bEraseHelp = true;
            DebugOutput.trace(100, "ScreenGame", "bHelp01:" + bHelp1);
            Game.bHelpClean = false;
            iHelpValue = 2;
            this.iNextMode = 9;
            this.changeMode();
            return;
        }
        if (Game.bWinGame) {
            Game.bWinGame = false;
            iHelpValue = 1;
            this.iNextMode = 9;
            this.changeMode();
            return;
        }
        if (Game.bEraseHelp && this.bEraseHelp) {
            Game.bEraseHelp = false;
            this.bEraseHelp = false;
            iHelpValue = 4;
            this.iNextMode = 9;
            this.changeMode();
            return;
        }
        pGame.update(lTick);
    }

    public void updateGameOver(long lTick) {
    }

    private void updateModeInstrucion() {
        ++this.run;
        this.iInstructionShift += 8 * this.run;
        if (Resources.bTouchActivated) {
            this.runInstruction();
        } else {
            int maxOffsetY;
            Keys myKey = Application.getSingleton().getDevice().getKeys();
            if (myKey.isKeyPressed(50) || myKey.isKeyPressed(1) || myKey.isKeyPressed(116) || myKey.isKeyPressed(101)) {
                if ((textOffsetY -= TextsDescription.getFontHeight() >> 1) < 0) {
                    textOffsetY = 0;
                }
            } else if ((myKey.isKeyPressed(56) || myKey.isKeyPressed(6) || myKey.isKeyPressed(120) || myKey.isKeyPressed(98)) && (maxOffsetY = iHInstrAll - Resources.iHTable) > 0 && (textOffsetY += TextsDescription.getFontHeight() >> 1) > maxOffsetY) {
                textOffsetY = maxOffsetY;
            }
        }
        this.pMyApplication.repaintScreen();
    }

    public void runInstruction() {
        if (Resources.pImgBoard.getHeight() * (Resources.hCountMenuTable - 1) - cFontH > 0 && Resources.bTouchActivated) {
            return;
        }
        if (moveTableAcc > 0) {
            tableMove += moveTableAcc;
            if ((moveTableAcc -= tableAccDec) < 0) {
                moveTableAcc = 0;
            }
            if (tableMove > 0) {
                tableMove = 0;
                moveTableAcc = 0;
            }
        } else if (moveTableAcc < 0) {
            tableMove += moveTableAcc;
            if ((moveTableAcc += tableAccDec) > 0) {
                moveTableAcc = 0;
            }
            if (tableMove < -(iHInstrAll - Resources.iHTable)) {
                tableMove = -(iHInstrAll - Resources.iHTable);
                moveTableAcc = 0;
            }
        }
    }

    private void paintContinue(simple.video.Graphics g) {
        int iScreenW = g.getWidth();
        int iScreenH = g.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Graphics pTmpGraphics = g.getMicroeditionGraphics();
        String sText = Texts.getString(54);
        pTmpGraphics.setFont(MyApplication.pSystemFont);
        pTmpGraphics.setColor(0);
        pTmpGraphics.drawString(sText, iScreenW / 2, iScreenH / 2, 17);
        pTmpGraphics.setColor(0xFFFFFF);
        pTmpGraphics.drawString(sText, iScreenW / 2 - 1, iScreenH / 2 - 1, 17);
        Resources.paintLeftMenuButton(g, 1);
    }

    public void keyPressed(Key pKey) {
        if (MenuAnimation.iState != 0) {
            return;
        }
        switch (iMode) {
            case 2: {
                this.keyPressedModePlay(pKey);
                break;
            }
            case 3: {
                this.keyPressedModePause(pKey);
                break;
            }
            case 4: {
                this.keyPressedModeInstructionsAchevements(pKey);
                break;
            }
            case 5: {
                this.keyPressedGameOver(pKey);
                break;
            }
            case 6: {
                DebugOutput.trace(100, "ScreenGame", "MODE_CONGRATULATION keypressed:" + pKey.iValue);
                if (Resources.animationRun && MenuAnimation.iState != 0) {
                    return;
                }
                this.keyPressedCongrat(pKey);
                break;
            }
            case 7: {
                if (Resources.animationRun && MenuAnimation.iState != 0) {
                    return;
                }
                this.keyPressedModeRestart(pKey);
                break;
            }
            case 8: {
                this.keyPressedMainMenuQuestion(pKey);
                break;
            }
            case 9: {
                this.keyPressedHelp(pKey);
            }
        }
    }

    public void keyPressedModeRestart(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Resources.bButtonOut = true;
            bRestart = true;
            Game.restartSudoku();
            Resources.setTime(0L);
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            this.iNextMode = 3;
            MenuAnimation.closeMenu(this);
        }
    }

    public void endGameStartMenu() {
        if (Profile.bMusic) {
            MyApplication.soundManager.Stop();
        }
        this.endScreenGame();
        MyApplication.pScrMenu = new ScreenMenu();
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        ScreenMenu.bStartGame = true;
        MyApplication.pScrGame = null;
        System.gc();
        iMode = 0;
    }

    public void keyPressedCongrat(Key pKey) {
        DebugOutput.traceIn(100, "ScreenGame", "keyPressedCongrat()");
        if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == 8 || pKey.iValue == 53) {
            DebugOutput.trace(100, "ScreenGame", "Keys.KEY_FNLEFT");
            MenuAnimation.closeMenu(this);
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.endGameStartMenu();
            DebugOutput.trace(100, "ScreenGame", "Keys.KEY_FNRIGHT");
            MenuAnimation.closeMenu(this);
        }
        DebugOutput.traceOut(100, "ScreenGame", "keyPressedCongrat()");
    }

    public void keyPressedGameOver(Key pKey) {
        DebugOutput.traceIn(100, "ScreenGame", "keyPressedModeGameOver()");
        if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == 8 || pKey.iValue == 53) {
            Resources.resetListAnimation();
            Resources.bButtonOut = true;
            Resources.iPlayerLife = 3;
            bRestart = true;
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.resetListAnimation();
            Resources.bButtonOut = true;
            this.iNextMode = 10;
            MenuAnimation.closeMenu(this);
        }
        DebugOutput.traceOut(100, "ScreenGame", "keyPressedModeGameOver()");
    }

    private void keyPressedModePlay(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            if (Game.iPencilFrame == 0) {
                Game.iPencilFrame = 1;
                Game.iPosYPencil += Game.iEraserYShift;
            } else {
                Game.iPencilFrame = 0;
                Game.iPosYPencil -= Game.iEraserYShift;
            }
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            iMode = 3;
            this.preparePauseMenuItems();
            Profile.save();
            return;
        }
        if (this.bSecondHelp) {
            this.bSecondHelp = false;
            iHelpValue = 3;
            this.iNextMode = 9;
            this.changeMode();
            return;
        }
        DebugOutput.trace(100, "ScreenGame", "keyPressedModePlay");
        pGame.keyPressed(pKey);
    }

    private void keyPressedMainMenuQuestion(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            bSetSelectedMenuItem = true;
            iMenuItemValue = 3;
            this.iNextMode = 3;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Resources.bButtonOut = true;
            this.iNextMode = 10;
            MenuAnimation.closeMenu(this);
            return;
        }
    }

    public void endScreenGame() {
        this.saveGame();
        Resources.releaseGameResources();
    }

    public void keyPressedHelp(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Resources.bGuruOut = true;
            this.bPauseMode = true;
            Resources.bButtonOut = true;
            Profile.bFirstGame = false;
            switch (iHelpValue) {
                case 1: {
                    Resources.setTime(0L);
                    this.bNewGameStart = true;
                    break;
                }
                case 2: {
                    Resources.setTime(0L);
                }
            }
            Profile.save();
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
            return;
        }
    }

    private void keyPressedModePause(Key pKey) {
        DebugOutput.traceIn(100, "ScreenGame", "keyPressedModePause()");
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            this.bPauseMode = true;
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (!(Resources.bTouchActivated || pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != 8)) {
            this.onMenuPauseItemActivated(this.pMenuSystem.iSelectedMenuItem);
            return;
        }
        this.pMenuSystem.keyPressed(pKey);
        DebugOutput.traceOut(100, "ScreenGame", "keyPressedModePause()");
    }

    private void keyPressedModeInstructionsAchevements(Key pKey) {
        int maxOffsetY;
        DebugOutput.traceIn(100, "ScreenGame", "keyPressedModeInstructionsAchevements()");
        Keys myKey = Application.getSingleton().getDevice().getKeys();
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            Resources.resetListAnimation();
            bSetSelectedMenuItem = true;
            iMenuItemValue = 1;
            this.iNextMode = 3;
            MenuAnimation.closeMenu(this);
        } else if (myKey.isKeyPressed(50) || myKey.isKeyPressed(1) || pKey.iGameAction == 1 || pKey.iValue == 50 || myKey.isKeyPressed(116) || myKey.isKeyPressed(101)) {
            if (Resources.bTouchActivated) {
                if ((tableMove += TextsDescription.getFontHeight() >> 1) > 0) {
                    tableMove = 0;
                }
            } else if ((textOffsetY -= TextsDescription.getFontHeight() >> 1) < 0) {
                textOffsetY = 0;
            }
        } else if ((pKey.iValue == 56 || pKey.iGameAction == 6 || pKey.iValue == 120 || pKey.iValue == 98) && (maxOffsetY = iHInstrAll - Resources.iHTable) > 0) {
            if (Resources.bTouchActivated) {
                if ((tableMove -= iHInstrLine >> 1) < -(iHInstrAll - Resources.iHTable)) {
                    tableMove = -(iHInstrAll - Resources.iHTable);
                }
            } else if ((textOffsetY += TextsDescription.getFontHeight() >> 1) > maxOffsetY) {
                textOffsetY = maxOffsetY;
            }
        }
        DebugOutput.traceOut(100, "ScreenGame", "keyPressedModeInstructionsAchevements()");
    }

    public void activateMenuItem(int iSelectedMenuItem) {
        DebugOutput.traceIn(100, "ScreenGame", "activateMenuItem():" + iMode);
        switch (iMode) {
            case 3: {
                this.activatePauseMenuItem(iSelectedMenuItem);
            }
        }
        DebugOutput.traceIn(100, "ScreenGame", "activateMenuItem()");
    }

    private void activatePauseMenuItem(int iSelectedMenuItem) {
        DebugOutput.traceIn(100, "ScreenGame", "activatePauseMenuItem:" + iSelectedMenuItem);
        switch (iSelectedMenuItem) {
            case 1: {
                iMode = 4;
                break;
            }
            case 3: {
                this.endGameStartMenu();
            }
        }
        DebugOutput.traceOut(100, "ScreenGame", "activatePauseMenuItem mode:" + iMode);
    }

    public void keyReleased(Key pKey) {
        pGame.keyReleased(pKey);
    }

    public void paintScreen(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        switch (iMode) {
            case 2: {
                this.paintGame(g);
                break;
            }
            case 3: {
                this.paintPause(g);
                break;
            }
            case 5: {
                this.paintGameOver(g);
                break;
            }
            case 6: {
                this.paintCongrat(g);
                break;
            }
            case 4: {
                this.paintInstr(g);
                break;
            }
            case 7: 
            case 8: {
                this.paintModeMainMenuQuestion(g);
                break;
            }
            case 9: {
                this.paintHelpClean(g);
            }
        }
    }

    public void paintGame(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintGameBackground(g);
        if (iMode == 2) {
            Resources.paintStatusBar(g);
        }
        pGame.paint(g);
    }

    public void paintHelpClean(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintGame(g);
        Resources.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
        switch (iHelpValue) {
            case 2: 
            case 3: 
            case 4: {
                this.paintHelpSmallText(g);
                break;
            }
            case 1: {
                this.paintHelpText(g);
            }
        }
        if (!this.bNoGuru) {
            Resources.paintGuru(g);
        }
        Resources.paintLeftMenuButton(g, 1);
    }

    public void paintHelpText(simple.video.Graphics g) {
        if (MenuAnimation.iState == 0) {
            Resources.iYDspGuru = 0;
        }
        int iPosYText = this.iPosYHelpText + Resources.iYDspGuru;
        for (int i = 0; i < Resources.vecMultipleLines.size(); ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            Texts.drawTextAtPos(g, Resources.iPosXInstr, iPosYText, strText);
            iPosYText += iHInstrLine;
        }
    }

    public void paintHelpSmallText(simple.video.Graphics g) {
        if (MenuAnimation.iState == 0) {
            Resources.iYDspGuru = 0;
        }
        int iPosYText = this.iPosYHelpText + Resources.iYDspGuru;
        for (int i = 0; i < Resources.vecMultipleLinesDescription.size(); ++i) {
            String strText = (String)Resources.vecMultipleLinesDescription.elementAt(i);
            int iItemW = TextsDescription.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            TextsDescription.drawTextAtPos(g, Resources.iPosXInstr, iPosYText, strText);
            iPosYText += iHInstrLine;
        }
    }

    public void paintPause(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintGame(g);
        Resources.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        if (!Resources.bTouchActivated) {
            Resources.paintLeftMenuButton(g, 1);
        }
        Resources.paintRightMenuButton(g, 9);
    }

    public void paintCongrat(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintGame(g);
        Resources.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 6);
    }

    public void paintGameOver(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        g.drawRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 0);
        Resources.paintRightMenuButton(g, 9);
    }

    public void paintInstr(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintGame(g);
        Resources.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
                Resources.paintList(g, Resources.iPosYList, 3);
            } else {
                Resources.paintList(g, Resources.iPosYList, 2);
            }
        } else if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 3);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        Resources.paintRightMenuButton(g, 9);
    }

    public void paintInstrWindows(simple.video.Graphics g) {
        if (-Resources.angleFinishMovement > Resources.iPosYShiftList) {
            g.setClipRegion(0, Resources.iPosYInstr - Resources.pImgScreenButtons.getHeight(), Resources.iScreenW, Resources.iHTable * (Resources.iHListCounter + 3) + (Resources.pImgScreenButtons.getHeight() >> 1));
        }
        int iPosYInstrShift = Resources.bTouchActivated ? Resources.iPosYInstr + tableMove : Resources.iPosYInstr - textOffsetY;
        for (int i = 0; i < Resources.vecMultipleLinesDescription.size(); ++i) {
            String strText = (String)Resources.vecMultipleLinesDescription.elementAt(i);
            int iItemW = TextsDescription.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            if (iPosYInstrShift >= Resources.iPosYInstr && iPosYInstrShift <= Resources.iHTable * (Resources.iHListCounter + 3)) {
                TextsDescription.drawTextAtPos(g, Resources.iPosXInstr, iPosYInstrShift, strText);
            }
            iPosYInstrShift += iHInstrLine;
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        ScreenGame.paintNavigArrow(g, 0);
    }

    public void paintModeMainMenuQuestion(simple.video.Graphics g) {
        DebugOutput.traceIn(100, "ScreenGame", "paintModeMainMenuQuestion()");
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintGame(g);
        Resources.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 1);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 1);
        }
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 1);
        Resources.paintRightMenuButton(g, 2);
        DebugOutput.traceOut(100, "ScreenGame", "paintModeMainMenuQuestion()");
    }

    public void pointerPressed(int x, int y) {
        switch (iMode) {
            case 3: {
                if (Resources.pressedRightButton(x, y)) {
                    this.pMyKey.iValue = Keys.KEY_FNRIGHT;
                    this.keyPressed(this.pMyKey);
                    return;
                }
                this.pMenuSystem.pointerPressed(x, y);
                break;
            }
            case 2: {
                if (this.bSecondHelp) {
                    this.bSecondHelp = false;
                    iHelpValue = 3;
                    this.iNextMode = 9;
                    this.changeMode();
                    return;
                }
                pGame.pointerPressed(x, y);
                if (Resources.pressedLeftButton(x, y, 0)) {
                    this.pMyKey.iValue = Keys.KEY_FNLEFT;
                    this.keyPressedModePlay(this.pMyKey);
                    return;
                }
                if (Resources.pressedRightButton(x, y)) {
                    this.pMyKey.iValue = Keys.KEY_FNRIGHT;
                    this.keyPressedModePlay(this.pMyKey);
                    return;
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (Resources.pressedLeftButton(x, y, 80)) {
                    this.pMyKey.iValue = Keys.KEY_FNLEFT;
                    this.keyPressed(this.pMyKey);
                    return;
                }
                if (!Resources.pressedRightButton(x, y)) break;
                this.pMyKey.iValue = Keys.KEY_FNRIGHT;
                this.keyPressed(this.pMyKey);
                return;
            }
            case 4: {
                moveTableY = y;
                instructionReleased = false;
                if (!Resources.pressedRightButton(x, y)) break;
                this.pMyKey.iValue = Keys.KEY_FNRIGHT;
                this.keyPressed(this.pMyKey);
                return;
            }
        }
    }

    public boolean pressedInstructionDown(int x, int y) {
        int iW = Resources.pSprArrows.getWidth();
        int iH = Resources.pSprArrows.getHeight();
        if (y < iPosYDown || y > iPosYDown + iH) {
            return false;
        }
        return x >= iPosXDown && x <= iPosXDown + iW;
    }

    public boolean pressedInstructionUp(int x, int y) {
        int iW = Resources.pSprArrows.getWidth();
        int iH = Resources.pSprArrows.getHeight();
        if (y < iPosYUp || y > iPosYUp + iH) {
            return false;
        }
        return x >= iPosXUp && x <= iPosXUp + iW;
    }

    public void pointerReleased(int x, int y) {
        if (iMode == 2) {
            pGame.pointerReleased(x, y);
            return;
        }
        if (iMode == 4) {
            DebugOutput.trace(100, "ScreenMenu", "pointer released, set table move");
            if (tableMove < -(cFontH - iTableHeight)) {
                tableMove = -(cFontH - iTableHeight);
                moveTableAcc = 0;
            }
            if (tableMove > 0) {
                tableMove = 0;
                moveTableAcc = 0;
            }
        }
        this.pMyKey.iValue = 0;
        this.pMyKey.iGameAction = 0;
        this.bKeyDown = false;
        this.bKeyUp = false;
    }

    public void pointerDragged(int x, int y) {
        if (iMode == 4) {
            if (Resources.pImgBoard.getHeight() * (Resources.hCountMenuTable - 1) - cFontH > 0 && Resources.bTouchActivated) {
                return;
            }
            moveTableAcc = y < moveTableY ? -(moveTableY - y) : y - moveTableY;
            tableMove += moveTableAcc;
            moveTableY = y;
            instructionReleased = false;
            this.runInstruction();
        }
        if (iMode == 2) {
            pGame.pointerDragged(x, y);
        }
    }

    public void onMenuItemActivated(int iIndex) {
        switch (iMode) {
            case 3: {
                this.onMenuPauseItemActivated(iIndex);
            }
        }
    }

    private void onMenuPauseItemActivated(int iIndex) {
        bSetSelectedMenuItem = false;
        switch (iIndex) {
            case 2: {
                if (Profile.bMusic) {
                    Profile.bMusic = false;
                    if (MyApplication.soundManager.IsSoundOn()) {
                        MyApplication.soundManager.SetSoundOn(false);
                        MyApplication.soundManager.Stop();
                    }
                    CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(iIndex);
                    x.strCaption = Texts.getString(28) + Texts.getString(29);
                    x.iRight = x.iPosX + Texts.getTextWidth(x.strCaption);
                    break;
                }
                Profile.bMusic = true;
                MyApplication.soundManager.SetSoundOn(true);
                MyApplication.soundManager.Play(Sounds.SOUND_GAME, -1);
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(iIndex);
                x.strCaption = Texts.getString(28) + Texts.getString(30);
                x.iRight = x.iPosX + Texts.getTextWidth(x.strCaption);
                break;
            }
            case 0: {
                this.iNextMode = 7;
                Resources.bButtonOut = true;
                MenuAnimation.closeMenu(this);
                break;
            }
            case 1: {
                this.prepareInstruction();
                Resources.bButtonOut = true;
                this.iNextMode = 4;
                MenuAnimation.closeMenu(this);
                break;
            }
            case 3: {
                Resources.bButtonOut = true;
                this.iNextMode = 10;
                MenuAnimation.closeMenu(this);
            }
        }
    }

    private void prepareInstruction() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareInstructions()");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sInstr = Texts.getString(3);
        int iPosYText = (Resources.iHBoard >> 1) - Texts.getFontHeight();
        int iWText = Texts.getTextWidth(sInstr);
        int iWInstr = Resources.iWTable - (Resources.iWTable >> 3);
        Resources.prepareInstruction();
        this.pMenuSystem.addMenuItem(new CMenuItem(sInstr, Resources.iScreenW - iWText >> 1, iPosYText, iWText, Texts.getFontHeight()));
        String text = TextsDescription.getString(1) + "\n\n" + TextsDescription.getString(2);
        Resources.prepareMultiLineDescriptionText(text, iWInstr);
        iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
        cFontH = iHInstrAll = iHInstrLine * Resources.vecMultipleLinesDescription.size();
        iTableHeight = Resources.iHTable * Resources.iHListCounter;
        iPosYUp = Resources.iPosYList + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1);
        iPosYDown = Resources.iScreenW >= 360 && Resources.iScreenH > 480 ? Resources.iPosYList + Resources.iHTable * 3 + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1) : Resources.iPosYList + Resources.iHTable * 2 + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1);
        iPosXDown = iPosXUp = Resources.iScreenW - Resources.pImgScreenButtons.getWidth() >> 1;
        iPosXShiftIcon = 0;
        iPosYShiftIcon = 0;
        tableMove = 0;
        textOffsetY = 0;
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareInstructions()");
    }

    public void saveGame() {
        Profile.bGameOver = false;
        Game.save();
    }

    public void onPause() {
        if (iMode == 2) {
            iMode = 3;
            this.preparePauseMenuItems();
        }
    }

    public void onResume() {
        DebugOutput.traceNoIndent(100, "ScreenGame", "onResume");
        DebugOutput.traceNoIndent(100, "ScreenGame", "Profile.bMusic:" + Profile.bMusic);
        if (iMode == 3) {
            if (Profile.bMusic) {
                MyApplication.soundManager.SetSoundOn(true);
                MyApplication.soundManager.Play(Sounds.SOUND_GAME, -1);
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(2);
                x.strCaption = Texts.getString(28) + Texts.getString(30);
                x.iWidth = Texts.getTextWidth(x.strCaption);
                x.iPosX = Resources.iScreenW - x.iWidth >> 1;
                x.iRight = x.iPosX + x.iWidth;
            } else {
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(2);
                x.strCaption = Texts.getString(28) + Texts.getString(29);
                x.iWidth = Texts.getTextWidth(x.strCaption);
                x.iPosX = Resources.iScreenW - x.iWidth >> 1;
                x.iRight = x.iPosX + x.iWidth;
            }
        }
        if (iMode == 2) {
            iMode = 3;
            this.preparePauseMenuItems();
        }
        this.pMyApplication.repaintScreen();
    }

    static {
        bRestart = false;
        bGameOver = false;
        pImgPause = null;
        CLOSE_SCREEN_TIME = 300;
        iHInstrAll = 0;
        iHInstrLine = 0;
        bCreateFirstStarParticle = false;
        bCreateSecondStarParticle = false;
        bCreateThirdStarParticle = false;
        bSemaphor = false;
        lTimeSh = 0L;
        bHelp1 = false;
        tableMove = 0;
        instructionReleased = true;
        moveTableY = 0;
        moveTableAcc = 0;
        tableAccDec = 2;
        iActualyUsetTutorial = -1;
        iHCongMove = 0;
        iWCongMove = 0;
    }
}

