/*
 * Decompiled with CFR 0.152.
 */
package simple.input;

import java.util.Vector;
import simple.core.Device;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Key;
import sk.inlogic.tt.MyApplication;

public class Keys {
    public static final int ACTION_KEY_PRESSED = 1;
    public static final int ACTION_KEY_RELEASED = 2;
    public static final int ACTION_KEY_TYPED = 3;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_LEFT = 2;
    public static final int KEY_RIGHT = 5;
    public static final int KEY_UP = 1;
    public static final int KEY_DOWN = 6;
    public static final int KEY_FIRE = 8;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    public static int KEY_FNLEFT = -6;
    public static int KEY_FNRIGHT = -7;
    private static Keys pSingleton = null;
    private Device pDevice;
    Vector vecPressedKeys;
    Vector vecKeyEvents;

    public Keys(Device device) {
        DebugOutput.traceIn(2, "SIMPLE", "Keys.Keys()");
        this.pDevice = device;
        pSingleton = this;
        this.vecPressedKeys = new Vector();
        this.vecKeyEvents = new Vector();
        KEY_FNLEFT = 113;
        KEY_FNRIGHT = 112;
        DebugOutput.traceOut(2, "SIMPLE", "Keys.Keys()");
    }

    private boolean isFunctionKey(int iKey) {
        return iKey == KEY_FNLEFT || iKey == KEY_FNRIGHT;
    }

    public void pressKey(int iKey) {
        DebugOutput.traceIn(2, "SIMPLE", "Keys.pressKey(): " + iKey);
        if (!this.isFunctionKey(iKey) && this.isKeyPressed(iKey)) {
            DebugOutput.traceOut(2, "SIMPLE", "Keys.pressKey() - already pressed");
            return;
        }
        int iKeyVal = iKey;
        int iGameKey = -1;
        try {
            iGameKey = this.pDevice.getScreen().getMicroeditionCanvas().getGameAction(iKeyVal);
        }
        catch (Exception e) {
            // empty catch block
        }
        Key pKey = new Key();
        pKey.iIndex = this.vecPressedKeys.size() - 1;
        pKey.iValue = iKey;
        pKey.iGameAction = iGameKey;
        pKey.iAction = 1;
        pKey.bHandled = false;
        if (!this.isKeyPressed(iKey)) {
            this.vecPressedKeys.addElement(pKey);
        }
        this.vecKeyEvents.addElement(pKey);
        DebugOutput.traceOut(2, "SIMPLE", "Keys.pressKey()");
    }

    public void releaseKey(int iKey) {
        DebugOutput.traceIn(2, "SIMPLE", "Keys.releaseKey() : " + iKey);
        for (int i = this.vecPressedKeys.size() - 1; i >= 0; --i) {
            Key pKey = (Key)this.vecPressedKeys.elementAt(i);
            if (pKey.iValue != iKey) continue;
            if (pKey.bHandled) {
                pKey.iAction = 2;
                this.vecKeyEvents.addElement(pKey);
            }
            this.vecPressedKeys.removeElement(pKey);
            DebugOutput.traceOut(2, "SIMPLE", "Keys.releaseKey()");
            return;
        }
        DebugOutput.traceOut(2, "SIMPLE", "Keys.releaseKey()");
    }

    public void typeKey(int iKey) {
        DebugOutput.traceIn(2, "SIMPLE", "typeKey(" + new Integer(iKey).toString() + ")");
        Key pKey = new Key();
        pKey.iIndex = this.vecPressedKeys.size() - 1;
        pKey.iValue = iKey;
        pKey.iGameAction = -1;
        pKey.iAction = 3;
        pKey.bHandled = false;
        this.vecKeyEvents.addElement(pKey);
        DebugOutput.traceOut(2, "SIMPLE", "typeKey()");
    }

    public synchronized void update() {
        while (this.vecKeyEvents.size() > 0) {
            Key pKey = (Key)this.vecKeyEvents.elementAt(0);
            Event pEvent = null;
            switch (pKey.iAction) {
                case 1: {
                    pEvent = new Event("simple.input.Keys", "pressKey", "", pKey);
                    pKey.bHandled = true;
                    break;
                }
                case 2: {
                    pEvent = new Event("simple.input.Keys", "releaseKey", "", pKey);
                    pKey.bHandled = true;
                    break;
                }
                case 3: {
                    pEvent = new Event("simple.input.Keys", "typeKey", "", pKey);
                    pKey.bHandled = true;
                }
            }
            this.pDevice.fireEvent(pEvent);
            pEvent = null;
            pKey = null;
            this.vecKeyEvents.removeElementAt(0);
        }
    }

    public static Keys getSingleton() {
        return pSingleton;
    }

    public boolean isKeyPressed(int iKey) {
        MyApplication.ikey = iKey;
        try {
            for (int i = this.vecPressedKeys.size() - 1; i >= 0; --i) {
                Key key = (Key)this.vecPressedKeys.elementAt(i);
                if (key.iValue == iKey) {
                    return true;
                }
                if (key.iGameAction != iKey) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getNumberOfPressedKeys() {
        return this.vecPressedKeys.size();
    }

    public Key getPressedKey(int iIndex) {
        DebugOutput.trace(2, "SIMPLE", "getPressedKey()");
        if (iIndex < 0 || iIndex > this.getNumberOfPressedKeys() - 1) {
            return null;
        }
        return (Key)this.vecPressedKeys.elementAt(iIndex);
    }

    public static boolean isEventSender(Event event) {
        return event.getModuleName().compareTo("simple.input.Keys") == 0;
    }
}

