/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Key;
import simple.input.Keys;
import simple.input.Pointer;
import simple.input.Pointers;
import simple.video.Screen;
import sk.inlogic.tt.IScreen;
import sk.inlogic.tt.MenuAnimation;
import sk.inlogic.tt.Profile;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.ScreenGame;
import sk.inlogic.tt.ScreenMenu;
import sk.inlogic.tt.ScreenSplash;
import sk.inlogic.tt.SoundManager;
import sk.inlogic.tt.Sounds;
import sk.inlogic.tt.Texts;

public class MyApplication
extends Application {
    static MyApplication pInstance;
    public static IScreen pActiveScreen;
    public static ScreenSplash pScrSplash;
    public static ScreenMenu pScrMenu;
    public static ScreenGame pScrGame;
    public static boolean bLoading;
    public static Font pSystemFont;
    public static boolean bMusicOn;
    public static SoundManager soundManager;
    public static int ikey;
    long lLastRun;
    public static int iRun;
    public static boolean bStartUpdate;
    public static boolean bStartPaint;
    public static boolean bChangeSize;
    private static int iValue;
    private static int iGameAction;
    private static boolean bGo;
    private long lLastKeyUsedTime;
    private boolean bApplicationPaused = false;
    private int paintLoading = 0;
    public static boolean bOnResume;
    public static boolean bOnStop;
    public static boolean bOnStart;
    public static boolean bOnPause;
    public static int iCounter;
    public static Key pKey;

    public MyApplication() {
        DebugOutput.setDebugLevel(1000);
        pSystemFont = Font.getFont((int)0, (int)0, (int)8);
        soundManager = new SoundManager(1);
        soundManager.LoadPlayList(Sounds.GAME_SOUND_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
        soundManager.SetVolume(soundManager.getChannel(Sounds.SOUND_MENU), 100);
        soundManager.SetVolume(soundManager.getChannel(Sounds.SOUND_GAME), 100);
        pInstance = this;
        this.lLastKeyUsedTime = System.currentTimeMillis();
        this.bApplicationPaused = false;
        iRun = 0;
    }

    public static MyApplication getInstance() {
        return pInstance;
    }

    public synchronized void update() {
        if (pActiveScreen == null) {
            pScrSplash = new ScreenSplash();
            pActiveScreen = pScrSplash;
        }
        bStartUpdate = true;
        if (bChangeSize) {
            return;
        }
        ++iRun;
        if (pActiveScreen != null) {
            pActiveScreen.update(33L);
        }
        bStartUpdate = false;
    }

    public static void sizeChanged() {
        bChangeSize = !bChangeSize;
        pActiveScreen.onResume();
    }

    public void onEventFired(Event event) {
        if (Pointers.isEventSender(event)) {
            Pointer pointer = (Pointer)event.getData();
            switch (pointer.iAction) {
                case 2: {
                    this.pointerPressed(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 3: {
                    this.pointerReleased(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 4: {
                    this.pointerDragged(pointer.iPositionX, pointer.iPositionY);
                }
            }
        }
        if (Keys.isEventSender(event)) {
            Key pKey = (Key)event.getData();
            switch (pKey.iAction) {
                case 1: {
                    DebugOutput.trace(100, "MyApplication", "onEventFired - pressed");
                    this.keyPressed(pKey);
                    break;
                }
                case 2: {
                    DebugOutput.trace(100, "MyApplication", "onEventFired - released");
                    this.keyReleased(pKey);
                }
            }
        }
    }

    private void pointerPressed(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerPressed(" + iX + ", " + iY + ")");
        if (MenuAnimation.iState != 0) {
            return;
        }
        if (pActiveScreen != null) {
            pActiveScreen.pointerPressed(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerPressed()");
    }

    private void pointerDragged(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerDragged(" + iX + ", " + iY + ")");
        if (pActiveScreen != null) {
            pActiveScreen.pointerDragged(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerDragged()");
    }

    private void pointerReleased(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerReleased(" + iX + ", " + iY + ")");
        if (pActiveScreen != null) {
            pActiveScreen.pointerReleased(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerReleased()");
    }

    private void keyPressed(Key pKey) {
        bGo = false;
        if (bChangeSize) {
            return;
        }
        if (MenuAnimation.iState != 0) {
            return;
        }
        DebugOutput.trace(100, "MyApplication", "pKey.iValue:" + pKey.iValue);
        DebugOutput.trace(100, "MyApplication", "pKey.iAction:" + pKey.iAction);
        MyApplication.pKey = pKey;
        iValue = pKey.iValue;
        iGameAction = pKey.iGameAction;
        if (!this.checkBBUsedKeyboard(pKey)) {
            return;
        }
        bGo = true;
        if (pActiveScreen != null) {
            pActiveScreen.keyPressed(pKey);
        }
    }

    private boolean checkBBUsedKeyboard(Key pKey) {
        if (pKey.iValue == 97 || pKey.iValue == 8 || pKey.iValue == 32 || pKey.iValue == 106 || pKey.iValue == 117 || pKey.iValue == 107 || pKey.iValue == 104 || pKey.iValue == 110 || pKey.iValue == 108 || pKey.iValue == 103 || pKey.iValue == 113 || pKey.iValue == 112) {
            return false;
        }
        return pKey.iValue == Keys.KEY_FNLEFT || pKey.iValue == 50 || pKey.iGameAction == 1 || pKey.iValue == 52 || pKey.iGameAction == 2 || pKey.iValue == 53 || pKey.iGameAction == 8 || pKey.iValue == Keys.KEY_FNRIGHT || pKey.iValue == 54 || pKey.iGameAction == 5 || pKey.iValue == 56 || pKey.iGameAction == 6 || pKey.iValue == 49 || pKey.iValue == 51 || pKey.iValue == 55 || pKey.iValue == 57 || pKey.iValue == 119 || pKey.iValue == 101 || pKey.iValue == 114 || pKey.iValue == 115 || pKey.iValue == 100 || pKey.iValue == 102 || pKey.iValue == 122 || pKey.iValue == 120 || pKey.iValue == 99;
    }

    private void keyReleased(Key pKey) {
        DebugOutput.traceIn(100, "MyApplication", "keyReleased()");
        DebugOutput.trace(100, "MyApplication", "pKey.iValue:" + pKey.iValue);
        DebugOutput.trace(100, "MyApplication", "pKey.iAction:" + pKey.iAction);
        if (pActiveScreen != null) {
            pActiveScreen.keyReleased(pKey);
        }
        DebugOutput.traceOut(100, "MyApplication", "keyReleased()");
    }

    private void paintLoading(simple.video.Graphics g) {
        int iScreenW = g.getWidth();
        int iScreenH = g.getHeight();
        ++this.paintLoading;
        g.setColor(0);
        g.fillRect(0, 0, iScreenW, iScreenH);
        Graphics pTmpGraphics = g.getMicroeditionGraphics();
        String sText = Texts.getString(0);
        pTmpGraphics.setFont(pSystemFont);
        pTmpGraphics.setColor(0);
        pTmpGraphics.drawString(sText, iScreenW / 2, iScreenH / 2, 17);
        pTmpGraphics.setColor(0xFFFFFF);
        pTmpGraphics.drawString(sText, iScreenW / 2 - 1, iScreenH / 2 - 1, 17);
    }

    public void paintScreen(Screen pScreen) {
        simple.video.Graphics g = pScreen.getGraphics();
        bStartPaint = true;
        if (bChangeSize) {
            g.setColor(0);
            g.fillRect(0, 0, g.getWidth(), g.getHeight());
            Resources.pImgRotation.drawAtPoint(g, g.getWidth() - Resources.pImgRotation.getWidth() >> 1, g.getHeight() - Resources.pImgRotation.getHeight() >> 1);
            return;
        }
        if (this.bApplicationPaused) {
            this.onResume();
        }
        if (bLoading) {
            this.paintLoading(g);
            return;
        }
        if (pActiveScreen != null) {
            pActiveScreen.paintScreen(g);
        }
        bStartPaint = false;
    }

    public void onPause() {
        DebugOutput.traceIn(100, "MyApplication", "onPause()");
        ++iCounter;
        bOnPause = true;
        if (this.bApplicationPaused) {
            return;
        }
        Profile.save();
        if (Profile.bMusic) {
            DebugOutput.trace(100, "MyApplication", "StopMusic");
            Profile.bMusic = false;
            soundManager.Stop();
        }
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
        this.bApplicationPaused = true;
        DebugOutput.traceOut(100, "MyApplication", "onPause()");
    }

    public void onStart() {
        bOnStart = true;
        ++iCounter;
        this.onResume();
    }

    public static void resetStatus() {
        bOnResume = false;
        bOnStop = false;
        bOnStart = false;
        bOnPause = false;
    }

    public static void paintStatus(simple.video.Graphics g) {
        int iPosY = 0;
        Graphics pTmpGraphics = g.getMicroeditionGraphics();
        pTmpGraphics.setFont(pSystemFont);
        pTmpGraphics.setColor(0xFFFFFF);
        pTmpGraphics.drawString("VALUE:" + iValue, 0, iPosY, 20);
        pTmpGraphics.drawString("ACTION:" + iGameAction, 0, iPosY += pSystemFont.getHeight(), 20);
        pTmpGraphics.drawString("GO:" + iRun, 0, iPosY += pSystemFont.getHeight(), 20);
        iPosY += pSystemFont.getHeight();
    }

    public void onResume() {
        DebugOutput.traceIn(100, "MyApplication", "onResume()");
        ++iCounter;
        bOnResume = true;
        Profile.loadGame();
        if (pActiveScreen != null) {
            pActiveScreen.onResume();
        }
        this.bApplicationPaused = false;
        DebugOutput.traceOut(100, "MyApplication", "onResume()");
    }

    public void onStop() {
        DebugOutput.trace(100, "MyApplication", "onStop()");
        ++iCounter;
        bOnStop = true;
        if (this.bApplicationPaused) {
            return;
        }
        Profile.save();
        if (Profile.bMusic) {
            Profile.bMusic = false;
            soundManager.SetSoundOn(false);
            soundManager.Stop();
        }
        soundManager.SetSoundOn(false);
        soundManager.Stop();
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
    }

    static {
        pActiveScreen = null;
        pScrSplash = null;
        pScrMenu = null;
        pScrGame = null;
        bLoading = false;
        pSystemFont = null;
        bMusicOn = false;
        ikey = 0;
        iRun = 0;
        bStartUpdate = false;
        bStartPaint = false;
        bChangeSize = false;
        bGo = false;
        iCounter = 0;
        pKey = null;
    }
}

