/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import simple.debug.DebugOutput;
import sk.inlogic.game.SudokuSolver;
import sk.inlogic.util.RandomNum;

public class SudokuGenerator {
    private static String[] s;
    private static int[][] MARK;
    private static int[][] mark_row;
    private static int[][] mark_col;
    public static int[][] maze;
    public static int cells;
    public static int count;
    public static boolean cancelled;

    protected String[] genpuzzle(int level) {
        int val = 0;
        int row = 0;
        int col = 0;
        int region = 0;
        cells = 20;
        count = 0;
        cancelled = false;
        String[] ans = null;
        boolean notsolvable = true;
        maze = new int[10][10];
        mark_row = new int[10][10];
        mark_col = new int[10][10];
        MARK = new int[10][10];
        DebugOutput.trace(100, "SudokuGenerator", "genpuzzle");
        while (notsolvable) {
            this.initialize();
            count = 0;
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                // empty catch block
            }
            while (count <= cells) {
                val = (RandomNum.getRandomUInt(98727) + 1) % 9 + 1;
                row = (RandomNum.getRandomUInt(49837) + 1) % 9 + 1;
                col = (RandomNum.getRandomUInt(28320) + 1) % 9 + 1;
                region = this.decide_mesh(row, col);
                if (maze[row][col] != 0 || row == 0 || col == 0 || val == 0 || mark_row[row][val] != 0 || mark_col[col][val] != 0 || MARK[region][val] != 0) continue;
                SudokuGenerator.maze[row][col] = val;
                SudokuGenerator.mark_row[row][val] = 1;
                SudokuGenerator.mark_col[col][val] = 1;
                SudokuGenerator.MARK[region][val] = 1;
                ++count;
            }
            ans = new SudokuSolver().getAnswer(this.getstrings());
            if (ans == null) continue;
            notsolvable = false;
        }
        String[] ret = this.getstrings(ans, level);
        return ret;
    }

    protected int decide_mesh(int x, int y) {
        if (x < 4) {
            if (y < 4) {
                return 1;
            }
            if (y < 7) {
                return 2;
            }
            return 3;
        }
        if (x < 7) {
            if (y < 4) {
                return 4;
            }
            if (y < 7) {
                return 5;
            }
            return 6;
        }
        if (y < 4) {
            return 7;
        }
        if (y < 7) {
            return 8;
        }
        return 9;
    }

    protected String[] getstrings(String[] a, int level) {
        DebugOutput.traceIn(100, "SudokuGenerator", "getstrings");
        int k = 0;
        int c = 25;
        s = new String[81];
        c -= 5 * level;
        for (int i = 1; i < 10; ++i) {
            for (int j = 1; j < 10; ++j) {
                SudokuGenerator.s[k++] = maze[i][j] != 0 ? new String("" + maze[i][j] + "") : new String("");
            }
        }
        while (c != 0) {
            int m;
            int l = (RandomNum.getRandomUInt(49837) + 1) % 9 + 1;
            if (maze[l][m = (RandomNum.getRandomUInt(28320) + 1) % 9 + 1] != 0) continue;
            ++count;
            k = (l - 1) * 9 + (m - 1);
            SudokuGenerator.s[k] = a[k];
            SudokuGenerator.maze[l][m] = 1;
            --c;
        }
        DebugOutput.trace(100, "SudokuGenerator", "after");
        DebugOutput.traceOut(100, "SudokuGenerator", "getstrings");
        return s;
    }

    protected String[] getstrings() {
        int k = 0;
        s = new String[81];
        for (int i = 1; i < 10; ++i) {
            for (int j = 1; j < 10; ++j) {
                SudokuGenerator.s[k++] = new String("" + maze[i][j] + "");
            }
        }
        return s;
    }

    protected void initialize() {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                SudokuGenerator.MARK[i][j] = 0;
                SudokuGenerator.mark_col[i][j] = 0;
                SudokuGenerator.mark_row[i][j] = 0;
                SudokuGenerator.maze[i][j] = 0;
            }
        }
    }
}

