/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.UiApplication;
import simple.core.Application;
import simple.events.Event;
import simple.input.Keys;
import simple.input.Pointers;
import simple.video.Screen;

public class SimpleCanvas
extends GameCanvas
implements GlobalEventListener,
KeyListener {
    private Screen pScreen;
    private Graphics pGraphics = null;
    private final int iRimLeftKey;
    private UiApplication pUiApplication;

    SimpleCanvas(Screen pScreen, boolean suppressKeyEvents) {
        super(suppressKeyEvents);
        this.iRimLeftKey = 4098;
        super.setFullScreenMode(true);
        this.pScreen = pScreen;
        this.pUiApplication = UiApplication.getUiApplication();
        this.pUiApplication.addKeyListener((KeyListener)this);
        this.pUiApplication.addGlobalEventListener((GlobalEventListener)this);
    }

    public Graphics getGraphics() {
        if (this.pGraphics == null) {
            return super.getGraphics();
        }
        return this.pGraphics;
    }

    public void paint(Graphics g) {
        this.pGraphics = g;
        Application.getSingleton().paintScreen(this.pScreen);
    }

    protected void keyPressed(int iKeyCode) {
        Keys.getSingleton().pressKey(iKeyCode);
    }

    protected void keyReleased(int iKeyCode) {
        Keys.getSingleton().releaseKey(iKeyCode);
    }

    protected void keyRepeated(int iKeyCode) {
    }

    protected void pointerDragged(int x, int y) {
        Pointers.getSingleton().dragPointer(0, x, y, 0, 0);
    }

    protected void pointerPressed(int x, int y) {
        Pointers.getSingleton().pressPointer(0, x, y, 0, 0);
    }

    protected void pointerReleased(int x, int y) {
        Pointers.getSingleton().releasePointer(0, x, y, 0, 0);
    }

    protected void sizeChanged(int w, int h) {
        Event event = new Event("SimpleCanvas", "sizeChanged", "", null);
        Application.getSingleton().getDevice().fireEvent(event);
        event = null;
    }

    protected void showNotify() {
        Application.getSingleton().resume();
    }

    protected void hideNotify() {
        Application.getSingleton().pause();
    }

    public boolean keyChar(char cKey, int iStatus, int iTime) {
        return false;
    }

    public boolean keyDown(int iKeyCode, int iTime) {
        if (Keypad.key((int)iKeyCode) == 4098) {
            Keys.getSingleton().pressKey(Keys.KEY_FNLEFT);
            return true;
        }
        if (Keypad.key((int)iKeyCode) == 27) {
            Keys.getSingleton().pressKey(Keys.KEY_FNRIGHT);
            return true;
        }
        return false;
    }

    public boolean keyRepeat(int keycode, int time) {
        return false;
    }

    public boolean keyStatus(int keycode, int time) {
        return false;
    }

    public boolean keyUp(int iKeyCode, int iTime) {
        if (Keypad.key((int)iKeyCode) == 4098) {
            Keys.getSingleton().releaseKey(Keys.KEY_FNLEFT);
            return true;
        }
        if (Keypad.key((int)iKeyCode) == 27) {
            Keys.getSingleton().releaseKey(Keys.KEY_FNRIGHT);
            return true;
        }
        return false;
    }

    public void eventOccurred(long guid, int data0, int data1, Object object0, Object object1) {
        if (guid == 5961289116197897667L) {
            if (data0 == 1) {
                this.hideNotify();
            } else if (data0 == 2) {
                this.showNotify();
            }
        }
    }
}

