/*
 * Decompiled with CFR 0.152.
 */
package simple.input;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import simple.core.Application;
import simple.core.Device;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Pointer;

public class Pointers {
    public static final int ACTION_POINTER_MOVED = 1;
    public static final int ACTION_POINTER_PRESSED = 2;
    public static final int ACTION_POINTER_RELEASED = 3;
    public static final int ACTION_POINTER_DRAGGED = 4;
    private static Pointers singleton = null;
    private Device device = null;
    private Hashtable mapActivePointers;
    private Pointer releasedPointer;
    private Vector vecPointerEvents;
    public static boolean bPointersAvailable = false;

    public Pointers(Device device) {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.Pointers()");
        this.device = device;
        this.releasedPointer = new Pointer();
        singleton = this;
        this.mapActivePointers = new Hashtable();
        this.vecPointerEvents = new Vector();
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.Pointers()");
    }

    protected void finalize() throws Throwable {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.~Pointers()");
        this.resetActivePointers();
        this.releasedPointer = null;
        System.gc();
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.~Pointers()");
    }

    private void resetActivePointers() {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.resetActivePointers()");
        this.mapActivePointers.clear();
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.resetActivePointers()");
    }

    public void movePointer(int iKey, int iPositionX, int iPositionY, int iValue, int iScreenIndex) {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.movePointer(" + new Integer(iKey).toString() + ", " + new Integer(iPositionX).toString() + ", " + new Integer(iPositionY).toString() + ", " + new Integer(iValue).toString() + ", " + new Integer(iScreenIndex).toString() + ")");
        Long lKey = new Long(iKey);
        Pointer pointer = (Pointer)this.mapActivePointers.get(lKey);
        if (pointer == null) {
            pointer = new Pointer();
            this.mapActivePointers.put(lKey, pointer);
        }
        pointer.iKey = iKey;
        pointer.iPositionX = iPositionX;
        pointer.iPositionY = iPositionY;
        pointer.iValue = iValue;
        pointer.iScreenIndex = iScreenIndex;
        pointer.iAction = 1;
        this.vecPointerEvents.addElement(new Pointer(pointer));
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.movePointer()");
    }

    public void pressPointer(int iKey, int iPositionX, int iPositionY, int iValue, int iScreenIndex) {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.pressPointer(" + new Integer(iKey).toString() + ", " + new Integer(iPositionX).toString() + ", " + new Integer(iPositionY).toString() + ", " + new Integer(iValue).toString() + ", " + new Integer(iScreenIndex).toString() + ")");
        bPointersAvailable = true;
        Long lKey = new Long(iKey);
        Pointer pointer = (Pointer)this.mapActivePointers.get(lKey);
        if (pointer == null) {
            pointer = new Pointer();
            this.mapActivePointers.put(lKey, pointer);
        }
        if (Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iPositionY;
            iPositionY = Application.getSingleton().getDevice().getScreen().getHeight() - iPositionX;
            iPositionX = iTmp;
        }
        pointer.iKey = iKey;
        pointer.iPositionX = iPositionX;
        pointer.iPositionY = iPositionY;
        pointer.iValue = iValue;
        pointer.iScreenIndex = iScreenIndex;
        pointer.iAction = 2;
        this.vecPointerEvents.addElement(new Pointer(pointer));
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.pressPointer()");
    }

    public void releasePointer(int iKey, int iPositionX, int iPositionY, int iValue, int iScreenIndex) {
        DebugOutput.traceIn(2, "SIMPLE", "Pointers.releasePointer(" + new Integer(iKey).toString() + ", " + new Integer(iPositionX).toString() + ", " + new Integer(iPositionY).toString() + ", " + new Integer(iValue).toString() + ", " + new Integer(iScreenIndex).toString() + ")");
        Long lKey = new Long(iKey);
        Pointer pointer = (Pointer)this.mapActivePointers.get(lKey);
        if (pointer != null) {
            this.mapActivePointers.remove(lKey);
        }
        if (Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iPositionY;
            iPositionY = Application.getSingleton().getDevice().getScreen().getHeight() - iPositionX;
            iPositionX = iTmp;
        }
        this.releasedPointer.iKey = iKey;
        this.releasedPointer.iPositionX = iPositionX;
        this.releasedPointer.iPositionY = iPositionY;
        this.releasedPointer.iValue = iValue;
        this.releasedPointer.iScreenIndex = iScreenIndex;
        this.releasedPointer.iAction = 3;
        this.vecPointerEvents.addElement(new Pointer(this.releasedPointer));
        DebugOutput.traceOut(2, "SIMPLE", "Pointers.releasePointer()");
    }

    public void dragPointer(int iKey, int iPositionX, int iPositionY, int iValue, int iScreenIndex) {
        Long lKey = new Long(iKey);
        Pointer pointer = (Pointer)this.mapActivePointers.get(lKey);
        if (pointer == null) {
            pointer = new Pointer();
            this.mapActivePointers.put(lKey, pointer);
        }
        if (Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iPositionY;
            iPositionY = Application.getSingleton().getDevice().getScreen().getHeight() - iPositionX;
            iPositionX = iTmp;
        }
        pointer.iKey = iKey;
        pointer.iPositionX = iPositionX;
        pointer.iPositionY = iPositionY;
        pointer.iValue = iValue;
        pointer.iScreenIndex = iScreenIndex;
        pointer.iAction = 4;
        this.vecPointerEvents.addElement(new Pointer(pointer));
    }

    public synchronized void update() {
        if (!bPointersAvailable) {
            return;
        }
        while (this.vecPointerEvents.size() > 0) {
            Pointer pointer = (Pointer)this.vecPointerEvents.elementAt(0);
            Event event = null;
            switch (pointer.iAction) {
                case 2: {
                    event = new Event("simple.input.Pointers", "pressPointer", "", pointer);
                    break;
                }
                case 3: {
                    event = new Event("simple.input.Pointers", "releasePointer", "", pointer);
                    break;
                }
                case 1: {
                    event = new Event("simple.input.Pointers", "movePointer", "", pointer);
                    break;
                }
                case 4: {
                    event = new Event("simple.input.Pointers", "dragPointer", "", pointer);
                }
            }
            this.device.fireEvent(event);
            event = null;
            pointer = null;
            this.vecPointerEvents.removeElementAt(0);
        }
    }

    public static Pointers getSingleton() {
        DebugOutput.trace(2, "SIMPLE", "Pointers.getSingleton()");
        return singleton;
    }

    public int getActivePointersCount() {
        DebugOutput.trace(2, "SIMPLE", "Pointers.getActivePointersCount()");
        return this.mapActivePointers.size();
    }

    public Pointer getPointerByIndex(int iIndex) {
        DebugOutput.trace(2, "SIMPLE", "Pointers.getPointerByIndex(" + new Integer(iIndex).toString() + ")");
        if (iIndex >= 0 && iIndex < this.mapActivePointers.size()) {
            Enumeration enumElements = this.mapActivePointers.elements();
            for (int i = 0; i < iIndex; ++i) {
                enumElements.nextElement();
            }
            return (Pointer)((Object)enumElements);
        }
        return null;
    }

    public static boolean isEventSender(Event event) {
        return event.getModuleName().compareTo("simple.input.Pointers") == 0;
    }
}

