/*
 * Decompiled with CFR 0.152.
 */
package simple.debug;

public class DebugOutput {
    public static final int DEBUG_LEVEL_SYSTEM = 0;
    public static final int DEBUG_LEVEL_SIMPLE_PLATFORM_CALL = 1;
    public static final int DEBUG_LEVEL_SIMPLE_CALL = 2;
    private static int iDebugLevel = 10;
    private static int iIndentLevel = 0;
    private static String strOutput;
    private static boolean bAlreadyInTrace;

    private static String getIndentString() {
        String sIndentString = " ";
        for (int i = 0; i < iIndentLevel; ++i) {
            sIndentString = sIndentString + "---";
        }
        if (iIndentLevel > 0) {
            sIndentString = sIndentString + " ";
        }
        return sIndentString;
    }

    public static void setDebugLevel(int iDebugLevel) {
        DebugOutput.iDebugLevel = iDebugLevel;
    }

    public static int getDebugLevel() {
        return iDebugLevel;
    }

    public static void trace(int iDebugLevel, String strTag, String strMessage) {
        if (iDebugLevel > 0 && iDebugLevel < DebugOutput.iDebugLevel) {
            return;
        }
        while (bAlreadyInTrace) {
        }
        bAlreadyInTrace = true;
        strOutput = DebugOutput.getIndentString() + ">< " + strMessage;
        if (strTag.length() > 0) {
            strOutput = "[" + strTag + "] " + strOutput;
        }
        System.out.println(strOutput);
        bAlreadyInTrace = false;
    }

    public static void traceNoIndent(int iDebugLevel, String strTag, String strMessage) {
        if (iDebugLevel > 0 && iDebugLevel < DebugOutput.iDebugLevel) {
            return;
        }
        while (bAlreadyInTrace) {
        }
        bAlreadyInTrace = true;
        strOutput = strMessage;
        if (strTag.length() > 0) {
            strOutput = "[" + strTag + "] " + strOutput;
        }
        System.out.println(strOutput);
        bAlreadyInTrace = false;
    }

    public static void traceIn(int iDebugLevel, String strTag, String strMessage) {
        if (iDebugLevel > 0 && iDebugLevel < DebugOutput.iDebugLevel) {
            return;
        }
        while (bAlreadyInTrace) {
        }
        bAlreadyInTrace = true;
        strOutput = DebugOutput.getIndentString() + ">> " + strMessage;
        if (strTag.length() > 0) {
            strOutput = "[" + strTag + "] " + strOutput;
        }
        System.out.println(strOutput);
        ++iIndentLevel;
        bAlreadyInTrace = false;
    }

    public static void traceOut(int iDebugLevel, String strTag, String strMessage) {
        --iIndentLevel;
        if (iDebugLevel > 0 && iDebugLevel < DebugOutput.iDebugLevel) {
            return;
        }
        while (bAlreadyInTrace) {
        }
        bAlreadyInTrace = true;
        strOutput = DebugOutput.getIndentString() + "<< " + strMessage;
        if (strTag.length() > 0) {
            strOutput = "[" + strTag + "] " + strOutput;
        }
        System.out.println(strOutput);
        bAlreadyInTrace = false;
    }

    static {
        bAlreadyInTrace = false;
    }
}

