/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import javax.microedition.lcdui.Graphics;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.input.Key;
import simple.input.Keys;
import sk.inlogic.tt.CMenuItem;
import sk.inlogic.tt.Common;
import sk.inlogic.tt.FontDef;
import sk.inlogic.tt.IMenuAnimationListener;
import sk.inlogic.tt.IMenuItemActivator;
import sk.inlogic.tt.IMenuItemRenderer;
import sk.inlogic.tt.IScreen;
import sk.inlogic.tt.MenuAnimation;
import sk.inlogic.tt.MenuSystem;
import sk.inlogic.tt.MyApplication;
import sk.inlogic.tt.Profile;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.ScreenGame;
import sk.inlogic.tt.Sounds;
import sk.inlogic.tt.Texts;
import sk.inlogic.tt.TextsDescription;

public class ScreenMenu
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer,
IMenuAnimationListener {
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_MENU;
    final int MODE_ABOUT;
    final int MODE_INSTRUCTIONS;
    final int MODE_START_GAME_QUESTION;
    final int MODE_GAME;
    final int MODE_START;
    final int MODE_DIFFICULT;
    final int MODE_QUIT;
    int MI_PLAY;
    int MI_INSTRUCTIONS;
    int MI_SOUND;
    int MI_ABOUT;
    int MI_QUIT;
    public static int SM_CONTINUE;
    public static int SM_NEW_GAME;
    public static int DIF_EASY;
    public static int DIF_MEDIUM;
    public static int DIF_HARD;
    final int MI_MUSIC;
    final int MI_VIBRATIONS;
    final int MI_BACK;
    int iSelectedMenuItem = 0;
    public static int iMode;
    public int iNextMode;
    MenuSystem pMenuSystem = null;
    MyApplication pMyApplication = null;
    private static int textOffsetY;
    private static int iPosYUp;
    private static int iPosXUp;
    private static int iPosYDown;
    private static int iPosXDown;
    private static int iPosXShiftIcon;
    private static int iPosYShiftIcon;
    int iTotalInstructionsPages = 4;
    int iNavigationArrowLeftPosX;
    int iNavigationArrowLeftPosY;
    int iNavigationArrowLeftSize;
    int iNavigationArrowRightPosX;
    int iNavigationArrowRightPosY;
    int iNavigationArrowRightSize;
    private int iyTableName;
    public boolean isLeftActive = true;
    public boolean bBackFromGame;
    String strExternalURL;
    public static boolean bFirstTime;
    private static int iSelectedMenuItems;
    int iStrechMenu = 2;
    boolean bFinishMove = false;
    final int MSTATE_IDLE;
    final int MSTATE_OPENING;
    final int MSTATE_CLOSING;
    int iModeState;
    int iModeStateOffsetActual;
    int iModeStateOffsetInc;
    int iModeStateOffsetDest;
    Keys myKey;
    Key pKey;
    private static int cFontH;
    private static int iTableHeight;
    public static int tableMove;
    public static boolean instructionReleased;
    public static int moveTableY;
    public static int moveTableAcc;
    public static int tableAccDec;
    private boolean bKeyDown = false;
    private boolean bKeyUp = false;
    public static boolean bStartGame;
    public static boolean bSetSelectedMenuItem;
    public static int iMenuItemValue;
    public static long lTimeSpend;
    private int iPosYHelpText;
    public int iPosYLogo;
    public int iPosXLogo;
    public String strAboutText;
    public int iPosYVersion;
    public int iPosXVersion;
    public String strAboutTextDown;
    public int iPosYVersionDown;
    public int iPosXVersionDown;
    public int iCupFrame = 0;
    public static int[][][] iSelectedSetMenuXY;
    public static int iSelectedSetMenuWCount;
    public static int iSelectedSetMenuHCount;
    public static int iPosYNumber;
    public static int iPosYStarFull;
    public static int iPosXStar1;
    public static int iPosXStar2;
    public static int iPosXStar3;
    public static int iPosYLock;
    public static int iPosXLock;
    public static int iLevelSet;
    public static int iLevelActive;
    public static int iHVisibleArea;
    public static int iLevelShift;
    public static int iHVisibleAreaShift;
    public static int iPosXArrow;
    public static int iPosYArrowUp;
    public static int iPosYArrowDown;
    public static int iHInstrAll;
    public static int iHInstrLine;
    public static int iDspY;
    public static int iPosYMoveLevel;
    public static long lTimeSetLevel;
    public int yDrag;
    public static boolean bContinue;

    public ScreenMenu() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_MENU = 2;
        this.MODE_ABOUT = 3;
        this.MODE_INSTRUCTIONS = 4;
        this.MODE_START_GAME_QUESTION = 5;
        this.MODE_GAME = 6;
        this.MODE_START = 7;
        this.MODE_DIFFICULT = 8;
        this.MODE_QUIT = 9;
        this.MI_MUSIC = 0;
        this.MI_VIBRATIONS = 1;
        this.MI_BACK = 2;
        this.MSTATE_IDLE = 0;
        this.MSTATE_OPENING = 1;
        this.MSTATE_CLOSING = 2;
        DebugOutput.traceIn(0, "ScreenMenu", "ScreenMenu()");
        this.pMyApplication = MyApplication.getInstance();
        this.bBackFromGame = false;
        iMode = 1;
        this.myKey = Application.getSingleton().getDevice().getKeys();
        this.pKey = new Key();
        DebugOutput.traceOut(0, "ScreenMenu", "ScreenMenu()");
    }

    public void onMenuClosed() {
        iMode = this.iNextMode;
        switch (iMode) {
            case 2: {
                this.prepareMainMenuItems();
                break;
            }
            case 3: {
                this.prepareAboutMenuItems();
                break;
            }
            case 4: {
                this.prepareInstructions();
                break;
            }
            case 9: {
                this.prepareQuitMenuItems();
                break;
            }
            case 6: {
                this.prepareGameItems();
                break;
            }
            case 7: {
                this.startGame();
                break;
            }
            case 8: {
                this.prepareDifficult();
                break;
            }
            case 5: {
                this.prepareStartGameQuestion();
            }
        }
    }

    public void onMenuOpened() {
        this.pMyApplication.repaintScreen();
    }

    public void update(long tick) {
        switch (iMode) {
            case 1: {
                this.updateModeLoadingRes();
                break;
            }
            case 4: {
                this.updateModeInstrucion();
            }
        }
        if (iMode != 1) {
            Resources.update();
        }
        if (MenuAnimation.iState != 0 || this.pMenuSystem.isAnimating()) {
            MenuAnimation.update();
            this.pMyApplication.repaintScreen();
        }
    }

    private void updateModeInstrucion() {
        if (!Resources.bTouchActivated) {
            int maxOffsetY;
            if (this.myKey.isKeyPressed(50) || this.myKey.isKeyPressed(1) || this.myKey.isKeyPressed(116) || this.myKey.isKeyPressed(101)) {
                if ((textOffsetY -= iHInstrLine >> 1) < 0) {
                    textOffsetY = 0;
                }
            } else if ((this.myKey.isKeyPressed(56) || this.myKey.isKeyPressed(6) || this.myKey.isKeyPressed(120) || this.myKey.isKeyPressed(98)) && (maxOffsetY = iHInstrAll - Resources.iHTable) > 0 && (textOffsetY += iHInstrLine >> 1) > maxOffsetY) {
                textOffsetY = maxOffsetY;
            }
        } else {
            this.runInstruction();
        }
        this.pMyApplication.repaintScreen();
    }

    public void runInstruction() {
        if (cFontH - iTableHeight < 0) {
            return;
        }
        if (moveTableAcc > 0) {
            tableMove += moveTableAcc;
            if ((moveTableAcc -= tableAccDec) < 0) {
                moveTableAcc = 0;
            }
            if (tableMove > 0) {
                tableMove = 0;
                moveTableAcc = 0;
            }
        } else if (moveTableAcc < 0) {
            tableMove += moveTableAcc;
            if ((moveTableAcc += tableAccDec) > 0) {
                moveTableAcc = 0;
            }
            if (tableMove < -(iHInstrAll - Resources.iHTable)) {
                tableMove = -(iHInstrAll - Resources.iHTable);
                moveTableAcc = 0;
            }
        }
    }

    private void updateModeLoadingRes() {
        DebugOutput.traceIn(0, "ScreenMenu", "updateModeLoadingRes()");
        boolean bl = MyApplication.bLoading = !bFirstTime;
        if (MyApplication.bLoading) {
            Application.getSingleton().repaintScreen();
        }
        bFirstTime = false;
        Resources.loadMenuResources();
        Resources.prepareRightAndLeftButtons();
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        if (Profile.bMusic) {
            MyApplication.soundManager.Stop();
            MyApplication.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
        MyApplication.bLoading = false;
        this.pMyApplication.repaintScreen();
        this.prepareMainMenuItems();
        iMode = 2;
        DebugOutput.traceOut(0, "ScreenMenu", "updateModeLoadingRes()");
    }

    private void prepareMainMenuItems() {
        this.pMenuSystem.reset();
        int iMenuItems = 0;
        Resources.prepareRightAndLeftButtons();
        int iHeight = Texts.getFontHeight();
        int iGap = iHeight >> 2;
        Resources.iPosYList = Resources.iScreenW <= 176 ? Resources.iHBoard : (Resources.iScreenW >= 360 && Resources.iScreenH > 480 ? Resources.iHBoard + (Resources.iRightButtonY - Resources.iHBoard - 3 * Resources.iHTable >> 1) : (Resources.iScreenH >= 400 && Resources.iScreenW >= 240 ? Resources.iHBoard + (Resources.iRightButtonY - Resources.iHBoard - 3 * Resources.iHTable >> 1) : Resources.iHBoard + 5));
        int iPosY = Resources.iPosYList + (3 * Resources.iHTable >> 1) - (iHeight << 1) - (iGap << 1) - (iGap << 1);
        String sTmp = Texts.getString(2);
        int iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosYShiftBoardIcon = Texts.getFontHeight() - Resources.pSprCheck.getHeight() >> 1;
        Resources.iPosXMenuText = Resources.iScreenW - Texts.getTextWidth(Texts.getString(2)) >> 1;
        Resources.iPosXBoardIcon = Resources.iPosXMenuText - Resources.pSprCheck.getWidth() - (Resources.pSprCheck.getWidth() >> 1);
        int iHeightBoard = iHeight;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
        this.MI_PLAY = iMenuItems++;
        sTmp = Texts.getString(3);
        iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosXMenuText = Resources.iScreenW - iWidth >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY += iHeightBoard + iGap, iWidth, iHeight));
        this.MI_INSTRUCTIONS = iMenuItems++;
        sTmp = Texts.getString(6);
        iWidth = Texts.getTextWidth(sTmp);
        Resources.iPosXMenuText = Resources.iScreenW - iWidth >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY += iHeightBoard + iGap, iWidth, iHeight));
        iPosY += iHeightBoard + iGap;
        this.MI_ABOUT = iMenuItems++;
        if (!Profile.bMusic) {
            sTmp = Texts.getString(28) + Texts.getString(29);
            iWidth = Texts.getTextWidth(sTmp);
            Resources.iPosXMenuText = Resources.iScreenW - iWidth >> 1;
            this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
            iPosY += iHeightBoard + iGap;
        } else {
            sTmp = Texts.getString(28) + Texts.getString(30);
            iWidth = Texts.getTextWidth(sTmp);
            Resources.iPosXMenuText = Resources.iScreenW - iWidth >> 1;
            this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iPosXMenuText, iPosY, iWidth, iHeight));
            iPosY += iHeightBoard + iGap;
        }
        this.MI_SOUND = iMenuItems++;
        if (bSetSelectedMenuItem) {
            this.pMenuSystem.iSelectedMenuItem = iMenuItemValue;
        }
        int iHInstr = Resources.iRightButtonY - Resources.iHBoard;
        Resources.iPosXGuru = Resources.iScreenW - Resources.iWGuru - 5;
        Resources.iPosYGuru = Resources.iLeftButtonY - Resources.iHGuru;
        DebugOutput.trace(100, "ScreenMenu", "iHInstr:" + iHInstr);
        int tableHeight = 3 * Resources.pSprTable.getHeight() + 5;
        Resources.iDspYIn = -tableHeight + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, tableHeight);
        MenuAnimation.openMenu(this);
    }

    private void prepareStartGameQuestion() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareHelpClean");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sHelpText = "";
        sHelpText = TextsDescription.getString(10);
        Resources.prepareMultiLineDescriptionText(sHelpText, Resources.iWTable - (Resources.iWTable >> 3));
        iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
        int iHobj = iHInstrLine * Resources.vecMultipleLinesDescription.size();
        this.iPosYHelpText = Resources.iPosYList + (Resources.iHTable * 3 - iHobj >> 1);
        this.pMenuSystem.addMenuItem(new CMenuItem(" ", Resources.iPosXMenuText, Resources.iScreenH, 10, 10));
        DebugOutput.trace(100, "ScreenGame", "iPosYHelpText:" + this.iPosYHelpText);
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareHelpClean");
    }

    private void prepareQuitMenuItems() {
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String text = Texts.getString(4);
        int iWidth = Texts.getTextWidth(text);
        int iHeight = Texts.getFontHeight();
        Resources.iPosYList = Resources.iScreenW <= 176 ? Resources.iHBoard : (Resources.iScreenW >= 360 && Resources.iScreenH > 480 ? Resources.iHBoard + (Resources.iRightButtonY - Resources.iHBoard - 3 * Resources.iHTable >> 1) : Resources.iHBoard + 5);
        int tableHeight = 2 * Resources.pSprTable.getHeight() + 5;
        Resources.iDspYIn = -tableHeight + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, tableHeight);
        int iY = Resources.iPosYList + Resources.iHTable - (iHeight >> 1);
        int iX = Resources.iScreenW - iWidth >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(text, iX, iY, iWidth, iHeight));
        MenuAnimation.openMenu(this);
    }

    private void prepareAboutMenuItems() {
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sAbout = Texts.getString(6);
        int iPosYText = (Resources.iHBoard >> 1) - Texts.getFontHeight();
        int iWText = Texts.getTextWidth(sAbout);
        this.iPosYLogo = Resources.iPosYList + (Resources.pSprTable.getHeight() >> 1);
        this.iPosXLogo = Resources.iScreenW - Resources.pImgLogo.getWidth() >> 1;
        this.strAboutText = Texts.iLanguage == 3 ? "MASTER OF SUDOKU" : "MASTER OF SUDOKU";
        this.iPosYVersion = this.iPosYLogo + Resources.pImgLogo.getHeight() + (TextsDescription.getFontHeight() >> 1);
        this.iPosXVersion = Resources.iScreenW - TextsDescription.getTextWidth(this.strAboutText) >> 1;
        this.pMenuSystem.addMenuItem(new CMenuItem(sAbout, Resources.iScreenW - iWText >> 1, iPosYText, iWText, Texts.getFontHeight()));
        this.strAboutTextDown = "V 1.0.1";
        this.iPosYVersionDown = this.iPosYVersion + Texts.getFontHeight();
        this.iPosXVersionDown = Resources.iScreenW - TextsDescription.getTextWidth(this.strAboutTextDown) >> 1;
        MenuAnimation.openMenu(this);
    }

    private void prepareDifficult() {
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        int iMenuItems = 0;
        int iHeight = Texts.getFontHeight();
        int iYGap = iHeight >> 1;
        int iPosY = Resources.iPosYList + (3 * Resources.iHTable >> 1) - iHeight - iYGap - (iHeight >> 1);
        String sTmp = Texts.getString(56);
        int iWidth = Texts.getTextWidth(sTmp);
        int iHeightBoard = iHeight;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iScreenW - iWidth >> 1, iPosY, iWidth, iHeight));
        DIF_EASY = iMenuItems++;
        String sAdd = Texts.getString(57);
        iWidth = Texts.getTextWidth(sAdd);
        this.pMenuSystem.addMenuItem(new CMenuItem(sAdd, Resources.iScreenW - iWidth >> 1, iPosY += iHeightBoard + iYGap, iWidth, iHeight));
        DIF_MEDIUM = iMenuItems++;
        sAdd = Texts.getString(58);
        iWidth = Texts.getTextWidth(sAdd);
        this.pMenuSystem.addMenuItem(new CMenuItem(sAdd, Resources.iScreenW - iWidth >> 1, iPosY += iHeightBoard + iYGap, iWidth, iHeight));
        DIF_HARD = iMenuItems++;
        MenuAnimation.openMenu(this);
    }

    private void prepareGameItems() {
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        int iMenuItems = 0;
        int iHeight = Texts.getFontHeight();
        int yGap = (3 * Resources.iHTable - iHeight * 2) / 7;
        int iPosY = Resources.iPosYList + yGap * 3;
        String sTmp = Texts.getString(54);
        int iWidth = Texts.getTextWidth(sTmp);
        int iHeightBoard = iHeight;
        this.pMenuSystem.addMenuItem(new CMenuItem(sTmp, Resources.iScreenW - iWidth >> 1, iPosY, iWidth, iHeight));
        SM_CONTINUE = iMenuItems++;
        String sAdd = Texts.getString(55);
        iWidth = Texts.getTextWidth(sAdd);
        this.pMenuSystem.addMenuItem(new CMenuItem(sAdd, Resources.iScreenW - iWidth >> 1, iPosY += iHeightBoard + yGap, iWidth, iHeight));
        SM_NEW_GAME = iMenuItems++;
        if (bSetSelectedMenuItem) {
            this.pMenuSystem.iSelectedMenuItem = iMenuItemValue;
        }
        int tableHeight = 3 * Resources.pSprTable.getHeight() + 5;
        Resources.iDspYIn = -tableHeight + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, tableHeight);
        MenuAnimation.openMenu(this);
    }

    public static void printSelectedSetMenuXY() {
        DebugOutput.traceIn(100, "ScreenMenu", "printSelectedSetMenuXY()");
        for (int i = 0; i < iSelectedSetMenuHCount; ++i) {
            for (int j = 0; j < iSelectedSetMenuWCount; ++j) {
                System.out.print("[");
                System.out.print(iSelectedSetMenuXY[i][j][0]);
                System.out.print(",");
                System.out.print(iSelectedSetMenuXY[i][j][1]);
                System.out.print("]  ");
            }
            System.out.print("\n");
        }
        System.out.print("\n");
        DebugOutput.traceOut(100, "ScreenMenu", "printSelectedSetMenuXY()");
    }

    private void prepareInstructions() {
        DebugOutput.traceIn(100, "ScreenGame", "prepareInstructions()");
        this.pMenuSystem.reset();
        Resources.prepareRightAndLeftButtons();
        String sInstr = Texts.getString(3);
        int iPosYText = (Resources.iHBoard >> 1) - Texts.getFontHeight();
        if (Resources.iScreenW <= 176) {
            iPosYText -= Texts.getFontHeight();
        }
        int iWText = Texts.getTextWidth(sInstr);
        int iWInstr = Resources.iWTable - (Resources.iWTable >> 3);
        Resources.prepareInstruction();
        this.pMenuSystem.addMenuItem(new CMenuItem(sInstr, Resources.iScreenW - iWText >> 1, iPosYText, iWText, Texts.getFontHeight()));
        String text = TextsDescription.getString(1) + "\n\n" + TextsDescription.getString(2) + "\n\n" + TextsDescription.getString(3);
        Resources.prepareMultiLineDescriptionText(text, iWInstr);
        iHInstrLine = TextsDescription.getFontHeight() + FontDef.iCharGapSmall;
        cFontH = iHInstrAll = iHInstrLine * Resources.vecMultipleLinesDescription.size();
        DebugOutput.trace(100, "ScreenGame", "iHInstrAll:" + iHInstrAll);
        iTableHeight = Resources.iHTable * Resources.iHListCounter;
        iPosYUp = Resources.iPosYList + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1);
        iPosYDown = Resources.iScreenW >= 360 && Resources.iScreenH > 480 ? Resources.iPosYList + Resources.iHTable * 3 + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1) : Resources.iPosYList + Resources.iHTable * 2 + (Resources.iHTable - Resources.pSprButtonIcons.getHeight() >> 1);
        iPosXDown = iPosXUp = Resources.iScreenW - Resources.pImgScreenButtons.getWidth() >> 1;
        iPosXShiftIcon = 0;
        iPosYShiftIcon = 0;
        tableMove = 0;
        textOffsetY = 0;
        MenuAnimation.openMenu(this);
        DebugOutput.traceOut(100, "ScreenGame", "prepareInstructions()");
    }

    public void paintScreen(simple.video.Graphics g) {
        switch (iMode) {
            case 2: {
                this.paintModeMenu(g);
                break;
            }
            case 3: {
                this.paintModeAbout(g);
                break;
            }
            case 4: {
                this.paintModeInstructions(g);
                break;
            }
            case 9: {
                this.paintModeQuit(g);
                break;
            }
            case 5: {
                this.paintStartGameQuestion(g);
                break;
            }
            case 6: {
                this.paintModeGame(g);
                break;
            }
            case 8: {
                this.paintModeDifficult(g);
            }
        }
    }

    public void paintStartGameQuestion(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
        Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        this.paintHelpSmallText(g);
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 1);
        Resources.paintRightMenuButton(g, 2);
    }

    public void paintHelpSmallText(simple.video.Graphics g) {
        int iPosYText = this.iPosYHelpText + Resources.iDspYIn;
        for (int i = 0; i < Resources.vecMultipleLinesDescription.size(); ++i) {
            String strText = (String)Resources.vecMultipleLinesDescription.elementAt(i);
            int iItemW = TextsDescription.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            TextsDescription.drawTextAtPos(g, Resources.iPosXInstr, iPosYText, strText);
            iPosYText += iHInstrLine;
        }
    }

    void paintBackground(simple.video.Graphics g) {
        Resources.paintBackground(g);
    }

    private void paintModeQuit(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 1);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 1);
        }
        this.pMenuSystem.paintMenu(g);
        Resources.paintLeftMenuButton(g, 1);
        Resources.paintRightMenuButton(g, 2);
    }

    private void paintModeMenu(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        if (!Resources.bTouchActivated) {
            Resources.paintLeftMenuButton(g, 1);
        }
        Resources.paintRightMenuButton(g, 6);
    }

    private void paintModeGame(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        if (!Resources.bTouchActivated) {
            Resources.paintLeftMenuButton(g, 1);
        }
        Resources.paintRightMenuButton(g, 9);
    }

    private void paintModeDifficult(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        if (!Resources.bTouchActivated) {
            Resources.paintLeftMenuButton(g, 1);
        }
        Resources.paintRightMenuButton(g, 9);
    }

    private void paintModeAbout(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            Resources.paintList(g, Resources.iPosYList, 2);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintRightMenuButton(g, 9);
    }

    void paintModeInstructions(simple.video.Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.paintBackground(g);
        if (MenuAnimation.iState == 0) {
            if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
                Resources.paintList(g, Resources.iPosYList, 3);
            } else {
                Resources.paintList(g, Resources.iPosYList, 2);
            }
        } else if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 3);
        } else {
            Resources.paintList(g, Resources.iPosYList + Resources.iDspYIn, 2);
        }
        this.pMenuSystem.paintMenu(g);
        Resources.paintRightMenuButton(g, 9);
    }

    void paintInstructionScreen(simple.video.Graphics g, int iPosYDsp, int iHCount) {
        if (MenuAnimation.iState == 0) {
            iPosYDsp = 0;
        }
        g.setClipRegion(0, Resources.iPosYInstr + iPosYDsp, Resources.iScreenW, Resources.iHTable * iHCount - (Resources.iHTable >> 1));
        int iPosYInstrShift = Resources.bTouchActivated ? Resources.iPosYInstr + tableMove : Resources.iPosYInstr - textOffsetY;
        for (int i = 0; i < Resources.vecMultipleLinesDescription.size(); ++i) {
            String strText = (String)Resources.vecMultipleLinesDescription.elementAt(i);
            int iItemW = TextsDescription.getTextWidth(strText);
            Resources.iPosXInstr = Resources.iScreenW - iItemW >> 1;
            if (iPosYInstrShift >= Resources.iPosYInstr && iPosYInstrShift <= Resources.iPosYInstr + Resources.iHTable * iHCount - (Resources.iHTable >> 1)) {
                TextsDescription.drawTextAtPos(g, Resources.iPosXInstr, iPosYInstrShift + iPosYDsp, strText);
            }
            iPosYInstrShift += iHInstrLine;
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        ScreenMenu.paintNavigArrow(g, iPosYDsp);
    }

    void paintModeAchevements(simple.video.Graphics g) {
        this.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
    }

    public void renderMenuItem(simple.video.Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        int iDspY = 0;
        Resources.renderUpperImage(g, pMenuItem, iMode);
        int iHCount = 0;
        iHCount = iMode == 9 || iMode == 5 ? 1 : 2;
        if (iMode == 4 && Resources.iScreenW >= 360 && Resources.iScreenH > 480) {
            iHCount = 3;
        }
        iDspY = Resources.renderBackPlace(g, pMenuItem, iHCount, Resources.iPosYList);
        pMenuItem.iDspY = 0;
        if (Resources.animationRun && MenuAnimation.iState != 0) {
            iDspY = pMenuItem.iDspY = -pMenuItem.getTop() + Common.barValue(MenuAnimation.iStateOffsetActual, MenuAnimation.iStateOffsetDest, pMenuItem.getTop());
        }
        int iStretch = 0;
        if (bSelected) {
            iStretch = this.bFinishMove ? this.iStrechMenu - Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu) : Common.barValue(this.pMenuSystem.iMenuChangingSelectedItemOffset, 10, this.iStrechMenu);
            if (iStretch == this.iStrechMenu && !this.bFinishMove) {
                this.bFinishMove = true;
                this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
            } else if (iStretch == 0 && this.bFinishMove) {
                this.bFinishMove = false;
                this.pMenuSystem.iMenuChangingSelectedItemOffset = 0;
            }
        }
        if (Resources.bTouchActivated) {
            iStretch = 0;
        }
        switch (iMode) {
            case 5: 
            case 9: {
                g.setClipRegion(0, Resources.iPosYList, Resources.iScreenW, Resources.iHTable * (iHCount + 1));
                Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop(), pMenuItem.getCaption());
                g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                g.setClipRegion(0, Resources.iPosYList, Resources.iScreenW, Resources.iHTable * (iHCount + 1));
                Texts.drawTextAtPos(g, pMenuItem.getLeft(), pMenuItem.getTop(), pMenuItem.getCaption());
                g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
                if (!bSelected || Resources.bTouchActivated) break;
                Resources.paintSprite(g, Resources.pSprCheck, 0, pMenuItem.getLeft() + (pMenuItem.getWidth() >> 1) - (Resources.pSprCheck.getWidth() >> 1), pMenuItem.getTop() + pMenuItem.getHeight());
                break;
            }
            case 3: {
                this.paintAbout(g, Resources.iDspYIn);
                break;
            }
            case 4: {
                this.paintInstructionScreen(g, Resources.iDspYIn, iHCount);
            }
        }
    }

    public void paintAbout(simple.video.Graphics g, int iPosYDsp) {
        if (MenuAnimation.iState != 0) {
            Resources.pImgLogo.drawAtPoint(g, this.iPosXLogo, this.iPosYLogo + iPosYDsp);
            TextsDescription.drawTextAtPos(g, this.iPosXVersion, this.iPosYVersion + iPosYDsp, this.strAboutText);
            TextsDescription.drawTextAtPos(g, this.iPosXVersionDown, this.iPosYVersionDown + iPosYDsp, this.strAboutTextDown);
        } else {
            Resources.pImgLogo.drawAtPoint(g, this.iPosXLogo, this.iPosYLogo);
            TextsDescription.drawTextAtPos(g, this.iPosXVersion, this.iPosYVersion, this.strAboutText);
            TextsDescription.drawTextAtPos(g, this.iPosXVersionDown, this.iPosYVersionDown, this.strAboutTextDown);
        }
    }

    public void paintGame(simple.video.Graphics g, CMenuItem pMenuItem, boolean bSelected, int iStretch) {
    }

    public static void paintNavigArrow(simple.video.Graphics g, int shiftY) {
        boolean bPointerDragged = true;
        boolean bInstruc = false;
        bPointerDragged = false;
        if (cFontH - iTableHeight < 0) {
            return;
        }
        if (Resources.bTouchActivated) {
            if (!bPointerDragged) {
                if (tableMove != 0) {
                    if (tableMove != -(cFontH - Resources.iHTable)) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    }
                }
                if (tableMove != -(cFontH - Resources.iHTable)) {
                    if (tableMove != 0) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    }
                }
            } else {
                if (tableMove != 0) {
                    if (tableMove != -(cFontH - Resources.iHTable)) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                    }
                }
                if (tableMove != -(cFontH - Resources.iHTable)) {
                    if (tableMove != 0) {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    } else {
                        Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                    }
                }
            }
        } else {
            if (textOffsetY != 0) {
                if (textOffsetY != iHInstrAll - Resources.iHTable) {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                } else {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 7, iPosXUp + iPosXShiftIcon, iPosYUp + iPosYShiftIcon + shiftY);
                }
            }
            if (textOffsetY != iHInstrAll - Resources.iHTable) {
                if (textOffsetY != 0) {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                } else {
                    Resources.paintSprite(g, Resources.pSprButtonIcons, 8, iPosXDown + iPosXShiftIcon, iPosYDown + iPosYShiftIcon + shiftY);
                }
            }
        }
    }

    private void paintContinue(simple.video.Graphics g) {
        int iScreenW = g.getWidth();
        int iScreenH = g.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Graphics pTmpGraphics = g.getMicroeditionGraphics();
        String sText = Texts.getString(54);
        pTmpGraphics.setFont(MyApplication.pSystemFont);
        pTmpGraphics.setColor(0);
        pTmpGraphics.drawString(sText, iScreenW / 2, iScreenH / 2, 17);
        pTmpGraphics.setColor(0xFFFFFF);
        pTmpGraphics.drawString(sText, iScreenW / 2 - 1, iScreenH / 2 - 1, 17);
        Resources.paintLeftMenuButton(g, 1);
    }

    public void keyPressed(Key pKey) {
        DebugOutput.trace(100, "ScreenMenu", "iMode:" + iMode);
        if (MenuAnimation.iState != 0) {
            return;
        }
        switch (iMode) {
            case 2: {
                this.keyPressedMainMenu(pKey);
                break;
            }
            case 3: {
                this.keyPressedAbout(pKey);
                break;
            }
            case 4: {
                this.keyPressedModeInstructions(pKey);
                break;
            }
            case 9: {
                if (pKey.iValue == Keys.KEY_FNLEFT) {
                    Application.getSingleton().stop();
                    return;
                }
                if (pKey.iValue != Keys.KEY_FNRIGHT) break;
                this.iNextMode = 2;
                Resources.bButtonOut = true;
                MenuAnimation.closeMenu(this);
                return;
            }
            case 5: {
                this.keyPressedGameQuestion(pKey);
                break;
            }
            case 6: {
                this.keyPressedGame(pKey);
                break;
            }
            case 8: {
                this.keyPressedDifficult(pKey);
            }
        }
        DebugOutput.traceNoIndent(100, "ScreenMenu", "pMyApplication.repaintScreen()");
        this.pMyApplication.repaintScreen();
    }

    public void keyPressedAbout(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            bSetSelectedMenuItem = true;
            iMenuItemValue = this.MI_ABOUT;
            Resources.resetListAnimation();
            Resources.bButtonOut = true;
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
        }
    }

    public void onMenuShiftedUp() {
        iLevelShift -= iHVisibleAreaShift;
    }

    public void shiftDownLevelSet() {
        MenuAnimation.shiftMenu(this, 3);
    }

    public void shiftUpLevelSet() {
        iLevelShift += iHVisibleAreaShift;
        MenuAnimation.shiftMenu(this, 4);
    }

    public void keyPressedModeInstructions(Key pKey) {
        int maxOffsetY;
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Resources.bButtonOut = true;
            Resources.resetListAnimation();
            bSetSelectedMenuItem = true;
            iMenuItemValue = this.MI_INSTRUCTIONS;
            this.iNextMode = 2;
            MenuAnimation.closeMenu(this);
        } else if (this.myKey.isKeyPressed(50) || this.myKey.isKeyPressed(1) || pKey.iGameAction == 1 || pKey.iValue == 50 || this.myKey.isKeyPressed(116) || this.myKey.isKeyPressed(101)) {
            MyApplication.bOnPause = this.myKey.isKeyPressed(1);
            if (Resources.bTouchActivated) {
                if ((tableMove += TextsDescription.getFontHeight() >> 1) > 0) {
                    tableMove = 0;
                }
            } else if ((textOffsetY -= iHInstrLine >> 1) < 0) {
                textOffsetY = 0;
            }
        } else if ((pKey.iValue == 56 || pKey.iGameAction == 6 || pKey.iValue == 120 || pKey.iValue == 98) && (maxOffsetY = iHInstrAll - Resources.iHTable) > 0) {
            if (Resources.bTouchActivated) {
                if ((tableMove -= iHInstrLine >> 1) < -(iHInstrAll - Resources.iHTable)) {
                    tableMove = -(iHInstrAll - Resources.iHTable);
                }
                DebugOutput.traceNoIndent(100, "ScreenMenu", "bTouchActivated here is tableMove:" + tableMove);
            } else {
                DebugOutput.traceNoIndent(100, "ScreenMenu", "here is textOffsetY:" + (textOffsetY += iHInstrLine >> 1));
                if (textOffsetY > maxOffsetY) {
                    textOffsetY = maxOffsetY;
                }
            }
            DebugOutput.trace(100, "ScreenMenu", "keyPressedModeInstructions maxOffsetY:" + maxOffsetY + " textOffsetY:" + textOffsetY);
        }
    }

    public void keyPressedMainMenu(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.iNextMode = 9;
            Resources.bButtonOut = true;
            iMenuItemValue = this.pMenuSystem.iSelectedMenuItem;
            bSetSelectedMenuItem = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (!(Resources.bTouchActivated || pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != 8)) {
            this.onMenuItemActivatedMenuItem(this.pMenuSystem.iSelectedMenuItem);
            return;
        }
        DebugOutput.trace(100, "ScreenMenu", "keyPressedMainMenu");
        this.pMenuSystem.keyPressed(pKey);
        this.pMyApplication.repaintScreen();
    }

    public void keyPressedDifficult(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            if (Profile.bFirstGame) {
                this.iNextMode = 2;
            } else {
                this.iNextMode = 6;
                iMenuItemValue = SM_NEW_GAME;
            }
            bSetSelectedMenuItem = true;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (!(Resources.bTouchActivated || pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != 8)) {
            this.onMenuItemActivatedDifficult(this.pMenuSystem.iSelectedMenuItem);
            return;
        }
        this.pMenuSystem.keyPressed(pKey);
    }

    public void keyPressedGame(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.iNextMode = 2;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (!(Resources.bTouchActivated || pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != 8)) {
            this.onMenuItemActivatedGameItem(this.pMenuSystem.iSelectedMenuItem);
            return;
        }
        this.pMenuSystem.keyPressed(pKey);
    }

    public void keyPressedGameQuestion(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.iNextMode = 6;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            this.startNewGame();
            return;
        }
    }

    public void onMenuItemActivated(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "activateMenuItem(" + iMenuItem + ")");
        switch (iMode) {
            case 2: {
                this.onMenuItemActivatedMenuItem(iMenuItem);
                break;
            }
            case 6: {
                this.onMenuItemActivatedGameItem(iMenuItem);
                break;
            }
            case 8: {
                this.onMenuItemActivatedDifficult(iMenuItem);
            }
        }
        DebugOutput.traceOut(100, "ScreenMenu", "activateMenuItem()");
    }

    private void onMenuItemActivatedDifficult(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "onMenuItemActivatedDifficult(" + iMenuItem + ")");
        this.startNewGameDifficult(iMenuItem);
        DebugOutput.traceOut(100, "ScreenMenu", "onMenuItemActivatedDifficult(" + iMenuItem + ")");
    }

    private void onMenuItemActivatedGameItem(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "onMenuItemActivatedGameItem(" + iMenuItem + ")");
        MyApplication.resetStatus();
        if (iMenuItem == SM_CONTINUE) {
            DebugOutput.trace(100, "ScreenMenu", "SM_CONTINUE");
            this.startContinue();
            DebugOutput.traceOut(100, "ScreenMenu", "onMenuItemActivatedGameItem(" + iMenuItem + ")");
            return;
        }
        if (iMenuItem == SM_NEW_GAME) {
            DebugOutput.trace(100, "ScreenMenu", "SM_NEW_GAME");
            this.startNewGameQuestion();
            DebugOutput.traceOut(100, "ScreenMenu", "onMenuItemActivatedGameItem(" + iMenuItem + ")");
            return;
        }
    }

    private void onMenuItemActivatedMenuItem(int iMenuItem) {
        bSetSelectedMenuItem = false;
        DebugOutput.traceIn(100, "ScreenMenu", "activateMainMenuItem(" + iMenuItem + ")");
        if (iMenuItem == this.MI_PLAY) {
            Profile.loadGame();
            this.iNextMode = Profile.bFirstGame ? 8 : 6;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (iMenuItem == this.MI_ABOUT) {
            this.iNextMode = 3;
            Resources.bButtonOut = true;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (iMenuItem == this.MI_INSTRUCTIONS) {
            Resources.bButtonOut = true;
            Resources.prepareInstruction();
            this.iNextMode = 4;
            MenuAnimation.closeMenu(this);
            return;
        }
        if (iMenuItem == this.MI_SOUND) {
            if (Profile.bMusic) {
                Profile.bMusic = false;
                if (MyApplication.soundManager.IsSoundOn()) {
                    MyApplication.soundManager.SetSoundOn(false);
                    MyApplication.soundManager.Stop();
                }
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(iMenuItem);
                x.strCaption = Texts.getString(28) + Texts.getString(29);
                x.iRight = x.iPosX + Texts.getTextWidth(x.strCaption);
            } else {
                Profile.bMusic = true;
                MyApplication.soundManager.SetSoundOn(true);
                MyApplication.soundManager.Play(Sounds.SOUND_MENU, -1);
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(iMenuItem);
                x.strCaption = Texts.getString(28) + Texts.getString(30);
                x.iRight = x.iPosX + Texts.getTextWidth(x.strCaption);
            }
            Profile.save();
            return;
        }
        DebugOutput.traceOut(100, "ScreenMenu", "activateMainMenuItem()");
    }

    private void startNewGameDifficult(int iDiff) {
        this.iNextMode = 7;
        Resources.bButtonOut = true;
        Resources.iNewGameDifficult = iDiff;
        Resources.bNewGame = true;
        MenuAnimation.closeMenu(this);
    }

    private void startNewGameQuestion() {
        this.iNextMode = 5;
        Resources.bButtonOut = true;
        MenuAnimation.closeMenu(this);
    }

    private void startNewGame() {
        this.iNextMode = 8;
        Resources.bButtonOut = true;
        MenuAnimation.closeMenu(this);
    }

    private void startContinue() {
        Resources.iNewGameDifficult = -1;
        Resources.bNewGame = false;
        this.iNextMode = 7;
        Resources.bButtonOut = true;
        MenuAnimation.closeMenu(this);
    }

    private void startGame() {
        DebugOutput.traceIn(100, "ScreenMenu", "startGame()");
        Resources.releaseMenuResources();
        MyApplication.pScrGame = new ScreenGame();
        MyApplication.pActiveScreen = MyApplication.pScrGame;
        MyApplication.pScrMenu = null;
        System.gc();
        iMode = 0;
        DebugOutput.traceOut(100, "ScreenMenu", "startGame()");
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerPressed(int x, int y) {
        switch (iMode) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                if (Resources.pressedLeftButton(x, y, 20)) {
                    this.pKey.iValue = Keys.KEY_FNLEFT;
                    this.keyPressed(this.pKey);
                    return;
                }
                if (Resources.pressedRightButton(x, y)) {
                    this.pKey.iValue = Keys.KEY_FNRIGHT;
                    this.keyPressed(this.pKey);
                    return;
                }
                this.pMenuSystem.pointerPressed(x, y);
                break;
            }
            case 3: {
                if (!Resources.pressedRightButton(x, y)) break;
                this.pKey.iValue = Keys.KEY_FNRIGHT;
                this.keyPressed(this.pKey);
                return;
            }
            case 4: {
                this.pointerPressedInstruction(x, y);
            }
        }
        this.pMyApplication.repaintScreen();
    }

    public void pointerPressedSelectLevel(int x, int y) {
        iPosYMoveLevel = -1;
        lTimeSetLevel = 0L;
        if (Resources.pressedLeftButton(x, y, 30)) {
            this.pKey.iValue = Keys.KEY_FNLEFT;
            this.keyPressed(this.pKey);
            return;
        }
        if (Resources.pressedRightButton(x, y)) {
            this.pKey.iValue = Keys.KEY_FNRIGHT;
            this.keyPressed(this.pKey);
            return;
        }
        this.yDrag = y;
    }

    public void pointerPressedInstruction(int x, int y) {
        moveTableY = y;
        instructionReleased = false;
        if (Resources.pressedRightButton(x, y)) {
            this.pKey.iValue = Keys.KEY_FNRIGHT;
            this.keyPressed(this.pKey);
            return;
        }
    }

    public boolean pressedInstructionDown(int x, int y) {
        int iW = Resources.pImgScreenButtons.getWidth();
        int iH = Resources.pImgScreenButtons.getHeight();
        if (y < iPosYDown || y > iPosYDown + iH) {
            return false;
        }
        return x >= iPosXDown && x <= iPosXDown + iW;
    }

    public boolean pressedInstructionUp(int x, int y) {
        int iW = Resources.pImgScreenButtons.getWidth();
        int iH = Resources.pImgScreenButtons.getHeight();
        if (y < iPosYUp || y > iPosYUp + iH) {
            return false;
        }
        return x >= iPosXUp && x <= iPosXUp + iW;
    }

    public boolean pressedPlay(int x, int y) {
        DebugOutput.traceIn(100, "ScreenMenu", "pressedPlay()");
        DebugOutput.traceOut(100, "ScreenMenu", "pressedPlay = true");
        return true;
    }

    public void pointerReleased(int x, int y) {
        if (iMode == 4) {
            DebugOutput.trace(100, "ScreenMenu", "pointer released, set table move");
            if (tableMove < -(cFontH - iTableHeight)) {
                tableMove = -(cFontH - iTableHeight);
                moveTableAcc = 0;
            }
            if (tableMove > 0) {
                tableMove = 0;
                moveTableAcc = 0;
            }
        }
        this.bKeyDown = false;
        this.bKeyUp = false;
    }

    public void pointerDragged(int x, int y) {
        if (iMode == 4) {
            if (cFontH - iTableHeight < 0) {
                return;
            }
            moveTableAcc = y < moveTableY ? -(moveTableY - y) : y - moveTableY;
            tableMove += moveTableAcc;
            moveTableY = y;
            instructionReleased = false;
            this.runInstruction();
        }
    }

    public void onPause() {
        if (iMode == 2) {
            CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(this.MI_SOUND);
            x.strCaption = Texts.getString(28) + Texts.getString(29);
            x.iWidth = Texts.getTextWidth(x.strCaption);
            x.iPosX = Resources.iScreenW - x.iWidth >> 1;
            x.iRight = x.iPosX + x.iWidth;
        }
    }

    public void onResume() {
        DebugOutput.traceNoIndent(100, "ScreenMenu", "onResume");
        if (Profile.bMusic) {
            DebugOutput.traceNoIndent(100, "ScreenMenu", "PlayMusic");
            MyApplication.soundManager.SetSoundOn(true);
            MyApplication.soundManager.Play(Sounds.SOUND_MENU, -1);
            if (iMode == 2) {
                CMenuItem x = (CMenuItem)this.pMenuSystem.vecMenuItems.elementAt(this.MI_SOUND);
                x.strCaption = Texts.getString(28) + Texts.getString(30);
                x.iWidth = Texts.getTextWidth(x.strCaption);
                x.iPosX = Resources.iScreenW - x.iWidth >> 1;
                x.iRight = x.iPosX + x.iWidth;
            }
        }
    }

    static {
        bFirstTime = true;
        tableMove = 0;
        instructionReleased = true;
        moveTableY = 0;
        moveTableAcc = 0;
        tableAccDec = 2;
        bStartGame = false;
        lTimeSpend = 0L;
        iSelectedSetMenuXY = null;
        iHInstrAll = 0;
        iHInstrLine = 0;
        iDspY = 0;
        iPosYMoveLevel = -1;
        lTimeSetLevel = 0L;
    }
}

