/*
 * Decompiled with CFR 0.152.
 */
package simple.output;

import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import simple.core.Application;
import simple.core.Device;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.output.File;

public class FileSystem {
    private static FileSystem pSingleton;
    Device pDevice;
    public static final int EVENT_FILE_CREATION_FAILED = 1200;
    public static final int EVENT_FILE_OPEN_FAILED = 1201;
    public static final int EVENT_FILE_DELETE_FAILED = 1202;
    public static final int EVENT_DIR_SET_FAILED = 1203;

    public FileSystem(Device pDevice) {
        DebugOutput.traceIn(2, "SIMPLE", "FileSystem.FileSystem()");
        this.pDevice = pDevice;
        pSingleton = this;
        DebugOutput.traceOut(2, "SIMPLE", "FileSystem.FileSystem()");
    }

    protected void finalize() throws Throwable {
    }

    public String getCurrentDirectory() {
        return "";
    }

    public boolean setCurrentDirectory(String sDirectoryPath) {
        return true;
    }

    public String getApplicationRoot() {
        return "";
    }

    static boolean isRecordStore(String sFileName) {
        if ((sFileName = sFileName.toLowerCase()).startsWith("rs:")) {
            return true;
        }
        if (sFileName.startsWith("rstore:")) {
            return true;
        }
        return sFileName.startsWith("recordstore:");
    }

    static String getRecordStoreName(String sFileName) {
        if (sFileName.startsWith("rs:")) {
            sFileName = sFileName.substring(3);
        }
        if (sFileName.startsWith("rstore:")) {
            sFileName = sFileName.substring(8);
        }
        if (sFileName.startsWith("recordstore:")) {
            sFileName = sFileName.substring(12);
        }
        return sFileName;
    }

    public boolean fileExistsAtPath(String sPath) {
        boolean bRetVal = false;
        if (FileSystem.isRecordStore(sPath)) {
            sPath = FileSystem.getRecordStoreName(sPath);
            RecordStore rsTmp = null;
            try {
                rsTmp = RecordStore.openRecordStore((String)sPath, (boolean)false);
                bRetVal = true;
            }
            catch (Exception ex) {
                bRetVal = false;
            }
            if (rsTmp != null) {
                try {
                    rsTmp.closeRecordStore();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            rsTmp = null;
            System.gc();
        } else {
            try {
                InputStream pInputStream = ((Object)((Object)Application.getSingleton())).getClass().getResourceAsStream(sPath);
                pInputStream = null;
                bRetVal = true;
            }
            catch (Exception ex) {
                bRetVal = false;
            }
        }
        DebugOutput.traceNoIndent(2, "FileSystem", "fileExistsAtPath(" + sPath + ") = " + (bRetVal ? "TRUE" : "FALSE"));
        return bRetVal;
    }

    public File createFileAtPath(String sPath) {
        DebugOutput.trace(2, "FileSystem", "createFileAtPath(" + sPath + ")");
        if (this.fileExistsAtPath(sPath)) {
            return null;
        }
        File pFile = new File(this);
        pFile.create(sPath);
        return pFile;
    }

    public File openFileAtPath(String sPath) {
        DebugOutput.trace(2, "FileSystem", "openFileAtPath(" + sPath + ")");
        if (!this.fileExistsAtPath(sPath)) {
            return null;
        }
        File pFile = new File(this);
        pFile.open(sPath);
        return pFile;
    }

    public File openFileAtPathForReadingOnly(String sPath) {
        DebugOutput.traceNoIndent(2, "FileSystem", "openFileAtPathForReadingOnly(" + sPath + ")");
        if (!this.fileExistsAtPath(sPath)) {
            return null;
        }
        File pFile = new File(this);
        pFile.openForReadingOnly(sPath);
        return pFile;
    }

    public boolean deleteFileAtPath(String sPath) {
        boolean bRetVal = false;
        if (FileSystem.isRecordStore(sPath)) {
            sPath = FileSystem.getRecordStoreName(sPath);
            try {
                RecordStore.deleteRecordStore((String)sPath);
                bRetVal = true;
            }
            catch (Exception ex) {
                bRetVal = false;
            }
        } else {
            System.out.println("You can ony delete recordstore files");
        }
        DebugOutput.trace(2, "FileSystem", "deleteFileAtPath(" + sPath + ") = " + (bRetVal ? "TRUE" : "FALSE"));
        return bRetVal;
    }

    public static FileSystem getSingleton() {
        return pSingleton;
    }

    public static boolean isEventSender(Event event) {
        DebugOutput.trace(2, "SIMPLE", "FileSystem.isEventSender()");
        return event.getModuleName().compareTo("simple.output.FileSystem") == 0;
    }
}

