/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import simple.debug.DebugOutput;
import simple.output.File;
import simple.output.FileSystem;
import sk.inlogic.game.Game;
import sk.inlogic.tt.Resources;

public class Profile {
    static final String FILENAME = "rs:fr_profile";
    static Profile pInstance;
    public static boolean bMusic;
    public static int iBestScore;
    public static int iBestScoreChallenge;
    public static boolean bGameOver;
    public static boolean bGameComplete;
    public static boolean bFirstGame;
    public static boolean[] bShowTutorial;
    public static final int TUT_BASIC_1 = 0;
    public static final int TUT_BASIC_2 = 1;
    public static final int TUT_BASIC_3 = 2;
    public static final int TUT_BASIC_4 = 3;
    public static final int TUT_BASIC_WELL_DONE = 4;
    public static final int TUT_SCREEN = 5;
    public static final int TUT_SCREEN_WELL_DONE = 6;
    public static final int TUT_STRAW = 7;
    public static final int TUT_STRAW_WELL_DONE = 8;
    public static final int TUT_FLOW = 9;
    public static final int TUT_FLOW_WELL_DONE = 10;
    public static final int TUT_GAME_OVER_ALL_LEVELS = 11;
    public static final int TUT_GAME_OVER_ALL_STARS = 12;
    public static final int TUT_GAME_OVER_ALL_DONE = 13;
    public static final int TUT_HELP_START_2_LEVEL_1 = 14;
    public static final int TUT_HELP_START_2_LEVEL_2 = 15;
    public static final int TUT_FROG = 16;
    public static final int TUT_ALL = 17;

    public static void cleanTutorialBooleans() {
        for (int i = 0; i < bShowTutorial.length; ++i) {
            Profile.bShowTutorial[i] = false;
        }
    }

    public static void save() {
        DebugOutput.traceIn(100, "Profile", "save()");
        FileSystem pFileSystem = FileSystem.getSingleton();
        pFileSystem.deleteFileAtPath(FILENAME);
        File pFile = pFileSystem.createFileAtPath(FILENAME);
        if (pFile == null) {
            DebugOutput.trace(100, "Profile", "pFile is NULL");
            return;
        }
        pFile.writeBool(bFirstGame);
        pFile.writeInt(Resources.iNewGameDifficult);
        pFile.writeLong(Resources.lTime);
        Game.printSudokuBooleans();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                pFile.writeInt(Game.aiSudoku[i][j]);
                pFile.writeBool(Game.abSudoku[i][j]);
                pFile.writeBool(Game.abSudokuFail[i][j]);
            }
        }
        pFile.writeInt(Game.iCountToWin);
        pFile.writeBool(bMusic);
        pFile.close();
        DebugOutput.traceOut(100, "Profile", "save()");
    }

    public static boolean loadGame() {
        DebugOutput.traceIn(100, "Profile", "loadGame()");
        FileSystem pFileSystem = FileSystem.getSingleton();
        File pFile = pFileSystem.openFileAtPath(FILENAME);
        if (pFile == null) {
            DebugOutput.trace(100, "Profile", "load game = first game true");
            DebugOutput.traceOut(100, "Profile", "load() - false");
            bFirstGame = true;
            return false;
        }
        bFirstGame = pFile.readBool();
        Resources.iNewGameDifficult = pFile.readInt();
        Resources.lTime = pFile.readLong();
        Game.iErrBefore = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                Game.aiSudoku[i][j] = pFile.readInt();
                Game.abSudoku[i][j] = pFile.readBool();
                Game.abSudokuFail[i][j] = pFile.readBool();
                ++Game.iErrBefore;
            }
        }
        Game.iCountToWin = pFile.readInt();
        bMusic = pFile.readBool();
        pFile.close();
        Game.printSudokuBooleans();
        DebugOutput.traceOut(100, "Profile", "loadGame()");
        return true;
    }

    static {
        bGameComplete = false;
        bFirstGame = false;
        bShowTutorial = null;
        pInstance = new Profile();
        bShowTutorial = new boolean[17];
        Profile.cleanTutorialBooleans();
    }
}

