/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.tt;

import java.util.Vector;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.tt.CMenuItem;
import sk.inlogic.tt.IMenuItemActivator;
import sk.inlogic.tt.IMenuItemRenderer;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.ScreenSplash;

public class MenuSystem {
    Vector vecMenuItems;
    int iPrevSelectedMenuItem;
    int iSelectedMenuItem;
    public final int MAX_MENU_ITEMS;
    int iMenuItemsCount;
    public static final int CHANGING_SELECTED_ITEM_TICKS = 10;
    public int iMenuChangingSelectedItemOffset;
    public static final int CSTYLE_HORIZONTAL = 4;
    public static final int CSTYLE_VERTICAL = 16;
    private int iMenuControlStyle = 16;
    public int iControStyleItemIncVertical = 1;
    public int iControStyleItemIncHorizontal = 1;
    private IMenuItemActivator pMenuItemActivator = null;
    private IMenuItemRenderer pMenuItemRenderer = null;
    private static MenuSystem pInstance = null;

    public static MenuSystem getInstance() {
        if (pInstance == null) {
            pInstance = new MenuSystem();
        }
        return pInstance;
    }

    public void releaseInstance() {
        if (pInstance != null) {
            pInstance = null;
            System.gc();
        }
    }

    public MenuSystem() {
        this.MAX_MENU_ITEMS = 10;
        this.reset();
    }

    public void setMenuItemActivator(IMenuItemActivator pMenuItemActivator) {
        this.pMenuItemActivator = pMenuItemActivator;
    }

    public void setMenuItemRenderer(IMenuItemRenderer pMenuItemRenderer) {
        this.pMenuItemRenderer = pMenuItemRenderer;
    }

    public CMenuItem getItem(int iIndex) {
        return (CMenuItem)this.vecMenuItems.elementAt(iIndex);
    }

    public int getSelectedItem() {
        return this.iSelectedMenuItem;
    }

    public void setSelectedItem(int iSelectedItem) {
        this.iSelectedMenuItem = iSelectedItem;
    }

    public void setMenuControlStyle(int iMenuControlStyle) {
        this.iMenuControlStyle = iMenuControlStyle;
    }

    public boolean isAnimating() {
        return this.iMenuChangingSelectedItemOffset < 10;
    }

    public void reset() {
        this.setMenuControlStyle(16);
        this.vecMenuItems = new Vector();
        this.iMenuItemsCount = 0;
        this.iPrevSelectedMenuItem = 0;
        this.iSelectedMenuItem = 0;
        this.iControStyleItemIncVertical = 1;
        this.iControStyleItemIncHorizontal = 1;
    }

    public void addMenuItem(CMenuItem pMenuItem) {
        pMenuItem.iIndex = this.iMenuItemsCount++;
        this.vecMenuItems.addElement(pMenuItem);
    }

    public void paintMenu(Graphics g) {
        int iSize = this.vecMenuItems.size();
        if (this.iMenuChangingSelectedItemOffset < 10) {
            ++this.iMenuChangingSelectedItemOffset;
        }
        for (int i = 0; i < iSize; ++i) {
            if (i == this.iSelectedMenuItem) continue;
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, false);
        }
        CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(this.iSelectedMenuItem);
        this.pMenuItemRenderer.renderMenuItem(g, pMenuItem, true);
    }

    public void keyPressed(Key pKey) {
        if ((this.iMenuControlStyle & 0x10) != 0) {
            if (pKey.iValue == 116 || pKey.iGameAction == 1) {
                this.iPrevSelectedMenuItem = this.iSelectedMenuItem;
                this.iMenuChangingSelectedItemOffset = 0;
                this.iSelectedMenuItem -= this.iControStyleItemIncVertical;
                if (this.iSelectedMenuItem < 0) {
                    this.iSelectedMenuItem += this.iMenuItemsCount;
                }
            }
            if (pKey.iValue == 98 || pKey.iGameAction == 6) {
                this.iPrevSelectedMenuItem = this.iSelectedMenuItem;
                this.iMenuChangingSelectedItemOffset = 0;
                this.iSelectedMenuItem += this.iControStyleItemIncVertical;
                if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                    this.iSelectedMenuItem -= this.iMenuItemsCount;
                }
            }
        }
        if ((this.iMenuControlStyle & 4) != 0) {
            if (pKey.iGameAction == 2 || pKey.iValue == 102) {
                this.iPrevSelectedMenuItem = this.iSelectedMenuItem;
                this.iMenuChangingSelectedItemOffset = 0;
                this.iSelectedMenuItem -= this.iControStyleItemIncHorizontal;
                if (this.iSelectedMenuItem < 0) {
                    this.iSelectedMenuItem += this.iMenuItemsCount;
                }
            }
            if (pKey.iGameAction == 5 || pKey.iValue == 104) {
                this.iPrevSelectedMenuItem = this.iSelectedMenuItem;
                this.iMenuChangingSelectedItemOffset = 0;
                this.iSelectedMenuItem += this.iControStyleItemIncHorizontal;
                if (this.iSelectedMenuItem >= this.iMenuItemsCount) {
                    this.iSelectedMenuItem -= this.iMenuItemsCount;
                }
            }
        }
        if (ScreenSplash.iMode == 2) {
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == 8 || pKey.iValue == 103) {
            if (this.pMenuItemActivator == null) {
                return;
            }
            this.activateSelectedMenuItem();
        }
        System.out.println("MenuSystem.keyPressed: " + this.iSelectedMenuItem);
    }

    public void pointerPressed(int iX, int iY) {
        for (int i = 0; i < this.iMenuItemsCount; ++i) {
            CMenuItem pMenuItem = (CMenuItem)this.vecMenuItems.elementAt(i);
            if (!pMenuItem.containsPoint(iX, iY)) continue;
            this.iSelectedMenuItem = i;
            this.pMenuItemActivator.onMenuItemActivated(this.iSelectedMenuItem);
            return;
        }
        if (ScreenSplash.iMode != 2 && Resources.pressedRightButton(iX, iY)) {
            this.pMenuItemActivator.onMenuItemActivated(this.iSelectedMenuItem);
        }
    }

    public void activateSelectedMenuItem() {
        this.pMenuItemActivator.onMenuItemActivated(this.iSelectedMenuItem);
    }
}

