/*
 * Decompiled with CFR 0.152.
 */
package simple.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.output.FileSystem;

public class File {
    private RecordStore rsFile = null;
    private ByteArrayOutputStream pDataArray = null;
    private DataOutputStream pDataOutputStream = null;
    private DataInputStream pDataInputStream = null;
    byte[] aRecord = null;

    File(FileSystem pFileSystem) {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    boolean create(String sFileName) {
        System.out.println("> File.create(" + sFileName + ")");
        this.close();
        if (!FileSystem.isRecordStore(sFileName)) {
            System.out.println("simple.output.File.create(\"" + sFileName + "\") : you can only create rstore files");
            System.out.println("< File.create(" + sFileName + ") = FALSE");
            return false;
        }
        sFileName = FileSystem.getRecordStoreName(sFileName);
        boolean bRetVal = true;
        try {
            this.rsFile = RecordStore.openRecordStore((String)sFileName, (boolean)true);
            this.pDataArray = new ByteArrayOutputStream();
            this.pDataOutputStream = new DataOutputStream(this.pDataArray);
        }
        catch (Exception e) {
            bRetVal = false;
            e.printStackTrace();
        }
        System.out.println("  pDataOutputStream = " + this.pDataOutputStream);
        System.out.println("  pDataInputStream = " + this.pDataInputStream);
        System.out.println("< File.create(" + sFileName + ") = " + (bRetVal ? "TRUE" : "FALSE"));
        return bRetVal;
    }

    boolean open(String sFileName) {
        System.out.println("> File.open(" + sFileName + ")");
        this.close();
        if (!FileSystem.isRecordStore(sFileName)) {
            System.out.println("simple.output.File.open(\"" + sFileName + "\") : archieved files can be only opened in read only mode");
            System.out.println("< File.create(" + sFileName + ") = FALSE");
        }
        sFileName = FileSystem.getRecordStoreName(sFileName);
        boolean bRetVal = true;
        try {
            this.rsFile = RecordStore.openRecordStore((String)sFileName, (boolean)false);
            this.pDataArray = new ByteArrayOutputStream();
            if (this.rsFile.getNumRecords() > 0) {
                this.aRecord = this.rsFile.getRecord(1);
                this.pDataInputStream = new DataInputStream(new ByteArrayInputStream(this.aRecord));
            }
            this.pDataOutputStream = new DataOutputStream(this.pDataArray);
            if (this.aRecord != null) {
                this.pDataOutputStream.write(this.aRecord, 0, this.aRecord.length);
            }
        }
        catch (Exception e) {
            bRetVal = false;
            e.printStackTrace();
        }
        System.out.println("  pDataOutputStream = " + this.pDataOutputStream);
        System.out.println("  pDataInputStream = " + this.pDataInputStream);
        System.out.println("< File.open(" + sFileName + ") = " + (bRetVal ? "TRUE" : "FALSE"));
        return bRetVal;
    }

    boolean openForReadingOnly(String sFileName) {
        System.out.println("> File.openForReadingOnly(" + sFileName + ")");
        this.close();
        boolean bRetVal = true;
        InputStream pInputStream = null;
        try {
            if (!FileSystem.isRecordStore(sFileName)) {
                pInputStream = ((Object)((Object)Application.getSingleton())).getClass().getResourceAsStream(sFileName);
                this.pDataInputStream = new DataInputStream(pInputStream);
            } else {
                sFileName = FileSystem.getRecordStoreName(sFileName);
                this.rsFile = RecordStore.openRecordStore((String)sFileName, (boolean)false);
                if (this.rsFile.getNumRecords() > 0) {
                    this.aRecord = this.rsFile.getRecord(1);
                    this.pDataInputStream = new DataInputStream(new ByteArrayInputStream(this.aRecord));
                }
            }
        }
        catch (Exception e) {
            bRetVal = false;
            e.printStackTrace();
        }
        System.out.println("  pInputStream = " + pInputStream);
        System.out.println("  pDataInputStream = " + this.pDataInputStream);
        try {
            System.out.println("  pDataInputStream.available() = " + this.pDataInputStream.available());
        }
        catch (Exception e) {
            System.out.println("Exception : " + e.getMessage());
            System.out.println("Exception : " + e.toString());
        }
        System.out.println("< File.openForReadingOnly(" + sFileName + ") = " + (bRetVal ? "TRUE" : "FALSE"));
        return bRetVal;
    }

    public boolean endOfFile() {
        return false;
    }

    public void close() {
        if (this.rsFile == null) {
            return;
        }
        System.out.println("> File.close()");
        if (this.pDataOutputStream != null) {
            try {
                System.out.println("  pDataOutputStream.flush();");
                this.pDataOutputStream.flush();
                System.out.println("  rsFile.getNumRecords() = " + this.rsFile.getNumRecords());
                if (this.rsFile.getNumRecords() == 0) {
                    this.rsFile.addRecord(this.pDataArray.toByteArray(), 0, this.pDataArray.toByteArray().length);
                } else {
                    this.rsFile.setRecord(1, this.pDataArray.toByteArray(), 0, this.pDataArray.toByteArray().length);
                }
                this.rsFile.closeRecordStore();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pDataOutputStream = null;
        }
        if (this.pDataInputStream != null) {
            try {
                this.pDataInputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pDataInputStream = null;
        }
        this.rsFile = null;
        this.aRecord = null;
        System.out.println("< File.close()");
    }

    public void skip(long lBytes) {
        if (this.pDataInputStream == null) {
            return;
        }
        try {
            this.pDataInputStream.skip(lBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeByte(byte bVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeChar(bVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeChar(char cVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeChar(cVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeInt(int iVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeInt(iVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeShort(short sVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeShort(sVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeLong(long lVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeLong(lVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeBool(boolean bVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeBoolean(bVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeString(String sVal) {
        if (this.pDataOutputStream == null) {
            return;
        }
        try {
            this.pDataOutputStream.writeUTF(sVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte readByte() {
        if (this.pDataInputStream == null) {
            return 0;
        }
        byte bRetVal = 0;
        try {
            bRetVal = this.pDataInputStream.readByte();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bRetVal;
    }

    public char readChar() {
        if (this.pDataInputStream == null) {
            return '\u0000';
        }
        char cRetVal = '\u0000';
        try {
            cRetVal = this.pDataInputStream.readChar();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cRetVal;
    }

    public int readInt() {
        if (this.pDataInputStream == null) {
            DebugOutput.traceNoIndent(100, "File", "pDatainputStream = null");
            return 0;
        }
        int iRetVal = 0;
        try {
            iRetVal = this.pDataInputStream.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iRetVal;
    }

    public short readShort() {
        if (this.pDataInputStream == null) {
            return 0;
        }
        short siRetVal = 0;
        try {
            siRetVal = this.pDataInputStream.readShort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return siRetVal;
    }

    public long readLong() {
        if (this.pDataInputStream == null) {
            return 0L;
        }
        long lRetVal = 0L;
        try {
            lRetVal = this.pDataInputStream.readLong();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lRetVal;
    }

    public boolean readBool() {
        if (this.pDataInputStream == null) {
            return false;
        }
        boolean bRetVal = false;
        try {
            bRetVal = this.pDataInputStream.readBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bRetVal;
    }

    public String readString() {
        if (this.pDataInputStream == null) {
            return "";
        }
        String sRetVal = "";
        try {
            sRetVal = this.pDataInputStream.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sRetVal;
    }
}

