/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import simple.debug.DebugOutput;
import simple.input.Key;
import simple.video.Graphics;
import sk.inlogic.game.MainObject;
import sk.inlogic.game.SudokuGenerator;
import sk.inlogic.tt.Common;
import sk.inlogic.tt.MyApplication;
import sk.inlogic.tt.Profile;
import sk.inlogic.tt.Resources;
import sk.inlogic.tt.Texts;
import sk.inlogic.tt.TextsDescription;

public class Game {
    MyApplication pMyApplication;
    private int iMode;
    private int iNextMode;
    public static int iActiveSet = 1;
    public static int COUNT_W = 8;
    public static int COUNT_H = 9;
    public int iPosXSudoku;
    public int iPosYSudoku;
    public final int BOLDLINE;
    public static boolean bShowHelp = false;
    public static boolean bGameOverBomb = false;
    public static boolean bGameWin = false;
    public static int BOMB_SHAKING_DURATION = 20;
    public static int iPosXGameOverText;
    public static int iPosYGameOverText;
    public static int iPosXScoreText;
    public static int iPosYScoreText;
    public static int iPosYTable;
    public static int iPosYShiftGameOverText;
    public static int iPosXBestScoreText;
    public static int iPosYBestScoreText;
    public static int iPosYList;
    public static int iHListCounter;
    public static int iPosYShiftList;
    public static String sBestScoreNum;
    public static final int SUDOKU_SIZE = 9;
    public static int[][] aiSudoku;
    public static boolean[][] abSudoku;
    public static boolean[][] abSudokuFail;
    public static int iCountToWin;
    public static int[] aiPosXSudoku;
    public static int[] aiPosYSudoku;
    public static int iPencilFrame;
    public static int iPosXPencil;
    public static int iPosYPencil;
    public static int iPencilYShift;
    public static int iEraserYShift;
    public static int iEraserYPlace;
    public static int iSetY;
    public static int iSetX;
    public static int iWShiftNumber;
    public static int iHShiftNumber;
    public static int[] iPosXTouchButton;
    public static int iPosYTouchButton;
    public static int iPosXTouchNumberShift;
    public static int iPosYTouchNumberShift;
    public static int iPxSmallCube;
    public int iPosXStartSudoku;
    public int iPosYStartSudoku;
    public int iYShiftToEdge;
    public static int iPxLine;
    public static int iPxBoldLine;
    public static boolean bPeakDown;
    public static int iSetXErr;
    public static int iSetYErr;
    public static int iErrBefore;
    private static int iErrAfter;
    private int iEmpty = 0;
    public static boolean bEraseHelp;
    public static boolean bHelpClean;
    public static boolean bWinGame;
    public boolean bWinGameTmp = false;
    public static boolean bFindSame;
    public static int iNumbOfKeyTry;
    public int lTimeIncerement = 0;
    public static int iPosXShake;
    public static int iPosYShake;
    int ourAngle = 0;
    public static int iBombShift;
    public static int iBombAtualValue;
    public boolean bTouchPaint = true;
    public Key myKey;
    public int iDragCounter = 0;

    public Game() {
        this.BOLDLINE = 3;
        DebugOutput.traceIn(100, "Game", "Game()");
        this.pMyApplication = MyApplication.getInstance();
        DebugOutput.traceOut(100, "Game", "Game()");
    }

    public void setParam() {
        bPeakDown = false;
        if (Resources.iScreenW <= 128) {
            iPxSmallCube = 11;
            bPeakDown = true;
            this.iPosXStartSudoku = 11;
            this.iPosYStartSudoku = 13;
            iPxLine = 1;
            iPxBoldLine = 1;
        } else if (Resources.iScreenW <= 176) {
            iPxSmallCube = 16;
            bPeakDown = true;
            this.iPosXStartSudoku = 21;
            this.iPosYStartSudoku = 34;
            iPxLine = 1;
            iPxBoldLine = 2;
            if (Resources.iScreenH <= 208) {
                this.iPosYStartSudoku = 15;
            }
        } else if (Resources.iScreenW <= 208) {
            iPxSmallCube = 16;
            bPeakDown = true;
            this.iPosXStartSudoku = 37;
            this.iPosYStartSudoku = 27;
            iPxLine = 1;
            iPxBoldLine = 2;
        } else if (Resources.iScreenW <= 220) {
            iPxSmallCube = 14;
            bPeakDown = true;
            this.iPosXStartSudoku = 52;
            this.iPosYStartSudoku = 19;
            iPxLine = 1;
            iPxBoldLine = 2;
        } else if (Resources.iScreenW <= 240) {
            if (Resources.iScreenH <= 260) {
                this.iPosXStartSudoku = 35;
                this.iPosYStartSudoku = 33;
                iPxSmallCube = 20;
                bPeakDown = true;
                iPxLine = 1;
                iPxBoldLine = 2;
            } else if (Resources.iScreenH <= 287) {
                this.iPosXStartSudoku = 35;
                this.iPosYStartSudoku = 50;
                iPxSmallCube = 20;
                bPeakDown = true;
                iPxLine = 1;
                iPxBoldLine = 2;
            } else if (Resources.iScreenH <= 300) {
                this.iPosXStartSudoku = 35;
                this.iPosYStartSudoku = 57;
                iPxSmallCube = 20;
                bPeakDown = true;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 13;
            } else if (Resources.iScreenH <= 320) {
                iPxSmallCube = 24;
                if (Resources.bTouchActivated) {
                    bPeakDown = true;
                    this.iPosYStartSudoku = 48;
                } else {
                    this.iPosYStartSudoku = 48;
                }
                bPeakDown = true;
                this.iPosYStartSudoku = 46;
                this.iPosXStartSudoku = 17;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 13;
            } else if (Resources.iScreenH <= 348) {
                this.iPosXStartSudoku = 21;
                this.iPosYStartSudoku = 66;
                iPxSmallCube = 20;
                bPeakDown = true;
                iPxLine = 2;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 13;
            } else if (Resources.iScreenH <= 400) {
                this.iPosXStartSudoku = 17;
                this.iPosYStartSudoku = 87;
                iPxSmallCube = 24;
                bPeakDown = true;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 13;
            } else if (Resources.iScreenH <= 432) {
                this.iPosXStartSudoku = 17;
                this.iPosYStartSudoku = 108;
                iPxSmallCube = 24;
                bPeakDown = true;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 13;
            }
        } else if (Resources.iScreenW <= 320) {
            if (Resources.iScreenH <= 240) {
                iPxSmallCube = 15;
                bPeakDown = true;
                this.iPosXStartSudoku = 93;
                this.iPosYStartSudoku = 44;
                iPxLine = 2;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 22;
            } else if (Resources.iScreenH == 480) {
                iPxSmallCube = 15;
                bPeakDown = true;
                this.iPosXStartSudoku = 93;
                this.iPosYStartSudoku = 44;
                iPxLine = 2;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 22;
            }
        } else if (Resources.iScreenW <= 352) {
            iPxSmallCube = 27;
            bPeakDown = true;
            this.iPosXStartSudoku = 46;
            this.iPosYStartSudoku = 45;
            iPxLine = 2;
            iPxBoldLine = 3;
            this.iYShiftToEdge = 20;
        } else if (Resources.iScreenW <= 360) {
            iPxSmallCube = 31;
            bPeakDown = true;
            this.iPosXStartSudoku = 32;
            this.iPosYStartSudoku = 130;
            iPxLine = 2;
            iPxBoldLine = 3;
            this.iYShiftToEdge = 20;
            if (Resources.iScreenH <= 400) {
                iPxSmallCube = 38;
                bPeakDown = true;
                this.iPosXStartSudoku = 77;
                this.iPosYStartSudoku = 87;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 18;
            } else if (Resources.iScreenH <= 480) {
                iPxSmallCube = 38;
                bPeakDown = true;
                this.iPosXStartSudoku = 14;
                this.iPosYStartSudoku = Resources.bTouchActivated ? 60 : 60;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 19;
            } else if (Resources.iScreenH <= 640) {
                iPxSmallCube = 38;
                bPeakDown = true;
                this.iPosXStartSudoku = 14;
                this.iPosYStartSudoku = Resources.bTouchActivated ? 145 : 145;
                iPxLine = 1;
                iPxBoldLine = 2;
                this.iYShiftToEdge = 19;
            }
        } else if (Resources.iScreenW <= 480) {
            iPxSmallCube = 42;
            bPeakDown = true;
            this.iPosXStartSudoku = 38;
            this.iPosYStartSudoku = 146;
            iPxLine = 3;
            iPxBoldLine = 4;
            this.iYShiftToEdge = 23;
            if (Resources.iScreenH <= 320) {
                iPxSmallCube = 24;
                bPeakDown = true;
                this.iPosXStartSudoku = 137;
                this.iPosYStartSudoku = 48;
                iPxLine = 1;
                iPxBoldLine = 2;
            } else if (Resources.iScreenH <= 360) {
                iPxSmallCube = 24;
                bPeakDown = true;
                this.iPosXStartSudoku = 137;
                this.iPosYStartSudoku = 74;
                iPxLine = 1;
                iPxBoldLine = 2;
            } else if (Resources.iScreenH <= 640) {
                iPxSmallCube = 50;
                bPeakDown = true;
                this.iPosXStartSudoku = 20;
                this.iPosYStartSudoku = Resources.bTouchActivated ? 92 : 92;
                iPxLine = 1;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 22;
            } else if (Resources.iScreenH <= 696) {
                iPxSmallCube = 50;
                bPeakDown = true;
                this.iPosXStartSudoku = 20;
                this.iPosYStartSudoku = 117;
                iPxLine = 1;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 22;
            } else if (Resources.iScreenH <= 800) {
                iPxSmallCube = 50;
                bPeakDown = true;
                this.iPosXStartSudoku = 19;
                this.iPosYStartSudoku = 169;
                iPxLine = 1;
                iPxBoldLine = 3;
                this.iYShiftToEdge = 22;
            }
        } else if (Resources.iScreenW <= 640) {
            iPxSmallCube = 27;
            bPeakDown = true;
            this.iPosXStartSudoku = 189;
            this.iPosYStartSudoku = 74;
            iPxLine = 2;
            iPxBoldLine = 3;
        }
    }

    public void release() {
    }

    public static void restartSudoku() {
        bWinGame = false;
        iCountToWin = 0;
        iErrAfter = 0;
        iErrBefore = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!abSudoku[i][j]) {
                    Game.aiSudoku[i][j] = 0;
                    ++iCountToWin;
                }
                Game.abSudokuFail[i][j] = false;
            }
        }
    }

    public static void generateNewGame() {
        DebugOutput.traceIn(100, "Game", "generateNewGame()");
        DebugOutput.trace(100, "Game", "Resources.iNewGameDifficult:" + Resources.iNewGameDifficult);
        String[] puzzleStr = new SudokuGenerator().genpuzzle(Resources.iNewGameDifficult);
        DebugOutput.trace(100, "Game", "Resources.iNewGameDifficult:" + Resources.iNewGameDifficult + " puzzleStr.length:" + puzzleStr.length);
        iCountToWin = 0;
        bWinGame = false;
        iErrBefore = 0;
        iErrAfter = 0;
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int n = Game.aiSudoku[i][j] = puzzleStr[k].equals("") ? 0 : Integer.parseInt(puzzleStr[k]);
                if (aiSudoku[i][j] != 0) {
                    Game.abSudoku[i][j] = true;
                } else {
                    Game.abSudoku[i][j] = false;
                    ++iCountToWin;
                }
                Game.abSudokuFail[i][j] = false;
                ++k;
            }
        }
        DebugOutput.trace(100, "Game", "iCountToWin:" + iCountToWin);
        DebugOutput.traceOut(100, "Game", "generateNewGame()");
    }

    public static void cleanSudoku() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                Game.aiSudoku[i][j] = -1;
            }
        }
    }

    public static void printSudoku() {
        DebugOutput.traceIn(100, "Game", "printSudoku()");
        for (int i = 0; i < 9; ++i) {
            DebugOutput.trace(100, "Game", aiSudoku[i][0] + " " + aiSudoku[i][1] + " " + aiSudoku[i][2] + " " + aiSudoku[i][3] + " " + aiSudoku[i][4] + " " + aiSudoku[i][5] + " " + aiSudoku[i][6] + " " + aiSudoku[i][7] + " " + aiSudoku[i][8] + " ");
        }
        DebugOutput.traceOut(100, "Game", "printSudoku()");
    }

    public static void printSudokuBooleans() {
        DebugOutput.traceIn(100, "Game", "printSudokuBooleans()");
        for (int i = 0; i < 9; ++i) {
            DebugOutput.trace(100, "Game", abSudoku[i][0] + " " + abSudoku[i][1] + " " + abSudoku[i][2] + " " + abSudoku[i][3] + " " + abSudoku[i][4] + " " + abSudoku[i][5] + " " + abSudoku[i][6] + " " + abSudoku[i][7] + " " + abSudoku[i][8] + " ");
        }
        DebugOutput.traceOut(100, "Game", "printSudokuBooleans()");
    }

    public void restartLoadedGame() {
        this.preparePositions();
    }

    public void preparePositions() {
        this.setParam();
        Resources.prepareStatusBar(this.iPosYStartSudoku);
        iWShiftNumber = iPxSmallCube - Resources.iWNumbers >> 1;
        iHShiftNumber = iPxSmallCube - Resources.iHNumbers >> 1;
        this.iPosXSudoku = this.iPosXStartSudoku + iWShiftNumber - 10;
        this.iPosYSudoku = this.iPosYStartSudoku + iHShiftNumber;
        Game.aiPosXSudoku[0] = this.iPosXSudoku;
        Game.aiPosYSudoku[0] = this.iPosYSudoku;
        for (int i = 1; i < 9; ++i) {
            this.iPosXSudoku += iPxSmallCube + iPxLine;
            if (i % 3 == 0) {
                this.iPosXSudoku += iPxBoldLine - iPxLine;
            }
            Game.aiPosXSudoku[i] = this.iPosXSudoku;
            this.iPosYSudoku += iPxSmallCube + iPxLine;
            if (i % 3 == 0) {
                this.iPosYSudoku += iPxBoldLine - iPxLine;
            }
            Game.aiPosYSudoku[i] = this.iPosYSudoku;
        }
        iPencilFrame = 0;
        iSetX = 4;
        iSetY = 4;
        iPencilYShift = iPxSmallCube + iPxLine;
        iEraserYShift = Resources.iHPencil >> 1;
        iEraserYPlace = iEraserYShift - iPencilYShift;
        iPosXPencil = aiPosXSudoku[iSetX] + (iPxSmallCube >> 2);
        iPosYPencil = aiPosYSudoku[iSetY] - iPencilYShift;
        this.lTimeIncerement = 0;
        int iGapX = (Resources.iScreenW - 9 * Resources.pImgTouchButton.getWidth()) / 10;
        for (int i = 0; i < 9; ++i) {
            Game.iPosXTouchButton[i] = 2 * iGapX + i * (Resources.pImgTouchButton.getWidth() + iGapX);
        }
        iPosYTouchButton = this.iPosYStartSudoku - this.iYShiftToEdge - Resources.pImgTouchButton.getHeight() >> 1;
        iPosXTouchNumberShift = Resources.pImgTouchButton.getWidth() - Resources.pSprTouchNumbers.getWidth() >> 1;
        iPosYTouchNumberShift = Resources.pImgTouchButton.getHeight() - Resources.pSprTouchNumbers.getHeight() >> 1;
        Resources.prepareRightAndLeftButtons();
    }

    public boolean findErrorInSudoku() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!abSudokuFail[i][j] || abSudoku[i][j]) continue;
                iSetYErr = i;
                iSetXErr = j;
                return true;
            }
        }
        bHelpClean = false;
        return false;
    }

    public static void setErrorPosition() {
        iSetX = iSetXErr;
        iSetY = iSetYErr;
        iPosXPencil = aiPosXSudoku[iSetX] - iWShiftNumber + (iPxSmallCube >> 2);
        iPosYPencil = aiPosYSudoku[iSetY] - iPencilYShift + iEraserYShift;
        iPencilFrame = 1;
    }

    public static void printPositionX() {
        DebugOutput.traceIn(100, "Game", "printPositionX()");
        DebugOutput.trace(100, "Game", aiPosXSudoku[0] + " " + aiPosXSudoku[1] + " " + aiPosXSudoku[2] + " " + aiPosXSudoku[3] + " " + aiPosXSudoku[4] + " " + aiPosXSudoku[5] + " " + aiPosXSudoku[6] + " " + aiPosXSudoku[7] + " " + aiPosXSudoku[8] + " ");
        DebugOutput.traceOut(100, "Game", "printPositionX()");
    }

    public static void printPositionY() {
        DebugOutput.traceIn(100, "Game", "printPositionY()");
        DebugOutput.trace(100, "Game", aiPosYSudoku[0] + " " + aiPosYSudoku[1] + " " + aiPosYSudoku[2] + " " + aiPosYSudoku[3] + " " + aiPosYSudoku[4] + " " + aiPosYSudoku[5] + " " + aiPosYSudoku[6] + " " + aiPosYSudoku[7] + " " + aiPosYSudoku[8] + " ");
        DebugOutput.traceOut(100, "Game", "printPositionY()");
    }

    public void preparePositionsGameOver() {
        iPosXGameOverText = Resources.iScreenW - Texts.getTextWidth(Texts.getString(8)) >> 1;
        iPosYTable = (Resources.iScreenH >> 2) - Resources.pImgBoard.getHeight();
        iPosYShiftGameOverText = Resources.pImgBoard.getHeight() - Texts.getFontHeight() >> 1;
        iPosYGameOverText = iPosYTable + iPosYShiftGameOverText;
        iPosXScoreText = Resources.iScreenW - Texts.getTextWidth(Texts.getString(18)) >> 1;
        iPosYScoreText = (Resources.iScreenH >> 1) - (Texts.getFontHeight() >> 1);
        iPosXBestScoreText = Resources.iScreenW - Texts.getTextWidth("BEST SCORE:") >> 1;
        iPosYBestScoreText = iPosYScoreText + Texts.getFontHeight();
        iHListCounter = 2 * TextsDescription.getFontHeight() / Resources.pSprTable.getHeight() + 3;
        iPosYList = Resources.iScreenH - iHListCounter * Resources.pSprTable.getHeight() >> 1;
        iPosYShiftList = (Resources.iScreenH >> 1) - iPosYList;
        sBestScoreNum = Integer.toString(Profile.iBestScore);
    }

    public static void save() {
        Profile.save();
    }

    public void keyPressed(Key pKey) {
        if (pKey.iGameAction == 8 || pKey.iValue == 103) {
            if (iPencilFrame == 1 && !abSudoku[iSetY][iSetX]) {
                this.cleankErrorInPosition(iSetX, iSetY, aiSudoku[iSetY][iSetX]);
                this.checkErrors();
                ++iCountToWin;
            }
        } else if (pKey.iValue != 50 && pKey.iValue != 52 && pKey.iValue != 54 && pKey.iValue != 56) {
            if (pKey.iGameAction == 1) {
                if (--iSetY < 0) {
                    iSetY = 8;
                }
                iPosYPencil = iPencilFrame == 0 ? aiPosYSudoku[iSetY] - iPencilYShift : aiPosYSudoku[iSetY] - iPencilYShift + iEraserYShift;
                return;
            }
            if (pKey.iGameAction == 6) {
                if (++iSetY >= 9) {
                    iSetY = 0;
                }
                iPosYPencil = iPencilFrame == 0 ? aiPosYSudoku[iSetY] - iPencilYShift : aiPosYSudoku[iSetY] - iPencilYShift + iEraserYShift;
                return;
            }
            if (pKey.iGameAction == 2) {
                if (--iSetX < 0) {
                    iSetX = 8;
                }
                iPosXPencil = aiPosXSudoku[iSetX] + (iPxSmallCube >> 2);
                return;
            }
            if (pKey.iGameAction == 5) {
                if (++iSetX >= 9) {
                    iSetX = 0;
                }
                iPosXPencil = aiPosXSudoku[iSetX] + (iPxSmallCube >> 2);
                return;
            }
        }
        if (iPencilFrame == 1) {
            if (pKey.iValue == 53 && !abSudoku[iSetY][iSetX]) {
                this.cleankErrorInPosition(iSetX, iSetY, aiSudoku[iSetY][iSetX]);
                this.checkErrors();
            }
            return;
        }
        int iTmp = pKey.iValue;
        if (abSudoku[iSetY][iSetX]) {
            return;
        }
        switch (pKey.iValue) {
            case 49: {
                this.setNumber(1);
                break;
            }
            case 50: {
                this.setNumber(2);
                break;
            }
            case 51: {
                this.setNumber(3);
                break;
            }
            case 52: {
                this.setNumber(4);
                break;
            }
            case 53: {
                this.setNumber(5);
                break;
            }
            case 54: {
                this.setNumber(6);
                break;
            }
            case 55: {
                this.setNumber(7);
                break;
            }
            case 56: {
                this.setNumber(8);
                break;
            }
            case 57: {
                this.setNumber(9);
                break;
            }
            case 48: {
                return;
            }
        }
        iErrAfter = this.checkErrors();
        if (iErrAfter != 0) {
            bEraseHelp = true;
        }
        DebugOutput.trace(100, "Game", "iErrBefore: " + iErrBefore);
        DebugOutput.trace(100, "Game", "iErrAfter: " + iErrAfter + " iEmpty:" + this.iEmpty);
        if (iErrAfter == 0 && this.iEmpty == 0) {
            bWinGame = true;
        }
        pKey.iValue = iTmp;
    }

    public int checkErrors() {
        int iAllErrors = 0;
        this.iEmpty = 0;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (aiSudoku[i][j] != 0 && !abSudoku[i][j]) {
                    int iErrTmp = this.checkErrorInPosition(j, i, aiSudoku[i][j]);
                    if (i == iSetY && j == iSetX && iErrTmp > 0) {
                        Game.abSudokuFail[Game.iSetY][Game.iSetX] = true;
                    }
                    iAllErrors += iErrTmp;
                }
                if (aiSudoku[i][j] != 0) continue;
                ++this.iEmpty;
            }
        }
        return iAllErrors;
    }

    private int checkErrorInPosition(int x, int y, int iNumb) {
        int i;
        DebugOutput.traceIn(100, "Game", "checkErrorInPosition x:" + x + " y:" + y + " iNumb:" + iNumb);
        int iNumbOfErrors = 0;
        for (i = 0; i < 9; ++i) {
            if (x == i || aiSudoku[y][i] != iNumb) continue;
            DebugOutput.trace(100, "Game", "Error Position on x:" + i + " y:" + y);
            Game.abSudokuFail[y][i] = true;
            ++iNumbOfErrors;
        }
        for (i = 0; i < 9; ++i) {
            if (y == i || aiSudoku[i][x] != iNumb) continue;
            DebugOutput.trace(100, "Game", "Error Position on x:" + x + " y:" + i);
            Game.abSudokuFail[i][x] = true;
            ++iNumbOfErrors;
        }
        int iTmpX = 0;
        int iTmpY = 0;
        if (x / 3 == 0) {
            iTmpX = 0;
        }
        if (x / 3 == 1) {
            iTmpX = 3;
        }
        if (x / 3 == 2) {
            iTmpX = 6;
        }
        if (y / 3 == 0) {
            iTmpY = 0;
        }
        if (y / 3 == 1) {
            iTmpY = 3;
        }
        if (y / 3 == 2) {
            iTmpY = 6;
        }
        for (int i2 = iTmpY; i2 < iTmpY + 3; ++i2) {
            for (int j = iTmpX; j < iTmpX + 3; ++j) {
                if (y == i2 && x == j || aiSudoku[i2][j] != iNumb) continue;
                DebugOutput.trace(100, "Game", "Error Position on x:" + j + " y:" + i2);
                Game.abSudokuFail[i2][j] = true;
                ++iNumbOfErrors;
            }
        }
        DebugOutput.traceOut(100, "Game", "checkErrorInPosition: iNumbOfErrors:" + iNumbOfErrors);
        return iNumbOfErrors;
    }

    private void cleankErrorInPosition(int x, int y, int iNumb) {
        int i;
        DebugOutput.traceIn(100, "Game", "checkErrorInPosition x:" + x + " y:" + y + " iNumb:" + iNumb);
        for (i = 0; i < 9; ++i) {
            if (x == i || aiSudoku[y][i] != iNumb) continue;
            Game.abSudokuFail[y][i] = false;
        }
        for (i = 0; i < 9; ++i) {
            if (y == i || aiSudoku[i][x] != iNumb) continue;
            Game.abSudokuFail[i][x] = false;
        }
        int iTmpX = 0;
        int iTmpY = 0;
        if (x / 3 == 0) {
            iTmpX = 0;
        }
        if (x / 3 == 1) {
            iTmpX = 3;
        }
        if (x / 3 == 2) {
            iTmpX = 6;
        }
        if (y / 3 == 0) {
            iTmpY = 0;
        }
        if (y / 3 == 1) {
            iTmpY = 3;
        }
        if (y / 3 == 2) {
            iTmpY = 6;
        }
        for (int i2 = iTmpY; i2 < iTmpY + 3; ++i2) {
            for (int j = iTmpX; j < iTmpX + 3; ++j) {
                if (y == i2 && x == j || aiSudoku[i2][j] != iNumb) continue;
                Game.abSudokuFail[i2][j] = false;
            }
        }
        Game.aiSudoku[Game.iSetY][Game.iSetX] = 0;
        Game.abSudokuFail[Game.iSetY][Game.iSetX] = false;
    }

    public void setNumber(int iNumber) {
        if (aiSudoku[iSetY][iSetX] == iNumber) {
            return;
        }
        if (aiSudoku[iSetY][iSetX] != 0) {
            this.cleankErrorInPosition(iSetX, iSetY, aiSudoku[iSetY][iSetX]);
        }
        Game.aiSudoku[Game.iSetY][Game.iSetX] = iNumber;
        bWinGame = this.bWinGameTmp;
        DebugOutput.trace(100, "Game", "iCountToWin:" + --iCountToWin);
        DebugOutput.trace(100, "Game", "bWinGame:" + bWinGame);
    }

    public void cleanNumber(int iNumb) {
        Game.aiSudoku[Game.iSetY][Game.iSetX] = 0;
    }

    public void checkNumber(int iNumb) {
        bFindSame = false;
        iNumbOfKeyTry = 0;
        this.bWinGameTmp = true;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (aiSudoku[i][j] == 0) {
                    DebugOutput.trace(100, "Game", "iSetY:" + iSetY + " iSetX:" + iSetX);
                    if (i != iSetY || j != iSetX) {
                        this.bWinGameTmp = false;
                    }
                    DebugOutput.trace(100, "Game", "aiSudoku[" + i + "][" + j + "] == 0");
                }
                if (iSetX == j && iNumb == aiSudoku[i][j]) {
                    Game.abSudokuFail[i][j] = true;
                    bFindSame = true;
                }
                if (iSetY != i || iNumb != aiSudoku[i][j]) continue;
                Game.abSudokuFail[i][j] = true;
                bFindSame = true;
            }
        }
        int iX = iSetX / 3;
        int iY = iSetY / 3;
        for (int i = iY * 3; i < iY * 3 + 3; ++i) {
            for (int j = iX * 3; j < iX * 3 + 3; ++j) {
                if (iNumb != aiSudoku[i][j]) continue;
                Game.abSudokuFail[i][j] = true;
                DebugOutput.trace(100, "Game", "abSudokuFail[" + i + "][" + j + "] == true");
                bFindSame = true;
            }
        }
        if (bFindSame) {
            Game.abSudokuFail[Game.iSetY][Game.iSetX] = true;
            this.bWinGameTmp = false;
        } else {
            Game.abSudokuFail[Game.iSetY][Game.iSetX] = false;
        }
    }

    public void paintSudoku(Graphics g) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (abSudoku[i][j]) {
                    Resources._numberBgDark.drawAtPoint(g, aiPosXSudoku[j] - iWShiftNumber, aiPosYSudoku[i] - iHShiftNumber);
                }
                if (iSetX == j && aiSudoku[i][j] != 0 && abSudoku[i][j]) {
                    Resources._numberBgLight.drawAtPoint(g, aiPosXSudoku[j] - iWShiftNumber, aiPosYSudoku[i] - iHShiftNumber);
                }
                if (iSetY == i && aiSudoku[i][j] != 0 && abSudoku[i][j]) {
                    Resources._numberBgLight.drawAtPoint(g, aiPosXSudoku[j] - iWShiftNumber, aiPosYSudoku[i] - iHShiftNumber);
                }
                if (abSudokuFail[i][j]) {
                    Resources._numberBgWrong.drawAtPoint(g, aiPosXSudoku[j] - iWShiftNumber, aiPosYSudoku[i] - iHShiftNumber);
                }
                if (aiSudoku[i][j] == 0) continue;
                String _number = "" + aiSudoku[i][j];
                Texts.drawTextAtPos(g, aiPosXSudoku[j] - (Texts.getTextWidth(_number) >> 2), aiPosYSudoku[i] - (Texts.getFontHeight() >> 2), _number);
            }
        }
        int iTmpX = 0;
        int iTmpY = 0;
        if (iSetX / 3 == 0) {
            iTmpX = 0;
        }
        if (iSetX / 3 == 1) {
            iTmpX = 3;
        }
        if (iSetX / 3 == 2) {
            iTmpX = 6;
        }
        if (iSetY / 3 == 0) {
            iTmpY = 0;
        }
        if (iSetY / 3 == 1) {
            iTmpY = 3;
        }
        if (iSetY / 3 == 2) {
            iTmpY = 6;
        }
        Resources._numberBorder.drawAtPoint(g, aiPosXSudoku[iTmpX] - iWShiftNumber, aiPosYSudoku[iTmpY] - iHShiftNumber);
    }

    public void paintPencil(Graphics g) {
        if (iPencilFrame == 0) {
            Resources._pencil.drawAtPoint(g, iPosXPencil + iPosXShake, iPosYPencil + iPosYShake);
        } else {
            Resources._eraser.drawAtPoint(g, iPosXPencil + iPosXShake, iPosYPencil + iPosYShake);
        }
    }

    public void paintTouchNumbers(Graphics g) {
        for (int i = 0; i < 9; ++i) {
            Resources.pImgTouchButton.drawAtPoint(g, iPosXTouchButton[i], iPosYTouchButton);
            String _number = "" + (i + 1);
            Texts.drawTextAtPos(g, iPosXTouchButton[i] + iPosXTouchNumberShift - (Texts.getTextWidth(_number) >> 2), iPosYTouchButton + iPosYTouchNumberShift - (Texts.getFontHeight() >> 2), _number);
        }
    }

    public void paint(Graphics g) {
        if (Resources.bTouchActivated) {
            this.paintTouchNumbers(g);
        }
        this.paintSudoku(g);
        this.paintPencil(g);
    }

    public void update(long iTick) {
        this.lTimeIncerement = (int)((long)this.lTimeIncerement + iTick);
        if (this.lTimeIncerement > 1000) {
            Resources.incrementTime();
            this.lTimeIncerement = 0;
        }
        this.updatePencil();
    }

    public void updatePencil() {
        iPosXShake = Common.getArcX(this.ourAngle % 360, 5);
        iPosYShake = Common.getArcY(this.ourAngle % 360, 5);
        this.ourAngle += 15;
    }

    public void updateGameOver(long iTick) {
        iBombAtualValue += iBombShift;
    }

    public void keyReleased(Key pKey) {
        MainObject.keyReleased(pKey);
    }

    public void changeMode() {
        this.iMode = this.iNextMode;
    }

    public void pointerPressed(int x, int y) {
        boolean bFindCube = false;
        for (int j = 0; j < 9; ++j) {
            for (int i = 0; i < 9; ++i) {
                if (j == 8 || i == 8) {
                    if (x < aiPosXSudoku[i] || x >= aiPosXSudoku[i] + iPxSmallCube + 20 || y < aiPosYSudoku[j] || y >= aiPosYSudoku[j] + iPxSmallCube) continue;
                    bFindCube = true;
                    iSetY = j;
                    iSetX = i;
                    DebugOutput.trace(100, "Game", "j:" + j + " i:" + i);
                    continue;
                }
                if (x < aiPosXSudoku[i] || x >= aiPosXSudoku[i + 1] || y < aiPosYSudoku[j] || y >= aiPosYSudoku[j + 1]) continue;
                bFindCube = true;
                iSetY = j;
                iSetX = i;
                DebugOutput.trace(100, "Game", "j:" + j + " i:" + i);
            }
        }
        if (bFindCube) {
            iPosXPencil = aiPosXSudoku[iSetX] - iWShiftNumber + (iPxSmallCube >> 2);
            iPosYPencil = aiPosYSudoku[iSetY] - iPencilYShift;
            if (iPencilFrame == 1) {
                iPosYPencil += iEraserYShift;
                if (!abSudoku[iSetY][iSetX]) {
                    this.cleankErrorInPosition(iSetX, iSetY, aiSudoku[iSetY][iSetX]);
                    Game.aiSudoku[Game.iSetY][Game.iSetX] = 0;
                    Game.abSudokuFail[Game.iSetY][Game.iSetX] = false;
                    this.checkErrors();
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (x < iPosXTouchButton[i] + iPosXTouchNumberShift || x >= iPosXTouchButton[i] + iPosXTouchNumberShift + Resources.pSprTouchNumbers.getWidth() || y < iPosYTouchButton + iPosYTouchNumberShift || y >= iPosYTouchButton + iPosYTouchNumberShift + Resources.pSprTouchNumbers.getHeight() || iPencilFrame != 0) continue;
            if (abSudoku[iSetY][iSetX]) {
                return;
            }
            this.setNumber(i + 1);
            iErrAfter = this.checkErrors();
            if (iErrAfter != 0) {
                bEraseHelp = true;
            }
            DebugOutput.trace(100, "Game", "totalErr: " + iErrAfter + " iEmpty:" + this.iEmpty);
            if (iErrAfter != 0 || this.iEmpty != 0) continue;
            bWinGame = true;
        }
        this.iDragCounter = 0;
        this.bTouchPaint = true;
    }

    public void pointerDragged(int x, int y) {
        DebugOutput.trace(100, "Game", "pointerDragged");
    }

    public void pointerReleased(int x, int y) {
        this.bTouchPaint = false;
    }

    static {
        aiSudoku = new int[9][9];
        abSudoku = new boolean[9][9];
        abSudokuFail = new boolean[9][9];
        iCountToWin = 0;
        aiPosXSudoku = new int[9];
        aiPosYSudoku = new int[9];
        iPosXTouchButton = new int[9];
        bEraseHelp = false;
        bWinGame = false;
        bFindSame = false;
        iNumbOfKeyTry = 0;
        iPosXShake = 0;
        iPosYShake = 0;
    }
}

