/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.screen;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.component.BitmapField;
import com.ximad.zuminja.component.CustomButton;
import com.ximad.zuminja.component.UiScreen;
import com.ximad.zuminja.engine.Application;
import com.ximad.zuminja.engine.Consts;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.screen.ConfirmScreen;
import com.ximad.zuminja.screen.GameScreen;
import com.ximad.zuminja.screen.SelectLevelScreen;

public class SelectStageScreen
extends UiScreen {
    private int level;
    private int stagesCount;
    CustomButton[] buttons;
    BitmapField[] icons;
    CustomButton backButton;

    public SelectStageScreen(int level) {
        this.level = level;
        this.backgroundBitmap = Resources.selectStageBg[level];
        this.stagesCount = 0;
        this.buttons = new CustomButton[5];
        this.icons = new BitmapField[5];
        for (int i = 0; i < 5; ++i) {
            final int stage = i;
            ++this.stagesCount;
            Bitmap bmp = DataManager.lockedStages[this.level * 5 + stage] ? Resources.icons[Consts.ICONS[this.level * 5 + stage]] : Resources.iconsInactive[Consts.ICONS[this.level * 5 + stage]];
            this.icons[i] = new BitmapField(bmp);
            this.buttons[i] = new CustomButton(Resources.stageOff[level][i], Resources.stageOn[level][i], null, Resources.stageLocked[level][i]){

                public void touchAction() {
                    if (!DataManager.isSavedGameEnabled()) {
                        Application.setScreen(new GameScreen(false, SelectStageScreen.this.level * 5 + stage));
                        return;
                    }
                    Application.setScreen(new ConfirmScreen(Resources.confirmNewGame, 304){

                        public void yesClick() {
                            DataManager.removeLevelData();
                            Application.setScreen(new GameScreen(false, SelectStageScreen.this.level * 5 + stage));
                        }

                        public boolean onClose() {
                            Application.setScreen(new SelectStageScreen(SelectStageScreen.this.level));
                            return false;
                        }

                        public void noClick() {
                            Application.setScreen(new SelectStageScreen(SelectStageScreen.this.level));
                        }
                    });
                }
            };
            this.buttons[i].setCheckState(!DataManager.lockedStages[this.level * 5 + stage]);
            this.buttons[i].set_btn_state(DataManager.lockedStages[this.level * 5 + stage]);
            this.add(this.icons[i], 57, 120 + 77 * i);
            this.add(this.buttons[i], 153, 145 + 77 * i);
        }
        this.backButton = new CustomButton(Resources.menuBackOff, Resources.menuBackOn, null, null){

            public void touchAction() {
                Application.setScreen(new SelectLevelScreen());
            }
        };
        this.add(this.backButton, 137, 524);
    }
}

