/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.screen;

import com.ximad.zuminja.component.CustomButton;
import com.ximad.zuminja.component.UiScreen;
import com.ximad.zuminja.engine.Application;
import com.ximad.zuminja.engine.Consts;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.screen.ScoreBoardScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ResultScreen
extends UiScreen {
    long score;
    int id;
    CustomButton okButton;
    CustomButton[] alphButtons;
    CustomButton delButton;
    String playerName = "PLAYER";

    public void okClick() {
        if (this.playerName.length() != 0) {
            DataManager.setName(this.playerName, this.id);
        }
        Application.setScreen(new ScoreBoardScreen());
    }

    public void append(char x) {
        if (this.playerName.length() < 9) {
            this.playerName = this.playerName + x;
        }
        Application.canvas.repaint(0, 310, 360, 350);
    }

    public void remove() {
        if (this.playerName.length() == 0) {
            return;
        }
        this.playerName = this.playerName.substring(0, this.playerName.length() - 1);
        Application.canvas.repaint(0, 310, 360, 350);
    }

    public ResultScreen(boolean result, long score) {
        int i;
        this.id = DataManager.addScore(this.playerName, score);
        this.backgroundBitmap = Resources.popupEnterName;
        this.score = score;
        this.alphButtons = new CustomButton[26];
        for (i = 0; i < 26; ++i) {
            final char c = (char)(i + 65);
            this.alphButtons[i] = new CustomButton(Resources.alphabetOff[i], Resources.alphabetOn[i], null){

                public void touchAction() {
                    ResultScreen.this.append(c);
                }
            };
        }
        this.delButton = new CustomButton(Resources.delOff, Resources.delOn, null){

            public void touchAction() {
                ResultScreen.this.remove();
            }
        };
        this.okButton = new CustomButton(Resources.okOff, Resources.okOn, null){

            public void touchAction() {
                ResultScreen.this.okClick();
            }
        };
        this.add(this.okButton, 140, 299);
        for (i = 0; i < 26; ++i) {
            this.add(this.alphButtons[i], Consts.AL_X[i], Consts.AL_Y[i]);
        }
        this.add(this.delButton, 277, 553);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        g.setColor(0xFFFFFF);
        g.setFont(Font.getFont((int)0, (int)0, (int)16));
        g.drawString(this.playerName, 179, 234, 17);
    }

    private class RepaintThread
    extends Thread {
        private RepaintThread() {
        }
    }
}

