/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.engine;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.component.MainCanvas;
import com.ximad.zuminja.component.Screen;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.screen.GameScreen;
import com.ximad.zuminja.screen.LoadingScreen;
import com.ximad.zuminja.screen.MainMenuScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet {
    public static MainCanvas canvas;
    private static Application instance;
    public static int screenWidth;
    public static int screenHeight;
    public static DataManager dataManager;
    public static boolean foreground;
    public static int time;
    public static Screen screen;
    private static Command quitCommand;

    public static Application getInstance() {
        return instance;
    }

    public Application() {
        instance = this;
        canvas = new MainCanvas();
        canvas.setFullScreenMode(true);
        time = 0;
    }

    public void startApp() {
        canvas.setFullScreenMode(true);
        canvas.start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)canvas);
        Screen.sleep(50L);
        screenWidth = canvas.getWidth();
        screenHeight = canvas.getHeight();
        if (screenHeight > screenWidth) {
            screenWidth = canvas.getHeight();
            screenHeight = canvas.getWidth();
        }
        Bitmap bg = new Bitmap("/img/360x640/menu/Splash.jpg");
        Application.setScreen(new LoadingScreen(bg));
        new Resources();
        dataManager = new DataManager();
        Application.setScreen(new MainMenuScreen());
        foreground = true;
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        dataManager.saveSettings();
        DataManager.stopSound();
        canvas.stop();
    }

    public static void setScreen(Screen screen) {
        if (Application.screen != null) {
            Application.screen.onHide();
        }
        Application.screen = screen;
        if (screen != null) {
            screen.onShow();
        }
    }

    public static Screen getScreen() {
        return screen;
    }

    public static void activate() {
        if (screen instanceof MainMenuScreen) {
            DataManager.playMenuSound();
        }
        if (screen instanceof GameScreen) {
            DataManager.playGameSound(-1);
        }
        foreground = true;
        canvas.start();
    }

    public static void deactivate() {
        DataManager.stopSound();
        foreground = false;
        canvas.stop();
    }

    public static void quit() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
    }
}

