/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.engine.Utils;
import com.ximad.zuminja.game.Arc;
import com.ximad.zuminja.game.Ball;
import com.ximad.zuminja.game.Point;

public class Path {
    Point[] points;
    int pointCount;
    int length;
    Arc[] arcs;
    int arcsCount;

    private static int sqr(int x) {
        return x * x;
    }

    public Path(Arc[] vector, int count) {
        this.arcsCount = count;
        this.arcs = vector;
        this.length = 0;
        for (int i = 0; i < count; ++i) {
            this.length += vector[i].getLength();
        }
        this.pointCount = -1;
    }

    public Path(Point[] vector, int count) {
        int i;
        this.points = new Point[count + 1];
        this.pointCount = count;
        for (i = 0; i < count; ++i) {
            this.points[i] = vector[i];
        }
        this.points[count] = count != 0 ? vector[count - 1] : new Point();
        this.arcs = new Arc[count - 1];
        this.arcsCount = count - 1;
        this.length = 0;
        for (i = 0; i < this.pointCount - 1; ++i) {
            int x;
            int r = -1;
            int k0 = Path.sqr(this.points[i].x) - Path.sqr(this.points[i + 1].x) + Path.sqr(this.points[i].y) - Path.sqr(this.points[i + 1].y);
            int k1 = 2 * (this.points[i].y - this.points[i + 1].y);
            int k2 = 2 * (this.points[i].x - this.points[i + 1].x);
            int m0 = Path.sqr(this.points[i].x) - Path.sqr(this.points[i + 2].x) + Path.sqr(this.points[i].y) - Path.sqr(this.points[i + 2].y);
            int m1 = 2 * (this.points[i].y - this.points[i + 2].y);
            int m2 = 2 * (this.points[i].x - this.points[i + 2].x);
            int a = k2 * m0 - k0 * m2;
            int b = k2 * m1 - k1 * m2;
            if (b == 0) continue;
            int y = a / b;
            Point x0 = new Point();
            x0.y = y;
            if ((double)Math.abs(m2) > 0.01) {
                x = (m0 - y * m1) / m2;
            } else {
                if (!((double)Math.abs(k2) > 0.01)) continue;
                x = (k0 - y * k1) / k2;
            }
            x0.x = x;
            r = (int)Math.sqrt(Path.sqr(this.points[i].x - x) + Path.sqr(this.points[i].y - y));
            int dx0 = this.points[i].x - x0.x;
            int dx1 = this.points[i + 1].x - x0.x;
            int dy0 = this.points[i].y - x0.y;
            int dy1 = this.points[i + 1].y - x0.y;
            float tg0 = -((float)dy0) / (float)dx0;
            float tg1 = -((float)dy1) / (float)dx1;
            double startDegree = Utils.atan(tg0);
            if (dx0 < 0) {
                startDegree += Math.PI;
            }
            double endDegree = Utils.atan(tg1);
            if (dx1 < 0) {
                endDegree += Math.PI;
            }
            this.arcs[i] = new Arc(x0, r, Math.toDegrees(startDegree), Math.toDegrees(endDegree), 1);
        }
        for (i = 0; i < this.arcsCount; ++i) {
            if (this.arcs[i] == null) {
                this.arcs[i] = new Arc(this.points[i], this.points[i + 1]);
            }
            this.length += this.arcs[i].getLength();
        }
    }

    public Point getPointByNumber(int number) {
        if (this.pointCount < 0) {
            return null;
        }
        return this.points[number];
    }

    public Arc getArc(int number) {
        return this.arcs[number];
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public Point getPointByDistance(int distance) {
        return Ball.getPoint(this, distance);
    }

    public int getArcsCount() {
        return this.arcsCount;
    }

    public int getLength() {
        return this.length;
    }
}

