/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.component.Bitmap;
import com.ximad.zuminja.engine.Application;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.engine.Utils;
import com.ximad.zuminja.game.Ball;
import com.ximad.zuminja.game.Launcher;
import com.ximad.zuminja.game.Level;
import com.ximad.zuminja.game.PackedGame;
import com.ximad.zuminja.game.Path;
import com.ximad.zuminja.game.Point;
import com.ximad.zuminja.game.Track;
import com.ximad.zuminja.screen.GameScreen;
import com.ximad.zuminja.screen.InfoScreen;
import com.ximad.zuminja.screen.LifesLeftScreen;
import com.ximad.zuminja.screen.ResultScreen;
import com.ximad.zuminja.screen.ScoreBoardScreen;
import java.util.Timer;

public class Game {
    private boolean[] endedLevels;
    private Track[] tracks;
    private int tracksCount;
    private int launchedBallTick = -1;
    private int animationTick = -1;
    private int launcherIdentifier;
    private GameScreen gameScreen;
    private Timer timer;
    private int level;
    private int lifesLeftTick;
    private long score;
    private int lifesCount;
    private int addBonusTick;
    private double finishSpeed = -1.0;
    private Ball launchedBall = null;
    Launcher launcher;
    private boolean isFinished;
    private boolean isStopped;
    private int gunExplodeFrame = -1;
    private int x2Tick;
    private int slowTick;
    private Path path;
    int number;
    public double atan;

    public Game(boolean loadGame, GameScreen screen, int level) {
        this.gameScreen = screen;
        if (loadGame) {
            this.loadGame();
        } else {
            this.newGame(level);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public Track getTrack(int index) {
        return this.tracks[index];
    }

    public int getTracksCount() {
        return this.tracksCount;
    }

    public int getBonusAddTick() {
        return this.addBonusTick;
    }

    public int getLifesCount() {
        return this.lifesCount;
    }

    private void newGame(int level) {
        this.score = 0L;
        if (DataManager.isSavedGameEnabled()) {
            this.score = DataManager.loadLevel().score;
            this.lifesCount = DataManager.loadLevel().lifesLeft;
        } else {
            this.lifesCount = 2;
        }
        Level thisLevel = null;
        this.level = level >= DataManager.getLevelWithBackgroundCount() ? DataManager.getLevelWithBackgroundCount() - 1 : level;
        this.tracksCount = DataManager.getLevelWithBackgroundAt(this.level).getLevelCount();
        this.tracks = new Track[this.tracksCount];
        for (int i = 0; i < this.tracksCount; ++i) {
            this.tracks[i] = new Track(this, level, i, false);
        }
        this.isFinished = false;
        this.isStopped = false;
        this.endedLevels = new boolean[this.tracksCount];
        thisLevel = DataManager.getLevelWithBackgroundAt(this.level).getLevel(0);
        this.launcher = new Launcher(thisLevel.getLauncherPoint(), this.tracks, this.tracksCount, level / 5);
        this.addBonusTick = 0;
    }

    private void loadGame() {
        if (!DataManager.isSavedGameEnabled()) {
            this.newGame(0);
            return;
        }
        PackedGame game = DataManager.loadLevel();
        if (game == null) {
            this.newGame(0);
            return;
        }
        if (game.continueGame) {
            this.newGame(-game.level);
            return;
        }
        this.level = game.level >= DataManager.getLevelWithBackgroundCount() ? DataManager.getLevelWithBackgroundCount() - 1 : game.level;
        this.tracksCount = DataManager.getLevelWithBackgroundAt(this.level).getLevelCount();
        this.tracks = new Track[this.tracksCount];
        for (int i = 0; i < this.tracksCount; ++i) {
            this.tracks[i] = new Track(this, this.level, i, true);
        }
        this.isFinished = false;
        this.isStopped = false;
        this.endedLevels = game.endedLevels;
        this.score = game.score;
        this.addBonusTick = game.bonusAddTick;
        this.x2Tick = game.x2Tick;
        this.slowTick = game.slowTick;
        this.lifesCount = DataManager.loadLevel().lifesLeft;
        Level thisLevel = DataManager.getLevelWithBackgroundAt(this.level).getLevel(0);
        this.launcher = new Launcher(thisLevel.getLauncherPoint(), this.tracks, this.tracksCount, game.currentBallType, game.nextBallType, game.nextNextBallType, this.level / 5);
    }

    public boolean[] getEndedLevels() {
        return this.endedLevels;
    }

    public void finalize() {
        try {
            this.timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tick() {
        int i;
        this.launchBallTick();
        ++this.addBonusTick;
        if (this.addBonusTick == 125) {
            int track = Utils.nextInt(this.tracksCount);
            int bonus = Utils.nextInt(3);
            if ((bonus == 0 || bonus == 2) && Utils.nextInt(4) == 0) {
                bonus = 1;
            }
            this.tracks[track].addBonus(bonus);
            this.addBonusTick = 0;
        }
        if (this.lifesLeftTick > 0) {
            --this.lifesLeftTick;
        }
        if (this.gunExplodeFrame != -1) {
            this.gunExplodeFrame = this.gunExplodeFrame + 1 == 6 ? -1 : ++this.gunExplodeFrame;
        }
        for (i = 0; i < this.tracksCount; ++i) {
            this.tracks[i].tick();
        }
        if (this.x2Tick != 0) {
            --this.x2Tick;
        }
        if (this.slowTick != 0) {
            --this.slowTick;
        }
        this.launcher.getNextBall().changeType(this.tracks, this.tracksCount);
        for (i = 0; i < this.tracksCount; ++i) {
            if (this.tracks[i].getBallsCount() <= 0) continue;
            return;
        }
        this.endLevel();
    }

    public void endLevel(int track) {
        this.endedLevels[track] = true;
        for (int i = 0; i < this.tracksCount; ++i) {
            if (this.endedLevels[i]) continue;
            return;
        }
        this.endLevel();
    }

    public void endLevel() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        if (!this.isFinished) {
            DataManager.endLevel(this.level);
            ++this.level;
            this.level = -this.level;
            try {
                this.gameScreen.saveGame(true);
                this.gameScreen.finalize();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.level == -20) {
                Application.setScreen(new InfoScreen(Resources.popupWinGame){

                    public void action() {
                        if (DataManager.isHighScore(Game.this.score)) {
                            Application.setScreen(new ResultScreen(true, Game.this.score));
                        } else {
                            Application.setScreen(new ScoreBoardScreen());
                        }
                    }
                });
                DataManager.playWinSound();
            } else {
                Bitmap popupWin = -this.level % 5 == 0 ? Resources.popup[(-this.level - 1) / 5] : Resources.popupWin;
                Application.setScreen(new InfoScreen(popupWin){

                    public void action() {
                        Application.setScreen(new GameScreen(true, 0));
                    }
                });
                DataManager.playWinSound();
            }
        } else {
            --this.lifesCount;
            if (this.lifesCount == -1) {
                DataManager.removeLevelData();
                try {
                    this.gameScreen.finalize();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Application.setScreen(new InfoScreen(Resources.popupLoose){

                    public void action() {
                        if (DataManager.isHighScore(Game.this.score)) {
                            Application.setScreen(new ResultScreen(false, Game.this.score));
                        } else {
                            Application.setScreen(new ScoreBoardScreen());
                        }
                    }
                });
                DataManager.playPopupSound();
            } else {
                this.level = -this.level;
                try {
                    this.gameScreen.saveGame(true);
                    this.gameScreen.finalize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Application.setScreen(new LifesLeftScreen(this.lifesCount));
                DataManager.playLeftPopupSound();
            }
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public String getNumber() {
        return String.valueOf(this.number);
    }

    public int[] getDeep() {
        int[] deep = new int[this.tracksCount];
        for (int i = 0; i < this.tracksCount; ++i) {
            deep[i] = this.tracks[i].getDeep();
        }
        return deep;
    }

    public int getLifesLeftTick() {
        return this.lifesLeftTick;
    }

    public void launchBall() {
        int x = this.launcher.getPoint().x;
        int y = this.launcher.getPoint().y;
        int angle = this.launcher.getAngle();
        x = (int)((double)x + 100.0 * Math.cos(Math.toRadians(angle)));
        y = (int)((double)y + -100.0 * Math.sin(Math.toRadians(angle)));
        this.launchBall(new Point(x, y));
    }

    public void launchBallTick() {
        if (this.launchedBall == null) {
            return;
        }
        Point tempPoint = this.launcher.getBallPoint();
        if (tempPoint.x < 0 || tempPoint.x > 360 || tempPoint.y < 0 || tempPoint.y > 640) {
            try {
                this.launchedBall = null;
                this.launcher.breakLaunch();
                this.launchedBallTick = -1;
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        double cosX = Math.cos(this.atan);
        double sinY = Math.sin(this.atan);
        this.launcher.setAngle(Utils.round(Math.toDegrees(this.atan)));
        double speedX = 15.0 * cosX;
        double speedY = -(15.0 * sinY);
        ++this.launchedBallTick;
        tempPoint.x = (int)((double)this.launcher.getPoint().x + speedX * (double)this.launchedBallTick);
        tempPoint.y = (int)((double)this.launcher.getPoint().y + speedY * (double)this.launchedBallTick);
        double minDX = 9999.99;
        int number = -1;
        boolean direction = false;
        int track = -1;
        for (int t = 0; t < this.tracksCount; ++t) {
            Level thisLevel = DataManager.getLevelWithBackgroundAt(this.level).getLevel(t);
            for (int i = 0; i < this.tracks[t].getBallsCount(); ++i) {
                double distance;
                this.tracks[t].getBall(i);
                Point currentPoint = Ball.getPoint(this.tracks[t].getPath(), this.tracks[t].getBall(i).getCurrentX());
                if (currentPoint == null || this.tracks[t].getBall(i).getState() != -1 || !((distance = Math.sqrt((currentPoint.x - tempPoint.x) * (currentPoint.x - tempPoint.x) + (currentPoint.y - tempPoint.y) * (currentPoint.y - tempPoint.y))) < minDX)) continue;
                this.tracks[t].getBall(i);
                Point currentPointRight = Ball.getPoint(this.tracks[t].getPath(), this.tracks[t].getBall(i).getCurrentX() + 18.0);
                double distanceRight = 9999.9;
                if (currentPointRight != null) {
                    distanceRight = Math.sqrt((currentPointRight.x - tempPoint.x) * (currentPointRight.x - tempPoint.x) + (currentPointRight.y - tempPoint.y) * (currentPointRight.y - tempPoint.y));
                }
                this.tracks[t].getBall(i);
                Point currentPointLeft = Ball.getPoint(this.tracks[t].getPath(), this.tracks[t].getBall(i).getCurrentX() - 18.0);
                double distanceLeft = 9999.9;
                if (currentPointLeft != null) {
                    distanceLeft = Math.sqrt((currentPointLeft.x - tempPoint.x) * (currentPointLeft.x - tempPoint.x) + (currentPointLeft.y - tempPoint.y) * (currentPointLeft.y - tempPoint.y));
                }
                if (distanceLeft < distanceRight && thisLevel.isInDeathZone(this.tracks[t].getBall(i).getCurrentX() - 18.0) || distanceRight < distanceLeft && thisLevel.isInDeathZone(this.tracks[t].getBall(i).getCurrentX() + 18.0) || distanceLeft == distanceRight && thisLevel.isInDeathZone(this.tracks[t].getBall(i).getCurrentX() + 18.0) && thisLevel.isInDeathZone(this.tracks[t].getBall(i).getCurrentX() - 18.0)) continue;
                number = i;
                minDX = distance;
                track = t;
            }
        }
        if (minDX <= 36.0) {
            this.number = number;
            this.tracks[track].getBall(number);
            Point currentPointRight = Ball.getPoint(this.tracks[track].getPath(), this.tracks[track].getBall(number).getCurrentX() + 18.0);
            double distanceRight = 9999.9;
            if (currentPointRight != null) {
                distanceRight = Math.sqrt((currentPointRight.x - tempPoint.x) * (currentPointRight.x - tempPoint.x) + (currentPointRight.y - tempPoint.y) * (currentPointRight.y - tempPoint.y));
            }
            this.tracks[track].getBall(number);
            Point currentPointLeft = Ball.getPoint(this.tracks[track].getPath(), this.tracks[track].getBall(number).getCurrentX() - 18.0);
            double distanceLeft = 9999.9;
            if (currentPointLeft != null) {
                distanceLeft = Math.sqrt((currentPointLeft.x - tempPoint.x) * (currentPointLeft.x - tempPoint.x) + (currentPointLeft.y - tempPoint.y) * (currentPointLeft.y - tempPoint.y));
            }
            if (direction = !(distanceLeft < distanceRight)) {
                this.launchedBall.setCurrentX(this.tracks[track].getBall(number).getCurrentX() + 18.0, this.tracks[track].getPath());
                if (this.launchedBall.getType() == 7) {
                    this.launchedBall.setType(this.tracks[track].getBall(number).getType());
                }
                this.tracks[track].getBallsVector().insertElementAt(this.launchedBall, number);
                this.tracks[track].setDeep(1);
                this.tracks[track].deleteBalls(number);
            } else {
                this.launchedBall.setCurrentX(this.tracks[track].getBall(number).getCurrentX() - 18.0, this.tracks[track].getPath());
                if (this.launchedBall.getType() == 7) {
                    this.launchedBall.setType(this.tracks[track].getBall(number).getType());
                }
                this.tracks[track].getBallsVector().insertElementAt(this.launchedBall, number + 1);
                this.tracks[track].setDeep(1);
                this.tracks[track].deleteBalls(number + 1);
            }
            try {
                this.launchedBall = null;
                this.launcher.breakLaunch();
                this.launchedBallTick = -1;
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void launchBall(final Point clickPoint) {
        this.gameScreen.invokeLater(new Runnable(){

            public void run() {
                if (Game.this.launchedBall != null || Game.this.isFinished() || Game.this.isStopped()) {
                    return;
                }
                Game.this.launchedBall = Game.this.launcher.getNextBall();
                Game.this.launchedBallTick = 0;
                Game.this.gunExplodeFrame = 0;
                int diffX = clickPoint.x - Game.this.launcher.getPoint().x;
                int diffY = -clickPoint.y + Game.this.launcher.getPoint().y;
                double tan = (double)diffY / (double)diffX;
                double tempAtan = Utils.atan(tan);
                if (diffX < 0) {
                    tempAtan += Math.PI;
                }
                Game.this.atan = tempAtan;
                Game.this.launcher.setBallPoint(Game.this.launcher.getPoint());
                Game.this.launcher.launch(Game.this.tracks, Game.this.tracksCount);
            }
        });
    }

    public int getLaunchIdentifier() {
        return this.launcherIdentifier;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public long getScore() {
        return this.score;
    }

    public void setScore(long score) {
        for (long i = this.score + 1L; i <= score; ++i) {
            if (i % 1500L != 0L) continue;
            if (this.lifesCount < 99) {
                ++this.lifesCount;
            }
            this.lifesLeftTick = 100;
        }
        this.score = score;
    }

    public int getLevel() {
        return this.level;
    }

    public void finish() {
        this.isFinished = true;
    }

    public int getGunExplodeFrame() {
        return this.gunExplodeFrame;
    }

    public int getX2Tick() {
        return this.x2Tick;
    }

    public void setX2Tick(int x2Tick) {
        this.x2Tick = x2Tick;
    }

    public int getSlowTick() {
        return this.slowTick;
    }

    public void setSlowTick(int slowTick) {
        this.slowTick = slowTick;
    }

    public void destroyBalls(Point point) {
        for (int i = 0; i < this.tracksCount; ++i) {
            this.tracks[i].destroyBalls(point);
        }
    }
}

