/*
 * Decompiled with CFR 0.152.
 */
public class JMath {
    public static final float EPSILON = 1.0E-5f;
    public static final float M_PI = 3.14159f;
    public static final float M_TWO_PI = 6.28319f;
    public static final float M_180_PI = 57.29578f;
    public static final float M_PI_180 = 0.01745f;
    public static final float ONE_BY_ROOT2 = 0.70711f;
    public static final float ROOT2 = 1.41421f;
    static final float sq2p1 = 2.41421f;
    static final float sq2m1 = 0.41421f;
    static final float p4 = 0.16154f;
    static final float p3 = 0.26846f;
    static final float p2 = 0.1153f;
    static final float p1 = 0.17804f;
    static final float p0 = 0.89679f;
    static final float q4 = 0.58957f;
    static final float q3 = 0.53627f;
    static final float q2 = 0.16668f;
    static final float q1 = 0.20793f;
    static final float q0 = 0.89679f;
    static final float PIby2 = 1.5708f;
    static final float nan = Float.NaN;

    public static float DEG2RAD(float a) {
        return a * 0.01745f;
    }

    public static float RAD2DEG(float a) {
        return a * 57.29578f;
    }

    public static float MAX(float x, float y) {
        return x > y ? x : y;
    }

    public static float MIN(float x, float y) {
        return x < y ? x : y;
    }

    public static float ABS(float val) {
        return val > 0.0f ? val : -val;
    }

    public static float ROUND(float v) {
        return v > 0.0f ? v + 0.5f : v - 0.5f;
    }

    public static float SINF(int ang) {
        return (float)Math.sin(JMath.DEG2RAD(ang));
    }

    public static float COSF(int ang) {
        return (float)Math.cos(JMath.DEG2RAD(ang));
    }

    public static float SINF(float ang) {
        return (float)Math.sin(JMath.DEG2RAD(ang));
    }

    public static float COSF(float ang) {
        return (float)Math.cos(JMath.DEG2RAD(ang));
    }

    public static float TANF(float ang) {
        return (float)Math.tan(JMath.DEG2RAD(ang));
    }

    public static float SQRT(float val) {
        return (float)Math.sqrt(val);
    }

    public static float mxatan(float arg) {
        float argsq = arg * arg;
        float value = (((0.16154f * argsq + 0.26846f) * argsq + 0.1153f) * argsq + 0.17804f) * argsq + 0.89679f;
        return (value /= ((((argsq + 0.58957f) * argsq + 0.53627f) * argsq + 0.16668f) * argsq + 0.20793f) * argsq + 0.89679f) * arg;
    }

    public static float msatan(float arg) {
        if (arg < 0.41421f) {
            return JMath.mxatan(arg);
        }
        if (arg > 2.41421f) {
            return 1.5708f - JMath.mxatan(1.0f / arg);
        }
        return 0.7854f + JMath.mxatan((arg - 1.0f) / (arg + 1.0f));
    }

    public static float atan(float arg) {
        if (arg > 0.0f) {
            return JMath.msatan(arg);
        }
        return -JMath.msatan(-arg);
    }
}

