/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class JProjectileMotion
extends JMath {
    public static final float GRAVITY = 1.0f;
    public static final float E_FACTOR = 0.75f;
    public static final float THETA_MAX = 85.0f;
    public static final float PHI_MAX = 360.0f;
    public static final float VEL_MAX = 70.0f;
    public static final int SHADOW_MAX_WIDTH = 6;
    public static final int SHADOW_MAX_HEIGHT = 6;
    public static final int SHADOW_MIN_WIDTH = 1;
    public static final int SHADOW_MIN_HEIGHT = 1;
    float rangeMax;
    public float heightMax;
    float v;
    float vH;
    float vV;
    float vE;
    float vN;
    float phiDeg;
    float thetaDeg;
    float t;
    public float tMax;
    float tHalf;
    JPoint2D pos2D;
    JPoint3D pos3D;
    JPoint3D pos3DMax;
    JPoint2D pos2DMax;
    JPoint2D initialPos2D;
    JPoint3D initialPos3D;
    JPoint2D haltPos2D;
    JPoint3D haltPos3D;
    boolean bReached;
    boolean bBounce;
    public float range;
    Image ball;
    JPoint2D ballPos;
    public JRect obj;
    public JRect shadow;
    static float shadowThreshold;
    float shadowScaleFactor;
    float shadowScaleOffset;
    float timeFactor = 1.0f;
    float hFactor = 0.3f;
    float haltTime = 0.0f;

    public JProjectileMotion() {
        try {
            this.pos2D = new JPoint2D();
            this.pos3D = new JPoint3D();
            this.pos2DMax = new JPoint2D();
            this.pos3DMax = new JPoint3D();
            this.initialPos2D = new JPoint2D();
            this.initialPos3D = new JPoint3D();
            this.haltPos2D = new JPoint2D();
            this.haltPos3D = new JPoint3D();
            this.obj = new JRect();
            this.shadow = new JRect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPos(float x, float y) {
        this.initialPos2D.x = x;
        this.initialPos2D.y = y;
        this.initialPos3D = JProjectileMotion.conv2D_3D(this.initialPos2D);
    }

    public void setPos(JPoint2D initPos2D) {
        this.initialPos2D.set(initPos2D);
        this.initialPos3D = JProjectileMotion.conv2D_3D(this.initialPos2D);
    }

    public void setPos(float x, float y, float z) {
        this.initialPos3D.x = x;
        this.initialPos3D.y = y;
        this.initialPos3D.z = z;
        this.initialPos2D = JProjectileMotion.conv3D_2D(this.initialPos3D);
    }

    public void setPos(JPoint3D initPos3D) {
        this.initialPos3D.set(initPos3D);
        this.initialPos2D = JProjectileMotion.conv3D_2D(this.initialPos3D);
    }

    public void setVel(float vel) {
        this.v = vel;
        this.vH = this.v * JProjectileMotion.COSF(this.thetaDeg);
        this.vV = this.v * JProjectileMotion.SINF(this.thetaDeg);
        this.vE = this.vH * JProjectileMotion.COSF(this.phiDeg);
        this.vN = this.vH * JProjectileMotion.SINF(this.phiDeg);
    }

    public void setAngles(float theta_deg, float phi_deg) {
        if (theta_deg < 0.0f) {
            theta_deg = 0.0f;
        } else if (theta_deg > 85.0f) {
            theta_deg = 85.0f;
        }
        if (phi_deg > 360.0f) {
            phi_deg -= 360.0f;
        }
        this.thetaDeg = theta_deg;
        this.phiDeg = phi_deg;
    }

    public void reset() {
        this.t = 0.0f;
        this.tMax = 0.0f;
        this.rangeMax = 0.0f;
        this.heightMax = 0.0f;
        this.pos2D.reset();
        this.pos3D.reset();
        this.pos2DMax.reset();
        this.pos3DMax.reset();
        this.initialPos2D.reset();
        this.initialPos3D.reset();
        this.haltPos2D.reset();
        this.haltPos3D.reset();
        this.bReached = false;
        this.bBounce = false;
        this.bounceActive(false);
        this.setPos(0.0f, 0.0f);
        this.setVel(0.0f);
        this.setAngles(0.0f, 0.0f);
    }

    public void set(float vel, float theta_deg, float phi_deg, float range) {
        this.t = 0.0f;
        this.tMax = 0.0f;
        this.bReached = false;
        this.rangeMax = range;
        this.pos2D.reset();
        this.pos3D.reset();
        this.pos3DMax.reset();
        this.pos2DMax.reset();
        this.setAngles(theta_deg, phi_deg);
        this.setVel(vel);
        this.tMax = JProjectileMotion.ABS(this.vV / 1.0f);
        this.tHalf = this.tMax * 0.5f;
        this.heightMax = this.vV * this.tHalf - 1.0f * this.tHalf * this.tHalf;
        this.pos3DMax.x = this.vE * this.tMax;
        this.pos3DMax.y = this.vN * this.tMax;
        this.pos3DMax.z = 0.0f;
        this.pos3DMax.plus(this.initialPos3D);
        this.pos2DMax = JProjectileMotion.conv3D_2D(this.pos3DMax);
    }

    public boolean update(float dtSec) {
        try {
            this.t = this.timeFactor * dtSec;
            if (this.t >= this.tMax && !this.bReached) {
                this.t = this.tMax;
                this.bReached = true;
            }
            if (!this.bReached) {
                this.pos3D.x = this.vE * this.t;
                this.pos3D.y = this.vN * this.t;
                this.pos3D.z = this.vV * this.t - 1.0f * this.t * this.t;
                this.pos3D.plus(this.initialPos3D);
                this.pos2D = JProjectileMotion.conv3D_2D(this.pos3D);
            }
            this.updateShadow(this.shadow);
            this.obj.x = (int)JProjectileMotion.ROUND(this.pos2D.x);
            this.obj.y = (int)JProjectileMotion.ROUND(this.pos2D.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bReached;
    }

    public static float getRange(JPoint2D posSrc, JPoint2D posDest) {
        float range = 0.0f;
        float diffX = posDest.x - posSrc.x;
        float diffY = posDest.y - posSrc.y;
        range = JMath.SQRT(diffX * diffX + diffY * diffY);
        return range;
    }

    public static JPoint3D conv2D_3D(JPoint2D pos2d) {
        JPoint3D pos3d = new JPoint3D();
        pos3d.x = pos2d.x + pos2d.y;
        pos3d.y = -(pos2d.y * 1.41421f);
        pos3d.z = 0.0f;
        return pos3d;
    }

    JPoint3D conv2D_3D(float x, float y) {
        JPoint2D pos2D = new JPoint2D();
        pos2D.set(x, y);
        return JProjectileMotion.conv2D_3D(pos2D);
    }

    public static JPoint2D conv3D_2D(JPoint3D pos3d) {
        JPoint2D pos2d = new JPoint2D();
        float offset = pos3d.y * 0.70711f;
        pos2d.x = pos3d.x + offset;
        pos2d.y = -(offset + pos3d.z);
        return pos2d;
    }

    public static JPoint2D conv3D_2D(float x, float y, float z) {
        JPoint3D pos3d = new JPoint3D();
        pos3d.set(x, y, z);
        return JProjectileMotion.conv3D_2D(pos3d);
    }

    public static float getRange(JPoint3D posSrc, JPoint3D posDest) {
        float range = 0.0f;
        float diffX = posDest.x - posSrc.x;
        float diffY = posDest.y - posSrc.y;
        float diffZ = posDest.z - posSrc.z;
        range = JMath.SQRT(diffX * diffX + diffY * diffY + diffZ * diffZ);
        return range;
    }

    public static float getRange(float vel, float thetaDeg) {
        float range = 0.0f;
        range = vel * JMath.SINF(2.0f * thetaDeg) / 2.0f * 1.0f;
        return range;
    }

    public static float getPhiDeg(JPoint3D posSrc, JPoint3D posDest) {
        float phiDeg = 0.0f;
        float diffX = posDest.x - posSrc.x;
        float diffY = posDest.y - posSrc.y;
        if (diffX == 0.0f && diffY == 0.0f) {
            return 0.0f;
        }
        float diff = diffY / diffX;
        phiDeg = JProjectileMotion.atan(diff);
        phiDeg = JProjectileMotion.RAD2DEG(phiDeg);
        if (posDest.y > posSrc.y ? phiDeg <= 0.0f : posDest.y < posSrc.y && phiDeg >= 0.0f) {
            return 180.0f + phiDeg;
        }
        if (phiDeg == 0.0f && posSrc.x > posDest.x) {
            return 180.0f + phiDeg;
        }
        return phiDeg;
    }

    public static float getVelocity(float range, float thetaDeg) {
        float v = 0.0f;
        v = range * 2.0f / JProjectileMotion.SINF(2.0f * thetaDeg);
        return JProjectileMotion.SQRT(v);
    }

    float getThetaDegAtTime(float time, float range) {
        float thetaDeg = 0.0f;
        float vV = 0.0f;
        float vH = 0.0f;
        vV = time * 1.0f;
        vH = range / time;
        float diffRatio = vV / vH;
        thetaDeg = JProjectileMotion.atan(diffRatio);
        if ((thetaDeg = JProjectileMotion.RAD2DEG(thetaDeg)) < 0.0f) {
            thetaDeg = 0.0f;
        } else if (thetaDeg > 85.0f) {
            thetaDeg = 85.0f;
        }
        return thetaDeg;
    }

    void setBounce() {
        if (this.v > 0.75f) {
            this.setPos(this.pos2DMax);
            this.v = 0.75f * this.v;
            if (this.thetaDeg > 5.0f) {
                this.thetaDeg *= 0.7f;
            }
            this.rangeMax = this.v * JMath.SINF(2.0f * this.thetaDeg) / 2.0f * 1.0f;
            this.set(this.v, this.thetaDeg, this.phiDeg, this.rangeMax);
        }
    }

    void setBounce(float heightMax, float thetaDeg) {
        float vel = 0.0f;
        vel = this.getApproxVel(heightMax, thetaDeg);
        if (vel > 0.0f) {
            this.setPos(this.pos2DMax);
            this.v = vel;
            this.rangeMax = this.v * JMath.SINF(2.0f * thetaDeg) / 2.0f * 1.0f;
            this.set(this.v, thetaDeg, this.phiDeg, this.rangeMax);
        }
    }

    public void bounceActive(boolean flag) {
        this.bBounce = flag;
    }

    void resetShadow() {
        this.obj.set(600, 600, 6, 6);
        this.shadow.set(600, 600, 6, 6);
    }

    public void updateShadow(JRect shadow) {
        shadow.x = (int)JProjectileMotion.ROUND(this.pos2D.x);
        shadow.y = (int)JProjectileMotion.ROUND(this.pos2D.y + this.pos3D.z);
    }

    public static float getMaxHeight(float vel, float thetaDeg) {
        float heightMax = 0.0f;
        float vV = vel * JMath.SINF(thetaDeg);
        float tHalf = vV / 1.0f * 0.5f;
        heightMax = vV * tHalf - 1.0f * tHalf * tHalf;
        return heightMax;
    }

    float getTimeToReachHeight(float height) {
        float requiredTime = 0.0f;
        float factor1 = this.vV * 0.5f / 1.0f;
        if (height > factor1 * this.vV && height > this.heightMax) {
            return 0.0f;
        }
        float factor2 = height / 1.0f;
        float factor3 = factor1 * factor1 - factor2;
        requiredTime = factor1 - JMath.SQRT(factor3);
        return requiredTime;
    }

    public static float getShadowScaleFactor(float height) {
        return height / shadowThreshold;
    }

    JPoint3D get3DPosAfterTime(float t) {
        JPoint3D pos3D = new JPoint3D();
        pos3D.reset();
        if (t >= 0.0f && t <= this.tMax) {
            pos3D.x = this.vE * t;
            pos3D.y = this.vN * t;
            pos3D.z = this.vV * t - 1.0f * t * t;
            pos3D.plus(this.initialPos3D);
        }
        return pos3D;
    }

    void advanceProjByTime(float time) {
        if (time < this.tMax) {
            this.t = time;
        }
    }

    float getRangeAtHeight(float height, float theta) {
        float range = 0.0f;
        range = 4.0f * height / JMath.TANF(theta);
        return range;
    }

    float getRangeAtTime(float t, float v, float thetaDeg) {
        float range = 0.0f;
        float vV = v * JMath.SINF(thetaDeg);
        float height = vV * t - 1.0f * t * t;
        range = 4.0f * height / JMath.TANF(thetaDeg);
        return range;
    }

    float getApproxVel(float heightMax, float thetaDeg) {
        float vel = 0.0f;
        float factor1 = heightMax * 1.0f;
        factor1 = 2.0f * JMath.SQRT(factor1);
        vel = factor1 / JMath.SINF(thetaDeg);
        return vel;
    }

    void setHaltPos() {
        JProjectileMotion temp = new JProjectileMotion();
        this.haltPos2D.reset();
        this.haltPos3D.reset();
        this.haltTime = 0.0f;
        temp.v = this.v;
        temp.thetaDeg = this.thetaDeg;
        temp.phiDeg = this.phiDeg;
        temp.heightMax = this.heightMax;
        temp.pos2DMax.set(this.pos2DMax);
        temp.pos3DMax.set(this.pos3DMax);
        this.haltTime = temp.tMax = this.tMax;
        while (temp.v > 0.0f) {
            temp.v = this.getApproxVel(temp.heightMax * this.hFactor, temp.thetaDeg);
            temp.vH = temp.v * JMath.COSF(temp.thetaDeg);
            temp.vV = temp.v * JMath.SINF(temp.thetaDeg);
            temp.vE = temp.vH * JMath.COSF(temp.phiDeg);
            temp.vN = temp.vH * JMath.SINF(temp.phiDeg);
            temp.tMax = JProjectileMotion.ABS(temp.vV / 1.0f);
            temp.tHalf = temp.tMax * 0.5f;
            temp.heightMax = temp.vV * temp.tHalf - 1.0f * temp.tHalf * temp.tHalf;
            temp.pos3DMax.x += temp.vE * temp.tMax;
            temp.pos3DMax.y += temp.vN * temp.tMax;
            temp.pos3DMax.z = 0.0f;
            temp.pos2DMax = JProjectileMotion.conv3D_2D(temp.pos3DMax);
            this.haltTime += temp.tMax;
        }
        this.haltPos2D.set(temp.pos2DMax);
        this.haltPos3D.set(temp.pos3DMax);
    }
}

