/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class Congratulations
extends GameCanvas {
    private Image imgpapelito;
    private Image imgfondocab;
    private Image imgpress5;
    private Image imgcongrat;
    private Image imgfestejo;
    private Papelito[] mpapelitos;
    private int[] animacionfestejo = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
    private int iaf;
    private int cantidad;
    private Graphics g;
    private int ancho;
    private int alto;
    private int timeStep;
    private int tiempoxcopo;
    private int randomInt;
    private int i;
    private Sprite jugador;
    Random generator;

    public Congratulations(Graphics graf, int vancho, int valto) throws IOException {
        super(true);
        this.g = graf;
        this.ancho = vancho;
        this.alto = valto;
        this.iaf = -1;
        this.cantidad = 10;
        this.cargarImagenes();
        this.setCantPapelitos(this.cantidad);
        this.jugador = new Sprite(this.imgfestejo, 85, 120);
        this.jugador.setPosition(this.ancho / 2, this.alto / 4 * 2);
        this.timeStep = 80;
        this.tiempoxcopo = 0;
        this.i = 0;
        this.generator = new Random();
        this.generator.setSeed(System.currentTimeMillis());
        for (int m = 0; m < this.cantidad; ++m) {
            this.randomInt = this.generator.nextInt();
            this.mpapelitos[m].posiInicAleatoria(this.ancho, this.randomInt);
        }
    }

    private void cargarImagenes() {
        try {
            this.imgpapelito = Image.createImage((String)"/papelito.png");
            this.imgfondocab = Image.createImage((String)"/fondocab.png");
            this.imgpress5 = Image.createImage((String)"/press5.png");
            this.imgcongrat = Image.createImage((String)"/congrat.png");
            this.cargaFestejo();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load Image: " + e);
        }
    }

    private void cargaFestejo() {
        try {
            switch (StreetPenaltyCanvas.personajeelegido) {
                case 1: {
                    this.imgfestejo = Image.createImage((String)"/festejo1.png");
                    break;
                }
                case 2: {
                    this.imgfestejo = Image.createImage((String)"/festejo2.png");
                    break;
                }
                case 3: {
                    this.imgfestejo = Image.createImage((String)"/festejo3.png");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load Image: " + e);
        }
    }

    private Papelito creaPapelito() throws IOException {
        return new Papelito(this.imgpapelito, 7, 8);
    }

    private void setCantPapelitos(int cant) throws IOException {
        this.cantidad = cant;
        this.mpapelitos = new Papelito[this.cantidad];
        for (int i = 0; i < this.cantidad; ++i) {
            this.mpapelitos[i] = this.creaPapelito();
        }
    }

    private void animaFestejo() {
        this.iaf = this.iaf < this.animacionfestejo.length - 1 ? ++this.iaf : 0;
        this.jugador.setFrame(this.animacionfestejo[this.iaf]);
        this.jugador.paint(this.g);
    }

    public void Mostrar() {
        int m;
        this.g.drawImage(this.imgfondocab, 0, 0, 4 | 0x10);
        this.g.drawImage(this.imgcongrat, this.ancho / 2, this.alto / 4, 1 | 2);
        this.g.drawImage(this.imgpress5, this.ancho / 2, this.alto - this.imgpress5.getHeight(), 1 | 2);
        this.animaFestejo();
        if (this.tiempoxcopo > 5) {
            this.tiempoxcopo = 0;
            if (this.i < this.cantidad) {
                this.mpapelitos[this.i].setAparece(true);
                ++this.i;
                for (m = 0; m < this.cantidad; ++m) {
                    if (this.mpapelitos[m].getY() <= this.alto) continue;
                    this.generator.setSeed(System.currentTimeMillis());
                    this.randomInt = this.generator.nextInt();
                    this.mpapelitos[m].posiInicAleatoria(this.ancho, this.randomInt);
                }
            } else {
                this.i = 0;
            }
        }
        for (m = 0; m < this.cantidad; ++m) {
            this.mpapelitos[m].gravedad();
            this.mpapelitos[m].paint(this.g);
        }
        ++this.tiempoxcopo;
    }
}

