/*
 * Decompiled with CFR 0.152.
 */
package com.zeemote.util;

import com.zeemote.util.Strings;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class StringsTest
extends TestCase {
    public void testResourceNotFound() {
        try {
            Strings.createFromResource("non-existent.txt");
            Assert.fail((String)"Did not raise an exception with a non existent resource name");
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void testBasicAccess() throws IOException {
        Strings strings = Strings.createFromResource("test-words-1.txt");
        Assert.assertEquals((String)"red", (String)strings.get(0));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2));
        Assert.assertTrue((null == strings.get(-1) ? 1 : 0) != 0);
    }

    public void testIntParamAccess() throws IOException {
        Object object = new int[0];
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{2, 4};
        int[] nArray3 = new int[]{2, 4, 6};
        Strings strings = Strings.createFromResource("test-words-1.txt");
        Assert.assertEquals((String)"red", (String)strings.get(0, (int[])null));
        Assert.assertEquals((String)"red", (String)strings.get(0, (int[])object));
        Assert.assertEquals((String)"red", (String)strings.get(0, nArray));
        Assert.assertEquals((String)"red", (String)strings.get(0, nArray2));
        Assert.assertEquals((String)"red", (String)strings.get(0, nArray3));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, (int[])null));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, (int[])object));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, nArray));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, nArray2));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, nArray3));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, (int[])null));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, (int[])object));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, nArray));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, nArray2));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, nArray3));
        try {
            strings.get(3, (int[])null);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(3, (int[])object);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        Assert.assertEquals((String)"param 0 ='2'", (String)strings.get(3, nArray));
        Assert.assertEquals((String)"param 0 ='2'", (String)strings.get(3, nArray2));
        Assert.assertEquals((String)"param 0 ='2'", (String)strings.get(3, nArray3));
        try {
            strings.get(3, (int[])null);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(4, (int[])object);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            strings.get(4, nArray);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        Assert.assertEquals((String)"param 0='2' and param 1='4'", (String)strings.get(4, nArray2));
        Assert.assertEquals((String)"param 0='2' and param 1='4'", (String)strings.get(4, nArray3));
        Assert.assertTrue((null == strings.get(-1, (int[])null) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, (int[])object) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, nArray) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, nArray2) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, nArray3) ? 1 : 0) != 0);
    }

    public void testStringParamAccess() throws IOException {
        Object[] objectArray = new String[]{};
        Object[] objectArray2 = new String[]{"zeemote"};
        Object[] objectArray3 = new String[]{"zeemote", "inc"};
        Object[] objectArray4 = new String[]{"zeemote", "inc", "foo"};
        Strings strings = Strings.createFromResource("test-words-1.txt");
        Assert.assertEquals((String)"red", (String)strings.get(0, (Object[])null));
        Assert.assertEquals((String)"red", (String)strings.get(0, objectArray));
        Assert.assertEquals((String)"red", (String)strings.get(0, objectArray2));
        Assert.assertEquals((String)"red", (String)strings.get(0, objectArray3));
        Assert.assertEquals((String)"red", (String)strings.get(0, objectArray4));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, (Object[])null));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, objectArray));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, objectArray2));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, objectArray3));
        Assert.assertEquals((String)"pay 10% of your fee", (String)strings.get(1, objectArray4));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, (Object[])null));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, objectArray));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, objectArray2));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, objectArray3));
        Assert.assertEquals((String)"this has no params", (String)strings.get(2, objectArray4));
        try {
            strings.get(3, (Object[])null);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(3, objectArray);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        Assert.assertEquals((String)"param 0 ='zeemote'", (String)strings.get(3, objectArray2));
        Assert.assertEquals((String)"param 0 ='zeemote'", (String)strings.get(3, objectArray3));
        Assert.assertEquals((String)"param 0 ='zeemote'", (String)strings.get(3, objectArray4));
        try {
            strings.get(4, (Object[])null);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(4, objectArray);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        try {
            strings.get(4, objectArray2);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        Assert.assertEquals((String)"param 0='zeemote' and param 1='inc'", (String)strings.get(4, objectArray3));
        Assert.assertEquals((String)"param 0='zeemote' and param 1='inc'", (String)strings.get(4, objectArray4));
        Assert.assertTrue((null == strings.get(-1, (Object[])null) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, objectArray) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, objectArray2) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, objectArray3) ? 1 : 0) != 0);
        Assert.assertTrue((null == strings.get(-1, objectArray4) ? 1 : 0) != 0);
    }

    public void testCreateFromString() throws IOException {
        Object object = null;
        try {
            Strings.createFromString(null);
            Assert.fail((String)"Should have rasied NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
        object = Strings.createFromString("");
        Assert.assertEquals((int)0, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("\n");
        Assert.assertEquals((int)0, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("\r");
        Assert.assertEquals((int)0, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("\r\n");
        Assert.assertEquals((int)0, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("   \r\n");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("\r\n   ");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("    \r\n   ");
        Assert.assertEquals((int)2, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("name\r\n");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("=value\r\n");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("name=\r\n");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        object = Strings.createFromString("name=value\r\n");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        Assert.assertEquals((String)"name=value", (String)((Strings)object).get(0));
        object = Strings.createFromString("value");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        Assert.assertEquals((String)"value", (String)((Strings)object).get(0));
        object = Strings.createFromString("value\r");
        Assert.assertEquals((int)1, (int)((Strings)object).getValues().length);
        Assert.assertEquals((String)"value", (String)((Strings)object).get(0));
        object = Strings.createFromString("name1=value1\r\nname2=value2\nname3=value3");
        Assert.assertEquals((int)3, (int)((Strings)object).getValues().length);
        Assert.assertEquals((String)"name1=value1", (String)((Strings)object).get(0));
        Assert.assertEquals((String)"name2=value2", (String)((Strings)object).get(1));
        Assert.assertEquals((String)"name3=value3", (String)((Strings)object).get(2));
    }

    public void testExceptions() throws IOException {
        Strings strings = Strings.createFromResource("test-words-1.txt");
        try {
            strings.get(3);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(4);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        try {
            strings.get(5);
            Assert.fail((String)"Expected StringIndexOutOfBoundsException");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        try {
            strings.get(6);
            Assert.fail((String)"Expected NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            strings.get(7);
            Assert.fail((String)"Expected NumberFormatException");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }
}

