/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_ROTATE = 0;
    public static final int IMG_LOGO_INLOGIC = 1;
    public static final int IMG_BTN_PAUSE = 2;
    public static final int IMG_BTN_OK = 3;
    public static final int IMG_BTN_CANCEL = 4;
    public static final int IMG_BTN_BACK = 5;
    public static final int IMG_BTN_QUIT = 6;
    public static final int IMG_BG_01 = 7;
    public static final int IMG_BG_02 = 8;
    public static final int IMG_BG_03 = 9;
    public static final int IMG_TREE_1 = 10;
    public static final int IMG_PEN_1 = 11;
    public static final int IMG_PEN_2 = 12;
    public static final int IMG_PEN_3 = 13;
    public static final int IMG_HERO_LOGAN_MNU = 14;
    public static final int IMG_SHADOW_MENU = 15;
    public static final int IMG_SHADOW_GAME_1 = 16;
    public static final int IMG_SHADOW_GAME_2 = 17;
    public static final int IMG_SHADOW_GAME_3 = 18;
    public static final int IMG_MEDAL_1 = 19;
    public static final int IMG_MEDAL_2 = 20;
    public static final int IMG_MEDAL_3 = 21;
    public static final int IMG_MEDAL_4 = 22;
    public static final int IMG_GRAVE_1 = 23;
    public static final int IMG_GRAVE_2 = 24;
    public static final int IMG_GRAVE_3 = 25;
    public static final int IMG_TITLE = 26;
    public static final int IMG_TREE_2 = 27;
    public static final int IMG_TREE_3 = 28;
    public static final int IMG_HERO_K_MNU = 29;
    public static final int IMG_HERO_BEATRIX_MNU = 30;
    public static final int IMG_HERO_MICHAEL_MNU = 31;
    public static final int TOTAL_IMGS = 32;
    public static Image[] resImgs = new Image[32];
    public static final int SPR_LANGUAGE = 0;
    public static final int SPR_DIALOG = 1;
    public static final int SPR_BUTTON = 2;
    public static final int SPR_ARROW = 3;
    public static final int SPR_ARROW_02 = 4;
    public static final int SPR_HERO_LOGAN = 5;
    public static final int SPR_DIALOG2 = 6;
    public static final int SPR_GRAVE_DUST_1 = 7;
    public static final int SPR_GRAVE_DUST_2 = 8;
    public static final int SPR_GRAVE_DUST_3 = 9;
    public static final int SPR_BRANCH_01 = 10;
    public static final int SPR_BRANCH_02 = 11;
    public static final int SPR_BRANCH_03 = 12;
    public static final int SPR_BRANCH_04 = 13;
    public static final int SPR_BRANCH_05 = 14;
    public static final int SPR_BRANCH_06 = 15;
    public static final int SPR_TUTORIAL_LEFT = 16;
    public static final int SPR_TUTORIAL_RIGHT = 17;
    public static final int SPR_HERO_K = 18;
    public static final int SPR_HERO_BEATRIX = 19;
    public static final int SPR_HERO_MICHAEL = 20;
    public static final int TOTAL_SPRS = 21;
    public static Sprite[] resSprs = new Sprite[21];
    public static final int GFONT_MAIN_1 = 0;
    public static final int GFONT_MAIN_2 = 1;
    public static final int GFONT_NUMBERS = 2;
    public static final int GFONT_NUMBERS_BIG = 3;
    public static final int TOTAL_GFONTS = 4;
    public static GFont[] resGFonts = new GFont[4];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_ENABLE_MUSIC_QUESTION = 2;
    public static final int TEXT_MAIN_YES = 3;
    public static final int TEXT_MAIN_NO = 4;
    public static final int TEXT_MAIN_MENU = 5;
    public static final int TEXT_MAIN_BACK = 6;
    public static final int TEXT_MAIN_PLAY = 7;
    public static final int TEXT_MAIN_INSTRUCTIONS = 8;
    public static final int TEXT_MAIN_SOUND = 9;
    public static final int TEXT_MAIN_ABOUT = 10;
    public static final int TEXT_MAIN_MORE_GAMES = 11;
    public static final int TEXT_MAIN_QUIT = 12;
    public static final int TEXT_MAIN_QUIT_TO_MENU = 13;
    public static final int TEXT_MAIN_QUIT_TO_MENU_QUESTION = 14;
    public static final int TEXT_MAIN_ON = 15;
    public static final int TEXT_MAIN_OFF = 16;
    public static final int TEXT_MAIN_VERSION = 17;
    public static final int TEXT_MAIN_EXIT_APP_QUESTION = 18;
    public static final int TEXT_MAIN_CONTINUE = 19;
    public static final int TEXT_MAIN_PAUSE = 20;
    public static final int TEXT_MAIN_GAME_OVER = 21;
    public static final int TEXT_MAIN_MEDAL = 22;
    public static final int TEXT_MAIN_SCORE = 23;
    public static final int TEXT_MAIN_BEST = 24;
    public static final int TEXT_MAIN_CONTROLS_TEXT_TOUCH = 26;
    public static final int TEXT_MAIN_CONTROLS_TEXT_KEYBOARD = 27;
    public static final int TEXT_MAIN_AIM_OF_GAME = 28;
    public static final int TEXT_MAIN_TAP = 29;
    public static boolean sysFont;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            System.out.println(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "logo_inlogic.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "pauza.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "fajka.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "zrusit.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "spet.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "vypnut.png";
                break;
            }
            case 7: {
                imgPath = graphicsDisplayDir + "background_01.png";
                break;
            }
            case 8: {
                imgPath = graphicsDisplayDir + "background_02.png";
                break;
            }
            case 9: {
                imgPath = graphicsDisplayDir + "background_03.png";
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "pen_01.png";
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "pen_02.png";
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "pen_03.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "wood_01.png";
                break;
            }
            case 27: {
                imgPath = graphicsBaseDir + "wood_02.png";
                break;
            }
            case 28: {
                imgPath = graphicsBaseDir + "wood_03.png";
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "hero_logan_menu.png";
                break;
            }
            case 29: {
                imgPath = graphicsBaseDir + "hero_k_menu.png";
                break;
            }
            case 31: {
                imgPath = graphicsBaseDir + "hero_michael_menu.png";
                break;
            }
            case 30: {
                imgPath = graphicsBaseDir + "hero_beatrix_menu.png";
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "tien_menu.png";
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "tien_hra_01.png";
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "tien_hra_02.png";
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "tien_hra_03.png";
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "medaila_01.png";
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "medaila_02.png";
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "medaila_03.png";
                break;
            }
            case 22: {
                imgPath = graphicsBaseDir + "medaila_04.png";
                break;
            }
            case 23: {
                imgPath = graphicsBaseDir + "hrob_01.png";
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "hrob_02.png";
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "hrob_03.png";
                break;
            }
            case 26: {
                imgPath = graphicsBaseDir + "title_01.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "flags_01.png";
                slicesX = 1;
                slicesY = 5;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "dialogove_okno.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "dialogove_okno2.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "tlacidlo.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "sipky_01.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "sipky_02.png";
                slicesX = 1;
                slicesY = 2;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "konar_01.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "hero_logan.png";
                slicesX = 1;
                slicesY = 4;
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "hero_k.png";
                slicesX = 1;
                slicesY = 4;
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "hero_michael.png";
                slicesX = 1;
                slicesY = 4;
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "hero_beatrix.png";
                slicesX = 1;
                slicesY = 4;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "efekt_hrob_01.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "efekt_hrob_02.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "efekt_hrob_03.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "konar_02.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "konar_03.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "konar_04.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "konar_05.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "konar_06.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "sipka_tutorial_02.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "sipka_tutorial_01.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '&', '@', '\\', '%', '+', '=', '\u00f7', '-', '.', ',', ':', '\'', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '|', '\u00a9', '(', ')', '/', '\u011e', '\u015e', '\u0130', ' '};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 11: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 4, 4, 5, 4, 1, 3, 4, 3, 7, 5, 5, 4, 5, 5, 4, 5, 5, 5, 7, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 5, 5, 4, 5, 4, 5, 2, 3, 3, 3, 3, 5, 6, 5, 6, 5, 5, 6, 5, 6, 5, 6, 5, 5, 5, 5, 4, 4, 5, 4, 4, 4, 7, 2, 4, 3, 3, 3, 2, 1, 1, 1, 1, 3, 1, 4, 1, 2, 5, 4, 2, 4, 4, 4, 3, 4, 3, 4, 4, 1, 5, 2, 2, 2, 5, 4, 3, 3};
                break;
            }
            case 22: {
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 4, 4, 5, 4, 1, 3, 4, 3, 7, 5, 5, 4, 5, 5, 4, 5, 5, 5, 7, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 5, 5, 4, 5, 4, 5, 2, 3, 3, 3, 3, 5, 6, 5, 6, 5, 5, 6, 5, 6, 5, 6, 5, 5, 5, 5, 4, 4, 5, 4, 4, 4, 7, 2, 4, 3, 3, 3, 2, 1, 1, 1, 1, 3, 1, 4, 1, 2, 5, 4, 2, 4, 4, 4, 3, 4, 3, 4, 4, 1, 5, 2, 2, 2, 5, 4, 3, 3};
                int i = 0;
                while (i < fontCharsWidth.length) {
                    int n = i++;
                    fontCharsWidth[n] = (short)(fontCharsWidth[n] * 2);
                }
                break;
            }
            case 44: {
                spaceBetweenChars = 4;
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 4, 4, 5, 4, 1, 3, 4, 3, 7, 5, 5, 4, 5, 5, 4, 5, 5, 5, 7, 5, 5, 4, 5, 5, 5, 5, 5, 5, 4, 5, 5, 4, 5, 4, 5, 2, 3, 3, 3, 3, 5, 6, 5, 6, 5, 5, 6, 5, 6, 5, 6, 5, 5, 5, 5, 4, 4, 5, 4, 4, 4, 7, 2, 4, 3, 3, 3, 2, 1, 1, 1, 1, 3, 1, 4, 1, 2, 5, 4, 2, 4, 4, 4, 3, 4, 3, 4, 4, 1, 5, 2, 2, 2, 5, 4, 3, 3};
                int i = 0;
                while (i < fontCharsWidth.length) {
                    int n = i++;
                    fontCharsWidth[n] = (short)(fontCharsWidth[n] * 4);
                }
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontNumbers(Image gFontImg) {
        char[] fontChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', ' '};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 8: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{4, 6, 6, 6, 5, 6, 5, 6, 6, 6, 6};
                break;
            }
            case 16: {
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{8, 12, 12, 12, 10, 12, 10, 12, 12, 12, 12};
                break;
            }
            case 32: {
                spaceBetweenChars = 4;
                fontCharsWidth = new short[]{8, 12, 12, 12, 10, 12, 10, 12, 12, 12, 12};
                int i = 0;
                while (i < fontCharsWidth.length) {
                    int n = i++;
                    fontCharsWidth[n] = (short)(fontCharsWidth[n] * 2);
                }
                break;
            }
            case 64: {
                spaceBetweenChars = 8;
                fontCharsWidth = new short[]{8, 12, 12, 12, 10, 12, 10, 12, 12, 12, 12};
                int i = 0;
                while (i < fontCharsWidth.length) {
                    int n = i++;
                    fontCharsWidth[n] = (short)(fontCharsWidth[n] * 4);
                }
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_01.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_02.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_cisla_01.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbers(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_cisla_velke_01.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbers(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }
}

