/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_TIME = 3000;
    private MainCanvas mainCanvas;
    private int mode;
    private long modeDelay;
    private int bodyAnimation;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private int fkAnimationR = 0;
    private int fkAnimationL = 0;
    private int fkIconAnimationR = 0;
    private int fkIconAnimationL = 0;
    private int hideFkLAnimation = 0;
    private int hideFkRAnimation = 0;
    private int showFkRAnimation = 0;
    private int bodyAnimation2 = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int interuption = 0;
    private int topAnimation = 0;
    boolean bottom = false;
    private boolean hide = false;
    private Rectangle rectDialog;
    private PreparedText title;
    private int kCode = 0;
    private int COMP_ID_YES = 0;
    private int COMP_ID_NO = 1;
    private Rectangle[] rectItems = new Rectangle[2];

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadSprite(16);
        this.mode = 0;
        Resources.loadImage(19);
        Resources.loadImages(new int[]{24, 16, 15, 1});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.loadGFont(3);
        Resources.loadText(0);
        this.calculatePosition();
    }

    public void afterHide() {
        Resources.freeSprite(16);
        Resources.freeImage(19);
        Resources.freeImages(new int[]{24, 16, 15, 1});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.freeGFont(3);
    }

    public void calculatePosition() {
        System.out.println("1");
        int iconWidth = Resources.resSprs[0].getWidth();
        System.out.println("2");
        int bgIconWidth = Resources.resSprs[16].getWidth();
        int bgIconHeight = Resources.resSprs[16].getHeight();
        int downHeight = Resources.resSprs[18].getHeight();
        this.rectItems[this.COMP_ID_YES] = new Rectangle(0, MainCanvas.HEIGHT - bgIconHeight, bgIconWidth + (bgIconWidth >> 1), bgIconHeight);
        this.rectItems[this.COMP_ID_NO] = new Rectangle(MainCanvas.WIDTH - bgIconWidth - (bgIconWidth >> 1), MainCanvas.HEIGHT - bgIconHeight, bgIconWidth + (bgIconWidth >> 1), bgIconHeight);
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight() + Resources.resImgs[15].getHeight(), this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.fkAnimationR = this.mainCanvas.getWidth();
        this.fkAnimationL = 0 - bgIconWidth;
        this.fkIconAnimationR = this.mainCanvas.getWidth() + iconWidth;
        this.fkIconAnimationL = 0 - iconWidth;
        this.showFkRAnimation = this.mainCanvas.getWidth() + iconWidth;
        this.hideFkRAnimation = this.mainCanvas.getWidth() - iconWidth;
        this.hideFkLAnimation = 0 - iconWidth;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.mainCanvas.getHeight() - downHeight;
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        System.out.println("t");
        this.title = new PreparedText(Resources.resGFonts[3]);
        System.out.println("t1");
        this.title.prepareText(Resources.resTexts[0].getHashedString(28), this.mainCanvas.getWidth());
        System.out.println("t2");
    }

    public void beforeInteruption() {
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this.mode) {
            case 1: 
            case 2: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= lastRunLenght;
                    return;
                }
                this.nextMode();
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(this.kCode)) {
                    MainCanvas.music = false;
                    Settings.musicOn = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKLeftCode(this.kCode)) break;
                MainCanvas.music = true;
                Settings.musicOn = true;
                MainCanvas.soundManager.SetSoundOn(true);
                this.nextMode();
            }
        }
    }

    private void nextMode() {
        switch (this.mode) {
            case 0: {
                Resources.loadImage(1);
                Resources.loadSprite(0);
                this.modeDelay = 3000L;
                this.mode = 1;
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                Resources.freeImage(1);
                Resources.loadImage(0);
                this.modeDelay = 3000L;
                this.mode = 2;
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                Resources.freeImage(0);
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
            }
        }
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationShow() {
        while (this.fkAnimationR != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
            --this.fkAnimationR;
            if (0 > this.fkAnimationL) {
                ++this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkIconAnimationR != this.hideFkRAnimation) {
            --this.fkIconAnimationR;
            if (this.fkIconAnimationL != 0) {
                ++this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationHide() {
        while (this.fkIconAnimationR != this.showFkRAnimation) {
            ++this.fkIconAnimationR;
            if (this.fkIconAnimationL > this.hideFkLAnimation) {
                --this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkAnimationR != this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth()) {
            ++this.fkAnimationR;
            if (0 - Resources.resSprs[16].getWidth() < this.fkAnimationL) {
                --this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    public void paintSoundTop(Graphics g) {
        int _topCenterpPosY = this.rectDialog.y >> 1;
        int _leftShift = 5;
        int _titleShift = 1;
        Sprite _bg = Resources.resSprs[16];
        Sprite _icons = Resources.resSprs[17];
        Image _border = Resources.resImgs[15];
        Image _bgIcon = Resources.resImgs[24];
        _bg.setFrame(1);
        for (int i = _bg.getWidth(); i < MainCanvas.WIDTH - 5 - _bg.getWidth(); i += _bg.getWidth()) {
            _bg.setPosition(i, _topCenterpPosY - (_bg.getHeight() >> 1));
            _bg.paint(g);
        }
        _bg.setFrame(2);
        _bg.setPosition(MainCanvas.WIDTH - _bg.getWidth() - 5, _topCenterpPosY - (_bg.getHeight() >> 1));
        _bg.paint(g);
        g.drawImage(_bgIcon, _leftShift, _topCenterpPosY, 6);
        _icons.setFrame(3);
        _icons.setPosition(_leftShift + (_bg.getWidth() >> 1) - (_icons.getWidth() >> 1), _bg.getY() + (_bg.getHeight() >> 1) - (_icons.getHeight() >> 1));
        _icons.paint(g);
        Rectangle _screenTitle = new Rectangle(_leftShift + _bgIcon.getWidth() + _titleShift, _topCenterpPosY - (this.title.getTextHeight() >> 1), this.mainCanvas.getWidth(), _bg.getHeight());
        this.title.drawText(g, _screenTitle, 0, 20);
        g.drawImage(_border, 0, this.rectDialog.y, 20);
    }

    public void paintSoundBottom(Graphics g) {
        Image _border = Resources.resImgs[15];
        g.drawImage(_border, 0, this.rectDialog.y + this.rectDialog.height - _border.getHeight(), 20);
    }

    public void paintSoundBoby(Graphics g) {
        Image _sound = Resources.resImgs[19];
        g.drawImage(_sound, this.rectDialog.getCenterX(), this.rectDialog.getCenterY(), 3);
    }

    public void paintSoundFk(Graphics g) {
        Sprite _funKey = Resources.resSprs[16];
        Sprite _fk = Resources.resSprs[0];
        int _shiftPositionY = this.mainCanvas.getHeight() - (this.rectDialog.y + this.rectDialog.height) >> 1;
        int _positionY = this.mainCanvas.getHeight() - _shiftPositionY - (_funKey.getHeight() >> 1);
        int _positionX = (_funKey.getWidth() >> 1) - (_fk.getWidth() >> 1);
        _funKey.setFrame(2);
        _funKey.setPosition(0, _positionY);
        _funKey.paint(g);
        _fk.setFrame(1);
        _fk.setPosition(_positionX, _positionY + (_funKey.getHeight() >> 1) - (_fk.getHeight() >> 1));
        _fk.paint(g);
        _funKey.setFrame(0);
        _funKey.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth(), _positionY);
        _funKey.paint(g);
        _fk.setFrame(2);
        _fk.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth() + _positionX, _positionY + (_funKey.getHeight() >> 1) - (_fk.getHeight() >> 1));
        _fk.paint(g);
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.setColor(269619);
                g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                this.paintSoundTop(g);
                this.paintSoundBottom(g);
                this.paintSoundBoby(g);
                this.paintSoundFk(g);
                break;
            }
            case 1: {
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.setColor(269619);
                g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(Resources.resImgs[1], MainCanvas.WIDTH / 2, MainCanvas.HEIGHT / 2, 3);
                break;
            }
            case 2: {
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.setColor(269619);
                g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(Resources.resImgs[0], 0, 0, 20);
            }
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.kCode = keyCode;
                    this.hide = true;
                    Settings.musicOn = true;
                    MainCanvas.soundManager.SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.kCode = keyCode;
                this.hide = true;
                Settings.musicOn = false;
                MainCanvas.soundManager.SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 0: {
                System.out.println("som tu 1");
                for (int i = 0; i < this.rectItems.length; ++i) {
                    System.out.println("som na pol ceste");
                    if (!this.rectItems[i].contains(x, y)) continue;
                    System.out.println("presiel som podmienkou");
                    if (i == this.COMP_ID_YES) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        MainCanvas.soundManager.SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != this.COMP_ID_NO) continue;
                    Settings.musicOn = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 0: {
                for (int i = 0; i < this.rectItems.length; ++i) {
                    if (!this.rectItems[i].contains(x, y)) continue;
                    if (i == this.COMP_ID_YES) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        MainCanvas.soundManager.SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != this.COMP_ID_NO) continue;
                    Settings.musicOn = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

