/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_INLOGIC = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private Rectangle[] rectItems = new Rectangle[2];
    private Rectangle rectText;
    private Rectangle rectDialog;
    private int selectedCompId;
    private static PreparedText preparedText;
    private static final String INLOGIC_URL = "http://www.inlogic.eu";
    private int interuption = 0;
    private static final int textMarginTop = 20;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private PreparedText title;
    private int fkAnimation = 0;
    private int fkIconAnimation = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int topAnimation = 0;
    boolean bottom = false;
    private int bodyAnimation2 = 0;
    private int bodyAnimation;
    int cycle = 10;
    private int musicControler = 0;

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{24, 22, 15, 17, 1});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.loadGFont(4);
        Resources.loadGFont(3);
        this.calculatePositions();
        Resources.loadGFont(4);
        preparedText = new PreparedText(Resources.resGFonts[4]);
        preparedText.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectText.width);
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(23), this.rectText.width);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{24, 22, 15, 17, 1});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.freeGFont(4);
        Resources.freeGFont(3);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        int itemWidth = Resources.resSprs[15].getWidth();
        int itemHeight = Resources.resSprs[15].getHeight();
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight() + Resources.resImgs[15].getHeight(), this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - itemWidth - (itemWidth >> 1), MainCanvas.HEIGHT - itemHeight, itemWidth + (itemWidth >> 1), itemHeight);
        Image imgLogo = Resources.resImgs[1];
        this.rectItems[1] = new Rectangle(this.rectDialog.x + (this.rectDialog.width >> 1) - (imgLogo.getWidth() >> 1), this.rectDialog.y + (this.rectDialog.height >> 1) - (imgLogo.getHeight() >> 1) - 20, imgLogo.getWidth(), imgLogo.getHeight());
        this.rectText = new Rectangle(this.rectDialog.x, this.rectItems[1].getBottom() + 20, this.rectDialog.width, (this.rectDialog.height >> 1) - 20);
        this.fkAnimation = this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth();
        this.fkIconAnimation = this.mainCanvas.getWidth() + Resources.resSprs[0].getWidth();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight();
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
    }

    public void update(long lastRunLenght) {
        if (MainCanvas.interuption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                if (this.musicControler == 1) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    this.musicControler = 0;
                }
                this.cycle = 10;
            }
        }
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimation(boolean show) {
        if (show) {
            while (this.fkAnimation != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
                --this.fkAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkIconAnimation != this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth()) {
                --this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
        } else {
            while (this.fkIconAnimation != this.mainCanvas.getWidth()) {
                ++this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkAnimation != this.mainCanvas.getWidth()) {
                ++this.fkAnimation;
                this.mainCanvas.repaint();
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKRightCode(keyCode)) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2));
        }
        System.out.println("1");
        System.out.println("3");
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(269619);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(Resources.resImgs[22], 0, 0, 20);
        this.paintBody(g);
        this.paintTop(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintTop(Graphics g) {
        int _topCenterpPosY = this.rectDialog.y >> 1;
        int _leftShift = 5;
        int _titleShift = 1;
        Sprite _bg = Resources.resSprs[16];
        Sprite _icons = Resources.resSprs[17];
        Image _border = Resources.resImgs[15];
        Image _bgIcon = Resources.resImgs[24];
        _bg.setFrame(1);
        for (int i = _bg.getWidth(); i < MainCanvas.WIDTH - 5 - _bg.getWidth(); i += _bg.getWidth()) {
            _bg.setPosition(i, _topCenterpPosY - (_bg.getHeight() >> 1));
            _bg.paint(g);
        }
        _bg.setFrame(2);
        _bg.setPosition(MainCanvas.WIDTH - _bg.getWidth() - 5, _topCenterpPosY - (_bg.getHeight() >> 1));
        _bg.paint(g);
        g.drawImage(_bgIcon, _leftShift, _topCenterpPosY, 6);
        _icons.setFrame(2);
        _icons.setPosition(_leftShift + (_bg.getWidth() >> 1) - (_icons.getWidth() >> 1), _bg.getY() + (_bg.getHeight() >> 1) - (_icons.getHeight() >> 1));
        _icons.paint(g);
        Rectangle _screenTitle = new Rectangle(_leftShift + _bgIcon.getWidth() + _titleShift, _topCenterpPosY - (this.title.getTextHeight() >> 1), this.mainCanvas.getWidth(), _bg.getHeight());
        this.title.drawText(g, _screenTitle, 0, 20);
        g.drawImage(_border, 0, this.rectDialog.y, 20);
    }

    private void paintBody(Graphics g) {
        Image border = Resources.resImgs[15];
        g.setColor(269619);
        g.fillRect(this.rectDialog.x, this.rectDialog.y, this.rectDialog.width, this.rectDialog.height - this.bodyAnimation2 + border.getHeight() - (border.getHeight() << 1));
        g.drawImage(Resources.resImgs[1], this.rectItems[1].x, this.rectItems[1].y, 20);
        preparedText.drawText(g, this.rectText, 0, 17);
    }

    private void paintBottom(Graphics g) {
        Image _border = Resources.resImgs[15];
        g.drawImage(_border, 0, _border.getHeight() + this.rectDialog.y + this.rectDialog.height - (_border.getHeight() << 1), 20);
    }

    private void paintFK(Graphics g) {
        Sprite _funKey = Resources.resSprs[16];
        Sprite _fk = Resources.resSprs[0];
        int _shiftPositionY = 0;
        int _positionY = this.mainCanvas.getHeight() - _shiftPositionY - _funKey.getHeight();
        int _positionX = (_funKey.getWidth() >> 1) - (_fk.getWidth() >> 1);
        _funKey.setFrame(0);
        _funKey.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth(), _positionY);
        _funKey.paint(g);
        _fk.setFrame(9);
        _fk.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth() + _positionX, _positionY + (_funKey.getHeight() >> 1) - (_fk.getHeight() >> 1));
        _fk.paint(g);
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

