/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenRealyQuit
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_YES = 0;
    private static final int COMP_ID_NO = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private int interuption = 0;
    private Rectangle[] rectItems = new Rectangle[2];
    private Rectangle rectDialog;
    private int selectedCompId;
    private int selectedComMenuId;
    private int resource = 0;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private int fkAnimation = 0;
    private int fkIconAnimation = 0;
    private int logoAnimation = 0;
    private int textAnimation = 0;
    private int bottomShow = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int topAnimation = 0;
    private int topMove = 0;
    boolean bottom = false;
    private int bodyAnimation2 = 0;
    private int bodyAnimation = 0;
    private int fkAnimationR = 0;
    private int fkAnimationL = 0;
    private int fkIconAnimationR = 0;
    private int fkIconAnimationL = 0;
    private int hideFkLAnimation = 0;
    private int hideFkRAnimation = 0;
    private int showFkLAnimation = 0;
    private int showFkRAnimation = 0;
    private PreparedText title;
    int cycle = 10;

    public ScreenRealyQuit(MainCanvas mainCanvas, int selectedItem) {
        this.mainCanvas = mainCanvas;
        this.selectedComMenuId = selectedItem;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{24, 22, 15, 17});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 0, 16});
        this.calculatePositions();
        Resources.loadText(0);
        Resources.loadGFont(4);
        Resources.loadGFont(3);
        if (!Resources.sysFont) {
            Resources.loadGFont(3);
        }
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(2), this.mainCanvas.getWidth());
    }

    public void afterHide() {
        Resources.freeImages(new int[]{24, 22, 15, 17});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 0, 16});
        Resources.freeGFont(3);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        int iconWidth = Resources.resSprs[0].getWidth();
        int bgIconWidth = Resources.resSprs[16].getWidth();
        int bgIconHeight = Resources.resSprs[16].getHeight();
        int downHeight = Resources.resSprs[18].getHeight();
        int marginLeft = fkWidth;
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight() + Resources.resImgs[15].getHeight(), MainCanvas.WIDTH, MainCanvas.HEIGHT - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - bgIconHeight, bgIconWidth + (bgIconWidth >> 1), bgIconHeight);
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - bgIconWidth - (bgIconWidth >> 1), MainCanvas.HEIGHT - bgIconHeight, bgIconWidth + (bgIconWidth >> 1), bgIconHeight);
        this.fkAnimation = this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth();
        this.fkIconAnimation = this.mainCanvas.getWidth() + Resources.resSprs[0].getWidth();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.bottomShow = this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight();
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.fkAnimationR = this.mainCanvas.getWidth();
        this.fkAnimationL = 0 - bgIconWidth;
        this.fkIconAnimationR = this.mainCanvas.getWidth() + iconWidth;
        this.fkIconAnimationL = 0 - iconWidth;
        this.showFkRAnimation = this.mainCanvas.getWidth() + iconWidth;
        this.hideFkRAnimation = this.mainCanvas.getWidth() - iconWidth;
        this.showFkLAnimation = 0 + iconWidth;
        this.hideFkLAnimation = 0 - iconWidth;
    }

    public void update(long lastRunLenght) {
        if (Keys.isKeyPressed(-6)) {
            // empty if block
        }
    }

    private void textAnimation(boolean show) {
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationShow() {
        while (this.fkAnimationR != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
            --this.fkAnimationR;
            if (0 > this.fkAnimationL) {
                ++this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkIconAnimationR != this.hideFkRAnimation) {
            --this.fkIconAnimationR;
            if (this.fkIconAnimationL != 0) {
                ++this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationHide() {
        while (this.fkIconAnimationR != this.showFkRAnimation) {
            ++this.fkIconAnimationR;
            if (this.fkIconAnimationL > this.hideFkLAnimation) {
                --this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkAnimationR != this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth()) {
            ++this.fkAnimationR;
            if (0 - Resources.resSprs[16].getWidth() < this.fkAnimationL) {
                --this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    public void paint(Graphics g) {
        g.setColor(269619);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(Resources.resImgs[22], 0, 0, 20);
        this.paintBody(g);
        this.paintTop(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintBottom(Graphics g) {
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.rectDialog.y - border.getHeight(), 20);
        g.drawImage(border, 0, this.rectDialog.y + this.rectDialog.height - border.getHeight(), 20);
    }

    private void paintBody(Graphics g) {
        g.setColor(269619);
        g.setColor(269619);
        g.fillRect(this.rectDialog.x, this.rectDialog.y, this.rectDialog.width, this.rectDialog.height);
        if (Resources.sysFont) {
            g.setFont(Font.getDefaultFont());
            g.setColor(13813276);
            g.drawString(Resources.resTexts[0].getHashedString(2), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (Font.getDefaultFont().getHeight() >> 1), 17);
            g.setColor(0);
        } else {
            GFont font = Resources.resGFonts[4];
            String text = Resources.resTexts[0].getHashedString(2);
            font.drawString(g, text.toCharArray(), MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        }
    }

    private void paintTop(Graphics g) {
        int _topCenterpPosY = this.rectDialog.y >> 1;
        int _leftShift = 5;
        int _titleShift = 1;
        Sprite _bg = Resources.resSprs[16];
        Sprite _icons = Resources.resSprs[17];
        Image _border = Resources.resImgs[15];
        Image _bgIcon = Resources.resImgs[24];
        _bg.setFrame(1);
        for (int i = _bg.getWidth(); i < MainCanvas.WIDTH - 5 - _bg.getWidth(); i += _bg.getWidth()) {
            _bg.setPosition(i, _topCenterpPosY - (_bg.getHeight() >> 1));
            _bg.paint(g);
        }
        _bg.setFrame(2);
        _bg.setPosition(MainCanvas.WIDTH - _bg.getWidth() - 5, _topCenterpPosY - (_bg.getHeight() >> 1));
        _bg.paint(g);
        g.drawImage(_bgIcon, _leftShift, _topCenterpPosY, 6);
        _icons.setFrame(2);
        _icons.setPosition(_leftShift + (_bg.getWidth() >> 1) - (_icons.getWidth() >> 1), _bg.getY() + (_bg.getHeight() >> 1) - (_icons.getHeight() >> 1));
        _icons.paint(g);
        Rectangle _screenTitle = new Rectangle(_leftShift + _bgIcon.getWidth() + _titleShift, _topCenterpPosY - (this.title.getTextHeight() >> 1), this.mainCanvas.getWidth(), _bg.getHeight());
        this.title.drawText(g, _screenTitle, 0, 20);
    }

    public void paintDialogItems(Graphics g) {
        if (Resources.sysFont) {
            g.setFont(Font.getDefaultFont());
            g.setColor(13813276);
            g.drawString(Resources.resTexts[0].getHashedString(2), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (Font.getDefaultFont().getHeight() >> 1), 17);
            g.setColor(0);
        } else {
            GFont font = Resources.resGFonts[3];
            String text = Resources.resTexts[0].getHashedString(2);
            font.drawString(g, text.toCharArray(), MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        }
    }

    public void paintFK(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(1);
        funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(2);
        funKey.setPosition(funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(1);
        fk.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
        funKey.setFrame(1);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(2);
        fk.setPosition(this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            X.quitApp();
        } else if (Keys.isFKRightCode(keyCode)) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, this.selectedComMenuId));
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyPressed(-6);
                    break;
                }
                case 1: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
            this.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

