/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_SPLASH = 0;
    public static final int IMG_INLOGIC_LOGO = 1;
    public static final int IMG_LANG_EN = 2;
    public static final int IMG_LANG_DE = 3;
    public static final int IMG_LANG_FR = 4;
    public static final int IMG_LANG_IT = 5;
    public static final int IMG_LANG_ES = 6;
    public static final int IMG_LANG_PT = 7;
    public static final int IMG_LANG_RU = 8;
    public static final int IMG_LANG_SK = 9;
    public static final int IMG_RES_ROTATION = 10;
    public static final int IMG_MNU_SLCTR = 11;
    public static final int IMG_GAM_DARK_TILE = 12;
    public static final int IMG_GAM_BRIGHT_TILE = 13;
    public static final int IMG_GAM_DOWN = 14;
    public static final int IMG_GAME_BORDER_LIGHT = 15;
    public static final int IMG_MENU_LOGO = 16;
    public static final int IMG_MENU_LIGHT = 17;
    public static final int IMG_LEVEL_SLCTR = 18;
    public static final int IMG_SOUNDS = 19;
    public static final int IMG_LOCK = 20;
    public static final int IMG_STAR = 21;
    public static final int IMG_BG = 22;
    public static final int IMG_MENU_BUTTON_GOLD = 23;
    public static final int IMG_MENU_BUTTON_BLUE_LIGHT = 24;
    public static final int IMG_MENU_BUTTON_BLUE_DARK = 25;
    public static final int TOTAL_IMGS = 26;
    public static Image[] resImgs = new Image[26];
    public static final int SPR_MNU_FK = 0;
    public static final int SPR_GAM_DIAROTATE = 1;
    public static final int SPR_GAM_BNSSPECTRUM = 2;
    public static final int SPR_GAM_BNSBOMB = 3;
    public static final int SPR_GAM_PROGRES = 4;
    public static final int SPR_GAM_SELECTOR = 5;
    public static final int SPR_GAM_BLOCK = 6;
    public static final int SPR_GAM_PARTICLES = 7;
    public static final int SPR_GAM_BNSCROSS = 8;
    public static final int SPR_GAM_FLAME = 9;
    public static final int SPR_GAM_BNSFALLF = 10;
    public static final int SPR_MNU_SCROLLARROWS = 11;
    public static final int SPR_GAM_PANELS = 12;
    public static final int SPR_MNU_SLCTR = 13;
    public static final int SPR_GAME_BORDER = 14;
    public static final int SPR_TIME_BAR = 15;
    public static final int SPR_BUTON_BG = 16;
    public static final int SPR_BUTON_BG2 = 23;
    public static final int SPR_MENU_ICONS = 17;
    public static final int SPR_ORNAMENT_ANIM = 18;
    public static final int SPR_ARROW = 19;
    public static final int SPR_LANGUAGE = 20;
    public static final int SPR_LEVEL_ICONS = 21;
    public static final int SPR_CUPS = 22;
    public static final int SPR_GAM_BNSBOMBB = 24;
    public static final int SPR_GAM_BNSESC = 25;
    public static final int SPR_MNU_FK2 = 26;
    public static final int TOTAL_SPRS = 27;
    public static Sprite[] resSprs = new Sprite[27];
    public static final int GFONT_MAIN = 0;
    public static final int GFONT_GAME = 1;
    public static final int GFONT_NUMS = 2;
    public static final int GFONT_MNU = 3;
    public static final int GFONT_MNU_GOLD = 4;
    public static final int GFONT_MNU_BLUE = 5;
    public static final int GFONT_GAME_BROWN = 6;
    public static final int GFONT_GAME_GOLD = 7;
    public static final int TOTAL_GFONTS = 8;
    public static GFont[] resGFonts = new GFont[8];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 23: {
                imgPath = graphicsBaseDir + "level_icon_bg_v1.png";
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "level_icon_bg_v2.png";
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "level_selector.png";
                break;
            }
            case 22: {
                imgPath = graphicsBaseDir + "background.png";
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "lock.png";
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "star1.png";
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "sound.png";
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "level_selector.png";
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "game_border.png";
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "light.png";
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "jewels.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "l.png";
                break;
            }
            case 0: {
                imgPath = graphicsDisplayDir + "s.png";
                break;
            }
            case 12: {
                imgPath = graphicsDisplayDir + "DarkTile.png";
                break;
            }
            case 13: {
                imgPath = graphicsDisplayDir + "BrightTile.png";
                break;
            }
            case 14: {
                imgPath = graphicsDisplayDir + "GamDrw.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "lang_en.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "lang_de.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "lang_fr.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "lang_it.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "lang_es.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "lang_pt.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "lang_ru.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "lang_sk.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "rot.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 22: {
                imgPath = graphicsBaseDir + "cups.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "level_icons.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 4;
                slicesY = 3;
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "menu_arow.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "ornament_down.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "GamBnsBombB.png";
                slicesX = 6;
                slicesY = 7;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "GamBnsFallF.png";
                slicesX = 8;
                slicesY = 2;
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "GamBnsFallF.png";
                slicesX = 8;
                slicesY = 1;
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "menu_icons.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "button_bg_v1.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 23: {
                imgPath = graphicsBaseDir + "button_bg_v2.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "level_select_buttons.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "game_border.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 0: {
                imgPath = graphicsBaseDir + "MnuFK.png";
                slicesX = 11;
                slicesY = 1;
                break;
            }
            case 26: {
                imgPath = graphicsBaseDir + "MnuFK_v1.png";
                slicesX = 11;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "GamDiaAnm.png";
                slicesX = 6;
                slicesY = 7;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "GamBnsSpectrum.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "GamBnsBomb.png";
                slicesX = 6;
                slicesY = 7;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "GamSlctr.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "GamBlock.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "GamParticles.png";
                slicesX = 7;
                slicesY = 7;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "GamBnsCross.png";
                slicesX = 6;
                slicesY = 7;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "GamFlame.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "MnuArrwLeftRight.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "GamPnls.png";
                slicesX = 1;
                slicesY = 2;
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "MnuSlctr.png";
                slicesX = 1;
                slicesY = 1;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMenu(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '~', '\u02c6', '.', ',', ':', ';', '\"', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 14: {
                fontCharsWidth = new short[]{10, 8, 8, 8, 8, 7, 8, 8, 2, 5, 7, 7, 11, 8, 7, 8, 8, 8, 7, 7, 8, 9, 13, 10, 10, 8, 10, 10, 10, 10, 10, 10, 8, 8, 8, 8, 8, 8, 8, 8, 3, 4, 5, 6, 7, 8, 8, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 8, 8, 8, 8, 8, 8, 9, 8, 6, 9, 7, 5, 9, 6, 9, 4, 5, 5, 5, 4, 5, 2, 3, 2, 3, 4, 2, 5, 2, 5, 7, 4, 8, 3, 8, 8, 8, 8, 8, 9, 8, 8, 0};
                break;
            }
            case 18: {
                fontCharsWidth = new short[]{14, 10, 10, 10, 10, 9, 10, 10, 3, 6, 9, 10, 14, 10, 10, 10, 11, 10, 9, 10, 10, 13, 17, 12, 12, 10, 13, 13, 13, 13, 13, 13, 10, 10, 10, 10, 10, 10, 9, 10, 4, 4, 6, 7, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 10, 10, 10, 10, 10, 10, 11, 10, 8, 11, 9, 7, 10, 4, 4, 12, 6, 6, 7, 6, 6, 7, 2, 4, 2, 3, 5, 3, 7, 2, 7, 9, 5, 10, 3, 11, 10, 10, 10, 11, 11, 11, 10, 0};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{20, 16, 14, 16, 15, 15, 16, 16, 4, 9, 15, 14, 21, 16, 16, 16, 17, 16, 15, 14, 15, 21, 26, 20, 19, 16, 20, 20, 20, 20, 20, 20, 15, 15, 16, 14, 14, 14, 14, 14, 6, 6, 8, 11, 14, 16, 16, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 19, 16, 16, 14, 14, 15, 16, 17, 14, 12, 18, 13, 10, 16, 5, 5, 19, 8, 10, 10, 9, 10, 10, 4, 4, 4, 4, 8, 4, 11, 3, 11, 14, 7, 16, 3, 17, 16, 17, 16, 17, 16, 16, 16, 0};
                break;
            }
            case 36: {
                fontCharsWidth = new short[]{26, 20, 18, 20, 19, 19, 20, 20, 5, 11, 19, 18, 27, 20, 20, 21, 21, 20, 19, 19, 20, 26, 34, 26, 24, 21, 26, 26, 26, 26, 26, 26, 19, 19, 20, 19, 19, 19, 19, 19, 8, 8, 11, 14, 18, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 25, 21, 21, 19, 19, 19, 20, 22, 19, 16, 23, 16, 13, 20, 6, 6, 25, 11, 13, 12, 12, 13, 13, 4, 5, 5, 5, 9, 5, 14, 5, 14, 17, 9, 20, 5, 21, 21, 22, 21, 22, 22, 21, 22, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{14, 10, 10, 10, 10, 9, 10, 10, 2, 7, 10, 9, 13, 11, 10, 10, 11, 10, 9, 10, 10, 13, 17, 12, 12, 10, 13, 13, 13, 13, 13, 13, 10, 10, 10, 10, 10, 10, 9, 10, 4, 4, 6, 7, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 10, 10, 10, 10, 9, 11, 11, 9, 9, 11, 9, 7, 10, 8, 12, 6, 6, 7, 6, 6, 7, 2, 4, 2, 3, 5, 3, 7, 2, 7, 9, 5, 10, 3, 11, 10, 10, 10, 11, 11, 11, 10, 0};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontGame(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', '/', 'm', 'd', '*'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 8: {
                fontCharsWidth = new short[]{6, 2, 6, 7, 6, 6, 7, 6, 7, 5, 2, 4, 9, 7, 7};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{14, 5, 15, 16, 16, 16, 17, 16, 16, 16, 3, 9, 24, 16, 19};
                break;
            }
            case 28: {
                spaceBetweenChars = 3;
                fontCharsWidth = new short[]{21, 5, 21, 23, 23, 22, 23, 23, 22, 23, 4, 14, 33, 23, 26};
                break;
            }
            default: {
                fontCharsWidth = new short[]{6, 2, 6, 7, 6, 6, 7, 6, 7, 5, 2, 4, 9, 7, 7};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontMain.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontGame_v1.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 6: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontGame_v3.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 7: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontGame_v2.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntMnu_v3.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
                break;
            }
            case 4: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntMnu_v2.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
                break;
            }
            case 5: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntMnu_v1.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

