/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Game;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int gameMode;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_STARTSCREEN = 5;
    private static final int STATUS_RESTARTSCREEN = 6;
    private static final int STATUS_LAST_MESSAGE = 7;
    private static final int STATUS_REALY_QUIT = 8;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int COMP_ID_ARR_UP = 7;
    private static final int COMP_ID_ARR_DOWN = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    Rectangle ret;
    private Rectangle rectDialog;
    private Rectangle rectTextInstrructions;
    private Rectangle rectTextDialog;
    private Rectangle rectText;
    private int selectedCompId;
    private int icount;
    private static int PROGRESWIDTH;
    private static int PROGRESH;
    private static int DSP_X;
    private static int X1;
    private static int X2;
    private static PreparedText preparedInstructionsText;
    private static PreparedText preparedText1;
    private static PreparedText preparedText2;
    private static PreparedText play;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    int level = 0;
    private final int[] SELECTEDSEQUENCE = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
    private int resourceFrame = 0;
    private int repeats = 0;
    private int bodyAnimation = 0;
    private int bodyAnimation2 = 0;
    private int actualLevel;
    private boolean bonusPack = false;
    int cycle = 10;
    private int score = 0;
    private String stars = "";
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;

    public ScreenGame(MainCanvas mainCanvas, int gameMode, int level, boolean bonus) {
        this.bonusPack = bonus;
        if (this.bonusPack) {
            Level.getBonusLevel(level);
        } else {
            Level.getLevel(level);
        }
        this.actualLevel = level;
        this.mainCanvas = mainCanvas;
        this.gameMode = gameMode;
        this.status = Level.tutorial ? 4 : 5;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{23, 24, 25, 24, 22, 21, 12, 13, 15, 17, 12, 13});
        Resources.loadSprites(new int[]{25, 21, 18, 19, 16, 23, 17, 15, 14, 13, 3, 6, 7, 5, 10, 1, 9, 2, 8, 12, 26, 6, 3});
        Resources.loadGFonts(new int[]{4, 3, 0, 1});
        this.calculatePositions();
        Resources.loadText(0);
        Resources.loadGFonts(new int[]{4, 3, 0, 1});
        preparedInstructionsText = new PreparedText(Resources.resGFonts[4]);
        preparedText1 = new PreparedText(Resources.resGFonts[4]);
        preparedText2 = new PreparedText(Resources.resGFonts[4]);
        Resources.loadGFont(0);
        play = new PreparedText(Resources.resGFonts[3]);
        String controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(17) + "\n                                                             \n                                         \n                 \n  ";
        preparedInstructionsText.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.mainCanvas.getWidth() - 28);
        preparedInstructionsText.setLineHeightCorrection(-2);
        if (!this.bonusPack) {
            Level.getLevel(this.actualLevel);
        } else {
            Level.getBonusLevel(this.actualLevel);
        }
        int lvl = 0;
        lvl = this.gameMode == Level.TYPE_BLOCKER || this.gameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level.level2 : 1;
        RMSObjects.game.restartGame(this.gameMode, lvl, Level.level, Level.colors);
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        RMSObjects.createRMSConnect(rmsConnectId);
        DSP_X = 5;
        if (MainCanvas.WIDTH == 128) {
            DSP_X = 5;
        }
        X1 = this.rectItems[0].width;
        X2 = 2 * MainCanvas.WIDTH / 3;
        if (!this.bonusPack) {
            RMSObjects.createRMSConnect(0);
            RMSObjects.rmsConnects[0].load();
        } else {
            RMSObjects.createRMSConnect(9);
            RMSObjects.rmsConnects[9].load();
        }
    }

    private void addScoreToTable() {
        if (!this.bonusPack) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level.highScore ? 3 : (RMSObjects.game.getScore() >= Level.midleScore ? 2 : 1);
            RMSObjects.localScores.userName = Integer.toString(this.actualLevel);
            RMSObjects.localScores.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[0].isExist()) {
                RMSObjects.rmsConnects[0].create();
            }
            RMSObjects.rmsConnects[0].save();
        } else {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level.highScore ? 3 : (RMSObjects.game.getScore() >= Level.midleScore ? 2 : 1);
            RMSObjects.localScoresBonus.userName = Integer.toString(this.actualLevel);
            RMSObjects.localScoresBonus.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[9].isExist()) {
                RMSObjects.rmsConnects[9].create();
            }
            RMSObjects.rmsConnects[9].save();
        }
    }

    private int getRMSConnectIdByGameType(int gameType) {
        switch (0) {
            case 20: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public void afterHide() {
        Resources.freeImages(new int[]{23, 24, 25, 24, 22, 21, 12, 13, 15, 17, 12, 13});
        Resources.freeSprites(new int[]{25, 21, 18, 23, 16, 17, 16, 15, 14, 13, 26, 1, 12, 2, 10, 5, 6, 7, 8, 9, 3});
        Resources.freeSprites(new int[]{19, 12});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
        RMSObjects.freeRMSConnect(this.getRMSConnectIdByGameType(this.gameMode));
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        Jewel.BLOCKSIZE = Resources.resSprs[6].getWidth();
        this.rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        this.ret = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        this.ret.y += Resources.resGFonts[3].getHeight() * 2;
        this.ret.height -= Resources.resGFonts[3].getHeight() * 2;
        Jewel.MOVE_VELOCITY = (this.rectGameArea.width << 8) / 48;
        Jewel.DSP_BNSBOMB = Resources.resSprs[3].getWidth() - Jewel.BLOCKSIZE >> 1;
        Jewel.DSP_BNSCROSS = Resources.resSprs[8].getWidth() - Jewel.BLOCKSIZE >> 1;
        int fkWidth = Resources.resSprs[26].getWidth();
        int fkHeight = Resources.resSprs[26].getHeight();
        int itemWidth = Resources.resSprs[15].getWidth();
        int itemHeight = Resources.resSprs[15].getHeight();
        this.rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - itemHeight, itemWidth + (itemWidth >> 1), itemHeight);
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - itemWidth - (itemWidth >> 1), MainCanvas.HEIGHT - itemHeight, itemWidth + (itemWidth >> 1), itemHeight);
        this.rectDialog = MainCanvas.HEIGHT < 320 ? new Rectangle(fkWidth, 0, MainCanvas.WIDTH - (fkWidth << 1), this.mainCanvas.getHeight()) : new Rectangle(fkWidth, 0, MainCanvas.WIDTH - (fkWidth << 1), this.mainCanvas.getHeight());
        this.rectText = new Rectangle(this.rectDialog.x, this.rectDialog.y + this.rectDialog.height / 2, this.rectDialog.width, this.rectDialog.height / 2);
        Sprite sprItems2 = Resources.resSprs[15];
        int y = (MainCanvas.HEIGHT >> 1) - (Resources.resSprs[15].getHeight() << 1) - (Resources.resSprs[15].getHeight() >> 1);
        int x = (MainCanvas.WIDTH >> 1) - (sprItems2.getWidth() >> 1);
        int dialogCenterX = this.rectDialog.getCenterX();
        this.rectItems[2] = new Rectangle(0, 0, 0, 0);
        this.rectItems[3] = new Rectangle(0, y, this.mainCanvas.getWidth(), sprItems2.getHeight());
        this.rectItems[4] = new Rectangle(0, y += sprItems2.getHeight(), this.mainCanvas.getWidth(), sprItems2.getHeight());
        this.rectItems[6] = new Rectangle(0, y += sprItems2.getHeight(), this.mainCanvas.getWidth(), sprItems2.getHeight());
        this.rectItems[5] = new Rectangle(0, y += sprItems2.getHeight(), this.mainCanvas.getWidth() - sprItems2.getWidth(), sprItems2.getHeight());
        PROGRESWIDTH = MainCanvas.WIDTH * 194 / 240;
        if (MainCanvas.WIDTH == 128) {
            PROGRESWIDTH = 108;
        } else if (MainCanvas.WIDTH == 176) {
            PROGRESWIDTH = 140;
        } else if (MainCanvas.WIDTH == 208) {
            PROGRESWIDTH = 160;
        } else if (MainCanvas.WIDTH == 220) {
            PROGRESWIDTH = 126;
        } else if (MainCanvas.WIDTH == 240) {
            PROGRESWIDTH = 194;
        } else if (MainCanvas.WIDTH == 320) {
            PROGRESWIDTH = MainCanvas.HEIGHT == 480 ? 256 : 178;
        } else if (MainCanvas.WIDTH == 352) {
            PROGRESWIDTH = 282;
        } else if (MainCanvas.WIDTH == 360) {
            PROGRESWIDTH = 288;
        } else if (MainCanvas.WIDTH == 480) {
            PROGRESWIDTH = MainCanvas.HEIGHT >= 640 ? 390 : 194;
        } else if (MainCanvas.WIDTH == 540) {
            PROGRESWIDTH = 438;
        }
        PROGRESH = 50;
        int aWidth = Resources.resSprs[19].getWidth();
        int aHeight = Resources.resSprs[19].getHeight();
        this.rectTextDialog = this.rectGameArea;
        this.rectTextInstrructions = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) + aHeight * 2, Jewel.BLOCKSIZE << 3, (Jewel.BLOCKSIZE << 3) - aHeight * 4);
        this.rectItems[7] = new Rectangle(dialogCenterX - (aWidth >> 1), this.rectTextInstrructions.y - (aHeight << 1), aWidth, aHeight << 1);
        this.rectItems[8] = new Rectangle(dialogCenterX - (aWidth >> 1), this.rectTextInstrructions.getBottom(), aWidth, aHeight << 1);
        this.bodyAnimation = this.rectGameArea.y + this.rectGameArea.height;
    }

    public void update(long lastRunLenght) {
        if (this.status == 0) {
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isLevelDone()) {
                this.status = 2;
            } else if (RMSObjects.game.isGameOver()) {
                this.status = 2;
                this.icount = -1;
                if (this.getTopScore() < RMSObjects.game.getScore()) {
                    this.icount = 0;
                }
            }
            this.mainCanvas.repaint();
        }
        if (this.status == 2) {
            this.updateWindow();
            if (this.icount >= 0) {
                ++this.icount;
                this.icount %= 10;
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    private void updateWindow() {
        while (this.bodyAnimation != this.rectTextDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mainCanvas.repaint();
        }
    }

    private void updateAnimation() {
        int framesCount = 0;
        framesCount = this.SELECTEDSEQUENCE.length - 1;
        if (this.resourceFrame < framesCount) {
            ++this.resourceFrame;
        } else {
            if (this.repeats > 0) {
                --this.repeats;
            }
            this.resourceFrame = 0;
        }
        this.mainCanvas.repaint();
    }

    private void reset() {
        try {
            this.score = 0;
            this.stars = "";
        }
        catch (Exception r) {
            System.out.println("Exception in: RESET()");
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[4].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = preparedInstructionsText.getTextHeight() - this.rectTextInstrructions.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[4].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void paint(Graphics g) {
        g.setColor(269619);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g);
                this.paintPanelTop(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
                break;
            }
            case 1: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintMenuDialogItems(g);
                this.paintFK(g);
                break;
            }
            case 2: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintPanelBottom(g);
                this.paintResultText(g);
                this.paintFK(g);
                break;
            }
            case 3: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintPanelBottom(g);
                this.paintInstructions(g);
                this.paintFK(g);
                break;
            }
            case 4: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintTutorial(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
                break;
            }
            case 5: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintStartText(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
                break;
            }
            case 6: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintRestartText(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
                break;
            }
            case 7: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintLastMessage(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
                break;
            }
            case 8: {
                g.drawImage(Resources.resImgs[22], 0, 0, 20);
                this.paintTextDialog(g);
                this.paintRealyQuit(g);
                this.paintPanelBottom(g);
                this.paintFK(g);
            }
        }
    }

    private void paintRealyQuit(Graphics g) {
        PreparedText startInfo = new PreparedText(Resources.resGFonts[4]);
        String info = Resources.resTexts[0].getHashedString(77);
        startInfo.prepareText(info, this.rectGameArea.width);
        startInfo.setLineHeightCorrection(-2);
        startInfo.drawText(g, this.rectGameArea, startInfo.getTextHeight() >> 1, 3);
    }

    private void paintLastMessage(Graphics g) {
        PreparedText startInfo = new PreparedText(Resources.resGFonts[4]);
        String info = "";
        info = !this.bonusPack ? (MainCanvas.totalStars == 180 ? Resources.resTexts[0].getHashedString(73) + " " + Resources.resTexts[0].getHashedString(74) : Resources.resTexts[0].getHashedString(72)) : (MainCanvas.totalBonusStars == 60 ? Resources.resTexts[0].getHashedString(76) : Resources.resTexts[0].getHashedString(75));
        startInfo.prepareText(info, this.rectGameArea.width);
        startInfo.setLineHeightCorrection(-2);
        startInfo.drawText(g, this.rectGameArea, 0, 3);
    }

    private void paintRestartText(Graphics g) {
        PreparedText startInfo = new PreparedText(Resources.resGFonts[4]);
        String info = Resources.resTexts[0].getHashedString(78);
        startInfo.prepareText(info, this.rectGameArea.width);
        startInfo.setLineHeightCorrection(-2);
        startInfo.drawText(g, this.rectGameArea, 0, 3);
    }

    private void paintStartText(Graphics g) {
        String info = "";
        PreparedText startInfo = new PreparedText(Resources.resGFonts[4]);
        switch (this.gameMode) {
            case 0: {
                info = Resources.resTexts[0].getHashedString(43) + " " + Level.moves + " " + Resources.resTexts[0].getHashedString(44) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 1: {
                info = Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level.time + " " + Resources.resTexts[0].getHashedString(46);
                break;
            }
            case 2: {
                info = Resources.resTexts[0].getHashedString(39) + " " + Level.escapedJewels + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(43) + " " + Level.moves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 3: {
                info = Resources.resTexts[0].getHashedString(41) + " " + Level.diamondsCount + " " + Resources.resTexts[0].getHashedString(42) + " " + Resources.resTexts[0].getHashedString(47) + " " + Level.moves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 4: {
                info = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level.time + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 5: {
                info = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 6: {
                info = Resources.resTexts[0].getHashedString(39) + " " + Level.escapedJewels + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level.time + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 7: {
                info = Resources.resTexts[0].getHashedString(43) + " " + Level.moves + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level.time + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level.minScore + " " + Resources.resTexts[0].getHashedString(37);
            }
        }
        startInfo.prepareText(info, this.rectGameArea.width);
        startInfo.setLineHeightCorrection(-2);
        startInfo.drawText(g, this.rectGameArea, 0, 3);
    }

    private void paintTutorial(Graphics g) {
        String info = "";
        PreparedText startInfo = new PreparedText(Resources.resGFonts[4]);
        if (MainCanvas.controlsTut == 0 && this.level == 1) {
            info = Resources.resTexts[0].getHashedString(30);
        } else {
            switch (this.gameMode) {
                case 0: {
                    info = Resources.resTexts[0].getHashedString(31);
                    break;
                }
                case 1: {
                    info = Resources.resTexts[0].getHashedString(35);
                    break;
                }
                case 2: {
                    info = Resources.resTexts[0].getHashedString(33);
                    break;
                }
                case 3: {
                    info = Resources.resTexts[0].getHashedString(34);
                    break;
                }
                case 5: {
                    info = Resources.resTexts[0].getHashedString(32);
                }
            }
        }
        startInfo.prepareText(info, this.rectGameArea.width - 10);
        startInfo.setLineHeightCorrection(-2);
        startInfo.drawText(g, this.ret, 0, 17);
    }

    private void paintInstructions(Graphics g) {
        if (preparedInstructionsText.getTextHeight() >= this.rectTextInstrructions.height) {
            Sprite sprArrwUpDown = Resources.resSprs[19];
            if (this.scrollUP) {
                sprArrwUpDown.setFrame(0);
                sprArrwUpDown.setTransform(1);
                sprArrwUpDown.setPosition(this.rectItems[7].x, this.rectGameArea.y + sprArrwUpDown.getHeight());
                sprArrwUpDown.paint(g);
            }
            if (this.scrollDOWN) {
                sprArrwUpDown.setFrame(0);
                sprArrwUpDown.setTransform(0);
                sprArrwUpDown.setPosition(this.rectItems[8].x, this.rectGameArea.getBottom() - sprArrwUpDown.getHeight());
                sprArrwUpDown.paint(g);
            }
        }
        preparedInstructionsText.drawText(g, this.rectTextInstrructions, this.textOffsetY, 20);
    }

    private void paintBgGame(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(269619);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(Resources.resImgs[22], 0, 0, 20);
    }

    private void paintPanelTop(Graphics g) {
        Image _progresLight = Resources.resImgs[25];
        Image _progresDark = Resources.resImgs[24];
        Sprite border = Resources.resSprs[14];
        Sprite levelIcon = Resources.resSprs[21];
        border.setPosition(0, this.rectGameArea.y - border.getHeight());
        border.setTransform(2);
        border.setFrame(0);
        border.paint(g);
        Sprite botom = Resources.resSprs[23];
        botom.setFrame(0);
        botom.setPosition(5, 0 + _progresLight.getHeight() / 8);
        botom.paint(g);
        botom.setFrame(1);
        for (int i = 5 + botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            botom.setPosition(i, 0 + _progresLight.getHeight() / 8);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(MainCanvas.WIDTH - 5 - botom.getWidth(), 0 + _progresLight.getHeight() / 8);
        botom.paint(g);
        GFont gameFont = Resources.resGFonts[1];
        Rectangle leftRectText = new Rectangle(5, 0 + _progresLight.getHeight() / 8, botom.getWidth(), botom.getHeight());
        String leftText = " ";
        if (this.gameMode != 1 && this.gameMode != 7 && this.gameMode != 4 && this.gameMode != 6) {
            leftText = leftText + "m:" + Integer.toString(Level.moves - MainCanvas.moveCounter);
        } else if (this.gameMode == 7) {
            leftText = " m:" + Integer.toString(MainCanvas.moveCounter);
        } else if ((this.gameMode == 1 || this.gameMode == 4 || this.gameMode == 6) && Level.time - (long)RMSObjects.game.getTimeInSec() < 10L) {
            leftText = " " + Integer.toString((int)Level.time - RMSObjects.game.getTimeInSec());
        }
        if (this.gameMode == 3) {
            leftText = Level.diamondsCount - Game.progressSecondary >= 0 ? leftText + "d" + (Level.diamondsCount - Game.progressSecondary) : leftText + "d0";
        }
        if (this.gameMode == 2) {
            leftText = Level.escapedJewels - Game.progressSecondary >= 0 ? leftText + "d" + (Level.escapedJewels - Game.progressSecondary) : leftText + "d0";
        }
        if (this.gameMode == 6) {
            if (Level.escapedJewels - Game.progressSecondary >= 0) {
                leftText = leftText + "d" + (Level.escapedJewels - Game.progressSecondary);
                if (Level.time - (long)RMSObjects.game.getTimeInSec() < 10L) {
                    leftText = leftText + " " + Integer.toString((int)Level.time - RMSObjects.game.getTimeInSec());
                }
            } else {
                leftText = leftText + "d0";
                if (Level.time - (long)RMSObjects.game.getTimeInSec() < 10L) {
                    leftText = leftText + " " + Integer.toString((int)Level.time - RMSObjects.game.getTimeInSec());
                }
            }
        }
        gameFont.drawString(g, leftText.toCharArray(), leftRectText.x + gameFont.getSpaceWidth(), (leftRectText.y + leftRectText.height) / 2 + gameFont.getHeight() / 4, 6);
        PROGRESH = _progresLight.getHeight();
        g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
        try {
            Rectangle rightRectText = new Rectangle(this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1) + _progresLight.getWidth(), 0 + _progresLight.getHeight() / 8, this.mainCanvas.getWidth(), botom.getHeight());
            String rightText = "*:" + Integer.toString(RMSObjects.game.getScore());
            gameFont.drawString(g, rightText.toCharArray(), rightRectText.x, (rightRectText.y + rightRectText.height) / 2 + gameFont.getHeight() / 4, 6);
            if (this.gameMode != Level.TYPE_ESCAPE) {
                g.setClip(this.rectGameArea.getCenterX() - (PROGRESH >> 1), 256 - PROGRESH * RMSObjects.game.getProgresRate() >> 8, _progresLight.getWidth(), _progresLight.getHeight() - border.getHeight());
                g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(_progresDark, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(this.rectGameArea.getCenterX() - (PROGRESH >> 1), 256 - PROGRESH * RMSObjects.game.getProgresRate() >> 8, _progresLight.getWidth(), _progresLight.getHeight() - border.getHeight());
                g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            } else if (this.gameMode != Level.TYPE_MIXED_TIME_AND_ESCAPE) {
                g.setClip(this.rectGameArea.getCenterX() - (PROGRESH >> 1), 256 - PROGRESH * (int)(Level.time * 1000L - (long)RMSObjects.game.getTimeInSec()) >> 8, _progresLight.getWidth(), _progresLight.getHeight() - border.getHeight());
                g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(_progresDark, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(this.rectGameArea.getCenterX() - (PROGRESH >> 1), 256 - PROGRESH * (int)(Level.time * 1000L - (long)RMSObjects.game.getTimeInSec()) >> 8, _progresLight.getWidth(), _progresLight.getHeight() - border.getHeight());
                g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.gameMode == Level.TYPE_MOVES) {
            g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
        }
        if (this.gameMode == Level.TYPE_BLOCKER) {
            g.drawImage(_progresLight, this.rectGameArea.getCenterX() - (_progresLight.getWidth() >> 1), 0, 20);
        }
        switch (this.gameMode) {
            case 0: {
                levelIcon.setFrame(0);
                break;
            }
            case 1: {
                levelIcon.setFrame(1);
                break;
            }
            case 2: {
                levelIcon.setFrame(3);
                break;
            }
            case 3: {
                levelIcon.setFrame(2);
                break;
            }
            case 4: {
                levelIcon.setFrame(4);
                break;
            }
            case 5: {
                levelIcon.setFrame(4);
                break;
            }
            case 6: {
                levelIcon.setFrame(3);
                break;
            }
            case 7: {
                levelIcon.setFrame(0);
                break;
            }
            case 8: {
                levelIcon.setFrame(4);
            }
        }
        levelIcon.setPosition(this.rectGameArea.getCenterX() - levelIcon.getWidth() / 2, _progresLight.getHeight() / 2 - levelIcon.getHeight() / 2);
        levelIcon.paint(g);
    }

    private void paintPanelBottom(Graphics g) {
        Sprite ornament = Resources.resSprs[18];
        Sprite border = Resources.resSprs[14];
        border.setPosition(0, this.rectGameArea.getBottom());
        border.setFrame(0);
        border.paint(g);
    }

    private void paintFK(Graphics g) {
        Sprite sprFK = Resources.resSprs[26];
        Sprite funKey = Resources.resSprs[23];
        if (this.status == 0) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(1);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(0);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(3);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
            sprFK.setFrame(4);
            sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 2) {
            if (RMSObjects.game.isGameOver()) {
                funKey.setFrame(1);
                funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                funKey.setFrame(2);
                funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                funKey.setFrame(1);
                funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                funKey.setFrame(0);
                funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                sprFK.setFrame(0);
                sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
                sprFK.paint(g);
                sprFK.setFrame(5);
                sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
                sprFK.paint(g);
            } else if (RMSObjects.game.isLevelDone()) {
                funKey.setFrame(1);
                funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                funKey.setFrame(2);
                funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
                funKey.paint(g);
                sprFK.setFrame(1);
                sprFK.setPosition(this.rectItems[0].x, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
                sprFK.paint(g);
            }
        } else if (this.status == 3) {
            funKey.setFrame(1);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(0);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(9);
            sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 1) {
            funKey.setFrame(1);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(0);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(9);
            sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 4) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(1);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 5) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(1);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 7) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(1);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 6) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(1);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(0);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(1);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
            sprFK.setFrame(2);
            sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        } else if (this.status == 8) {
            funKey.setFrame(1);
            funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(2);
            funKey.setPosition(0 + funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(1);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            funKey.setFrame(0);
            funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
            funKey.paint(g);
            sprFK.setFrame(1);
            sprFK.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
            sprFK.setFrame(2);
            sprFK.setPosition(MainCanvas.WIDTH - sprFK.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - sprFK.getHeight() / 2);
            sprFK.paint(g);
        }
    }

    private void paintTextDialog(Graphics g) {
        g.setColor(269619);
        g.fillRect(this.rectTextDialog.x, this.rectTextDialog.y, this.rectTextDialog.width, this.rectTextDialog.height);
        g.setColor(269619);
        g.fillRect(0, this.rectGameArea.y, MainCanvas.WIDTH, this.rectGameArea.height);
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.rectTextDialog.y, 20);
    }

    private void paintResultText(Graphics g) {
        if (RMSObjects.game.isLevelDone()) {
            this.paintWin(g);
        } else if (RMSObjects.game.isGameOver()) {
            this.paintLose(g);
        }
    }

    private void paintWin(Graphics g) {
        GFont gameFont = Resources.resGFonts[7];
        GFont gameFont2 = Resources.resGFonts[4];
        Image stars = Resources.resImgs[21];
        String star = " ";
        int y = this.rectTextDialog.y + gameFont.getHeight();
        int score = RMSObjects.game.getScore();
        if (score >= Level.highScore) {
            star = "***";
            g.drawImage(stars, MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
            g.drawImage(stars, (MainCanvas.WIDTH >> 1) - stars.getWidth(), y + gameFont2.getHeight() * 2, 17);
            g.drawImage(stars, (MainCanvas.WIDTH >> 1) + stars.getWidth(), y + gameFont2.getHeight() * 2, 17);
        } else if (score >= Level.midleScore) {
            star = "**";
            g.drawImage(stars, MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 20);
            g.drawImage(stars, MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 24);
        } else if (score >= Level.minScore) {
            star = "*";
            g.drawImage(stars, MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
        }
        gameFont2.drawString(g, Resources.resTexts[0].getHashedString(56).toCharArray(), MainCanvas.WIDTH >> 1, y, 17);
        gameFont2.drawString(g, (Resources.resTexts[0].getHashedString(10) + " : " + (score - RMSObjects.game.getBombScore() - RMSObjects.game.getEscScore() - RMSObjects.game.getDownScore())).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - gameFont2.getHeight(), 17);
        gameFont2.drawString(g, (Resources.resTexts[0].getHashedString(57) + " : " + RMSObjects.game.getBombScore()).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (gameFont2.getHeight() >> 1), 17);
        if (this.gameMode == 2) {
            gameFont2.drawString(g, (Resources.resTexts[0].getHashedString(59) + " : " + RMSObjects.game.getEscScore()).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + gameFont2.getHeight() * 2, 17);
        } else if (this.gameMode == 3) {
            gameFont2.drawString(g, (Resources.resTexts[0].getHashedString(58) + " : " + RMSObjects.game.getDownScore()).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + gameFont2.getHeight() * 2, 17);
        }
        gameFont2.drawString(g, ("TOTAL : " + score).toCharArray(), MainCanvas.WIDTH >> 1, this.rectTextDialog.getBottom() - gameFont2.getHeight() * 2, 17);
    }

    private void paintLose(Graphics g) {
        GFont gameFont = Resources.resGFonts[7];
        GFont gameFont2 = Resources.resGFonts[3];
        String star = " ";
        int y = this.rectTextDialog.y + gameFont.getHeight();
        int score = RMSObjects.game.getScore();
        if (score >= Level.highScore) {
            star = "***";
        } else if (score >= Level.midleScore) {
            star = "**";
        } else if (score >= Level.minScore) {
            star = "*";
        }
        gameFont2.drawString(g, Resources.resTexts[0].getHashedString(60).toCharArray(), MainCanvas.WIDTH >> 1, y, 17);
        gameFont2.drawString(g, Resources.resTexts[0].getHashedString(52).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - gameFont2.getHeight(), 17);
        switch (RMSObjects.game.getLoseMode()) {
            case 1: {
                gameFont2.drawString(g, Resources.resTexts[0].getHashedString(63).toCharArray(), MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
                break;
            }
            case 3: {
                gameFont2.drawString(g, Resources.resTexts[0].getHashedString(64).toCharArray(), MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
                break;
            }
            case 4: {
                gameFont2.drawString(g, Resources.resTexts[0].getHashedString(62).toCharArray(), MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
                break;
            }
            case 2: {
                gameFont2.drawString(g, Resources.resTexts[0].getHashedString(61).toCharArray(), MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
                break;
            }
            default: {
                gameFont2.drawString(g, Resources.resTexts[0].getHashedString(61).toCharArray(), MainCanvas.WIDTH >> 1, y + gameFont2.getHeight() * 2, 17);
            }
        }
        gameFont2.drawString(g, ("TOTAL : " + score).toCharArray(), MainCanvas.WIDTH >> 1, this.rectTextDialog.getBottom() - gameFont2.getHeight(), 17);
    }

    private int getTopScore() {
        if (!this.bonusPack) {
            Vector scores = RMSObjects.localScores.getScoresForGame(0);
            int scoresCount = 0;
            if (scores != null) {
                scoresCount = scores.size();
            }
            PowV2ScoreItem scoreItem = null;
            if (scoresCount > 0) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(0);
                return scoreItem.scoreValue;
            }
            return 0;
        }
        Vector scores = RMSObjects.localScoresBonus.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    private void paintMenuDialogItems(Graphics g) {
        int i;
        Sprite sprBtns1 = Resources.resSprs[15];
        Sprite botom = Resources.resSprs[16];
        Sprite icons = Resources.resSprs[17];
        Image light = Resources.resImgs[17];
        Image _bgIcon = Resources.resImgs[23];
        Image _bgIconSelect = Resources.resImgs[24];
        play.prepareText(Resources.resTexts[0].getHashedString(24), this.rectDialog.width);
        boolean animFrame = false;
        animFrame = true;
        int posY = sprBtns1.getHeight() / 2 - botom.getHeight() / 2;
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[3].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[3].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[3].y + posY);
        botom.paint(g);
        if (this.selectedCompId == 3) {
            g.drawImage(_bgIconSelect, 5, this.rectItems[3].y, 20);
        } else {
            g.drawImage(_bgIcon, 5, this.rectItems[3].y, 20);
        }
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[4].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[4].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[4].y + posY);
        botom.paint(g);
        if (this.selectedCompId == 4) {
            g.drawImage(_bgIconSelect, 5, this.rectItems[4].y, 20);
        } else {
            g.drawImage(_bgIcon, 5, this.rectItems[4].y, 20);
        }
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[6].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[6].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[6].y + posY);
        botom.paint(g);
        if (this.selectedCompId == 6) {
            g.drawImage(_bgIconSelect, 5, this.rectItems[6].y, 20);
        } else {
            g.drawImage(_bgIcon, 5, this.rectItems[6].y, 20);
        }
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[5].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[5].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[5].y + posY);
        botom.paint(g);
        if (this.selectedCompId == 5) {
            g.drawImage(_bgIconSelect, 5, this.rectItems[5].y, 20);
        } else {
            g.drawImage(_bgIcon, 5, this.rectItems[5].y, 20);
        }
        Rectangle r = new Rectangle(5 + botom.getWidth() / 2 + sprBtns1.getWidth(), this.rectItems[2].y + posY, this.mainCanvas.getWidth(), botom.getHeight());
        Rectangle l = new Rectangle(5 + botom.getWidth() / 2 + sprBtns1.getWidth(), this.rectItems[3].y + posY, this.mainCanvas.getWidth(), botom.getHeight());
        sprBtns1.setFrame(0);
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[3].y);
        play.prepareText(Resources.resTexts[0].getHashedString(25), this.rectDialog.width);
        l.y = this.rectItems[3].y + botom.getHeight() / 4;
        play.drawText(g, l, 0, 6);
        icons.setFrame(5);
        icons.setPosition(5 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[3].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
        icons.paint(g);
        sprBtns1.setFrame(0);
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[4].y);
        play.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectDialog.width);
        l.y = this.rectItems[4].y + botom.getHeight() / 4;
        play.drawText(g, l, 0, 6);
        icons.setFrame(MainCanvas.soundManager.IsSoundOn() ? 3 : 4);
        icons.setPosition(5 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[4].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
        icons.paint(g);
        sprBtns1.setFrame(0);
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[6].y);
        play.prepareText(Resources.resTexts[0].getHashedString(22), this.rectDialog.width);
        r.y = this.rectItems[6].y + botom.getHeight() / 4;
        play.drawText(g, r, 0, 6);
        icons.setFrame(1);
        icons.setPosition(5 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[6].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
        icons.paint(g);
        sprBtns1.setFrame(0);
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[5].y);
        play.prepareText(Resources.resTexts[0].getHashedString(19), this.rectDialog.width);
        l.y = this.rectItems[5].y + botom.getHeight() / 4;
        play.drawText(g, l, 0, 6);
        icons.setFrame(6);
        icons.setPosition(5 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[5].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
        icons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 5: {
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.status = 0;
                break;
            }
            case 8: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.status = 1;
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
                this.reset();
                break;
            }
            case 4: {
                if (!Keys.isFKLeftCode(keyCode)) break;
                if (MainCanvas.controlsTut == 0) {
                    this.status = 4;
                    ++MainCanvas.controlsTut;
                    break;
                }
                if (MainCanvas.controlsTut != 1) break;
                this.status = 5;
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.showHint();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.moveDown();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.DragOrDrop();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                if (this.selectedCompId != 3 && this.selectedCompId != 6 && this.selectedCompId != 5) break;
                this.checkButton2 = this.selectedCompId;
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.status = 1;
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                this.reset();
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    if (!this.bonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    MainCanvas.moveCounter = 0;
                    if (this.gameMode == 4 || this.gameMode == 5) {
                        RMSObjects.game.restartGame(RMSObjects.game.getMode(), Level.level2, Level.level, Level.colors);
                    } else {
                        RMSObjects.game.restartGame(RMSObjects.game.getMode(), 1, Level.level, Level.colors);
                    }
                    this.status = 0;
                    this.reset();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.status = 1;
                this.reset();
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        if (!RMSObjects.rmsConnects[rmsConnectId].isExist()) {
            RMSObjects.rmsConnects[rmsConnectId].create();
        }
        RMSObjects.rmsConnects[rmsConnectId].save();
        this.status = 1;
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 6;
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 3;
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 8;
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.status = 0;
            this.reset();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void keyReleasedResult(int keyCode) {
        block32: {
            block33: {
                block31: {
                    if (!RMSObjects.game.isGameOver()) break block31;
                    if (Keys.isFKRightCode(keyCode)) {
                        this.reset();
                        this.stars = "";
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                        if (MainCanvas.soundManager.IsSoundOn()) {
                            MainCanvas.soundManager.Stop();
                            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        }
                    } else if (Keys.isFKLeftCode(keyCode)) {
                        this.stars = "";
                        this.reset();
                        if (!this.bonusPack) {
                            Level.getLevel(this.actualLevel);
                        } else {
                            Level.getBonusLevel(this.actualLevel);
                        }
                        MainCanvas.moveCounter = 0;
                        if (this.gameMode == 4 || this.gameMode == 5) {
                            this.status = 5;
                            RMSObjects.game.restartGame(RMSObjects.game.getMode(), Level.level2, Level.level, Level.colors);
                        } else {
                            this.status = 5;
                            if (!this.bonusPack) {
                                Level.getLevel(this.actualLevel);
                            } else {
                                Level.getBonusLevel(this.actualLevel);
                            }
                            RMSObjects.game.restartGame(RMSObjects.game.getMode(), 1, Level.level, Level.colors);
                        }
                        MainCanvas.soundManager.Stop();
                        if (MainCanvas.soundManager.IsSoundOn()) {
                            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                        }
                    }
                    break block32;
                }
                if (!RMSObjects.game.isLevelDone()) break block32;
                if (!Keys.isFKLeftCode(keyCode)) break block33;
                this.status = 5;
                this.stars = "";
                this.reset();
                this.addScoreToTable();
                if (!this.bonusPack) {
                    if (MainCanvas.slcLvl < 59) {
                        if (MainCanvas.counterX < 3) {
                            ++MainCanvas.counterX;
                            ++MainCanvas.slcLvl;
                        } else {
                            if (MainCanvas.slcLvl == 19) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else if (MainCanvas.slcLvl == 39) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else {
                                ++MainCanvas.counterY;
                            }
                            MainCanvas.counterX = 0;
                            ++MainCanvas.slcLvl;
                        }
                    }
                } else if (MainCanvas.slcLvl < 19) {
                    if (MainCanvas.counterX < 3) {
                        ++MainCanvas.counterX;
                        ++MainCanvas.slcLvl;
                    } else {
                        MainCanvas.counterX = 0;
                        ++MainCanvas.counterY;
                        ++MainCanvas.slcLvl;
                    }
                }
                if (this.actualLevel != 19) ** GOTO lbl-1000
                if (MainCanvas.slcPack == 0) {
                    ++MainCanvas.slcPack;
                    MainCanvas.counterY = 0;
                } else if (this.actualLevel == 39) {
                    if (MainCanvas.slcPack == 1) {
                        ++MainCanvas.slcPack;
                        MainCanvas.counterY = 0;
                    }
                }
                if (!this.bonusPack) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
                } else {
                    this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
                }
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
                break block32;
            }
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.score = RMSObjects.game.getScore();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
            this.checkButton = this.selectedCompId;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            Game.bhint = false;
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
                this.checkButton2 = this.selectedCompId;
            }
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this.status == 3) {
                        this.status = 1;
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    if (this.selectedCompId == 4) {
                        this.selectedCompId = this.checkButton2;
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 8) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3 ? i == 1 : (status == 5 ? i == 0 : status == 4 && i == 0)) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        if (this.status == 3) {
            if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT - Resources.resSprs[26].getHeight()) {
                if (x >= this.rectDialog.x && x <= this.rectDialog.x + this.rectDialog.width) {
                    this.dragDown();
                }
            } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[26].getHeight() && x >= this.rectDialog.x && x <= this.rectDialog.x + this.rectDialog.width) {
                this.dragUp();
            }
        }
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    if (this.status == 3) {
                        this.status = 1;
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this.status != 1) break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                if (this.selectedCompId != 6 && (this.selectedCompId == 3 || this.selectedCompId == 5)) {
                    if (this.checkButton2 == 6 || this.checkButton2 == 3 || this.checkButton2 == 5) {
                        this.selectedCompId = this.checkButton2;
                        break;
                    }
                    this.selectedCompId = 3;
                    break;
                }
                this.selectedCompId = this.checkButton;
                break;
            }
            case 1: {
                if (this.status == 3) {
                    this.status = 1;
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                if (this.status == 0) {
                    this.selectedCompId = 2;
                }
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
            }
        }
        if (this.selectedCompId == 4) {
            this.selectedCompId = 3;
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[3].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = preparedInstructionsText.getTextHeight() - this.rectGameArea.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[3].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }
}

