/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.screen.ScreenSelectPack;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectLevel
implements IScreen {
    MainCanvas mainCanvas;
    int mode;
    long modeDelay;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int COMP_ID_ALLLEVELS = 3;
    private static final int TOTAL_COMP_IDS = 4;
    Rectangle[] rectItems = new Rectangle[4];
    Rectangle[] rectLevel = new Rectangle[20];
    Rectangle rectDialog;
    Rectangle rectSelector;
    private int selectedCompId;
    private int gameMode;
    private PreparedText preparedText;
    private PreparedText levelNum;
    private PreparedText levelStar;
    private Rectangle rectTop;
    private Rectangle rectDown;
    private Rectangle rectBody;
    private int dy = 0;
    private int selectorDx = 0;
    private int selectorDy = 0;
    private int counterX = 0;
    private int counterY = 0;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int repeat = 0;
    private int selectedPack = 0;
    private int selectdLevel = 0;
    private int levelNumber = 0;
    private String[] levelStars = new String[60];
    private String[] levelnames = new String[60];
    private int x = 0;
    private int y = 0;
    private int scoresCount = 0;
    private int count = 0;
    private int interuption = 0;
    public boolean animatedMenu = false;
    int cycle = 10;
    Rectangle selectedLevel;
    Rectangle rectStar;
    int check = 0;

    public ScreenSelectLevel(MainCanvas mainCanvas, int selectedLevel) {
        this.mainCanvas = mainCanvas;
        this.counterX = MainCanvas.counterX;
        this.counterY = MainCanvas.counterY;
        this.selectedPack = MainCanvas.slcPack;
        this.selectdLevel = MainCanvas.slcLvl;
        System.out.println("counterX: " + this.counterX + " counterY: " + this.counterY + " selectedPack: " + this.selectedPack + " selectdLevel: " + this.selectdLevel);
    }

    public void beforeShow() {
        MainCanvas.totalStars = 0;
        Resources.loadImages(new int[]{22, 20, 18, 19, 24});
        System.out.println("haha");
        Resources.loadSprites(new int[]{15, 19, 16, 1, 0});
        Resources.loadGFonts(new int[]{7, 6});
        Resources.loadGFont(0);
        this.preparedText = new PreparedText(Resources.resGFonts[0]);
        this.calculatePositions();
        this.levelNum = new PreparedText(Resources.resGFonts[6]);
        this.levelStar = new PreparedText(Resources.resGFonts[7]);
        for (int i = 0; i < 60; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        this.prepareLevelStars();
        this.pointerReleased(1, MainCanvas.WIDTH >> 1);
        this.pointerPressed(1, MainCanvas.WIDTH >> 1);
    }

    private void prepareLevelStars() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 60; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
    }

    public void afterHide() {
        Resources.freeImages(new int[]{22, 20, 18, 19, 24});
        Resources.freeSprites(new int[]{15, 19, 15, 16, 1, 0});
        Resources.freeGFont(0);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        int itemWidth = Resources.resSprs[16].getWidth();
        int itemHeight = Resources.resSprs[16].getHeight();
        int sprArrwUpDownWidth = Resources.resSprs[19].getWidth();
        int sprArrwUpDownHeigth = Resources.resSprs[19].getHeight();
        int marginLeft = fkWidth;
        this.rectDialog = new Rectangle(marginLeft, 0, MainCanvas.WIDTH - (marginLeft << 1), this.mainCanvas.getHeight());
        this.rectTop = new Rectangle(0, 0, this.mainCanvas.getWidth(), Resources.resSprs[16].getHeight());
        this.rectDown = new Rectangle(0, this.mainCanvas.getHeight() - Resources.resSprs[16].getHeight(), this.mainCanvas.getWidth(), Resources.resSprs[16].getHeight());
        this.rectBody = new Rectangle(Resources.resSprs[16].getWidth() / 2, this.rectTop.height, this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth() / 2, this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - Resources.resSprs[15].getWidth() - (Resources.resSprs[15].getWidth() >> 1), MainCanvas.HEIGHT - Resources.resSprs[15].getHeight(), Resources.resSprs[15].getWidth() + (Resources.resSprs[15].getWidth() >> 1), Resources.resSprs[15].getHeight());
        this.rectItems[1] = new Rectangle(this.rectTop.getCenterX() - sprArrwUpDownWidth / 2, this.rectTop.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this.rectItems[2] = new Rectangle(this.rectDown.getCenterX() - sprArrwUpDownWidth / 2, this.rectDown.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this.rectItems[3] = new Rectangle(0, this.rectTop.getCenterY() + sprArrwUpDownHeigth, this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.dy = Resources.resSprs[16].getHeight();
        this.selectorDx = Resources.resSprs[16].getWidth();
        this.selectorDy = this.dy;
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        g.setColor(0, 20, 80);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(Resources.resImgs[22], 0, 0, 20);
        this.paintTop(g);
        this.paintBody(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintTop(Graphics g) {
        Sprite sprArrwUp = Resources.resSprs[19];
        sprArrwUp.setFrame(0);
        sprArrwUp.setTransform(1);
        sprArrwUp.setPosition(this.rectTop.getCenterX() - sprArrwUp.getWidth() / 2, this.rectTop.getCenterY() - sprArrwUp.getHeight() / 2);
        if (this.selectedPack != 0) {
            sprArrwUp.paint(g);
        }
    }

    private void paintBottom(Graphics g) {
        Sprite sprArrwDown = Resources.resSprs[19];
        sprArrwDown.setFrame(0);
        sprArrwDown.setTransform(0);
        sprArrwDown.setPosition(this.rectDown.getCenterX() - sprArrwDown.getWidth() / 2, this.rectDown.getCenterY() - sprArrwDown.getHeight() / 2);
        if (this.selectedPack != 2) {
            sprArrwDown.paint(g);
        }
    }

    private void paintBody(Graphics g) {
        int picovina = 0;
        boolean _selected = false;
        Image _selector = Resources.resImgs[24];
        Sprite level = Resources.resSprs[15];
        int posunX = (this.mainCanvas.getWidth() - 2 * this.rectBody.x - 4 * level.getWidth()) / 4;
        int posunY = (this.mainCanvas.getHeight() - 2 * this.rectBody.y - 5 * level.getHeight()) / 4;
        switch (this.selectedPack) {
            case 0: {
                this.levelNumber = 0;
                break;
            }
            case 1: {
                this.levelNumber = 20;
                break;
            }
            case 2: {
                this.levelNumber = 40;
            }
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                _selected = false;
                this.levelStar.prepareText("", level.getWidth());
                level.setPosition(this.rectBody.x + x * (posunX + level.getWidth()) + (level.getWidth() >> 2), this.rectBody.y + y * (level.getHeight() + posunY) - this.levelStar.getTextHeight() / 2);
                if (picovina < 20) {
                    this.rectLevel[picovina] = new Rectangle(level.getX(), level.getY(), level.getWidth(), level.getHeight());
                    ++picovina;
                }
                if (level.getX() == x * posunX + this.rectBody.x + this.counterX * level.getWidth() + (level.getWidth() >> 2) + this.x * level.getWidth() && level.getY() == y * posunY + this.rectBody.y + this.counterY * level.getHeight() + this.y * level.getHeight() - this.levelStar.getTextHeight() / 2) {
                    _selected = true;
                } else if (this.levelNumber <= this.count) {
                    level.setFrame(0);
                } else {
                    level.setFrame(1);
                }
                if (this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight() >= this.rectBody.y + this.rectBody.height || this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight() < this.rectBody.y) continue;
                int s = 0;
                try {
                    if (this.levelStars[this.levelNumber] != null) {
                        s = Integer.parseInt(this.levelStars[this.levelNumber]);
                    }
                }
                catch (Exception r) {
                    // empty catch block
                }
                ++this.levelNumber;
                g.setColor(0, 49, 49);
                String num = this.levelNumber < 10 ? "" + this.levelNumber + "" : "" + this.levelNumber;
                this.levelNum.prepareText(num, level.getWidth());
                switch (s) {
                    case 1: {
                        this.levelStar.prepareText("*", level.getWidth());
                        break;
                    }
                    case 2: {
                        this.levelStar.prepareText("**", level.getWidth());
                        break;
                    }
                    case 3: {
                        this.levelStar.prepareText("***", level.getWidth());
                        break;
                    }
                    default: {
                        this.levelStar.prepareText("", level.getWidth());
                    }
                }
                if (y < 5) {
                    this.selectedLevel = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX) + level.getWidth() / 4 + 1, this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight() - this.levelNum.getTextHeight() / 2, level.getWidth() - level.getWidth() / 4, level.getHeight());
                    this.rectStar = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX) + level.getWidth() / 4 + 1, this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight(), level.getWidth() - level.getWidth() / 4, level.getHeight());
                    this.selectedLevel = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX) + level.getWidth() / 4 + 1, level.getY() - this.levelNum.getTextHeight() / 2, level.getWidth(), level.getHeight());
                    this.rectStar = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX) + level.getWidth() / 4 + 1, level.getY() - this.levelNum.getTextHeight() / 2, level.getWidth(), level.getHeight());
                }
                this.selectedLevel = new Rectangle(level.getX(), level.getY(), level.getWidth(), level.getHeight());
                this.rectStar = new Rectangle(level.getX(), level.getY() + level.getHeight(), this.levelNum.getTextHeight() << 2, this.levelNum.getTextHeight());
                if (this.levelNumber <= this.count + 1) {
                    if (!_selected) {
                        level.paint(g);
                    } else {
                        g.drawImage(_selector, level.getX(), level.getY(), 20);
                    }
                    this.levelNum.drawText(g, this.selectedLevel, 0, 3);
                    this.levelStar.drawText(g, this.rectStar, 0, 17);
                    continue;
                }
                if (!_selected) {
                    level.paint(g);
                } else {
                    g.drawImage(_selector, level.getX(), level.getY(), 20);
                }
                g.drawImage(Resources.resImgs[20], level.getX() + (level.getWidth() >> 1), level.getY() + (level.getHeight() >> 1), 3);
            }
        }
        ++this.check;
    }

    private void paintFK(Graphics g) {
        Sprite _funKey = Resources.resSprs[16];
        Sprite _fk = Resources.resSprs[0];
        int _shiftPositionY = this.mainCanvas.getHeight() - (this.rectDialog.y + this.rectDialog.height) >> 1;
        int _positionY = this.mainCanvas.getHeight() - _shiftPositionY - _funKey.getHeight();
        int _positionX = (_funKey.getWidth() >> 1) - (_fk.getWidth() >> 1);
        _funKey.setFrame(2);
        _funKey.setPosition(0, _positionY);
        _funKey.paint(g);
        _fk.setFrame(10);
        _fk.setPosition(_positionX, _positionY + (_funKey.getHeight() >> 1) - (_fk.getHeight() >> 1));
        _fk.paint(g);
        _funKey.setFrame(0);
        _funKey.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth(), _positionY);
        _funKey.paint(g);
        _fk.setFrame(9);
        _fk.setPosition(this.mainCanvas.getWidth() - _funKey.getWidth() + _positionX, _positionY + (_funKey.getHeight() >> 1) - (_fk.getHeight() >> 1));
        _fk.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isFKLeftCode(keyCode)) {
                ScreenGame sg;
                if (this.selectdLevel <= this.count) {
                    Level.getLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    System.out.println(" level@ " + this.selectdLevel);
                    MainCanvas.slcLvl = this.selectdLevel;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, false);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
                if (this.count == 2 && this.selectdLevel == 0) {
                    Level.getLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, false);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.mainCanvas.changeLastActiveScreen(new ScreenSelectPack(this.mainCanvas, 0));
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                ScreenGame sg;
                if (this.selectdLevel <= this.count) {
                    Level.getLevel(this.selectdLevel);
                    System.out.println(" level@ " + this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, false);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
                if (this.count == 2 && this.selectdLevel == 0) {
                    Level.getLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, false);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this.counterX > 0) {
                    --this.counterX;
                    --MainCanvas.counterX;
                    --this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this.counterX < 3) {
                    ++this.counterX;
                    ++this.selectdLevel;
                    ++MainCanvas.counterX;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this.counterY > 0) {
                    --this.counterY;
                    --MainCanvas.counterY;
                    this.selectdLevel -= 4;
                } else if (this.selectedPack > 0) {
                    this.counterX = 0;
                    this.counterY = 0;
                    MainCanvas.counterX = 0;
                    MainCanvas.counterY = 0;
                    --this.selectedPack;
                    this.selectdLevel -= 20;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this.counterY < 4) {
                    ++this.counterY;
                    ++MainCanvas.counterY;
                    this.selectdLevel += 4;
                } else if (this.selectedPack < 2) {
                    this.counterX = 0;
                    this.counterY = 0;
                    MainCanvas.counterX = 0;
                    MainCanvas.counterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
            }
        }
        this.mainCanvas.repaint();
        System.out.println("selectedLevel " + this.selectdLevel);
        System.out.println("counterX: " + this.counterX + " counterY: " + this.counterY + " selectedPack: " + this.selectedPack + " selectdLevel: " + this.selectdLevel);
    }

    public void pointerPressed(int x, int y) {
        block6: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 1: {
                    Keys.keyPressed(50);
                    Keys.resetAllPressedKeysAndActions();
                    continue block6;
                }
                case 2: {
                    Keys.keyPressed(56);
                    Keys.resetAllPressedKeysAndActions();
                    continue block6;
                }
                case 0: {
                    System.out.println("pucik0: " + this.selectedCompId);
                    Keys.keyPressed(-7);
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 1: {
                    Keys.keyReleased(49);
                    break;
                }
                case 2: {
                    Keys.keyReleased(49);
                    break;
                }
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        int i;
        System.out.println("aj tu som: " + this.selectedCompId);
        for (i = 0; i < this.rectItems.length; ++i) {
            if (this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            System.out.println("i:+i" + i);
            break;
        }
        System.out.println("aj tu som: " + this.selectedCompId);
        switch (this.selectedCompId) {
            case 1: {
                if (this.selectedPack > 0) {
                    this.counterX = 0;
                    this.counterY = 0;
                    --this.selectedPack;
                    --MainCanvas.slcPack;
                    this.selectdLevel -= 20;
                }
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 2: {
                if (this.selectedPack < 2) {
                    this.counterX = 0;
                    this.counterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 0: {
                System.out.println("pucik");
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 3: {
                System.out.println("kokotek 1");
                for (i = 0; i < this.rectLevel.length; ++i) {
                    if (this.rectLevel[i] == null || !this.rectLevel[i].contains(x, y)) continue;
                    System.out.println("kokotek 2");
                    if (i + this.selectedPack * 20 > this.count) continue;
                    Level.getLevel(i + this.selectedPack * 20);
                    System.out.println("level: " + (i + this.selectedPack * 20));
                    this.gameMode = Level.gameMode;
                    if (i + this.selectedPack * 20 <= 19) {
                        MainCanvas.slcPack = 0;
                    } else if (i + this.selectedPack * 20 <= 39) {
                        MainCanvas.slcPack = 1;
                    }
                    ScreenGame sg = new ScreenGame(this.mainCanvas, this.gameMode, i + this.selectedPack * 20, false);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (!MainCanvas.soundManager.IsSoundOn()) continue;
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                this.keyReleased(5);
            }
        }
    }
}

