/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Island {
    Image IBack = null;
    Image[] ITiles;
    static final int MAPMAXSIZE = 100;
    static final int MAXNOFLAYER1 = 3;
    static final int NOFTILESETS = 3;
    int PIXELHEIGHT;
    int PIXELWIDTH;
    static final byte[] TILES_BUNGALOW;
    static final byte[] TILES_ISLAND;
    static final byte[] TILES_RESTO;
    int _oldScrollX;
    int _oldScrollY;
    int _scrollX;
    int _scrollY;
    byte[] b;
    static final boolean[] bTileSetPersistant;
    Graphics gBack = null;
    int iMapDXPos;
    int iMapDYPos;
    int iMapLoaded = -1;
    int iMapTileHe;
    int iMapTileWi;
    int iMapXTilePos;
    int iMapYTilePos;
    int iNofLayer1;
    int iScrollHe;
    int iScrollWi;
    int iTileHe;
    int iTileSetLoaded = -1;
    int iTileSize;
    int iTileWi;
    int iTilesTileHe = 1;
    int iTilesTileWi = 1;
    InputStream is;
    short[][] map;
    int mapXTilePos;
    int mapYTilePos;
    short[] sLayer1 = new short[3];

    static {
        bTileSetPersistant = new boolean[]{false};
        TILES_ISLAND = new byte[]{3, 4, 5, 6, 10, 11, 12, 13, 17, 18, 19, 20, 26, 27, 34, 50, 51, 52, 53, 54, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70};
        TILES_BUNGALOW = new byte[]{10, 11, 12, 13, 18, 20, 26, 27, 28, 37, 42};
        TILES_RESTO = new byte[]{1, 9, 10, 11, 12, 13, 16, 17, 19, 20, 24, 25, 27, 32, 39, 42, 45, 46, 47, 50, 52, 53, 54, 57, 58};
    }

    public Island(int n, int n2, int n3) {
        this.ITiles = new Image[3];
        this.b = new byte[100];
        this.PIXELWIDTH = n;
        this.PIXELHEIGHT = n2;
        this.iTileSize = n3;
        this.iScrollWi = (n - 1) / n3 + 2 + 1;
        this.iScrollWi *= n3;
        this.iScrollHe = (n2 - 1) / n3 + 2;
        this.iScrollHe *= n3;
        this.iTileWi = this.iScrollWi / n3;
        this.iTileHe = this.iScrollHe / n3;
        try {
            this.IBack = Image.createImage((int)this.iScrollWi, (int)this.iScrollHe);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gBack = this.IBack.getGraphics();
        this.map = new short[100][100];
        int n4 = 0;
        while (n4 < 3) {
            this.ITiles[n4] = null;
            ++n4;
        }
    }

    boolean TileForbidden(int n, int n2, int n3) {
        short s = this.map[n][n2];
        if (n3 == 0) {
            int n4 = 0;
            while (n4 < 32) {
                if (s == TILES_ISLAND[n4]) {
                    return false;
                }
                n4 = (byte)(n4 + 1);
            }
        } else if (n3 == 1 || n3 == 5 || n3 == 6) {
            int n5 = 0;
            while (n5 < 11) {
                if (s == TILES_BUNGALOW[n5]) {
                    return false;
                }
                n5 = (byte)(n5 + 1);
            }
        } else {
            int n6 = 0;
            while (n6 < 25) {
                if (s == TILES_RESTO[n6]) {
                    return false;
                }
                n6 = (byte)(n6 + 1);
            }
        }
        return true;
    }

    void UnLoad() {
        int n = 0;
        while (n < 100) {
            int n2 = 0;
            while (n2 < 100) {
                this.map[n][n2] = 0;
                n2 = (byte)(n2 + 1);
            }
            n = (byte)(n + 1);
        }
        n = 0;
        while (n < 3) {
            this.sLayer1[n] = 0;
            n = (byte)(n + 1);
        }
        n = 0;
        while (n < 3) {
            this.ITiles[n] = null;
            n = (byte)(n + 1);
        }
        this.iTileSetLoaded = -1;
    }

    short b2toS(byte n, byte by) {
        int n2 = 0;
        n2 = n < 0 ? 256 + n : n;
        return (short)(n2 += by << 8);
    }

    void down(int n) {
        this.iMapDYPos += n;
        while (this.iMapDYPos >= this.iTileSize) {
            this.iMapDYPos -= this.iTileSize;
            if (this.iMapYTilePos < this.iMapTileHe - this.iTileHe) {
                int n2 = this.iMapXTilePos % this.iTileWi;
                int n3 = this.iMapYTilePos % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileWi) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos + n4][this.iMapYTilePos + this.iTileHe]);
                    ++n2;
                    n2 %= this.iTileWi;
                    ++n4;
                }
                ++this.iMapYTilePos;
                continue;
            }
            this.iMapDYPos = this.iTileSize - 1;
        }
    }

    void drawTile(int n, int n2, int n3) {
        this.gBack.setClip(n *= this.iTileSize, n2 *= this.iTileSize, this.iTileSize, this.iTileSize);
        int n4 = n2 - n3 / this.iTilesTileWi * this.iTileSize;
        int n5 = n - n3 % this.iTilesTileWi * this.iTileSize;
        this.gBack.drawImage(this.ITiles[this.iTileSetLoaded], n5, n4, 0);
    }

    void left(int n) {
        this.iMapDXPos -= n;
        while (this.iMapDXPos < 0) {
            this.iMapDXPos += this.iTileSize;
            if (this.iMapXTilePos > 0) {
                int n2 = (this.iMapXTilePos - 1) % this.iTileWi;
                int n3 = this.iMapYTilePos % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileHe) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos - 1][this.iMapYTilePos + n4]);
                    ++n3;
                    n3 %= this.iTileHe;
                    ++n4;
                }
                --this.iMapXTilePos;
                continue;
            }
            this.iMapDXPos = 0;
        }
    }

    void loadMap(int n) {
        if (this.iMapLoaded == n) {
            return;
        }
        this.iMapLoaded = n;
        switch (n) {
            case 0: {
                this.is = this.getClass().getResourceAsStream("/level/island.xav");
                break;
            }
            case 1: {
                this.is = this.getClass().getResourceAsStream("/level/bungaloo.xav");
                break;
            }
            case 2: {
                this.is = this.getClass().getResourceAsStream("/level/reception.xav");
                break;
            }
            case 3: {
                this.is = this.getClass().getResourceAsStream("/level/resto.xav");
                break;
            }
            case 4: {
                this.is = this.getClass().getResourceAsStream("/level/boite.xav");
                break;
            }
            case 5: {
                this.is = this.getClass().getResourceAsStream("/level/detente.xav");
                break;
            }
            case 6: {
                this.is = this.getClass().getResourceAsStream("/level/souvenirs.xav");
            }
        }
        try {
            this.is.read(this.b, 0, 4);
            this.iMapTileWi = this.b[1];
            this.iMapTileHe = this.b[3];
            int n2 = 0;
            while (n2 < this.iMapTileHe) {
                this.is.read(this.b, 0, this.iMapTileWi);
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.iMapTileWi) {
                    this.map[n4][n2] = (short)(this.b2toS(this.b[n3++], (byte)0) - 1);
                    if (this.map[n4][n2] < 0) {
                        this.map[n4][n2] = 0;
                    }
                    ++n4;
                }
                ++n2;
            }
            this.is.read(this.b, 0, 2);
            int n5 = this.b2toS(this.b[1], this.b[0]);
            this.iNofLayer1 = 0;
            int n6 = 0;
            while (n6 < n5) {
                this.is.read(this.b, 0, 3);
                this.sLayer1[this.iNofLayer1++] = this.b2toS(this.b[0], (byte)0);
                this.sLayer1[this.iNofLayer1++] = this.b2toS(this.b[1], (byte)0);
                int n7 = this.b2toS(this.b[2], (byte)0) - 17;
                this.sLayer1[this.iNofLayer1++] = (short)n7;
                ++n6;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.iNofLayer1 /= 3;
    }

    void loadTileSet(int n) {
        if (this.iTileSetLoaded == n) {
            return;
        }
        if (this.iTileSetLoaded != -1 && !bTileSetPersistant[this.iTileSetLoaded]) {
            this.ITiles[this.iTileSetLoaded] = null;
        }
        this.iTileSetLoaded = n;
        if (this.ITiles[this.iTileSetLoaded] != null) {
            return;
        }
        try {
            this.ITiles[this.iTileSetLoaded] = Image.createImage((String)("/gfx/tile" + this.iTileSetLoaded + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iTilesTileWi = this.ITiles[this.iTileSetLoaded].getWidth() / this.iTileSize;
        this.iTilesTileHe = this.ITiles[this.iTileSetLoaded].getHeight() / this.iTileSize;
    }

    void paint(Graphics graphics, int n, int n2) {
        this._scrollX = this.iMapXTilePos * this.iTileSize + this.iMapDXPos;
        this._scrollY = this.iMapYTilePos * this.iTileSize + this.iMapDYPos;
        graphics.drawImage(this.IBack, n += -(this.iMapXTilePos % this.iTileWi) * this.iTileSize - this.iMapDXPos, n2 += -(this.iMapYTilePos % this.iTileHe) * this.iTileSize - this.iMapDYPos, 0);
        graphics.drawImage(this.IBack, n += this.iScrollWi, n2, 0);
        graphics.drawImage(this.IBack, n, n2 += this.iScrollHe, 0);
        graphics.drawImage(this.IBack, n -= this.iScrollWi, n2, 0);
    }

    void right(int n) {
        this.iMapDXPos += n;
        while (this.iMapDXPos >= this.iTileSize) {
            this.iMapDXPos -= this.iTileSize;
            if (this.iMapXTilePos < this.iMapTileWi - this.iTileWi) {
                int n2 = this.iMapXTilePos % this.iTileWi;
                int n3 = this.iMapYTilePos % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileHe) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos + this.iTileWi][this.iMapYTilePos + n4]);
                    ++n3;
                    n3 %= this.iTileHe;
                    ++n4;
                }
                ++this.iMapXTilePos;
                continue;
            }
            this.iMapDXPos = this.iTileSize - 1;
        }
    }

    void setScrollerPos(int n, int n2) {
        this.iMapDXPos = n % this.iTileSize;
        this.iMapDYPos = n2 % this.iTileSize;
        this.iMapXTilePos = n / this.iTileSize;
        this.iMapYTilePos = n2 / this.iTileSize;
        this.mapXTilePos = n / this.iTileSize;
        this.mapYTilePos = n2 / this.iTileSize;
        int n3 = this.mapXTilePos % this.iTileWi;
        int n4 = this.mapYTilePos % this.iTileHe;
        int n5 = 0;
        while (n5 < this.iTileHe) {
            int n6 = 0;
            while (n6 < this.iTileWi) {
                this.drawTile(n3, n4, this.map[n6 + this.iMapXTilePos][n5 + this.iMapYTilePos]);
                ++n3;
                n3 %= this.iTileWi;
                ++n6;
            }
            ++n4;
            n4 %= this.iTileHe;
            ++n5;
        }
    }

    void up(int n) {
        this.iMapDYPos -= n;
        while (this.iMapDYPos < 0) {
            this.iMapDYPos += this.iTileSize;
            if (this.iMapYTilePos > 0) {
                int n2 = this.iMapXTilePos % this.iTileWi;
                int n3 = (this.iMapYTilePos - 1) % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileWi) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos + n4][this.iMapYTilePos - 1]);
                    ++n2;
                    n2 %= this.iTileWi;
                    ++n4;
                }
                --this.iMapYTilePos;
                continue;
            }
            this.iMapDYPos = 0;
        }
    }
}

