/*
 * Decompiled with CFR 0.152.
 */
package bazan.game.sprites;

import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class animals {
    public static final String GAME_ANIMALS_FOLDER = "/game_animals";
    public static final int SHEEP_WIDTH = 128;
    public static final int SHEEP_HEIGHT = 128;
    public static final int WOLF_WIDTH = 160;
    public static final int WOLF_HEIGHT = 160;
    private String sSheep;
    private String sWolf;
    private Image iSheep;
    private Image iWolf;
    private Sprite spSheep;
    private Sprite spWolf;
    private int screenW = 0;
    private int screenH = 0;
    private int xSheep;
    private int ySheep;
    private int xWolf;
    private int yWolf;
    private boolean leftSheep = false;
    private boolean leftWolf = false;

    public animals(int w, int h) {
        this.screenW = w;
        this.screenH = h;
        this.sSheep = "/game_animals/sheep.png";
        this.sWolf = "/game_animals/wolf.png";
        try {
            this.iSheep = Image.createImage((String)this.sSheep);
            this.iWolf = Image.createImage((String)this.sWolf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.spSheep = new Sprite(this.iSheep, 128, 128);
        this.spSheep.defineReferencePixel(64, 64);
        this.spSheep.setVisible(false);
        this.spWolf = new Sprite(this.iWolf, 160, 160);
        this.spWolf.defineReferencePixel(80, 80);
        this.spWolf.setVisible(false);
        this.xSheep = 0;
        this.ySheep = 0;
    }

    private void updateAnimals(Sprite animal, int x, int y) {
        if (animal.isVisible()) {
            animal.setPosition(x, y);
            animal.nextFrame();
        }
    }

    public void updateSheep(int velY) {
        if (!this.leftSheep) {
            this.xSheep += 2;
            if (this.xSheep + this.spSheep.getWidth() > this.screenW) {
                this.leftSheep = true;
                this.spSheep.setTransform(2);
            }
        } else {
            this.xSheep -= 2;
            if (this.xSheep < 0) {
                this.leftSheep = false;
                this.spSheep.setTransform(0);
            }
        }
        this.ySheep += velY;
        if (this.ySheep > this.screenH) {
            this.spSheep.setVisible(false);
        }
        this.updateAnimals(this.spSheep, this.xSheep, this.ySheep);
    }

    public void updateWolf(int velY) {
        if (!this.leftWolf) {
            this.xWolf += 2;
            if (this.xWolf + this.spWolf.getWidth() > this.screenW) {
                this.leftWolf = true;
                this.spWolf.setTransform(2);
            }
        } else {
            this.xWolf -= 2;
            if (this.xWolf < 0) {
                this.leftWolf = false;
                this.spWolf.setTransform(0);
            }
        }
        this.yWolf += velY;
        if (this.yWolf > this.screenH) {
            this.spWolf.setVisible(false);
        }
        this.updateAnimals(this.spWolf, this.xWolf, this.yWolf);
    }

    public void setVisibleSheep(boolean v) {
        this.spSheep.setVisible(v);
    }

    public void setVisibleWolf(boolean v) {
        this.spWolf.setVisible(v);
    }

    public void setY_Sheep(int y) {
        this.ySheep = y;
    }

    public void setY_Wolf(int y) {
        this.yWolf = y;
    }

    public Sprite spSheep() {
        return this.spSheep;
    }

    public Sprite spWolf() {
        return this.spWolf;
    }
}

