/*
 * Decompiled with CFR 0.152.
 */
package bazan.game.imageeffect;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class imageEffect {
    private int[] rgbData;
    private int[] rgbDataAux;
    private int i;
    private int y;
    private int x;
    private int xAux;
    private int yAux;
    private int color = -1;

    public Image resizeImage(Image currentImage, int newWidth, int newHeight) {
        int currentWidth = currentImage.getWidth();
        int currentHeight = currentImage.getHeight();
        Image finalImage = Image.createImage((int)newWidth, (int)newHeight);
        Graphics g = finalImage.getGraphics();
        this.y = 0;
        while (this.y < newHeight) {
            this.x = 0;
            while (this.x < newWidth) {
                g.setClip(this.x, this.y, 1, 1);
                this.xAux = this.x * currentWidth / newWidth;
                this.yAux = this.y * currentHeight / newHeight;
                g.drawImage(currentImage, this.x - this.xAux, this.y - this.yAux, 20);
                ++this.x;
            }
            ++this.y;
        }
        return Image.createImage((Image)finalImage);
    }

    public Image resizeImage2(Image src, int newWidth, int newHeight) {
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        Image tmp = Image.createImage((int)newWidth, (int)srcHeight);
        Graphics g = tmp.getGraphics();
        int ratio = (srcWidth << 16) / newWidth;
        int pos = ratio / 2;
        this.x = 0;
        while (this.x < newWidth) {
            g.setClip(this.x, 0, 1, srcHeight);
            g.drawImage(src, this.x - (pos >> 16), 0, 20);
            pos += ratio;
            ++this.x;
        }
        Image resizedImage = Image.createImage((int)newWidth, (int)newHeight);
        g = resizedImage.getGraphics();
        ratio = (srcHeight << 16) / newHeight;
        pos = ratio / 2;
        for (int y = 0; y < newHeight; ++y) {
            g.setClip(0, y, newWidth, 1);
            g.drawImage(tmp, 0, y - (pos >> 16), 20);
            pos += ratio;
        }
        return resizedImage;
    }

    public Image getRGBImage(Image image) {
        this.rgbData = new int[image.getHeight() * image.getWidth()];
        image.getRGB(this.rgbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        this.i = 0;
        while (this.i < this.rgbData.length) {
            if (this.rgbData[this.i] == -1) {
                this.rgbData[this.i] = this.rgbData[this.i] & 0xFFFFFF;
            }
            ++this.i;
        }
        Image newImage = Image.createRGBImage((int[])this.rgbData, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
        return newImage;
    }

    public Image getRGBImage(Image image, int color) {
        this.color = color;
        return this.getRGBImage(image);
    }

    public Image flipImage(Image image) {
        this.x = 0;
        this.rgbData = new int[image.getHeight() * image.getWidth()];
        this.rgbDataAux = new int[image.getHeight() * image.getWidth()];
        image.getRGB(this.rgbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        this.i = this.rgbData.length - 1;
        while (this.i > 0) {
            this.rgbDataAux[this.x] = this.rgbData[this.i];
            ++this.x;
            --this.i;
        }
        Image flippedImage = Image.createRGBImage((int[])this.rgbDataAux, (int)image.getWidth(), (int)image.getHeight(), (boolean)false);
        return flippedImage;
    }
}

