/*
 * Decompiled with CFR 0.152.
 */
package bazan.game.pigshot;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite2 {
    private int posx;
    private int posy;
    private boolean active = false;
    private int frame = 1;
    private int nframes;
    private Image[] sprites;

    public Sprite2(int nframes) {
        this.nframes = nframes;
        this.sprites = new Image[nframes + 1];
    }

    public void setX(int x) {
        this.posx = x;
    }

    public void setY(int y) {
        this.posy = y;
    }

    int getX() {
        return this.posx;
    }

    int getY() {
        return this.posy;
    }

    int getW() {
        return this.sprites[this.nframes].getWidth();
    }

    int getH() {
        return this.sprites[this.nframes].getHeight();
    }

    public void on() {
        this.active = true;
    }

    public void off() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void selFrame(int frameno) {
        this.frame = frameno;
    }

    public int frames() {
        return this.nframes;
    }

    public void addFrame(int frameno, String path) {
        try {
            this.sprites[frameno] = Image.createImage((String)path);
        }
        catch (IOException e) {
            System.err.println("Can`t load the image " + path + ": " + e.toString());
        }
    }

    boolean collide(Sprite2 sp) {
        int w1 = this.getW();
        int h1 = this.getH();
        int w2 = sp.getW();
        int h2 = sp.getH();
        int x1 = this.getX();
        int y1 = this.getY();
        int x2 = sp.getX();
        int y2 = sp.getY();
        return x1 + w1 > x2 && y1 + h1 > y2 && x2 + w2 > x1 && y2 + h2 > y1;
    }

    public void draw(Graphics g) {
        g.drawImage(this.sprites[this.frame], this.posx, this.posy, 3);
    }
}

