/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.canvas;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Event;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.canvas.GameCanvas;
import mobileforce.slicetherope.userdata.BodyPointer;
import mobileforce.slicetherope.util.Constanta;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.Point;
import mobileforce.slicetherope.util.Utility;
import mobileforce.slicetherope.world.SimulationWorld;

public class SimulationCanvas
extends GameCanvas
implements Constanta {
    private SimulationWorld sim_world;
    private SimulationWorld backWorld;
    private Thread thread;
    Body[] bodList;
    Vector scores;
    Vector springs;
    Body frog;
    Body candy;
    Body bubble;
    Body eatingStar;
    Event candyEvent;
    Image eatImage;
    Image sadImage;
    Object lock = new Object();
    private int millis = 50;
    private boolean stopped = false;
    boolean eatCandyEnable;
    boolean eatStarEnable;
    boolean popBubbleEnable;
    boolean sadEnable;
    private int game_score;
    public int game_status;
    public static final String[] shapeImgNames = new String[]{"/fixing.png", "/star_panel.png", "/frog_panel.png", "/target.png", "/rope0.png", "/score.png", "/spike_move.png", "/bubble_flight.png", "/pump_01.png", "/trampoline.png", "/spikes_v.png", "/spikes_h.png"};
    int in = 0;
    boolean paused = false;

    void restart() {
        this.setWorld(this.backWorld);
    }

    protected void init() {
        this.scores = new Vector(3);
        this.springs = new Vector(4);
        this.game_score = 0;
        this.eatCandyEnable = false;
        this.eatStarEnable = false;
        this.popBubbleEnable = false;
        this.sadEnable = false;
        this.game_status = -1;
        this.startX = 15;
        this.startY = 95;
        this.currentX = this.startX;
        this.currentY = this.startY;
        this.setBGImage("/bg_play.png", this.getWidth(), -1);
    }

    protected void paint(Graphics g) {
        try {
            this.drawBG(g);
            this.drawScore(g);
            if (this.eatCandyEnable) {
                this.drawEatCandy(g);
            }
            if (this.eatStarEnable) {
                this.drawEatStar(g);
            }
            if (this.popBubbleEnable) {
                this.drawPopBubble(g);
            }
            if (this.sadEnable) {
                this.drawSad(g);
            }
            this.sim_world.draw(g);
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    public void setWorld(SimulationWorld world) {
        this.init();
        this.stopped = false;
        this.sim_world = world;
        this.backWorld = world;
        this.bodList = world.getBodies();
        this.setShapeSet();
        this.setSprings();
        this.refineRopePropety();
    }

    public void setShapeSet() {
        this.sim_world.shapeSet.setSize(shapeImgNames.length);
        int i = 0;
        while (i < this.bodList.length) {
            int shapeId;
            Body body = this.bodList[i];
            if (body != null && body.shape() != null && (shapeId = body.shape().getId()) >= 0 && shapeId < shapeImgNames.length) {
                Image shapeImg = GameCanvas.getImage(shapeImgNames[shapeId]);
                this.setObjectRegist(body, shapeId);
                this.sim_world.shapeSet.registerImage(shapeImg, shapeId);
            }
            ++i;
        }
    }

    public void setSprings() {
        Constraint[] cons = this.sim_world.getConstraints();
        int i = 0;
        while (i < cons.length) {
            Constraint con = cons[i];
            if (con instanceof Spring) {
                this.springs.addElement(con);
            }
            ++i;
        }
    }

    public void setObjectRegist(Body b, int shapeId) {
        switch (shapeId) {
            case 5: {
                this.scores.addElement(b);
                break;
            }
            case 3: {
                this.candy = b;
                break;
            }
            case 2: {
                this.frog = b;
                this.frog.setRotation2FX(0);
                break;
            }
            case 1: {
                b.angularVelocity2FX(4096);
                break;
            }
            case 7: {
                this.bubble = b;
                this.sim_world.setExistBubble(true);
            }
        }
    }

    public void refineRopePropety() {
        int i = 0;
        while (i < this.sim_world.getBodyCount()) {
            int shapeId = this.sim_world.getBodies()[i].shape().getId();
            if (shapeId == 4) {
                this.sim_world.getBodies()[i].setInteracting(false);
            }
            this.sim_world.getBodies()[i].shape().setFrictionFX(10);
            ++i;
        }
    }

    public void setEvent() {
        FXVector pos = this.candy.positionFX();
        this.candyEvent = Event.createBodyEvent(this.candy, this.candy.shape(), 4, pos.yFX, pos.xFX, pos.yFX, pos.xFX);
        this.sim_world.addEvent(this.candyEvent);
    }

    protected void showNotify() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void end() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long sleep = 0L;
        long start = 0L;
        Constants.playBG(this.engine);
        while (this.sim_world != null && !this.stopped) {
            if (this.game_status == 2) {
                this.engine.setGame_score(this.game_score);
                this.engine.setWin(true);
                this.engine.showScoreMenu();
                return;
            }
            if (this.game_status == 3) {
                this.end();
                this.engine.setGame_score(0);
                this.engine.setWin(false);
                this.engine.showScoreMenu();
                return;
            }
            start = System.currentTimeMillis();
            this.tick();
            if (!this.eatCandyEnable) {
                this.collisionProcess();
            }
            this.sim_world.simWordlProses(this.candy);
            this.checkGameOver();
            sleep = (long)this.millis - (System.currentTimeMillis() - start);
            sleep = Math.max(sleep, 0L);
            this.delay(sleep);
            if (!this.paused) continue;
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.paused = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    void delay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tick() {
        if (this.sim_world != null) {
            this.sim_world.tick();
        }
        this.repaint();
    }

    public void collisionProcess() {
        int i = 0;
        while (i < this.sim_world.getStars().length) {
            Body bod = this.sim_world.getStars()[i];
            if (bod != null && Utility.collition(bod, this.candy, 20)) {
                this.eatStar(bod);
                this.sim_world.getStars()[i] = null;
            }
            ++i;
        }
        if (Utility.collition(this.candy, this.frog, 15) && !this.eatCandyEnable) {
            this.eatCandy(this.candy, this.frog);
        }
    }

    void checkGameOver() {
        if (this.sim_world == null || this.candy == null) {
            return;
        }
        Body candyBody = this.candy;
        if (candyBody == null) {
            return;
        }
        int radius = GameCanvas.getImage(shapeImgNames[3]).getWidth() * 3;
        if (!this.isContainRect(candyBody.positionFX(), -radius, -radius, Constants.WIDTH_W2 + radius, Constants.HEIGHT_W2 + radius) && !this.sadEnable) {
            this.sadNom(this.candy, this.frog);
        }
    }

    boolean isContainRect(FXVector pos, int x0, int y0, int x1, int y1) {
        int x = pos.xAsInt();
        int y = pos.yAsInt();
        return x >= x0 && x <= x1 && y >= y0 && y <= y1;
    }

    public void eatStar(Body star) {
        this.eatStarEnable = true;
        this.eatingStar = star;
        this.eatingStar.setRotation2FX(0);
        ++this.game_score;
        this.sim_world.removeBody(star);
    }

    public void eatCandy(Body candy, Body fr) {
        this.sim_world.removeBody(candy);
        this.sim_world.removeBody(fr);
        this.frog.setRotation2FX(0);
        this.eatCandyEnable = true;
        Constants.playWin(this.engine);
    }

    public void sadNom(Body candy, Body fr) {
        this.sim_world.removeBody(candy);
        this.sim_world.removeBody(fr);
        this.frog.setRotation2FX(0);
        this.sadEnable = true;
        Constants.playSad(this.engine);
    }

    public void drawEatCandy(Graphics g) {
        if (this.eatImage == null) {
            this.eatImage = GameCanvas.getImage("/eat.png");
        }
        int h = this.eatImage.getHeight();
        int num = 10;
        int w = this.eatImage.getWidth() / num;
        int x = this.frog.positionFX().xAsInt();
        int y = this.frog.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        int rotFX = this.frog.rotation2FX();
        if (rotFX > 52707178) {
            rotFX -= 52707178;
            this.eatCandyEnable = false;
            this.game_status = 2;
            return;
        }
        this.frog.setRotation2FX(rotFX + 2635358);
        int index = rotFX / (52707178 / num);
        int tranfom = 0;
        g.drawImage(this.sim_world.getPlatformImage(), x, y + 20, 3);
        g.drawRegion(this.eatImage, index * w, 0, w, h, tranfom, x, y, 3);
    }

    public void drawSad(Graphics g) {
        if (this.sadImage == null) {
            this.sadImage = GameCanvas.getImage("/sad.png");
        }
        int h = this.sadImage.getHeight();
        int num = 6;
        int w = 48;
        int x = this.frog.positionFX().xAsInt();
        int y = this.frog.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        int rotFX = this.frog.rotation2FX();
        if (rotFX > 52707178) {
            rotFX -= 52707178;
            this.sadEnable = false;
            this.game_status = 3;
            return;
        }
        this.frog.setRotation2FX(rotFX + 5270717);
        int index = rotFX / (52707178 / num);
        int tranfom = 0;
        if (index < num) {
            g.drawImage(this.sim_world.getPlatformImage(), x, y + 20, 3);
            g.drawRegion(this.sadImage, index * w, 0, w, h, tranfom, x, y, 3);
        }
    }

    public void drawEatStar(Graphics g) {
        Image img = GameCanvas.getStarEatImage();
        if (img == null) {
            return;
        }
        int num = 2;
        int h = img.getHeight();
        int w = img.getWidth() / num;
        int x = this.eatingStar.positionFX().xAsInt();
        int y = this.eatingStar.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        int rotFX = this.eatingStar.rotation2FX();
        if (rotFX > 52707178) {
            rotFX -= 52707178;
            this.eatStarEnable = false;
            return;
        }
        this.eatingStar.setRotation2FX(rotFX + 26353589);
        int index = rotFX / (52707178 / num);
        int tranfom = 0;
        if (index < num) {
            g.drawRegion(img, index * w, 0, w, h, tranfom, x, y, 3);
        }
    }

    public void drawPopBubble(Graphics g) {
        Image img = GameCanvas.getImage("/bubble_pop.png");
        int num = 11;
        int h = img.getHeight();
        int w = img.getWidth() / num;
        int x = this.bubble.positionFX().xAsInt();
        int y = this.bubble.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        int rotFX = this.bubble.rotation2FX();
        if (rotFX > 52707178) {
            rotFX -= 52707178;
            this.popBubbleEnable = false;
            return;
        }
        this.bubble.setRotation2FX(rotFX + 26353589);
        int index = rotFX / (52707178 / num);
        int tranfom = 0;
        if (index < num) {
            g.drawRegion(img, index * w, 0, w, h, tranfom, x, y, 3);
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
        this.keyReleased(keyCode);
    }

    protected void keyReleased(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (keyCode >= 48 && keyCode <= 57) {
            int nomor = keyCode - 48;
            Object[] body_point = this.sim_world.getBodyPoint();
            if (nomor < body_point.length) {
                Spring pointer;
                UserData ud;
                Object point = body_point[nomor];
                if (point != null && point instanceof Body) {
                    Body pointer2 = (Body)point;
                    UserData ud2 = pointer2.getUserData();
                    if (ud2 != null) {
                        BodyPointer dv = (BodyPointer)ud2;
                        Body remove = dv.getBodyRemove();
                        if (remove == null) {
                            this.currentX = pointer2.positionFX().xAsInt();
                            this.currentY = pointer2.positionFX().yAsInt();
                            this.keyReleased(-5);
                        } else {
                            this.sim_world.removeBody(remove);
                            pointer2.setUserData(null);
                            dv.removeVector(this.sim_world);
                        }
                    }
                } else if (point instanceof Spring && (ud = (pointer = (Spring)point).getUserData()) != null) {
                    BodyPointer dv = (BodyPointer)ud;
                    Body remove = dv.getBodyRemove();
                    if (remove == null) {
                        this.sim_world.removeConstraint(pointer);
                    } else {
                        this.sim_world.removeBody(remove);
                        pointer.setUserData(null);
                    }
                }
            }
        } else if (action == 8) {
            if (this.sim_world.isExistBubble() && this.removeBubble()) {
                return;
            }
            if (this.pointerPressed) {
                this.pointerPressed = false;
                this.removeBodies();
                this.removeSprings();
            } else {
                this.pointerPressed = true;
                this.startX = this.currentX;
                this.startY = this.currentY;
            }
        }
    }

    void removeBodies() {
        int x1 = this.startX;
        int y1 = this.startY;
        int x2 = this.currentX;
        int y2 = this.currentY;
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0) {
            if (dy > 0) {
                int y = y1;
                while (y <= y2) {
                    this.removeBody(x1, y);
                    ++y;
                }
            } else {
                int y = y1;
                while (y >= y2) {
                    this.removeBody(x1, y);
                    --y;
                }
            }
        } else if (dx > 0) {
            int x = x1;
            while (x <= x2) {
                int y = y1 + (x - x1) * dy / dx;
                this.removeBody(x, y);
                ++x;
            }
        } else {
            int x = x1;
            while (x >= x2) {
                int y = y1 + (x - x1) * dy / dx;
                this.removeBody(x, y);
                --x;
            }
        }
    }

    void removeBody(int posX, int posY) {
        Body body = this.sim_world.findBodyAt(FXUtil.toFX(posX), FXUtil.toFX(posY));
        if (body != null) {
            if (body.shape().getId() == 4 || body.shape().getId() == 7) {
                if (body.shape().getId() == 7) {
                    this.sim_world.setExistBubble(false);
                    this.popBubbleEnable = true;
                }
                this.sim_world.removeBody(body);
            } else if (body.shape().getId() == 8) {
                int degree = Utility.RotationFXToDegree(body.rotation2FX());
                int x_power = Utility.degreeXElement(degree, this.sim_world.getPumpPower());
                int y_power = Utility.degreeYElement(degree, this.sim_world.getPumpPower());
                FXVector vector = FXVector.newVector(x_power, y_power);
                this.shake(this.candy, vector);
                this.sim_world.setCurrentPump(body);
            }
        }
    }

    private void shake(Body body, FXVector vector) {
        body.applyAcceleration(vector, this.sim_world.getTimestepFX());
    }

    private boolean removeBubble() {
        Body body = this.sim_world.findBodyAt(FXUtil.toFX(this.currentX), FXUtil.toFX(this.currentY));
        if (body != null && body.shape().getId() == 7) {
            int x = body.positionFX().xAsInt();
            int y = body.positionFX().yAsInt();
            this.removeBody(x, y);
            this.sim_world.turnGravity(180);
            return true;
        }
        return false;
    }

    void removeSprings() {
        int i = 0;
        while (i < this.springs.size()) {
            Point bp2;
            Point bp1;
            Point ap2;
            Spring sp = (Spring)this.springs.elementAt(i);
            Point ap1 = new Point(sp.getPoint1().xAsInt(), sp.getPoint1().yAsInt());
            if (this.GetIntersectPoint(ap1, ap2 = new Point(sp.getPoint2().xAsInt(), sp.getPoint2().yAsInt()), bp1 = new Point(this.startX, this.startY), bp2 = new Point(this.currentX, this.currentY))) {
                this.sim_world.removeConstraint(sp);
            }
            ++i;
        }
    }

    public final void pointerPressed(int posX, int posY) {
        this.pointerPressed = true;
        this.startX = posX;
        this.startY = posY;
        this.currentX = posX;
        this.currentY = posY;
    }

    public final void pointerReleased(int posX, int posY) {
        this.pointerPressed = false;
        this.currentX = posX;
        this.currentY = posY;
        this.removeBodies();
        this.removeSprings();
    }

    public final void pointerDragged(int x, int y) {
        this.currentX = x;
        this.currentY = y;
    }

    void drawCutLine(Graphics g) {
        int radius = 5;
        int x = this.startX - radius;
        int y = this.startY - radius;
        g.setColor(255, 0, 0);
        g.fillArc(x, y, radius * 2, radius * 2, 0, 360);
        g.setColor(255, 255, 255);
        g.drawLine(this.startX, this.startY, this.currentX, this.currentY);
    }

    public void drawScore(Graphics g) {
        try {
            int i = 0;
            while (i < this.scores.size()) {
                Body b = (Body)this.scores.elementAt(i);
                int type = this.game_score > i ? 1 : 0;
                Image img = GameCanvas.getImage(shapeImgNames[5]);
                int h = img.getHeight();
                if (h <= 2) {
                    return;
                }
                int tranfom = 0;
                int x = b.positionFX().xAsInt();
                int y = b.positionFX().yAsInt();
                g.drawRegion(img, type * h, 0, h, h, tranfom, x, y, 3);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean GetIntersectPoint(Point AP1, Point AP2, Point BP1, Point BP2) {
        double under = (BP2.y - BP1.y) * (AP2.x - AP1.x) - (BP2.x - BP1.x) * (AP2.y - AP1.y);
        if (under == 0.0) {
            return false;
        }
        double _t = (BP2.x - BP1.x) * (AP1.y - BP1.y) - (BP2.y - BP1.y) * (AP1.x - BP1.x);
        double _s = (AP2.x - AP1.x) * (AP1.y - BP1.y) - (AP2.y - AP1.y) * (AP1.x - BP1.x);
        double t = _t / under;
        double s = _s / under;
        if (t < 0.0 || t > 1.0 || s < 0.0 || s > 1.0) {
            return false;
        }
        return _t != 0.0 || _s != 0.0;
    }
}

