/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.world;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.language.LangController;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.FontFactory;
import mobileforce.slicetherope.world.GameWorld;

public class AboutWorld
extends GameWorld {
    int current = 2;
    Image button_x_on;
    Image button_x_off;
    Image button_n_on;
    Image button_n_off;
    Image bg_headline;
    Image frog;
    String title = LangController.getInstance().title_about();
    String[] about = LangController.getInstance().about();

    public void current_select(int current) {
        this.current = current;
    }

    public AboutWorld(World w) {
        super(w);
        this.initImage();
    }

    private void initImage() {
        this.button_x_on = Constants.getImage("/button_x_on.png");
        this.button_x_off = Constants.getImage("/button_x_off.png");
        this.button_n_on = Constants.getImage("/button_back_select.png");
        this.button_n_off = Constants.getImage("/button_back_select.png");
        this.bg_headline = Constants.getImage("/bg_headline.png");
        this.frog = Constants.getImage("/monster_menu.png");
    }

    public void drawBody(Graphics g, Body b) {
        if (b == null) {
            return;
        }
        int id = b.shape().getId();
        int x = b.positionFX().xAsInt();
        int y = b.positionFX().yAsInt();
        x = Constants.fromWorldX(x);
        y = Constants.fromWorldY(y);
        g.setColor(15363584);
        g.setFont(FontFactory.ABOUT_TITLE);
        if (id == 0) {
            this.drawImage(g, this.bg_headline, x, y);
            g.drawImage(this.bg_headline, x, y, 17);
            g.drawString(this.title, x, y + 5, 17);
        } else if (id == 1) {
            g.setColor(4535339);
            int i = 0;
            while (i < this.about.length) {
                g.drawString(this.about[i], x, y + 5 + i * 9, 65);
                ++i;
            }
        } else if (id == 2) {
            if (this.current == id) {
                this.drawImage(g, this.button_x_on, x, y);
            } else {
                this.drawImage(g, this.button_x_off, x, y);
            }
        } else if (id == 3) {
            this.drawImage(g, this.frog, x, y);
        } else if (id == 4) {
            if (this.current == id) {
                this.drawImage(g, this.button_n_on, x, y);
            } else {
                this.drawImage(g, this.button_n_off, x, y);
            }
        }
    }
}

