/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.canvas;

import javax.microedition.lcdui.Graphics;
import mobileforce.slicetherope.GameEngine;
import mobileforce.slicetherope.canvas.GameCanvas;
import mobileforce.slicetherope.world.ScoreMenuWorld;

public class ScoreMenuCanvas
extends GameCanvas {
    private ScoreMenuWorld world;
    private int currentBody = 4;
    private int game_score;
    private final int isReply;
    private final int isNext;
    private final int isMenu;
    private boolean win;

    public ScoreMenuCanvas() {
        this.isReply = 5;
        this.isNext = 4;
        this.isMenu = 6;
        this.setBGImage("/bg_score.png", this.getWidth(), -1);
        this.win = false;
    }

    public void setEngine(GameEngine e) {
        this.engine = e;
        this.game_score = e.game_score;
        this.win = e.isWin();
        if (!this.win) {
            this.game_score = 0;
        }
        if (this.game_score == 0) {
            this.currentBody = 5;
        }
    }

    public void setWorld(ScoreMenuWorld world) {
        this.world = world;
        world.setCurrent(this.currentBody, this.game_score);
        world.setWinning(this.win);
    }

    protected void paint(Graphics g) {
        this.drawBG(g);
        if (this.world != null) {
            this.world.draw(g);
        }
    }

    public void tick() {
        if (this.world != null) {
            this.world.tick();
        }
        this.repaint();
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (action == 8) {
            switch (this.currentBody) {
                case 5: {
                    this.engine.reply();
                    break;
                }
                case 6: {
                    this.engine.showMainMenu();
                    break;
                }
                case 4: {
                    this.engine.next();
                }
            }
        } else {
            switch (action) {
                case 1: {
                    --this.currentBody;
                    break;
                }
                case 6: {
                    ++this.currentBody;
                }
            }
            if (this.game_score != 0) {
                if (this.currentBody < 4) {
                    this.currentBody = 4;
                }
                if (this.currentBody > 6) {
                    this.currentBody = 6;
                }
            } else {
                if (this.currentBody < 5) {
                    this.currentBody = 5;
                }
                if (this.currentBody > 6) {
                    this.currentBody = 6;
                }
            }
        }
        this.world.setCurrent(this.currentBody, this.game_score);
        this.repaint();
    }
}

