/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.canvas;

import javax.microedition.lcdui.Graphics;
import mobileforce.slicetherope.canvas.GameCanvas;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.world.LevelWorld;

public class LevelCanvas
extends GameCanvas {
    private LevelWorld world;
    int current_body = 1;
    int current_level = 0;
    int current_page = 0;
    private static final int BACK_BUTTON = 2;
    private static final int LEVEL_BODY = 1;

    public LevelCanvas() {
        this.setBGImage("/bg_play.png", this.getWidth(), -1);
    }

    public void setWorld(LevelWorld world) {
        this.world = world;
    }

    protected void paint(Graphics g) {
        this.drawBG(g);
        if (this.world != null) {
            this.world.draw(g);
        }
    }

    public boolean isChangeCurrentPage(int data) {
        int page = data / LevelWorld.MaxNUmber();
        if (this.current_page != page) {
            return true;
        }
        return data >= Constants.levelWorldNames.length;
    }

    public void setRefineLevel() {
        if (this.current_level < 0) {
            this.current_level = Constants.levelWorldNames.length - 1;
        }
        if (this.current_level >= Constants.levelWorldNames.length) {
            this.current_level = 0;
        }
        this.current_page = this.current_level / LevelWorld.MaxNUmber();
    }

    protected void keyPressed(int keyCode) {
        int action;
        if (keyCode == -6) {
            this.engine.showMainMenu();
        }
        if ((action = this.getGameAction(keyCode)) == 2 && this.current_body == 1) {
            --this.current_level;
            this.setRefineLevel();
        } else if (action == 5 && this.current_body == 1) {
            ++this.current_level;
            this.setRefineLevel();
        } else if (action == 1) {
            if (this.current_body == 1) {
                this.current_level -= 3;
                if (this.current_level < 0) {
                    this.current_level = 0;
                }
                this.setRefineLevel();
            } else {
                this.current_body = 1;
            }
        } else if (action == 6) {
            if (this.current_body == 1) {
                if (!this.isChangeCurrentPage(this.current_level + 3)) {
                    this.current_level += 3;
                    this.setRefineLevel();
                } else {
                    this.current_body = 2;
                }
            }
        } else if (action == 8) {
            if (this.current_body == 2) {
                this.engine.showMainMenu();
            } else if (this.current_body == 1) {
                this.engine.play(this.current_level);
            }
        }
        this.world.current_select(this.current_body, this.current_page, this.current_level);
        this.repaint();
    }
}

