/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.util;

import at.emini.physics2D.Body;
import javax.microedition.lcdui.Image;

public class Utility {
    private static final int center = 5;
    public static final int tolerant_star = 20;
    public static final int tolerant_frog = 15;

    public static int Phytagoras(int x0, int y0, int x1, int y1) {
        int dx = x0 - x1;
        int dy = y0 - y1;
        int dx2 = dx * dx;
        int dy2 = dy * dy;
        int summary = dy2 + dx2;
        double sum = Math.sqrt(summary);
        return (int)sum;
    }

    public static boolean collition(Body one, Body two, int tolerant) {
        int y2;
        int x2;
        int y1;
        int x1 = one.positionFX().xAsInt() - 5;
        int gap = Utility.Phytagoras(x1, y1 = one.positionFX().yAsInt() - 5, x2 = two.positionFX().xAsInt() - 5, y2 = two.positionFX().yAsInt() - 5);
        return tolerant >= gap;
    }

    public static Image scale(Image src, int width, int height) {
        int scanline = src.getWidth();
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
        int[] buf2 = new int[width * height];
        int y = 0;
        while (y < height) {
            int c1 = y * width;
            int c2 = y * srch / height * scanline;
            int x = 0;
            while (x < width) {
                buf2[c1 + x] = buf[c2 + x * srcw / width];
                ++x;
            }
            ++y;
        }
        Image img = Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
        return img;
    }

    public static Image rotate(Image imgSource, int cx, int cy, double theta, int[] dd) {
        if (Math.abs(theta % 360.0) < 0.1) {
            return imgSource;
        }
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        int dx = cx;
        int dy = cy;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        int i = 0;
        while (i < w1) {
            int j = 0;
            while (j < h1) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
                ++j;
            }
            ++i;
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static final int RotationFXToDegree(int fx) {
        return fx / 292817;
    }

    public static final int degreeXElement(int degree, int force) {
        return (int)(Math.cos(Utility.toRad(degree)) * (double)force);
    }

    public static final int degreeYElement(int degree, int force) {
        return (int)(Math.sin(Utility.toRad(degree)) * (double)force);
    }

    public static final double toRad(int degree) {
        double result = (double)degree * Math.PI / 180.0;
        return result;
    }
}

