/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import mobileforce.slicetherope.canvas.AboutCanvas;
import mobileforce.slicetherope.canvas.FinishCanvas;
import mobileforce.slicetherope.canvas.GameCanvas;
import mobileforce.slicetherope.canvas.LanguageCanvas;
import mobileforce.slicetherope.canvas.LevelCanvas;
import mobileforce.slicetherope.canvas.MenuCanvas;
import mobileforce.slicetherope.canvas.ScoreMenuCanvas;
import mobileforce.slicetherope.canvas.SimulationCanvas;
import mobileforce.slicetherope.level.Level_01;
import mobileforce.slicetherope.level.Level_02;
import mobileforce.slicetherope.level.Level_03;
import mobileforce.slicetherope.level.Level_04;
import mobileforce.slicetherope.level.Level_05;
import mobileforce.slicetherope.level.Level_06;
import mobileforce.slicetherope.level.Level_07;
import mobileforce.slicetherope.level.Level_08;
import mobileforce.slicetherope.level.Level_09;
import mobileforce.slicetherope.level.Level_10;
import mobileforce.slicetherope.level.Level_11;
import mobileforce.slicetherope.level.Level_12;
import mobileforce.slicetherope.level.Level_13;
import mobileforce.slicetherope.level.Level_14;
import mobileforce.slicetherope.level.Level_15;
import mobileforce.slicetherope.level.Level_16;
import mobileforce.slicetherope.level.Level_17;
import mobileforce.slicetherope.level.Level_18;
import mobileforce.slicetherope.level.Level_19;
import mobileforce.slicetherope.level.Level_20;
import mobileforce.slicetherope.level.Level_21;
import mobileforce.slicetherope.level.Level_22;
import mobileforce.slicetherope.level.Level_23;
import mobileforce.slicetherope.level.Level_24;
import mobileforce.slicetherope.level.Level_25;
import mobileforce.slicetherope.level.Level_26;
import mobileforce.slicetherope.level.Level_27;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.world.AboutWorld;
import mobileforce.slicetherope.world.FinishWorld;
import mobileforce.slicetherope.world.LanguageWorld;
import mobileforce.slicetherope.world.LevelWorld;
import mobileforce.slicetherope.world.MenuWorld;
import mobileforce.slicetherope.world.ScoreMenuWorld;
import mobileforce.slicetherope.world.SimulationWorld;

public class GameEngine
extends MIDlet {
    private SimulationCanvas simulationCanvas;
    private Display display = Display.getDisplay((MIDlet)this);
    private MenuCanvas mainMenu;
    private boolean in_game = false;
    public static boolean startes = false;
    public static MIDlet MIDLET;
    private boolean win;
    int game_level;
    public int game_score;

    public GameEngine() {
        this.setMainMenu();
        this.init();
        this.win = false;
    }

    public void setWin(boolean win) {
        this.win = win;
    }

    public boolean isWin() {
        return this.win;
    }

    public void init() {
        this.levelInit();
        this.canvasInit();
    }

    public void canvasInit() {
        this.simulationCanvas = new SimulationCanvas();
        this.simulationCanvas.setFullScreenMode(true);
    }

    public void levelInit() {
        this.game_level = 0;
        this.game_score = 0;
    }

    public void mainMenuCommand() throws Exception {
        try {
            this.in_game = false;
            this.setMainMenu();
            if (this.simulationCanvas != null) {
                this.simulationCanvas.end();
            }
            this.levelInit();
            this.display.setCurrent((Displayable)this.mainMenu);
        }
        catch (Exception p) {
            throw new Exception();
        }
    }

    private void setMainMenu() {
        if (this.mainMenu == null) {
            this.mainMenu = new MenuCanvas();
            this.mainMenu.setFullScreenMode(true);
            PhysicsFileReader reader = new PhysicsFileReader("/menu.phy");
            MenuWorld world = new MenuWorld(World.loadWorld(reader));
            world.jitter();
            this.mainMenu.setEngine(this);
            this.mainMenu.setWorld(world);
        }
        this.mainMenu.refineLang();
    }

    public void language() {
        LanguageCanvas canvas = new LanguageCanvas();
        canvas.setFullScreenMode(true);
        PhysicsFileReader reader = new PhysicsFileReader("/language.phy");
        LanguageWorld world = new LanguageWorld(World.loadWorld(reader));
        world.jitter();
        canvas.setEngine(this);
        canvas.setWorld(world);
        this.display.setCurrent((Displayable)canvas);
    }

    public void select_level() {
        LevelCanvas canvas = new LevelCanvas();
        canvas.setFullScreenMode(true);
        PhysicsFileReader reader = new PhysicsFileReader("/level.phy");
        LevelWorld world = new LevelWorld(World.loadWorld(reader));
        world.jitter();
        canvas.setEngine(this);
        canvas.setWorld(world);
        this.display.setCurrent((Displayable)canvas);
    }

    public void startApp() {
        if (!startes) {
            MIDLET = this;
            this.setMainMenu();
            this.display.setCurrent((Displayable)this.mainMenu);
            startes = true;
        } else if (this.in_game) {
            this.simulationCanvas.resume();
        }
        Constants.loadScoreFromFile();
        this.game_level = Constants.LAST_LEVEL_PLAYED;
    }

    public void pauseApp() {
        if (this.simulationCanvas != null) {
            this.simulationCanvas.pause();
        }
        Constants.saveScoreToFile();
    }

    public void destroyApp(boolean unconditional) {
        this.simulationCanvas.end();
        this.mainMenu = null;
        this.display.setCurrent(null);
        Constants.saveScoreToFile();
    }

    public void play() {
        this.in_game = true;
        if (this.simulationCanvas != null) {
            this.simulationCanvas.end();
            this.simulationCanvas.setFullScreenMode(true);
        } else {
            this.simulationCanvas = new SimulationCanvas();
        }
        String name = Constants.levelWorldNames[this.game_level];
        PhysicsFileReader reader = new PhysicsFileReader(name);
        World w = World.loadWorld(reader);
        SimulationWorld world = this.chooseLevel(this.game_level, w);
        world.jitter();
        if (this.game_level == 0) {
            this.refinePosData(world);
        }
        this.simulationCanvas.setEngine(this);
        this.simulationCanvas.setWorld(world);
        this.display.setCurrent((Displayable)this.simulationCanvas);
    }

    private SimulationWorld chooseLevel(int level, World world) {
        SimulationWorld simulationwordl = null;
        switch (level + 1) {
            case 1: {
                simulationwordl = new Level_01(world);
                break;
            }
            case 2: {
                simulationwordl = new Level_02(world);
                break;
            }
            case 3: {
                simulationwordl = new Level_03(world);
                break;
            }
            case 4: {
                simulationwordl = new Level_04(world);
                break;
            }
            case 5: {
                simulationwordl = new Level_05(world);
                break;
            }
            case 6: {
                simulationwordl = new Level_06(world);
                break;
            }
            case 7: {
                simulationwordl = new Level_07(world);
                break;
            }
            case 8: {
                simulationwordl = new Level_08(world);
                break;
            }
            case 9: {
                simulationwordl = new Level_09(world);
                break;
            }
            case 10: {
                simulationwordl = new Level_10(world);
                break;
            }
            case 11: {
                simulationwordl = new Level_11(world);
                break;
            }
            case 12: {
                simulationwordl = new Level_12(world);
                break;
            }
            case 13: {
                simulationwordl = new Level_13(world);
                break;
            }
            case 14: {
                simulationwordl = new Level_14(world);
                break;
            }
            case 15: {
                simulationwordl = new Level_15(world);
                break;
            }
            case 16: {
                simulationwordl = new Level_16(world);
                break;
            }
            case 17: {
                simulationwordl = new Level_17(world);
                break;
            }
            case 18: {
                simulationwordl = new Level_18(world);
                break;
            }
            case 19: {
                simulationwordl = new Level_19(world);
                break;
            }
            case 20: {
                simulationwordl = new Level_20(world);
                break;
            }
            case 21: {
                simulationwordl = new Level_21(world);
                break;
            }
            case 22: {
                simulationwordl = new Level_22(world);
                break;
            }
            case 23: {
                simulationwordl = new Level_23(world);
                break;
            }
            case 24: {
                simulationwordl = new Level_24(world);
                break;
            }
            case 25: {
                simulationwordl = new Level_25(world);
                break;
            }
            case 26: {
                simulationwordl = new Level_26(world);
                break;
            }
            case 27: {
                simulationwordl = new Level_27(world);
                break;
            }
            default: {
                simulationwordl = new SimulationWorld(world);
            }
        }
        return simulationwordl;
    }

    public void play(int level) {
        this.game_level = level;
        this.play();
    }

    void refinePosData(SimulationWorld world) {
        int dx = -40;
        int dy = 50;
        int i = 0;
        while (i < world.getBodyCount()) {
            Body b = world.getBodies()[i];
            if (b != null && b.shape().getId() != 5) {
                FXVector pos = b.positionFX();
                int x = pos.xAsInt() + dx;
                int y = pos.yAsInt() + dy;
                world.getBodies()[i].setPositionFX(new FXVector(FXUtil.toFX(x), FXUtil.toFX(y)));
            }
            ++i;
        }
    }

    public void scoreMenuCommand() {
        this.simulationCanvas.end();
        ScoreMenuCanvas canvas = new ScoreMenuCanvas();
        canvas.setFullScreenMode(true);
        PhysicsFileReader reader = new PhysicsFileReader("/level_score_menu.phy");
        ScoreMenuWorld world = new ScoreMenuWorld(World.loadWorld(reader));
        world.jitter();
        canvas.setEngine(this);
        canvas.setWorld(world);
        this.display.setCurrent((Displayable)canvas);
        this.saveScore();
    }

    public void saveScore() {
        int stars = this.game_score;
        int level = this.game_level;
        Constants.saveScore(level, stars);
    }

    public void showAbout() {
        this.simulationCanvas.end();
        AboutCanvas canvas = new AboutCanvas();
        canvas.setFullScreenMode(true);
        PhysicsFileReader reader = new PhysicsFileReader("/about.phy");
        AboutWorld world = new AboutWorld(World.loadWorld(reader));
        world.jitter();
        canvas.setEngine(this);
        canvas.setWorld(world);
        this.display.setCurrent((Displayable)canvas);
    }

    public void exit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void reply() {
        this.play();
    }

    public void gameOver() {
        this.canvasInit();
        this.play();
    }

    public void next() {
        if (this.game_level + 1 < Constants.levelWorldNames.length) {
            ++this.game_level;
            this.play();
        } else {
            this.showEnd();
        }
    }

    public void showEnd() {
        this.simulationCanvas.end();
        PhysicsFileReader reader = new PhysicsFileReader("/end_level.phy");
        FinishWorld world = new FinishWorld(World.loadWorld(reader));
        world.jitter();
        FinishCanvas canvas = new FinishCanvas(world);
        canvas.setFullScreenMode(true);
        ((GameCanvas)canvas).setEngine(this);
        this.display.setCurrent((Displayable)canvas);
    }

    public void showMainMenu() {
        try {
            this.mainMenuCommand();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showScoreMenu() {
        this.scoreMenuCommand();
    }

    public int getGame_score() {
        return this.game_score;
    }

    public void setGame_score(int game_score) {
        this.game_score = game_score;
    }
}

