/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.world;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Spring;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.userdata.BodyPointer;
import mobileforce.slicetherope.util.Calculation;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.FontFactory;
import mobileforce.slicetherope.util.Utility;
import mobileforce.slicetherope.world.GameWorld;

public class SimulationWorld
extends GameWorld {
    Vector ropeImgSet;
    protected Object[] lbody_point;
    boolean isExistBubble;
    protected World loaded_world;
    protected int pumpPower;
    private Hashtable cache_image;
    protected Body[] the_star = new Body[3];
    protected Body the_frog;
    private Image platform_image;
    private Image pump_sprite;
    private Body current_pump = null;
    protected int tutorial_possition_x = -1;
    protected int tutorial_possition_y = -1;
    protected int tutorial_width = -1;
    protected int tutorial_height = -1;
    protected String[] tutorial_text = null;
    protected static final int FONT_HEIGHT = 13;
    protected static final int FONT_WIDTH = 8;
    protected static final int padding = 5;
    protected boolean springEnable = false;
    protected static Font THE_FONT = FontFactory.WORLD_TEXT;

    public SimulationWorld(World w) {
        super(w);
        this.loaded_world = w;
        this.pumpPower = 640;
        this.cache_image = new Hashtable();
        this.initRopeData();
        this.initPoint();
        this.platform_image = Constants.getImage("/platform.png");
        this.pump_sprite = Constants.getImage("/pump_02.png");
    }

    public void setCurrentPump(Body pump) {
        this.current_pump = pump;
    }

    public Image getPlatformImage() {
        return this.platform_image;
    }

    public int getPumpPower() {
        return this.pumpPower;
    }

    protected void initPoint() {
        Body[] body = this.getBodies();
        int index = 0;
        while (index < body.length) {
            Body b = body[index];
            if (b != null) {
                BodyPointer dv = new BodyPointer("", index, null);
                b.setUserData(dv);
            }
            ++index;
        }
        Constraint[] cons = this.getConstraints();
        int index2 = 0;
        while (index2 < cons.length) {
            Constraint c = cons[index2];
            if (c != null && c instanceof Spring) {
                Spring spring = (Spring)c;
                BodyPointer dv = new BodyPointer("", index2, null);
                spring.setUserData(dv);
            }
            ++index2;
        }
    }

    public Body[] getStars() {
        return this.the_star;
    }

    public Body getFrog() {
        return this.the_frog;
    }

    public Object[] getBodyPoint() {
        return this.lbody_point;
    }

    public void draw(Graphics g) {
        if (this.tutorial_possition_x != -1) {
            g.setColor(0xAAAAFF);
            g.fillRect(this.tutorial_possition_x, this.tutorial_possition_y, this.tutorial_width, this.tutorial_height);
            g.setFont(THE_FONT);
            g.setColor(0xEEEEEE);
            int x = 0;
            while (x < this.tutorial_text.length) {
                g.drawString(this.tutorial_text[x], this.tutorial_possition_x + 5, this.tutorial_possition_y + 5 + 13 * x, 20);
                ++x;
            }
        }
        Body candy = null;
        Body buble = null;
        int bodyCount = this.getBodyCount();
        Body[] bodies = this.getBodies();
        int constraintCount = this.getConstraintCount();
        Constraint[] constraints = this.getConstraints();
        int i = 0;
        while (i < bodyCount) {
            if (bodies[i].shape().getId() == 3) {
                candy = bodies[i];
            }
            if (bodies[i].shape().getId() == 7) {
                buble = bodies[i];
            } else {
                this.drawBody(g, bodies[i]);
                this.drawNumber(g, bodies[i]);
            }
            ++i;
        }
        i = 0;
        while (i < bodyCount) {
            if (bodies[i].shape().getId() != 3 && bodies[i].shape().getId() != 7) {
                this.drawNumber(g, bodies[i]);
            }
            ++i;
        }
        if (this.springEnable) {
            g.setColor(0, 0, 0);
            i = 0;
            while (i < constraintCount) {
                if (constraints[i] instanceof Spring) {
                    Spring spring = (Spring)constraints[i];
                    int x0 = spring.getPoint1().xAsInt();
                    int y0 = spring.getPoint1().yAsInt();
                    int x1 = spring.getPoint2().xAsInt();
                    int y1 = spring.getPoint2().yAsInt();
                    g.drawLine(x0, y0, x1, y1);
                    this.drawNumber(g, spring);
                }
                ++i;
            }
        }
        this.drawBody(g, candy);
        this.drawBody(g, buble);
        this.drawNumber(g, buble);
    }

    void initRopeData() {
        this.ropeImgSet = new Vector();
        this.numImages = Constants.rope_data.length;
        this.ropeImgSet.setSize(Constants.rope_data.length);
        int i = 0;
        while (i < this.numImages) {
            Image img = Constants.getImage(Constants.rope_data[i]);
            this.ropeImgSet.setElementAt(img, i);
            ++i;
        }
    }

    public boolean isExistBubble() {
        return this.isExistBubble;
    }

    public void setExistBubble(boolean isExistBubble) {
        this.isExistBubble = isExistBubble;
    }

    public void drawBody(Graphics g, Body b) {
        if (b == null) {
            return;
        }
        int shapeId = b.shape().getId();
        Image img = this.shapeSet.getImage(b);
        int x = b.positionFX().xAsInt();
        int y = b.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        int angle = b.rotation2FX();
        if (img != null) {
            switch (shapeId) {
                case 1: {
                    b.setRotation2FX(angle + 5270717);
                    this.drawSprite(g, img, x, y, angle, 4);
                    break;
                }
                case 2: {
                    b.setRotation2FX(angle + 5270717);
                    this.drawImage(g, this.platform_image, x, y + 20);
                    this.drawSprite(g, img, x, y, angle, 5);
                    break;
                }
                case 4: {
                    if (b.getUserData() != null) break;
                    this.drawRopeImage(g, x, y, angle);
                    break;
                }
                case 6: {
                    this.drawSpike(g, b, img);
                    break;
                }
                case 7: {
                    b.setRotation2FX(angle + 5270717);
                    this.drawSprite(g, img, x, y, angle, 13);
                    break;
                }
                case 8: {
                    if (b != this.current_pump && this.current_pump != null) {
                        this.drawStaticRotateImage(g, b, img, x, y);
                        break;
                    }
                    this.drawStaticRotateImage(g, b, this.pump_sprite, x, y);
                    this.current_pump = null;
                    break;
                }
                case 9: {
                    this.drawStaticRotateImage(g, b, img, x, y);
                    break;
                }
                case 0: 
                case 3: 
                case 10: 
                case 11: {
                    this.drawImage(g, img, x, y);
                    break;
                }
            }
        }
    }

    public void drawImageRotate(Graphics g, Body b, Image img, int x, int y) {
        try {
            int rotat = Utility.RotationFXToDegree(b.rotation2FX());
            Image hasil = Utility.rotate(img, img.getWidth() / 2, img.getHeight() / 2, 360 - rotat, new int[2]);
            g.drawImage(hasil, x, y, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawStaticRotateImage(Graphics g, Body b, Image img, int x, int y) {
        Object obj = this.cache_image.get(b);
        if (obj == null) {
            int rotat = Utility.RotationFXToDegree(b.rotation2FX());
            Image hasil = Utility.rotate(img, img.getWidth() / 2, img.getHeight() / 2, 360 - rotat, new int[2]);
            g.drawImage(hasil, x, y, 3);
            this.cache_image.put(b, hasil);
        } else {
            Image hasil = (Image)obj;
            g.drawImage(hasil, x, y, 3);
        }
    }

    public void drawSpike(Graphics g, Body b, Image img) {
        Object obj = this.cache_image.get(b);
        int x = b.positionFX().xAsInt();
        int y = b.positionFX().yAsInt();
        x = Constants.fromWorldX2(x);
        y = Constants.fromWorldY2(y);
        if (obj == null) {
            FXVector[] positions = b.getVertices();
            g.setColor(4535339);
            int x0 = positions[0].xAsInt();
            int y0 = positions[0].yAsInt();
            int x1 = positions[1].xAsInt();
            int y1 = positions[1].yAsInt();
            int atan = Calculation.atan(x0 - x1, y0 - y1);
            int[] dd = new int[2];
            Image baru = Utility.rotate(img, img.getWidth() / 2, img.getHeight() / 2, atan, dd);
            g.drawImage(baru, x, y, 3);
        } else {
            Image baru = (Image)obj;
            g.drawImage(baru, x, y, 3);
        }
    }

    public void drawRopeImage(Graphics g, int x, int y, int angle) {
        int tranIdx;
        int index;
        this.numImages = Constants.rope_data.length;
        int rotFX = angle + 13176794 / this.numImages;
        if (rotFX > 105414356) {
            rotFX -= 105414356;
        }
        if ((index = (rotFX - (tranIdx = rotFX / 26353589) * 52707178 / 2) / (26353589 / this.numImages)) < 0 || index >= this.numImages) {
            return;
        }
        int tranfom = 0;
        switch (tranIdx) {
            case 1: {
                tranfom = 5;
                break;
            }
            case 2: {
                tranfom = 3;
                break;
            }
            case 3: {
                tranfom = 6;
                break;
            }
        }
        Image img = (Image)this.ropeImgSet.elementAt(index);
        if (img == null) {
            return;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        g.drawRegion(img, 0, 0, w, h, tranfom, x, y, 3);
    }

    public void drawSprite(Graphics g, Image img, int x, int y, int angle, int total) {
        int h = img.getHeight();
        int w = img.getWidth() / total;
        int rotFX = angle;
        if (rotFX > 52707178) {
            rotFX -= 52707178;
        }
        int index = rotFX / (52707178 / total);
        int tranfom = 0;
        g.drawRegion(img, index * w, 0, w, h, tranfom, x, y, 3);
    }

    public void simWordlProses(Body candy) {
    }

    public void turnGravity(int degrees) {
        FXMatrix rotation = FXMatrix.createRotationMatrix((int)((long)degrees * 52707178L / 180L));
        this.setGravity(rotation.mult(this.getGravity()));
    }
}

