/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.world;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.language.LangController;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.FontFactory;
import mobileforce.slicetherope.world.GameWorld;

public class LevelWorld
extends GameWorld {
    int current_body = 1;
    int current_level = 0;
    int current_page = 0;
    static final int MAX_ROW = 3;
    static final int MAX_COLUMN = 3;
    static final int[] column_index;
    static int HEIGHT_LEVEL;
    static int WIDTH_LEVEL;
    static final int GAP_LEVEL = 3;
    Image bg_headline;
    Image frog;
    Image[][] leveling = new Image[2][4];
    Image button_back_on;
    Image button_back_off;
    String title = LangController.getInstance().level_title();
    int SELECT = 1;
    int UNSELECT = 0;

    static {
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 1;
        column_index = nArray;
        HEIGHT_LEVEL = 0;
        WIDTH_LEVEL = 0;
    }

    public static int MaxNUmber() {
        return 9;
    }

    public LevelWorld(World w) {
        super(w);
        this.initImage();
    }

    public void setPage(int page) {
        this.current_page = page;
    }

    public void current_select(int current, int page, int level) {
        this.current_body = current;
        this.current_level = level;
        this.current_page = page;
    }

    private void initImage() {
        this.button_back_off = Constants.getImage("/button_back.png");
        this.button_back_on = Constants.getImage("/button_back_select.png");
        this.bg_headline = Constants.getImage("/bg_headline.png");
        this.frog = Constants.getImage("/monster_menu.png");
        this.leveling[0][0] = Constants.getImage("/bg_level_0s.png");
        this.leveling[0][1] = Constants.getImage("/bg_level_1s.png");
        this.leveling[0][2] = Constants.getImage("/bg_level_2s.png");
        this.leveling[0][3] = Constants.getImage("/bg_level_3s.png");
        this.leveling[1][0] = Constants.getImage("/bg_level_0s_select.png");
        this.leveling[1][1] = Constants.getImage("/bg_level_1s_select.png");
        this.leveling[1][2] = Constants.getImage("/bg_level_2s_select.png");
        this.leveling[1][3] = Constants.getImage("/bg_level_3s_select.png");
        Image sample = this.leveling[0][0];
        HEIGHT_LEVEL = sample.getHeight();
        WIDTH_LEVEL = sample.getWidth();
    }

    public void drawBody(Graphics g, Body b) {
        if (b == null) {
            return;
        }
        int id = b.shape().getId();
        int x = b.positionFX().xAsInt();
        int y = b.positionFX().yAsInt();
        x = Constants.fromWorldX(x);
        y = Constants.fromWorldY(y);
        g.setColor(15363584);
        g.setFont(FontFactory.LEVEL_MENU);
        if (id == 0) {
            this.drawImage(g, this.bg_headline, x, y);
            g.drawString(this.title, x, y + 5, 65);
        } else if (id == 1) {
            int level = this.current_page * 3 * 3;
            int i = 0;
            while (i < 3) {
                int pos_y = i * (WIDTH_LEVEL + 3);
                int j = 0;
                while (j < 3) {
                    int pos_x;
                    if (level < Constants.levelWorldNames.length) {
                        int stars = Constants.LEVEL[level];
                        Image the_image = null;
                        the_image = this.current_level == level && this.current_body == id ? this.leveling[this.SELECT][stars] : this.leveling[this.UNSELECT][stars];
                        pos_x = (j - 1) * (WIDTH_LEVEL + 3);
                        this.drawImage(g, the_image, x + pos_x, y + pos_y);
                        if (++level - 1 > Constants.LAST_LEVEL) {
                            g.setColor(4535339);
                        }
                    } else {
                        return;
                    }
                    g.drawString(String.valueOf(level), x + pos_x, y + pos_y + 5, 65);
                    ++j;
                }
                ++i;
            }
        } else if (id == 2) {
            if (this.current_body == 2) {
                this.drawImage(g, this.button_back_on, x, y);
            } else {
                this.drawImage(g, this.button_back_off, x, y);
            }
        } else if (id == 3) {
            this.drawImage(g, this.frog, x, y);
        }
    }
}

