/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.world;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.userdata.BodyPointer;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.GraphicsShapeSet;

public class GameWorld
extends World {
    private Random random = new Random();
    public GraphicsShapeSet shapeSet = new GraphicsShapeSet();
    int numImages = 6;

    public GameWorld(World w) {
        super(w);
    }

    public void jitter() {
        Body[] bodies = this.getBodies();
        int i = 0;
        while (i < this.getBodyCount()) {
            this.jitter(bodies[i]);
            ++i;
        }
    }

    private void jitter(Body b) {
        int jitterFX = 1024;
        b.positionFX().add(new FXVector(this.random.nextInt() % jitterFX, this.random.nextInt() % jitterFX));
    }

    public void draw(Graphics g) {
        int bodyCount = this.getBodyCount();
        Body[] bodies = this.getBodies();
        int constraintCount = this.getConstraintCount();
        Constraint[] constraints = this.getConstraints();
        int i = 0;
        while (i < bodyCount) {
            this.drawBody(g, bodies[i]);
            this.drawNumber(g, bodies[i]);
            ++i;
        }
        g.setColor(0, 0, 0);
        i = 0;
        while (i < constraintCount) {
            if (constraints[i] instanceof Spring) {
                Spring spring = (Spring)constraints[i];
                int x0 = spring.getPoint1().xAsInt();
                int y0 = spring.getPoint1().yAsInt();
                int x1 = spring.getPoint2().xAsInt();
                int y1 = spring.getPoint2().yAsInt();
                g.drawLine(x0, y0, x1, y1);
                this.drawNumber(g, spring);
            }
            ++i;
        }
    }

    public void drawBody(Graphics g, Body b) {
    }

    public void drawNumber(Graphics g, Body b) {
        if (b == null) {
            return;
        }
        UserData ud = b.getUserData();
        if (ud != null && ud instanceof BodyPointer) {
            BodyPointer dv = (BodyPointer)ud;
            String number = String.valueOf(dv.getPoint()) + dv.getData();
            int x = b.positionFX().xAsInt();
            int y = b.positionFX().yAsInt();
            x = Constants.fromWorldX2(x);
            y = Constants.fromWorldY2(y);
            g.setColor(0xFF0000);
            g.fillArc(x - 5, y - 5, 10, 10, 0, 360);
            g.setColor(0xFFFFFF);
            g.setStrokeStyle(0);
            g.drawString(number, x - 5, y - 5, 20);
        }
    }

    public void drawNumber(Graphics g, Spring b) {
        if (b == null) {
            return;
        }
        UserData ud = b.getUserData();
        if (ud != null && ud instanceof BodyPointer) {
            BodyPointer dv = (BodyPointer)ud;
            String number = String.valueOf(dv.getPoint()) + dv.getData();
            int x0 = b.getPoint1().xAsInt();
            int y0 = b.getPoint1().yAsInt();
            int x1 = b.getPoint2().xAsInt();
            int y1 = b.getPoint2().yAsInt();
            int x = (x0 + x1) / 2;
            int y = (y0 + y1) / 2;
            g.setColor(0xFF0000);
            g.fillArc(x - 5, y - 5, 10, 10, 0, 360);
            g.setColor(0xFFFFFF);
            g.setStrokeStyle(0);
            g.drawString(number, x - 5, y - 5, 20);
        }
    }

    public void drawBodyArc(Graphics g, Body b) {
        FXVector[] positions = b.getVertices();
        if (positions.length == 1) {
            int radius = b.shape().getBoundingRadiusFX() >> 12;
            g.setColor(0);
            g.drawArc(b.positionFX().xAsInt() - radius, b.positionFX().yAsInt() - radius, radius * 2, radius * 2, 0, 360);
        } else {
            g.setColor(0);
            int i = 0;
            while (i < positions.length - 1) {
                g.drawLine(positions[i].xAsInt(), positions[i].yAsInt(), positions[i + 1].xAsInt(), positions[i + 1].yAsInt());
                ++i;
            }
            g.drawLine(positions[positions.length - 1].xAsInt(), positions[positions.length - 1].yAsInt(), positions[0].xAsInt(), positions[0].yAsInt());
        }
    }

    public void drawImageRotate(Graphics g, Image img, int x, int y) {
    }

    public void drawImage(Graphics g, Image img, int x, int y) {
        if (img == null) {
            return;
        }
        try {
            g.drawImage(img, x, y, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

