/*
 * Decompiled with CFR 0.152.
 */
package mobileforce.slicetherope.world;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobileforce.slicetherope.language.LangController;
import mobileforce.slicetherope.util.Constants;
import mobileforce.slicetherope.util.FontFactory;
import mobileforce.slicetherope.world.GameWorld;

public class FinishWorld
extends GameWorld {
    Image image_star;
    Image image_again;
    String game_done;
    String again;
    String score = Constants.getLastScore();
    static final int isStar = 0;
    static final int isScore = 1;
    static final int isText = 2;
    static final int isAgain = 3;

    public FinishWorld(World w) {
        super(w);
        this.initImage();
    }

    private void initImage() {
        this.image_star = Constants.getImage("/star_end_full.png");
        this.image_again = Constants.getImage("/monster_again.png");
        this.game_done = LangController.getInstance().finish_done();
        this.again = LangController.getInstance().again();
    }

    public void draw(Graphics g) {
        super.draw(g);
    }

    public void drawBody(Graphics g, Body b) {
        if (b == null) {
            return;
        }
        int x = b.positionFX().xAsInt();
        int y = b.positionFX().yAsInt();
        x = Constants.fromWorldX(x);
        y = Constants.fromWorldY(y);
        switch (b.shape().getId()) {
            case 0: {
                g.drawImage(this.image_star, x, y, 17);
                break;
            }
            case 1: {
                this.drawString(g, x, y, this.score);
                break;
            }
            case 2: {
                this.drawString(g, x, y, this.game_done);
                break;
            }
            case 3: {
                g.drawImage(this.image_again, x, y, 17);
                this.drawString(g, x, y + this.image_again.getHeight() - 10, this.again);
            }
        }
    }

    public void drawString(Graphics g, int x, int y, String string) {
        g.setFont(FontFactory.FINISH_TITLE);
        g.setColor(4535339);
        g.drawString(string, x, y + 5, 65);
    }
}

