/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinoquiz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.handyx.api.BasicSoundManager;
import net.handyx.api.FontRenderer;
import net.handyx.api.RecordManager;
import net.handyx.api.RunnableCanvas;
import net.handyx.api.Toast;

public class GameRes {
    public static final String RES_FOLDER = "";
    public static final boolean SOUND_SUPPORTS_VOLUME = false;
    public static final boolean DISABLE_ALPHA_EFFECTS = false;
    public static String VERSION_STRING = "1.0.0";
    public static final boolean DISABLE_ANIMATING_PANELS = false;
    public static boolean debug = true;
    public static boolean setting_sound = true;
    public static int setting_sound_volume = 50;
    public static boolean setting_countdown = false;
    public static boolean setting_show_answers = true;
    public static final String[] soundResources = new String[]{"applause", "incorrect", "joker", "whistle_end_lose", "whistle_end_win", "whistle_start"};
    public static boolean soundEnabled = false;
    public static BasicSoundManager soundMan = null;
    public static boolean useVolumeControl = true;
    public static boolean supportsMixing = false;
    public static FontRenderer gameFont;
    public static FontRenderer gameBlackFont;
    public static FontRenderer whiteFont;
    public static Image bgImage;
    public static Image menuBarImage;
    public static Image scrollBarOnImage;
    public static Image scrollBarOffImage;
    public static Image quizTitleImage;
    public static Image meshImage;
    public static Image scrollImage;
    public static Image yesOnImage;
    public static Image yesOffImage;
    public static Image noOnImage;
    public static Image noOffImage;
    public static boolean resourcesLoaded;
    public static final int QUESTION_IMAGE_HEIGHT = 75;
    public static final int QUESTION_IMAGE_WIDTH = 225;
    private static boolean a;
    public static Image rouletteTableImage;
    public static Image rouletteChip1Image;
    public static Image rouletteChip2Image;
    public static Image crapsTableTopImage;
    public static Image crapsTableBottomImage;
    public static Image bjCardBaseImage;
    public static Image bjCardLabelsImage;
    public static Image cardBaseImage;
    public static Image cardNumbersImage;
    private static Random b;
    public static Vector toastQueue;

    public static void purgeResources() {
        resourcesLoaded = false;
        menuBarImage = null;
        quizTitleImage = null;
        bgImage = null;
        scrollBarOffImage = null;
        scrollBarOnImage = null;
        if (gameFont != null) {
            gameFont.purge();
            gameFont = null;
        }
        if (gameBlackFont != null) {
            gameBlackFont.purge();
            gameBlackFont = null;
        }
        if (whiteFont != null) {
            whiteFont.purge();
            whiteFont = null;
        }
        System.gc();
    }

    public static void loadResources() {
        if (resourcesLoaded) {
            return;
        }
        gameFont = new FontRenderer("/fonts/komik_thin_white_16pt");
        gameBlackFont = new FontRenderer("/fonts/komik_thin_black_16pt");
        whiteFont = new FontRenderer("/fonts/komik_thin_white");
        try {
            if (soundMan == null) {
                soundMan = new BasicSoundManager();
                if (useVolumeControl) {
                    soundMan.enableVolumeControl();
                }
                soundMan.setSounds(soundResources);
                soundMan.loadSounds();
                soundMan.start();
            }
            bgImage = RunnableCanvas.loadImage("/bg.png");
            quizTitleImage = RunnableCanvas.loadImage("/quiz_title.png");
            menuBarImage = RunnableCanvas.loadImage("/menu_bar.png");
            scrollBarOnImage = RunnableCanvas.loadImage("/scrollbar_on.png");
            scrollBarOffImage = RunnableCanvas.loadImage("/scrollbar_off.png");
            resourcesLoaded = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void loadGameResources() {
        if (a) {
            return;
        }
        try {
            rouletteTableImage = RunnableCanvas.loadImage("/question_images/roulette.png");
            rouletteChip1Image = RunnableCanvas.loadImage("/question_images/roulette_chip.png");
            rouletteChip2Image = RunnableCanvas.loadImage("/question_images/roulette_chip2.png");
            crapsTableTopImage = RunnableCanvas.loadImage("/question_images/craps_top.png");
            crapsTableBottomImage = RunnableCanvas.loadImage("/question_images/craps_bottom.png");
            bjCardBaseImage = RunnableCanvas.loadImage("/question_images/bj_card_bases.png");
            bjCardLabelsImage = RunnableCanvas.loadImage("/question_images/bj_card_labels.png");
            cardBaseImage = RunnableCanvas.loadImage("/question_images/card_bases.png");
            cardNumbersImage = RunnableCanvas.loadImage("/question_images/card_nums.png");
            a = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void purgeGameResources() {
        if (!a) {
            return;
        }
        rouletteChip2Image = null;
        rouletteChip1Image = null;
        rouletteTableImage = null;
        crapsTableBottomImage = null;
        crapsTableTopImage = null;
        cardNumbersImage = null;
        cardBaseImage = null;
        bjCardLabelsImage = null;
        bjCardBaseImage = null;
        a = false;
        System.gc();
    }

    public static void renderQuestionImage(Graphics graphics, String string, int n, int n2, int n3) {
        if (!a) {
            return;
        }
        if (string.startsWith("bjhand")) {
            Object object = string.substring(string.indexOf("(") + 1);
            object = ((String)object).substring(0, ((String)object).indexOf(")"));
            object = FontRenderer.splitString(" ", (String)object);
            int n4 = (n - 225) / 2;
            n4 += 26;
            n4 += GameRes.a(graphics, (String)((Vector)object).elementAt(0), n4, n3, false);
            n4 += GameRes.a(graphics, (String)((Vector)object).elementAt(1), n4, n3, false);
            GameRes.a(graphics, (String)((Vector)object).elementAt(2), n4 += 14, n3, true);
            graphics.setClip(0, 0, n, n2);
            n4 = (n - 225) / 2;
            graphics.drawImage(bjCardLabelsImage, n4 + 47, n3 + 70, 20);
        } else if (string.startsWith("hand")) {
            Object object = string.substring(string.indexOf("(") + 1);
            object = ((String)object).substring(0, ((String)object).indexOf(")"));
            object = FontRenderer.splitString(" ", (String)object);
            int n5 = (n - ((Vector)object).size() * 43) / 2;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                string = (String)((Vector)object).elementAt(i);
                n5 += GameRes.a(graphics, string, n5, n3, false);
            }
        } else if (string.startsWith("roulette") || string.startsWith("craps")) {
            Object object = string.substring(string.indexOf("(") + 1);
            object = ((String)object).substring(0, ((String)object).indexOf(")"));
            object = FontRenderer.splitString(",", (String)object);
            int n6 = Integer.parseInt(((String)((Vector)object).elementAt(0)).trim());
            int n7 = Integer.parseInt(((String)((Vector)object).elementAt(1)).trim());
            n6 >>= 1;
            n7 >>= 1;
            int n8 = (n - 225) / 2;
            n6 += n8;
            n7 += n3;
            if (string.startsWith("roulette1")) {
                graphics.drawImage(rouletteTableImage, n8, n3, 20);
                graphics.drawImage(rouletteChip1Image, n6, n7, 20);
            } else if (string.startsWith("roulette2")) {
                graphics.drawImage(rouletteTableImage, n8, n3, 20);
                graphics.drawImage(rouletteChip2Image, n6, n7, 20);
            } else if (string.startsWith("craps1")) {
                graphics.drawImage(crapsTableTopImage, n8, n3, 20);
                graphics.drawImage(rouletteChip1Image, n6, n7, 20);
            } else if (string.startsWith("craps2")) {
                graphics.drawImage(crapsTableBottomImage, n8, n3, 20);
                graphics.drawImage(rouletteChip1Image, n6, n7, 20);
            }
        }
        graphics.setClip(0, 0, n, n2);
    }

    private static int a(Graphics graphics, String string, int n, int n2, boolean bl) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n3 = 43;
        int n4 = 4;
        int n5 = 5;
        if (bl) {
            graphics.setClip(n, n2, 58, 69);
            switch (c2) {
                case 'H': 
                case 'h': {
                    graphics.drawImage(bjCardBaseImage, n, n2, 20);
                    break;
                }
                case 'C': 
                case 'c': {
                    graphics.drawImage(bjCardBaseImage, n - 58, n2, 20);
                    break;
                }
                case 'D': 
                case 'd': {
                    graphics.drawImage(bjCardBaseImage, n - 116, n2, 20);
                    break;
                }
                case 'S': 
                case 's': {
                    graphics.drawImage(bjCardBaseImage, n - 174, n2, 20);
                }
            }
            n3 = 58;
            n4 = 20;
            n5 = 8;
        } else {
            graphics.setClip(n, n2, 43, 67);
            switch (c2) {
                case 'H': 
                case 'h': {
                    graphics.drawImage(cardBaseImage, n, n2, 20);
                    break;
                }
                case 'C': 
                case 'c': {
                    graphics.drawImage(cardBaseImage, n - 43, n2, 20);
                    break;
                }
                case 'D': 
                case 'd': {
                    graphics.drawImage(cardBaseImage, n - 86, n2, 20);
                    break;
                }
                case 'S': 
                case 's': {
                    graphics.drawImage(cardBaseImage, n - 129, n2, 20);
                    break;
                }
                case '?': {
                    graphics.drawImage(cardBaseImage, n - 172, n2, 20);
                }
            }
        }
        graphics.setClip(n + n4, n2 + n5, 14, 16);
        if (c2 == 'H' || c2 == 'h' || c2 == 'D' || c2 == 'd') {
            n5 -= 16;
        }
        switch (c) {
            case 'A': 
            case 'a': {
                graphics.drawImage(cardNumbersImage, n + n4, n2 + n5, 20);
                break;
            }
            case '2': {
                graphics.drawImage(cardNumbersImage, n + n4 - 15, n2 + n5, 20);
                break;
            }
            case '3': {
                graphics.drawImage(cardNumbersImage, n + n4 - 30, n2 + n5, 20);
                break;
            }
            case '4': {
                graphics.drawImage(cardNumbersImage, n + n4 - 45, n2 + n5, 20);
                break;
            }
            case '5': {
                graphics.drawImage(cardNumbersImage, n + n4 - 60, n2 + n5, 20);
                break;
            }
            case '6': {
                graphics.drawImage(cardNumbersImage, n + n4 - 75, n2 + n5, 20);
                break;
            }
            case '7': {
                graphics.drawImage(cardNumbersImage, n + n4 - 90, n2 + n5, 20);
                break;
            }
            case '8': {
                graphics.drawImage(cardNumbersImage, n + n4 - 105, n2 + n5, 20);
                break;
            }
            case '9': {
                graphics.drawImage(cardNumbersImage, n + n4 - 120, n2 + n5, 20);
                break;
            }
            case 'T': 
            case 't': {
                graphics.drawImage(cardNumbersImage, n + n4 - 135, n2 + n5, 20);
                break;
            }
            case 'J': 
            case 'j': {
                graphics.drawImage(cardNumbersImage, n + n4 - 150, n2 + n5, 20);
                break;
            }
            case 'Q': 
            case 'q': {
                graphics.drawImage(cardNumbersImage, n + n4 - 165, n2 + n5, 20);
                break;
            }
            case 'K': 
            case 'k': {
                graphics.drawImage(cardNumbersImage, n + n4 - 180, n2 + n5, 20);
            }
        }
        return n3;
    }

    public static int random(int n) {
        if (n == 0) {
            return 0;
        }
        return Math.abs(b.nextInt() % n);
    }

    public static void displayToast(String string) {
        if (toastQueue == null) {
            toastQueue = new Vector();
        }
        toastQueue.addElement(new Toast(string, 3000L));
    }

    public static void processToasts() {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                Toast toast = (Toast)toastQueue.elementAt(i);
                if (!toast.hasExpired()) continue;
                toastQueue.removeElementAt(i);
                --i;
            }
        }
    }

    public static void renderToasts(Graphics graphics) {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                GameRes.renderToast(graphics, (Toast)toastQueue.elementAt(i));
            }
        }
    }

    public static void renderToast(Graphics graphics, Toast stringArray) {
        if (gameFont == null) {
            return;
        }
        int n = RunnableCanvas.screenWidth - 50;
        stringArray = whiteFont.wrap(stringArray.getMessage(), n - 12);
        int n2 = whiteFont.getHeight() * stringArray.length + 15;
        int n3 = RunnableCanvas.screenHeight - n2 - 30;
        graphics.setColor(0);
        graphics.fillRoundRect(25, n3, n, n2, 14, 14);
        for (n = 0; n < stringArray.length; ++n) {
            whiteFont.drawString(graphics, stringArray[n], (RunnableCanvas.screenWidth - whiteFont.stringWidth(stringArray[n])) / 2, n3 + 7 + n * whiteFont.getHeight());
        }
    }

    public static void getVersion(MIDlet object) {
        try {
            object = object.getAppProperty("MIDlet-Version");
            if (object != null) {
                VERSION_STRING = ((String)object).trim();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String loadText(String object) {
        if (object == null) {
            return RES_FOLDER;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = object.getClass().getResourceAsStream(RES_FOLDER + (String)object);
            if (object != null) {
                int n;
                while ((n = ((InputStream)object).read()) != -1) {
                    stringBuffer.append((char)n);
                }
                ((InputStream)object).close();
            }
        }
        catch (Exception exception) {
            object = exception;
            GameRes.log(exception.toString());
        }
        return stringBuffer.toString();
    }

    public static void doSound(String string) {
        if (!soundEnabled || !setting_sound) {
            return;
        }
        if (soundMan != null) {
            soundMan.setVolume(setting_sound_volume);
            soundMan.queueSound(string);
        }
    }

    public static void stopSounds() {
        if (soundMan != null) {
            soundMan.stopSounds();
        }
    }

    public static boolean supportsSound() {
        return true;
    }

    public static void log(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void loadSettings() {
        try {
            if (RecordManager.exists("quiz_settings")) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(RecordManager.load("quiz_settings")));
                setting_countdown = dataInputStream.readBoolean();
                setting_show_answers = dataInputStream.readBoolean();
                setting_sound = dataInputStream.readBoolean();
                setting_sound_volume = dataInputStream.readInt();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveSettings() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(setting_countdown);
            dataOutputStream.writeBoolean(setting_show_answers);
            dataOutputStream.writeBoolean(setting_sound);
            dataOutputStream.writeInt(setting_sound_volume);
            RecordManager.save(byteArrayOutputStream.toByteArray(), "quiz_settings");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        resourcesLoaded = false;
        a = false;
        b = new Random();
        toastQueue = null;
    }
}

