/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SettingsMenuCanvas
extends Canvas {
    public int LINE_SPACING = 6;
    public Image topImage = null;
    public Image[] icons = new Image[10];
    public String[] items_sound = new String[]{"Sound", "Difficulty", "Reset"};
    public String[] icons_sound = new String[]{"sound", "diff", "reset"};
    public String[] items_nosound = new String[]{"Difficulty", "Reset"};
    public String[] icons_nosound = new String[]{"diff", "reset"};
    public String[] items = this.items_sound;
    public String[] list_icons = this.icons_sound;
    public Quiz parent;
    public int selectedIndex = 0;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;

    public SettingsMenuCanvas(Image image, Quiz object) {
        this.setFullScreenMode(true);
        this.topImage = image;
        this.parent = object;
        if (Common.DISABLE_SOUND) {
            this.items = this.items_nosound;
            this.list_icons = this.icons_nosound;
        }
        int n = 1;
        if (this.getWidth() > 128) {
            this.LINE_SPACING = 6;
        } else if (this.getHeight() > 128) {
            this.LINE_SPACING = 6;
        } else {
            n = 0;
            this.LINE_SPACING = 2;
        }
        if (n != 0) {
            for (n = 0; n < this.list_icons.length; ++n) {
                try {
                    this.icons[n] = Image.createImage((String)("/icons/" + this.list_icons[n] + ".png"));
                    continue;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        this.setFullScreenMode(true);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Font font = Font.getFont((int)0, (int)0, (int)0);
        graphics.setFont(font);
        graphics.setColor(0);
        int n = 0;
        if (this.topImage != null) {
            graphics.drawImage(this.topImage, 0, 0, 20);
            n = 0 + this.topImage.getHeight();
        }
        n += this.LINE_SPACING;
        int n2 = Common.fontRenderer.getHeight() + this.LINE_SPACING;
        int n3 = this.LINE_SPACING / 2;
        for (int i = 0; i < this.items.length; ++i) {
            if (i == this.selectedIndex) {
                graphics.setColor(0x333333);
                graphics.fillRect(0, n - n3, this.getWidth(), n2);
                Common.inverseFontRenderer.drawString(graphics, this.items[i], 10, n);
                graphics.setColor(0xFFFFFF);
            } else {
                Common.fontRenderer.drawString(graphics, this.items[i], 10, n);
                graphics.setColor(0);
            }
            if (this.icons[i] != null) {
                int n4 = (n2 - this.icons[i].getHeight()) / 2;
                graphics.drawImage(this.icons[i], this.getWidth() - 25, n - n3 + n4, 20);
            }
            n += Common.fontRenderer.getHeight() + this.LINE_SPACING;
        }
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(0, this.getHeight() - Common.fontRenderer.getHeight() - 6, this.getWidth(), Common.fontRenderer.getHeight() + 6);
        if (this.displayAlert) {
            Common.drawAlert(graphics, this.alertTitle, this.alertText, this.getWidth(), this.getHeight());
            Common.drawCommands(graphics, null, "OK", this.getWidth(), this.getHeight());
            return;
        }
        Common.drawCommands(graphics, "Select", "Back", this.getWidth(), this.getHeight());
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void keyReleased(int n) {
        if (this.displayAlert) {
            if (Common.isRSK(n)) {
                this.hideAlert();
            }
            return;
        }
        if (Common.isLSK(n)) {
            this.parent.settingsMenuSelect(this.selectedIndex);
            return;
        }
        if (Common.isRSK(n)) {
            this.parent.displayList();
            return;
        }
        int n2 = this.getGameAction(n);
        if (n2 == 1 || n == 50) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.items.length - 1;
            }
        } else if (n2 == 6 || n == 56) {
            ++this.selectedIndex;
            if (this.selectedIndex >= this.items.length) {
                this.selectedIndex = 0;
            }
        } else if (n2 == 8) {
            this.parent.settingsMenuSelect(this.selectedIndex);
        }
        this.repaint();
    }

    public void displayAlert(String string, String string2) {
        this.displayAlert = true;
        this.alertTitle = string;
        this.alertText = string2;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }
}

