/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoresCanvas
extends Canvas {
    static final int SCORE_Y = 54;
    private Image img = null;
    private boolean cleared = false;
    private Quiz home;
    private Vector strings;
    private boolean smallFont = false;
    private Quiz parent = null;
    public String leftCommand = null;
    public String rightCommand = null;
    private int backgroundColour = 0xFFFFFF;
    private int w;
    private int h;

    public ScoresCanvas() {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.strings = new Vector();
    }

    public ScoresCanvas(String res, Quiz home) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.loadImage(res);
        this.home = home;
        this.strings = new Vector();
    }

    public void setParent(Quiz p) {
        this.parent = p;
    }

    public void setCommands(String l, String r) {
        this.leftCommand = l;
        this.rightCommand = r;
    }

    public void loadImage(String res) {
        try {
            this.img = Image.createImage((String)res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void smallFont(boolean val) {
        this.smallFont = val;
    }

    public void setImage(Image img) {
        this.img = img;
    }

    public void setBackgroundColour(int newcol) {
        this.backgroundColour = newcol;
    }

    public void paint(Graphics g) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        if (!this.cleared) {
            g.setColor(this.backgroundColour);
            g.fillRect(0, 0, this.w, this.h);
            this.cleared = true;
        }
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, 0x10 | 4);
        }
        g.setColor(0xCC0000);
        Font boldFont = Font.getFont((int)0, (int)1, (int)16);
        if (this.smallFont) {
            boldFont = Font.getFont((int)0, (int)1, (int)0);
        }
        g.setFont(boldFont);
        for (int i = 0; i < this.strings.size(); ++i) {
            String str = (String)this.strings.elementAt(i);
            Common.titleFontRenderer.drawString(g, str, (this.w - Common.titleFontRenderer.stringWidth(str)) / 2, 54 + (i * Common.titleFontRenderer.getHeight() + 1));
        }
        g.setClip(0, 0, this.w, this.h);
        g.setColor(0xD0D0D0);
        g.fillRect(0, this.h - Common.fontRenderer.getHeight() - 6, this.w, Common.fontRenderer.getHeight() + 6);
        Common.drawCommands(g, this.leftCommand, this.rightCommand, this.w, this.h);
    }

    protected void hideNotify() {
        this.cleared = false;
    }

    public void setText(String newtext) {
        this.strings = ScoresCanvas.splitString(newtext);
    }

    public static Vector splitString(String text) {
        Vector<String> lines = new Vector<String>();
        int length = text.trim().length();
        for (int i = 0; i < length; ++i) {
            int num = text.indexOf("\n");
            if (num < 0) {
                lines.addElement(text);
                break;
            }
            lines.addElement(text.substring(0, num));
            text = text.substring(num + 1, text.length());
        }
        return lines;
    }

    public void keyPressed(int keyCode) {
        if (Common.isLSK(keyCode)) {
            this.parent.displayList();
        } else if (Common.isRSK(keyCode)) {
            if (this.rightCommand != null) {
                this.parent.ontoNextRound();
            }
        } else if (Common.isBackKey(keyCode)) {
            this.parent.displayList();
        }
    }
}

