/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;

public class Questions {
    public static final int NUMBER_OF_QUESTIONS = 900;
    public static final int QUESTIONS_PER_FILE = 100;
    public static final int NUMBER_OF_ANSWERS = 3;
    public static final int QUESTIONS_PER_SET = 10;
    private static final String QUESTIONS_FILE_BASENAME = "/QA";
    private static final String QUESTIONS_FILE_EXT = ".txt";
    private static final String QUESTIONS_RECORD_STORE = "quiz_results";
    private Vector questions;
    private int[] questionSet;
    private byte[] questionsAnswered;
    private int currentQuestionSet = -1;
    private int score = 0;
    public boolean debug = false;
    private Quiz quiz;

    public Questions(Quiz parent) {
        this.quiz = parent;
        this.questionsAnswered = new byte[900];
        this.questionSet = new int[10];
        if (RecordManager.exists(QUESTIONS_RECORD_STORE)) {
            this.questionsAnswered = RecordManager.load(QUESTIONS_RECORD_STORE);
            this.countScore();
        } else {
            for (int i = 0; i < 900; ++i) {
                this.questionsAnswered[i] = 0;
            }
            RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
        }
    }

    public Question get(int n) {
        return (Question)this.questions.elementAt(this.questionSet[n]);
    }

    public void loadQuestions(int fnum) {
        char[] buffer = new char[1024];
        Vector<String> data = new Vector<String>();
        int count = 0;
        if (this.debug) {
            System.out.println("loadQuestions() Loading question set " + fnum);
        }
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream(QUESTIONS_FILE_BASENAME + fnum + QUESTIONS_FILE_EXT);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    if ((char)chr != '\r' && (char)chr != '\n') {
                        buffer[count++] = (char)chr;
                        continue;
                    }
                    String s = new String(buffer, 0, count);
                    data.addElement(s);
                    count = 0;
                }
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentQuestionSet = fnum;
        this.questions = new Vector();
        count = 0;
        for (int q = 0; q < 100; ++q) {
            String qstr = (String)data.elementAt(count++);
            Question tmp = new Question();
            tmp.setQuestion(qstr);
            for (int i = 0; i < 3; ++i) {
                String a = (String)data.elementAt(count);
                tmp.setAnswer(i, a);
                ++count;
            }
            this.questions.addElement(tmp);
        }
        data = null;
        System.gc();
    }

    public boolean getQandAs() {
        Random rand = new Random(System.currentTimeMillis());
        int unansweredQs = 0;
        byte[] possibleQA = new byte[this.questionsAnswered.length];
        for (int i = 0; i < 900; ++i) {
            possibleQA[i] = this.questionsAnswered[i];
            if (possibleQA[i] != 0) continue;
            ++unansweredQs;
        }
        if (this.debug) {
            System.out.println("Unanswered Questions: " + unansweredQs);
        }
        if (unansweredQs < 10) {
            return false;
        }
        boolean foundSet = false;
        int selectedSet = 0;
        while (!foundSet) {
            int randomSet = Math.abs(rand.nextInt()) % 9;
            if (this.debug) {
                System.out.println("Randomly selected set " + randomSet);
            }
            int totalAnswered = 0;
            for (int q = 0; q < 100; ++q) {
                totalAnswered += possibleQA[randomSet * 100 + q];
            }
            if (this.debug) {
                System.out.println("Total answered questions in set " + randomSet + " is " + totalAnswered);
            }
            if (totalAnswered > 90) continue;
            foundSet = true;
            selectedSet = randomSet;
        }
        if (selectedSet != this.currentQuestionSet) {
            this.loadQuestions(selectedSet);
        } else if (this.debug) {
            System.out.println("Using cached question set " + this.currentQuestionSet);
        }
        for (int q = 0; q < 10; ++q) {
            boolean gotUnansweredQuestion = false;
            while (!gotUnansweredQuestion) {
                int randomQuestion = Math.abs(rand.nextInt()) % 100;
                if (possibleQA[selectedSet * 100 + randomQuestion] != 0) continue;
                if (this.debug) {
                    System.out.println("Selecting random question " + randomQuestion);
                }
                possibleQA[selectedSet * 100 + randomQuestion] = 1;
                this.questionSet[q] = randomQuestion;
                gotUnansweredQuestion = true;
            }
        }
        return true;
    }

    public void saveScores() {
        for (int i = 0; i < 10; ++i) {
            int q = this.currentQuestionSet * 100 + this.questionSet[i];
            this.questionsAnswered[q] = 1;
        }
        RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
    }

    public void resetScores() {
        for (int i = 0; i < 900; ++i) {
            this.questionsAnswered[i] = 0;
        }
        RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
    }

    public int getScore() {
        this.countScore();
        return this.score;
    }

    private void countScore() {
        this.score = 0;
        for (int i = 0; i < 900; ++i) {
            this.score += this.questionsAnswered[i];
        }
    }

    public boolean answeredAllQuestions() {
        return this.getScore() >= 900;
    }

    public int getQuestionSet() {
        return this.currentQuestionSet;
    }
}

