/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Common {
    public static boolean DISABLE_SOUND = false;
    public static FontRenderer fontRenderer;
    public static FontRenderer inverseFontRenderer;
    public static FontRenderer titleFontRenderer;
    public static Image meshImage;
    public static int[] LSK_VALUES;
    public static int[] RSK_VALUES;
    public static int BACK_KEY_VALUE;
    public static boolean SERVICE_REPAINTS;

    public static void loadResources() {
        fontRenderer = new FontRenderer("/fonts/asi");
        titleFontRenderer = new FontRenderer("/fonts/asi_red");
        inverseFontRenderer = new FontRenderer("/fonts/asi_inv");
        try {
            meshImage = Image.createImage((String)"/mesh.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawCommands(Graphics g, String l, String r, int w, int h) {
        if (l != null) {
            fontRenderer.drawString(g, l, 3, h - fontRenderer.getHeight() - 3);
        }
        if (r != null) {
            fontRenderer.drawString(g, r, w - fontRenderer.stringWidth(r) - 3, h - fontRenderer.getHeight() - 3);
        }
    }

    public static boolean isLSK(int keyCode) {
        for (int i = 0; i < LSK_VALUES.length; ++i) {
            if (keyCode != LSK_VALUES[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isRSK(int keyCode) {
        for (int i = 0; i < RSK_VALUES.length; ++i) {
            if (keyCode != RSK_VALUES[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isBackKey(int keyCode) {
        return keyCode == BACK_KEY_VALUE;
    }

    public static void drawAlert(Graphics g, String title, String msg, int w, int h) {
        int y;
        g.setClip(0, 0, w, h);
        int x = 0;
        for (y = 0; y < h; y += meshImage.getHeight()) {
            for (x = 0; x < w; x += meshImage.getWidth()) {
                g.drawImage(meshImage, x, y, 0x10 | 4);
            }
        }
        g.setColor(0xFFFFFF);
        g.fillRect(15, 35, w - 30, h - 70);
        g.setColor(0);
        g.drawRect(15, 35, w - 30, h - 70);
        titleFontRenderer.drawString(g, title, (w - titleFontRenderer.stringWidth(title)) / 2, 45);
        y = 65;
        Vector lines = FontRenderer.splitString("\n", fontRenderer.wrapString(msg, w - 50));
        for (int i = 0; i < lines.size(); ++i) {
            String s = (String)lines.elementAt(i);
            fontRenderer.drawString(g, s, (w - fontRenderer.stringWidth(s)) / 2, y);
            y += fontRenderer.getHeight();
        }
    }

    static {
        LSK_VALUES = new int[]{-21, 21};
        RSK_VALUES = new int[]{-22, 22};
        BACK_KEY_VALUE = -11;
        SERVICE_REPAINTS = true;
    }
}

