/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Question {
    private String question;
    private String[] answers = new String[3];
    private int[] answerOrder = new int[3];
    Random rand = new Random();

    public Question() {
        this.question = "";
        this.answers[0] = "";
        this.answers[1] = "";
        this.answers[2] = "";
        this.answerOrder[0] = 0;
        this.answerOrder[1] = 1;
        this.answerOrder[2] = 2;
    }

    public Question(String q, String a0, String a1, String a2) {
        this.question = q;
        this.answers[0] = a0;
        this.answers[1] = a1;
        this.answers[2] = a2;
        this.answerOrder[0] = 0;
        this.answerOrder[1] = 1;
        this.answerOrder[2] = 2;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String q) {
        this.question = q;
    }

    public String getAnswer(int num) {
        return this.answers[this.answerOrder[num]];
    }

    public void setAnswer(int num, String a) {
        this.answers[num] = a;
    }

    public int getCorrectAnswer() {
        for (int i = 0; i < this.answers.length; ++i) {
            if (this.answerOrder[i] != 0) continue;
            return i;
        }
        return 0;
    }

    public void setCorrectAnswer(int n) {
        this.answerOrder[0] = n;
        this.answerOrder[1] = 1;
        this.answerOrder[2] = 2;
        this.answerOrder[n] = 0;
    }

    public void reset() {
        this.answerOrder[0] = 0;
        this.answerOrder[1] = 1;
        this.answerOrder[2] = 2;
    }

    public String toString() {
        return this.question + "\nOriginal (0:" + this.answers[0] + " 1:" + this.answers[1] + " 2:" + this.answers[2] + ")" + "\nShuffled (0:" + this.answers[this.answerOrder[0]] + " 1:" + this.answers[this.answerOrder[1]] + " 2:" + this.answers[this.answerOrder[2]] + "\nCorrect Index:" + this.getCorrectAnswer();
    }

    public void shuffle() {
        this.rand = new Random(System.currentTimeMillis());
        int a1pos = this.random(3);
        int a2pos = this.random(3);
        while (a2pos == a1pos) {
            a2pos = this.random(3);
        }
        int a3pos = this.random(3);
        while (a3pos == a1pos || a3pos == a2pos) {
            a3pos = this.random(3);
        }
        this.answerOrder[0] = a1pos;
        this.answerOrder[1] = a2pos;
        this.answerOrder[2] = a3pos;
    }

    private int random(int v) {
        return Math.abs(this.rand.nextInt() % v);
    }
}

