/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuCanvas
extends Canvas {
    public int LINE_SPACING = 3;
    public Image topImage = null;
    public Quiz parent;
    public int selectedIndex = 0;
    private int w;
    private int h;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;

    public void displayAlert(String title, String text) {
        this.displayAlert = true;
        this.alertTitle = title;
        this.alertText = text;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }

    public MenuCanvas(Image t, Quiz q) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.topImage = t;
        this.parent = q;
    }

    public void paint(Graphics g) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.w, this.h);
        Font fnt = Font.getFont((int)0, (int)0, (int)0);
        g.setFont(fnt);
        g.setColor(0);
        int lineY = 0;
        g.drawImage(this.topImage, 0, 0, 0x10 | 4);
        lineY += this.topImage.getHeight() + this.LINE_SPACING;
        for (int i = 0; i < Strings.MENU_ITEMS.length; ++i) {
            String s = Strings.MENU_ITEMS[i];
            if (i == Strings.GMG_INDEX) {
                if (!GMG.DISPLAY_GET_MORE_GAMES_LINK) continue;
                s = GMG.GET_MORE_GAMES_LABEL;
            }
            if (i == this.selectedIndex) {
                g.setColor(0x333333);
                g.fillRect(0, lineY - this.LINE_SPACING / 2, this.w, Common.fontRenderer.getHeight() + this.LINE_SPACING);
                Common.inverseFontRenderer.drawString(g, s, 10, lineY);
                g.setColor(0xFFFFFF);
            } else {
                Common.fontRenderer.drawString(g, s, 10, lineY);
                g.setColor(0);
            }
            lineY += Common.fontRenderer.getHeight() + this.LINE_SPACING;
        }
        g.setClip(0, 0, this.w, this.h);
        g.setColor(0xD0D0D0);
        g.fillRect(0, this.h - Common.fontRenderer.getHeight() - 6, this.w, Common.fontRenderer.getHeight() + 6);
        if (this.displayAlert) {
            Common.drawAlert(g, this.alertTitle, this.alertText, this.getWidth(), this.getHeight());
            Common.drawCommands(g, null, "OK", this.getWidth(), this.getHeight());
        } else {
            Common.drawCommands(g, Strings.CMD_SELECT, Strings.CMD_EXIT, this.w, this.h);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void keyPressed(int keyCode) {
        if (this.displayAlert) {
            if (Common.isRSK(keyCode)) {
                this.hideAlert();
            }
            return;
        }
        if (Common.isLSK(keyCode)) {
            this.parent.mainMenuSelect(this.selectedIndex);
            return;
        }
        if (Common.isRSK(keyCode)) {
            this.parent.exitApplication();
            return;
        }
        int ga = this.getGameAction(keyCode);
        if (ga == 1 || keyCode == 50) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = Strings.MENU_ITEMS.length - 1;
            }
            if (this.selectedIndex == Strings.GMG_INDEX && !GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                --this.selectedIndex;
            }
        } else if (ga == 6 || keyCode == 56) {
            ++this.selectedIndex;
            if (this.selectedIndex >= Strings.MENU_ITEMS.length) {
                this.selectedIndex = 0;
            }
            if (this.selectedIndex == Strings.GMG_INDEX && !GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                ++this.selectedIndex;
            }
        } else if (ga == 8 || keyCode == 53) {
            this.parent.mainMenuSelect(this.selectedIndex);
        }
        this.repaint();
    }
}

